var samplePageObj = {
  // 샘플 타이틀
  title: '포커스 이동',
  subtitle: '시트 내에 데이터 셀을 클릭하거나, 키보드를 통해서 포커스 셀의 위치를 이동할 수 있습니다.',
  // 샘플 설명
  desc: '데이터 중에 일부를 포커스하지 못하게끔 설정하거나, 다양한 API를 통해 포커스 셀의 위치를 변경하는 것도 가능합니다.',

  // 객체 초기화 구문
  init: {
    Cfg: {
      SearchMode: 0
    },
    Def: {
      Row: {
        ShowHint: 0,
        Tip: 0
      }
    }, // 행,열 단위 공통 기능 설정
    LeftCols: [
      {
        Type: 'Int',
        Width: 80,
        Align: 'Center',
        Name: 'SEQ'
      }
    ],
    Cols: [
      {
        Header: '선택',
        Type: 'Bool',
        Name: 'CHK',
        Width: '50',
        Align: 'Center',
        CanEdit: 1
      },
      {
        Header: '대차계약번호',
        Type: 'Text',
        Name: 'CONTRACTNO',
        Width: '120',
        Align: 'Center',
        CanEdit: 0
      },
      {
        Header: '대차지점',
        Type: 'Text',
        Name: 'DELIVERYDEPTNAME',
        Width: '120',
        Align: 'Center',
        CanEdit: 0,
        TextColor: 'BLUE'
      },
      {
        Header: '차량번호',
        Type: 'Text',
        Name: 'CARNO',
        Width: '120',
        Align: 'Center',
        CanEdit: 1,
        Tip: 1
      },
      {
        Header: '차명(FULL차명)',
        Type: 'Text',
        Name: 'CARNAMEMSTNAME',
        Width: '200',
        Align: 'Left',
        CanEdit: 1,
        Suggest: '|싼타페 현대|포터2 현대|그랜저 현대|카니발 기아|더_뉴_아반떼 현대|쏘렌토 기아|봉고3_트럭_기아|모닝 기아|그랜드_스타렉스 현대|쏘나타_뉴_라이즈 현대|K5 기아|투싼 현대|티볼리 쌍용|렉스턴_스포츠 쌍용|스파크 GM|QM6 르노삼성|K7 기아|K3 기아|스포티지 기아|E-class BENZ|코나_electric 현대|G80 현대|코나 현대|그랜저_hybrid 현대|레이 기아|SM6 르노삼성|니로_(하이브리드) 기아|말리부 GM|G70 현대|CLS BENZ|ES 렉서스|G4_렉스턴 쌍용|스토닉 기아|트랙스 GM|GLC BENZ|K9 기아|Camry 토요타|K7_하이브리드 기아|Accord 혼다|EQ900 현대|Tiguan 폭스바겐|3-series BMW|Passat 폭스바겐|QM3 르노삼성|5-series BMW|모하비 기아|SM5 르노삼성|Explorer FORD|아이오닉_hybrid 현대|니로_EV_(전기차) 기아|엑센트 현대|A4 아우디|SM3 르노삼성|GLE BENZ|K5 하이브리드 기아|쏘나타_뉴_라이즈_hybrid 현대|라보 GM|스팅어 기아|Altima 닛산|SM7 르노삼성|GLA BENZ|Passat GT 폭스바겐|클리오 르노삼성|다마스 GM|코란도_C 싸용|XC60 볼보|i30 현대|Hatch MINI|All_New_Avalon 닛산|Panamera 포르쉐|Discovery_Sport 랜드로버|Prius 토요타|이쿼녹스 GM|K3_GT 기아|임팔라 GM|RX 렉서스|코란도_투리스모 쌍용|RAV4 토요타|벨로스터 현대|아이오닉_electric 현대|Clubman MINI|New_Cherokee 지프|NX 렉서스|All_New_Wrangler 지프|XC90 볼보|넥쏘 현대|A6 아우디|7-series BMW|X1 BMW|Renegade 지프|S-class BENZ|트위지 르노삼성|Discovery 랜드로버|Grand_Cherokee 지프|CT6 캐딜락|4-series BMW|GLS BENZ|Grand_C4_Picasso 씨트로앵|All_New_Compass 지프|X5 BMW|CLA BENZ|Prius_C 토요타|Countryman MINI|New_Range_Rover 랜드로버|MKX 링컨|X3 BMW|X6 BMW|Range_Rover_Velar 랜드로버|S90 볼보|벨로스터-N 현대|6-series BMW|MKZ 링컨|Odyssey 혼다|C-class BENZ|V40_Cross_Country 볼보|Q30 인피니티|CT 렉서스|Continental 링컨|XC40 볼보|E-Pace 재규어|M BMW|1-series BMW|Ghibli 마세라티|V90_Cross_Country 폴보|X4 BMW|LS 렉서스|Mustang FORD|New_Range_Rover_Sport 랜드로버|Levante 마세라티|니로_플러그인_하이브리드 기아|쏠라티 현대|5008 푸조|New_Sienna 토요타|XE 재규어|SM3_Z.E. 르노삼성|718_Boxster 포르쉐|Macan 포르쉐|Range_Rover_Evoque 랜드로버|QX60 인피니티|CTS 캐딜락|Q50 인피니티|i40 현대|Maxima 닛산|쏘울 기아|911 포르쉐|MKC 링컨|XT5 캐딜락|508 푸조|Mondeo FORD|Quattroporte 마세라티|XF 재규어|XJ 재규어|Q70 인피니티|308 푸조|카마로_SS GM|C4_Cactus 씨트로앵|마스터 르노|맥스크루즈 현대|Taurus FORD|Convertible MINI|ATS 캐딜락|DS3 씨트로앵|캡티바 GM|Kuga FORD|X2 BMW|Escalade 캐딜락|쏘나타_뉴라이즈plug-in 현대|볼트(플러그인하이브리드) GM|F-Type 재규어|Ghost_Series II 롤스로이스|아베오 아베오|718 Cayman 718 Cayman|Prius_Prime 토요타|New_i3 BMW|Pathfinder 닛산|B-class BENZ|F-Pace 재규어|Q60 인피니티|Arteon 폭스바겐|코란도_스포츠 쌍용|C4_Picasso 씨트로앵|Murano Murano|SL BENZ|볼트EV(전기차) GM|ES 렉서스|A-class BENZ|3008 푸조|크루즈 GM|Huracan 람보르니기|208 푸조|투싼(2017) 현대|SLC BENZ|Cherokee 지프|Civic 혼다|370Z 닛산|IS 렉서스|Wraith 롤스로이스|CLS BENZ|Grancabrio 마세라티|Phantom 롤스로이스|AMG GT BENZ|Dawn 롤스로이스|Pilot 혼다',
        SuggestType: 'Start,Empty,Complete'
      },
      {
        Header: {
          Value: '24시간기본요금\n포커스 불가 열',
          TextColor: 'RED'
        },
        Type: 'Float',
        Name: 'RENTFEE',
        Width: '120',
        Align: 'Right',
        CanEmpty: 1,
        Format: ',#.##',
        CanFocus: 0,
        Color: '#EDEDFF'
      },
      {
        Header: '출고일자',
        Type: 'Date',
        Name: 'RENTDATE',
        Width: '100',
        Align: 'Center',
        Format: 'yyyy/MM/dd',
        DataFormat: 'yyyyMMdd',
        CanEdit: 0
      },
      {
        Header: '입고일자',
        Type: 'Date',
        Name: 'RETURNDATE',
        Width: '100',
        Align: 'Center',
        Format: 'yyyy/MM/dd',
        DataFormat: 'yyyyMMdd',
        CanEdit: 0
      },
      {
        Header: '대차유형',
        Type: 'Text',
        Name: 'PROMOCODE',
        Width: '100',
        Align: 'Center',
        CanEdit: 1
      },
      {
        Header: '순서',
        Type: 'Text',
        Name: 'NO',
        Width: '50',
        Align: 'Center',
        DefaultValue: 'defaultValue'
      },
      {
        Header: '할인율',
        Type: 'Int',
        Name: 'DISCOUNTRATE',
        Width: '50',
        Align: 'Center',
        Format: '#,##0',
        CanEdit: 1
      },
      {
        Header: '순매출',
        Type: 'Int',
        FormulaRow: 'Sum',
        Name: 'NETSALEAMT',
        Width: '100',
        Align: 'Right',
        Format: '#,##0',
        CanEdit: 0
      },
      {
        Header: '부가세',
        Type: 'Int',
        FormulaRow: 'Sum',
        Name: 'SALEVATAMT',
        Width: '100',
        Align: 'Right',
        Format: '#,##0',
        CanEdit: 0
      },
      {
        Header: '총매출',
        Type: 'Int',
        FormulaRow: 'Sum',
        Name: 'SALEAMT',
        Width: '100',
        Align: 'Right',
        Format: '#,##0',
        CanEdit: 0
      },
      {
        Header: '원차번호',
        Type: 'Text',
        Name: 'OBJCARNO',
        Width: '100',
        Align: 'Center',
        CanEdit: 0
      },
      {
        Header: '매출지점',
        Type: 'Text',
        Name: 'DEPTNAME',
        Width: '100',
        Align: 'Center',
        CanEdit: 0
      },
      {
        Header: '차명(FULL차명)',
        Type: 'Text',
        Name: 'CARNAMEMSTNAME2',
        Width: '200',
        Align: 'Left',
        CanEdit: 1
      },
      {
        Header: '24시간기본요금',
        Type: 'Int',
        Name: 'UNIT24',
        Width: '100',
        Align: 'Center',
        Format: '#,##0',
        CanEdit: 0
      },
      {
        Header: '사고번호',
        Type: 'Text',
        Name: 'ACCNO',
        Width: '120',
        Align: 'Center',
        CanEdit: 0
      },
      {
        Header: '사고담당자',
        Type: 'Text',
        Name: 'ACCPERSONNAME',
        Width: '80',
        Align: 'Center',
        CanEdit: 0
      },
      {
        Header: '사고일자',
        Type: 'Date',
        Name: 'ACCDATE',
        Width: '100',
        Align: 'Center',
        Format: 'yyyy/MM/dd',
        DataFormat: 'yyyyMMdd',
        CanEdit: 0
      },
      {
        Header: '수리번호',
        Type: 'Text',
        Name: 'REPAIRNO',
        Width: '120',
        Align: 'Center',
        CanEdit: 0
      },
      {
        Header: '수리담당자',
        Type: 'Text',
        Name: 'REPAIRPERSONNAME',
        Width: '80',
        Align: 'Center',
        CanEdit: 0
      },
      {
        Header: '수리시작일자',
        Type: 'Date',
        Name: 'STARTDATE',
        Width: '100',
        Align: 'Center',
        Format: 'yyyy/MM/dd',
        DataFormat: 'yyyyMMdd',
        CanEdit: 0
      },
      {
        Header: '수리종료일자',
        Type: 'Date',
        Name: 'ENDDATE',
        Width: '100',
        Align: 'Center',
        Format: 'yyyy/MM/dd',
        DataFormat: 'yyyyMMdd',
        CanEdit: 0
      },
    ]
  },

  // 버튼/기능 영역 html (sampleBtn으로 호출하면 action함수로 연결)
  func: '<div>'
            + '<label>행 index</label><input type=\'number\' id=\'row\' value=\'10\' min=\'1\' style=\'width:50px;text-align:right\' class=\'mgr10\'> '
            + '<hr>'
            + '<label>행 id</label><input type=\'text\' id=\'rowId\' class=\'mgr10\'>'
            + '<hr>'
            + '<label>열</label><select id=\'col\' style=\'width:130px\' class=\'mgr10\'><select>'
            + '<hr>'
            + '<button class=\'btn mgr10\' onclick=\'sampleBtn(this)\'>포커스 확인</button> <button class=\'btn mgr10\' onclick=\'sampleBtn(this)\'>포커스 이동</button>'
            + '</div>',

  // 객체 생성 Html
  objEl: '<div id=\'sheetDiv\' style=\'width:100%;height:100%\'></div>',

  // 시트 하단 영역 html
  footer: '<span></span>',

  // 객체 생성 구문
  create: function () {
    var options = this.init;

    options.Events = this.event;
    IBSheet.create({
      id: 'sheet', // 생성할 시트의 id
      el: 'sheetDiv', // 시트를 생성할 Dom 객체 및 id
      options: options, // 생성될 시트의 속성
      data: this.data // 생성될 시트의 정적데이터
    });
  },
  // 버튼 클릭시 기능 로직
  action: function () {
    if (arguments[0].innerText == '포커스 확인') {
      // 선택된 행 객체를 얻음.
      var rowObj = sheet.getFocusedRow();

      if (rowObj) {
        document.getElementById('rowId').value = rowObj.id;
        document.getElementById('row').value = sheet.getRowIndex(rowObj);
        document.getElementById('col').value = sheet.getFocusedCol();
      } else {
        sheet.showMessageTime('선택된 셀이 없습니다.', 1500);
      }
    } else { // 포커스 이동
      // index 기준 Row객체 얻기
      var RowIdx = sheet.getRowByIndex(document.getElementById('row').value);
      // id 기준 Row객체 얻기
      var RowId = sheet.getRowById(document.getElementById('rowId').value);
      var sCol = document.getElementById('col').value;

      // 포커스 위치 이동
      sheet.focus(RowId || RowIdx, sCol);
    }
  },

  // event구문
  event: {
    onFocus: function (evtParam) {
      // 포커스 위치가 변경될때마다 발생하는 이벤트
      // 현재 셀의 위치와 변경전 셀의 위치를 얻을수 있음.
      var old = evtParam.orow ? '이전 행:' + evtParam.orow.id + ' 이전 열:' + evtParam.ocol : '';

      console.log('onFocus', '%cIB %cSheet log:\n', 'color:red', 'color:black',
        '변경된 행:' + evtParam.row.id + ' 변경된 열:' + evtParam.col,
        old);
    },
    onRenderFirstFinish: function (evtParam) {
      // 시트객체 처음 생성시 발생하는 이벤트
      console.log(evtParam.eventName + ' 발생');

      // 열 select에 option 넣기
      var cols = sheet.getCols('Visible');
      var sel = document.getElementById('col');

      for (var i = 0; i < cols.length; i++) {
        var option = document.createElement('option');

        option.text = sheet.getRowById('Header')[cols[i]];
        option.value = cols[i];
        sel.add(option);
      }
    }
  },

  // data
  data: [
    {
      NO: '001',
      CARNAMEMSTNAME2: 'K5렌터카 2000 LPI 스마트 AT LPG',
      RETURNDATE: '20120109',
      ACCNO: '201112171742',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1410101163627',
      CONTRACTNO: 'ss1180111242361',
      RENTFEE: '165000.123',
      OBJCARNO: '63허6557',
      CARNO: '56허9740',
      ACCPERSONNAME: '박수호',
      DATA_KEY: '1',
      CARNAMEMSTNAME: '소나타 Y20 렌터카 2000 LPI Luxury AT LPG',
      RENTDATE: '20111217',
      UNIT24: '165000',
      TERMTYPE: 'S',
      NETSALEAMT: '877091',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '천안아산지점',
      SALEVATAMT: '87709',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: 'L',
      DEPTNAME: '부천지점',
      ACCDATE: '20111217',
      SALEAMT: '964800',
      STARTDATE: ''
    },
    {
      NO: '002',
      CARNAMEMSTNAME2: '투싼 ix 4WD 2000 E-VGT X20 Luxury AT 디젤',
      RETURNDATE: '20120104',
      ACCNO: '201112191858',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LE1240100353144',
      CONTRACTNO: 'SS1476111242830',
      RENTFEE: '199000',
      OBJCARNO: '16허7603',
      CARNO: '26허6321',
      ACCPERSONNAME: '김대윤',
      DATA_KEY: '2',
      CARNAMEMSTNAME: 'QM5 2WD 2000 dCi LE AT 디젤',
      RENTDATE: '20111219',
      UNIT24: '190000',
      TERMTYPE: 'S',
      NETSALEAMT: '795927',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: 'MT기획팀',
      SALEVATAMT: '79593',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '대구지점(동대구역)',
      ACCDATE: '20111219',
      SALEAMT: '875520',
      STARTDATE: ''
    },
    {
      NO: '003',
      CARNAMEMSTNAME2: 'NEW 다마스코치 800 LPG 5P DLX MT LPG',
      RETURNDATE: '20120105',
      ACCNO: '201112212217',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1470080525542',
      CONTRACTNO: 'SS1903111243975',
      RENTFEE: '99000',
      OBJCARNO: '72허6161',
      CARNO: '41허2835',
      ACCPERSONNAME: '김현철',
      DATA_KEY: '3',
      CARNAMEMSTNAME: '뉴프라이드 1400 DOHC LX AT 휘발유/LPG',
      RENTDATE: '20111221',
      UNIT24: '0',
      TERMTYPE: 'S',
      NETSALEAMT: '347458',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '구로현주예약소',
      SALEVATAMT: '34746',
      REPAIRPERSONNAME: '',
      PROMOCODE: '리스대차',
      TERMTYPE2: 'L',
      DEPTNAME: 'SU6팀',
      ACCDATE: '20111221',
      SALEAMT: '382204',
      STARTDATE: ''
    },
    {
      NO: '004',
      CARNAMEMSTNAME2: '뉴카렌스 2000 LPI GX 최고급형 AT LPG',
      RETURNDATE: '20120102',
      ACCNO: '201111232662',
      REPAIRNO: '',
      DISCOUNTRATE: '0',
      OBJCONTRACTNO: 'LS1100091147985',
      CONTRACTNO: '',
      RENTFEE: '165000',
      OBJCARNO: '04허2246',
      CARNO: '62허5910',
      ACCPERSONNAME: '윤원재',
      DATA_KEY: '4',
      CARNAMEMSTNAME: '소나타 Y20 렌터카 2000 LPI Luxury AT LPG',
      RENTDATE: '20111123',
      UNIT24: '165000',
      TERMTYPE: 'M',
      NETSALEAMT: '288970',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '포커스 불가 행',
      SALEVATAMT: '28897',
      REPAIRPERSONNAME: '',
      PROMOCODE: '리스대차',
      TERMTYPE2: 'L',
      DEPTNAME: '인천지점',
      ACCDATE: '20111123',
      SALEAMT: '317867',
      STARTDATE: '',
      CanFocus: 0,
      Color: '#EDEDFF',
      DELIVERYDEPTNAMETextColor: '#FF0000'
    },
    {
      NO: '005',
      CARNAMEMSTNAME2: '체어맨 W 3600 XGi CW 700 Luxury AT 휘발유',
      RETURNDATE: '20120104',
      ACCNO: '201112101052',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1340100455093',
      CONTRACTNO: 'SS1944111234933',
      RENTFEE: '292000',
      OBJCARNO: '27허7417',
      CARNO: '52허5711',
      ACCPERSONNAME: '박수호',
      DATA_KEY: '5',
      CARNAMEMSTNAME: '5G 그랜져 3000 LPI HG300 렌터카 Prime AT LPG',
      RENTDATE: '20111210',
      UNIT24: '447000',
      TERMTYPE: 'S',
      NETSALEAMT: '1338182',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '대전태화예약소',
      SALEVATAMT: '133818',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: 'L',
      DEPTNAME: '거제지점',
      ACCDATE: '20111210',
      SALEAMT: '1472000',
      STARTDATE: ''
    },
    {
      NO: '006',
      CARNAMEMSTNAME2: '액티언스포츠 2000 XVT AX7(4WD) PASSION AT 디젤',
      RETURNDATE: '20120105',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '50',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1926111237887',
      RENTFEE: '199000',
      OBJCARNO: '86수8594',
      CARNO: '32허5870',
      ACCPERSONNAME: '',
      DATA_KEY: '6',
      CARNAMEMSTNAME: 'SORENTO R 2WD 2200 E-VGT TLX 고급형 AT 디젤',
      RENTDATE: '20111212',
      UNIT24: '190000',
      TERMTYPE: 'S',
      NETSALEAMT: '1702273',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '익산신동예약소',
      SALEVATAMT: '170227',
      REPAIRPERSONNAME: '',
      PROMOCODE: '리스대차',
      TERMTYPE2: '',
      DEPTNAME: 'AJ캐피탈',
      ACCDATE: '',
      SALEAMT: '1872500',
      STARTDATE: ''
    },
    {
      NO: '007',
      CARNAMEMSTNAME2: 'New SM5  2000 CVTC Ⅱ SE AT 휘발유',
      RETURNDATE: '20120107',
      ACCNO: '201112090956',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1450100353394',
      CONTRACTNO: 'SS1240111237791',
      RENTFEE: '160000',
      OBJCARNO: '04허3223',
      CARNO: '68허3128',
      ACCPERSONNAME: '박수호',
      DATA_KEY: '7',
      CARNAMEMSTNAME: 'New SM5  2000 CVTC Ⅱ XE AT 휘발유',
      RENTDATE: '20111215',
      UNIT24: '160000',
      TERMTYPE: 'S',
      NETSALEAMT: '773818',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '대구지점(동대구역)',
      SALEVATAMT: '77382',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업2팀',
      ACCDATE: '20111209',
      SALEAMT: '851200',
      STARTDATE: ''
    },
    {
      NO: '008',
      CARNAMEMSTNAME2: '그랜드 스타렉스 12P WAGON 2500 VGT CVX Luxury AT 디젤',
      RETURNDATE: '20120102',
      ACCNO: '201111151649',
      REPAIRNO: '',
      DISCOUNTRATE: '0',
      OBJCONTRACTNO: 'LD1180110367281',
      CONTRACTNO: 'SS1476111112369',
      RENTFEE: '219000',
      OBJCARNO: '72허4388',
      CARNO: '71허3758',
      ACCPERSONNAME: '이준엽',
      DATA_KEY: '8',
      CARNAMEMSTNAME: '그랜드 스타렉스 12P WAGON 2500 VGT CVX Premium AT 디젤',
      RENTDATE: '20111116',
      UNIT24: '219000',
      TERMTYPE: 'M',
      NETSALEAMT: '549975',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: 'MT기획팀',
      SALEVATAMT: '54998',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '천안아산지점',
      ACCDATE: '20111115',
      SALEAMT: '604973',
      STARTDATE: ''
    },
    {
      NO: '009',
      CARNAMEMSTNAME2: '소나타 Y20 렌터카 2000 LPI Deluxe AT LPG',
      RETURNDATE: '20120102',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '0',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1937111124325',
      RENTFEE: '165000',
      OBJCARNO: '52허3293',
      CARNO: '56허9673',
      ACCPERSONNAME: '',
      DATA_KEY: '9',
      CARNAMEMSTNAME: '소나타 Y20 렌터카 2000 LPI Luxury AT LPG',
      RENTDATE: '20111130',
      UNIT24: '165000',
      TERMTYPE: 'M',
      NETSALEAMT: '87709',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '성수한국타이어예약소',
      SALEVATAMT: '8771',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '창원지점',
      ACCDATE: '',
      SALEAMT: '96480',
      STARTDATE: ''
    },
    {
      NO: '010',
      CARNAMEMSTNAME2: '싼타페 The Style 4WD 2200 E-VGT CLX DELUXE AT 디젤',
      RETURNDATE: '20120104',
      ACCNO: '201112141372',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1180110906114',
      CONTRACTNO: 'SS1956111237024',
      RENTFEE: '199000',
      OBJCARNO: '52허3386',
      CARNO: '39허4211',
      ACCPERSONNAME: '이준엽',
      DATA_KEY: '10',
      CARNAMEMSTNAME: '싼타페 The Style 4WD 2200 E-VGT CLX DELUXE AT 디젤',
      RENTDATE: '20111214',
      UNIT24: '199000',
      TERMTYPE: 'S',
      NETSALEAMT: '866909',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '상봉예약소',
      SALEVATAMT: '86691',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '천안아산지점',
      ACCDATE: '20111213',
      SALEAMT: '953600',
      STARTDATE: ''
    },
    {
      NO: '011',
      CARNAMEMSTNAME2: '스포티지R 2WD 2000 E-VGT TLX 최고급형 AT 디젤',
      RETURNDATE: '20120110',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1956111244395',
      RENTFEE: '266000',
      OBJCARNO: '39허4253',
      CARNO: '06허4520',
      ACCPERSONNAME: '',
      DATA_KEY: '11',
      CARNAMEMSTNAME: '5G 그랜져 2400 GDI HG240 LUXURY AT 휘발유',
      RENTDATE: '20111221',
      UNIT24: '190000',
      TERMTYPE: 'S',
      NETSALEAMT: '857455',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '상봉예약소',
      SALEVATAMT: '85745',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '영업3팀',
      ACCDATE: '',
      SALEAMT: '943200',
      STARTDATE: ''
    },
    {
      NO: '012',
      CARNAMEMSTNAME2: '에쿠스 TRUE PRESTIGE 3800 GDI VS 380 프라임 AT 휘발유',
      RETURNDATE: '20120109',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '0',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1140111240995',
      RENTFEE: '488000',
      OBJCARNO: '10허6101',
      CARNO: '44허5390',
      ACCPERSONNAME: '',
      DATA_KEY: '12',
      CARNAMEMSTNAME: '에쿠스 TRUE PRESTIGE 3800 V6 람다 VS 380 프라임 AT 휘발유',
      RENTDATE: '20111209',
      UNIT24: '488000',
      TERMTYPE: 'M',
      NETSALEAMT: '1645000',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '안산지점',
      SALEVATAMT: '164500',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '영업5팀',
      ACCDATE: '',
      SALEAMT: '1809500',
      STARTDATE: ''
    },
    {
      NO: '013',
      CARNAMEMSTNAME2: '그랜져 THE LUXURY 2700 DOHC Q270 DELUXE  AT 휘발유',
      RETURNDATE: '20120105',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1937111244244',
      RENTFEE: '266000',
      OBJCARNO: '13허6139',
      CARNO: '52허5447',
      ACCPERSONNAME: '',
      DATA_KEY: '13',
      CARNAMEMSTNAME: '5G 그랜져 2400 GDI HG240 LUXURY AT 휘발유',
      RENTDATE: '20111221',
      UNIT24: '266000',
      TERMTYPE: 'S',
      NETSALEAMT: '1056000',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '성수한국타이어예약소',
      SALEVATAMT: '105600',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '구미지점',
      ACCDATE: '',
      SALEAMT: '1161600',
      STARTDATE: ''
    },
    {
      NO: '014',
      CARNAMEMSTNAME2: '아반떼 M16 1600 LPI 렌터카 DELUXE AT LPG',
      RETURNDATE: '20120109',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1230111241938',
      RENTFEE: '150000',
      OBJCARNO: '04허6735',
      CARNO: '04허2180',
      ACCPERSONNAME: '',
      DATA_KEY: '14',
      CARNAMEMSTNAME: '로체 이노베이션 렌트카 2000 LPI LX20 고급형 스페셜 AT LPG',
      RENTDATE: '20111219',
      UNIT24: '109000',
      TERMTYPE: 'S',
      NETSALEAMT: '568502',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '평택지점',
      SALEVATAMT: '56850',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '청주지점',
      ACCDATE: '',
      SALEAMT: '625352',
      STARTDATE: ''
    },
    {
      NO: '015',
      CARNAMEMSTNAME2: '아반떼 M16 GDi 1600 GDI LUXURY AT 휘발유',
      RETURNDATE: '20120109',
      ACCNO: '201112191929',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1210100962341',
      CONTRACTNO: 'SS1476111244626',
      RENTFEE: '99000',
      OBJCARNO: '13허6165',
      CARNO: '26허9314',
      ACCPERSONNAME: '이준엽',
      DATA_KEY: '15',
      CARNAMEMSTNAME: '뉴아반떼 1600 VVT S16 LUXURY  AT 휘발유',
      RENTDATE: '20111220',
      UNIT24: '109000',
      TERMTYPE: 'S',
      NETSALEAMT: '532600',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: 'MT기획팀',
      SALEVATAMT: '53260',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '구미지점',
      ACCDATE: '20111217',
      SALEAMT: '585860',
      STARTDATE: ''
    },
    {
      NO: '016',
      CARNAMEMSTNAME2: '그랜드 스타렉스 12P WAGON 2500 VGT CVX Luxury MT 디젤',
      RETURNDATE: '20120102',
      ACCNO: '201112212200',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1460090540073',
      CONTRACTNO: 'SS1476111244643',
      RENTFEE: '219000',
      OBJCARNO: '72허6387',
      CARNO: '72허3730',
      ACCPERSONNAME: '김병준',
      DATA_KEY: '16',
      CARNAMEMSTNAME: '그랜드 스타렉스 12P WAGON 2500 VGT CVX Deluxe AT 디젤',
      RENTDATE: '20111221',
      UNIT24: '219000',
      TERMTYPE: 'S',
      NETSALEAMT: '694691',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: 'MT기획팀',
      SALEVATAMT: '69469',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업1팀',
      ACCDATE: '20111221',
      SALEAMT: '764160',
      STARTDATE: ''
    },
    {
      NO: '017',
      CARNAMEMSTNAME2: '싼타페 4WD 2200 VGT CLX 기본형 AT 디젤',
      RETURNDATE: '20120103',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1476111244656',
      RENTFEE: '199000',
      OBJCARNO: '32허2261',
      CARNO: '26허9359',
      ACCPERSONNAME: '',
      DATA_KEY: '17',
      CARNAMEMSTNAME: '뉴싼타페 2000 VGT CLX 고급형 AT 디젤',
      RENTDATE: '20111220',
      UNIT24: '199000',
      TERMTYPE: 'S',
      NETSALEAMT: '696436',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: 'MT기획팀',
      SALEVATAMT: '69644',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '안양지점',
      ACCDATE: '',
      SALEAMT: '766080',
      STARTDATE: ''
    },
    {
      NO: '018',
      CARNAMEMSTNAME2: 'All New 모닝 1000 MPI 디럭스 AT 휘발유',
      RETURNDATE: '20120102',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1476111242038',
      RENTFEE: '99000',
      OBJCARNO: '05허7693',
      CARNO: '32허5871',
      ACCPERSONNAME: '',
      DATA_KEY: '18',
      CARNAMEMSTNAME: '포르테 1600 CVVT Si AT 휘발유',
      RENTDATE: '20111217',
      UNIT24: '95000',
      TERMTYPE: 'S',
      NETSALEAMT: '367709',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: 'MT기획팀',
      SALEVATAMT: '36771',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '영업3팀',
      ACCDATE: '',
      SALEAMT: '404480',
      STARTDATE: ''
    },
    {
      NO: '019',
      CARNAMEMSTNAME2: '베르나 트랜스폼 1500 VGT TRENDY AT 디젤',
      RETURNDATE: '20120103',
      ACCNO: '201112222440',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1120100150280',
      CONTRACTNO: 'SS1903111244698',
      RENTFEE: '99000',
      OBJCARNO: '44허1214',
      CARNO: '41허4156',
      ACCPERSONNAME: '김현철',
      DATA_KEY: '19',
      CARNAMEMSTNAME: '뉴아반떼 1600 VVT E16 VALUE AT 휘발유/LPG',
      RENTDATE: '20111222',
      UNIT24: '95000',
      TERMTYPE: 'S',
      NETSALEAMT: '300218',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '구로현주예약소',
      SALEVATAMT: '30022',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '구로지점',
      ACCDATE: '20111222',
      SALEAMT: '330240',
      STARTDATE: ''
    },
    {
      NO: '020',
      CARNAMEMSTNAME2: '스포티지R 2WD 2000 E-VGT LX AT 디젤',
      RETURNDATE: '20120104',
      ACCNO: '201112171723',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1455110266282',
      CONTRACTNO: 'SS1914111242142',
      RENTFEE: '199000',
      OBJCARNO: '04허6127',
      CARNO: '52허6597',
      ACCPERSONNAME: '김대윤',
      DATA_KEY: '20',
      CARNAMEMSTNAME: '쏘렌토 R 4WD 2200 E-VGT TLX 고급형 AT 디젤',
      RENTDATE: '20111217',
      UNIT24: '190000',
      TERMTYPE: 'S',
      NETSALEAMT: '866909',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '경기오포예약소',
      SALEVATAMT: '86691',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업4팀',
      ACCDATE: '20111217',
      SALEAMT: '953600',
      STARTDATE: ''
    },
    {
      NO: '021',
      CARNAMEMSTNAME2: 'K7 렌터카 2700 V6 뮤 VG270 럭셔리 AT LPG',
      RETURNDATE: '20120102',
      ACCNO: '201112171782',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1410100658696',
      CONTRACTNO: 'SS1903111241440',
      RENTFEE: '266000',
      OBJCARNO: '05허4986',
      CARNO: '63허5979',
      ACCPERSONNAME: '윤원재',
      DATA_KEY: '21',
      CARNAMEMSTNAME: '그랜져 THE LUXURY 2700 LPI 렌터카 Q270 모범형 PACKⅠ AT LPG',
      RENTDATE: '20111217',
      UNIT24: '292000',
      TERMTYPE: 'S',
      NETSALEAMT: '1126400',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '구로현주예약소',
      SALEVATAMT: '112640',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '부천지점',
      ACCDATE: '20111217',
      SALEAMT: '1239040',
      STARTDATE: ''
    },
    {
      NO: '022',
      CARNAMEMSTNAME2: 'SM5 New Impression 렌터카 2000 LPLi 고급형 AT LPG',
      RETURNDATE: '20120106',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1822111244658',
      RENTFEE: '165000',
      OBJCARNO: '63허4584',
      CARNO: '56허9353',
      ACCPERSONNAME: '',
      DATA_KEY: '22',
      CARNAMEMSTNAME: '소나타 Y20 렌터카 2000 LPI Luxury AT LPG',
      RENTDATE: '20111221',
      UNIT24: '150000',
      TERMTYPE: 'S',
      NETSALEAMT: '656509',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '대구하나',
      SALEVATAMT: '65651',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '창원지점',
      ACCDATE: '',
      SALEAMT: '722160',
      STARTDATE: ''
    },
    {
      NO: '023',
      CARNAMEMSTNAME2: '에쿠스 3800 DOHC JS 프리미어 VIP AT 휘발유',
      RETURNDATE: '20120104',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1476111242844',
      RENTFEE: '0',
      OBJCARNO: '24허5641',
      CARNO: '11허4678',
      ACCPERSONNAME: '',
      DATA_KEY: '23',
      CARNAMEMSTNAME: '에쿠스 4500 DOHC VS 프리미어 VIP AT 휘발유',
      RENTDATE: '20111219',
      UNIT24: '447000',
      TERMTYPE: 'S',
      NETSALEAMT: '1903771',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: 'MT기획팀',
      SALEVATAMT: '190377',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '구로지점',
      ACCDATE: '',
      SALEAMT: '2094148',
      STARTDATE: ''
    },
    {
      NO: '024',
      CARNAMEMSTNAME2: '모닝 1000 SOHC L AT 휘발유',
      RETURNDATE: '20120105',
      ACCNO: '201110171805',
      REPAIRNO: '',
      DISCOUNTRATE: '0',
      OBJCONTRACTNO: 'LS1200101264286',
      CONTRACTNO: 'SS1476111085514',
      RENTFEE: '95000',
      OBJCARNO: '69허1124',
      CARNO: '41허2404',
      ACCPERSONNAME: '이준엽',
      DATA_KEY: '24',
      CARNAMEMSTNAME: '클릭 1400 DOHC w 고급형 AT 휘발유',
      RENTDATE: '20111019',
      UNIT24: '95000',
      TERMTYPE: 'M',
      NETSALEAMT: '284364',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: 'MT기획팀',
      SALEVATAMT: '28436',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '원주지점',
      ACCDATE: '20111015',
      SALEAMT: '312800',
      STARTDATE: ''
    },
    {
      NO: '025',
      CARNAMEMSTNAME2: '렉스턴Ⅱ 2700 XDi RX5(2WD) 고급형 AT 디젤',
      RETURNDATE: '20120106',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '0',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1476111124800',
      RENTFEE: '349000',
      OBJCARNO: '45허3075',
      CARNO: '26허8540',
      ACCPERSONNAME: '',
      DATA_KEY: '25',
      CARNAMEMSTNAME: '베라크루즈 3000 V6 E-VGT 300VX Luxury AT 디젤',
      RENTDATE: '20111130',
      UNIT24: '190000',
      TERMTYPE: 'M',
      NETSALEAMT: '202279',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: 'MT기획팀',
      SALEVATAMT: '20228',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '영업4팀',
      ACCDATE: '',
      SALEAMT: '222507',
      STARTDATE: ''
    },
    {
      NO: '026',
      CARNAMEMSTNAME2: '엑센트 1400 CVVT LUXURY AT 휘발유',
      RETURNDATE: '20120106',
      ACCNO: '201112252886',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1452110704310',
      CONTRACTNO: 'SS1806111252509',
      RENTFEE: '165000',
      OBJCARNO: '39허3638',
      CARNO: '62허5105',
      ACCPERSONNAME: '이준엽',
      DATA_KEY: '26',
      CARNAMEMSTNAME: '소나타 Y20 렌터카 2000 LPI Luxury AT LPG',
      RENTDATE: '20111225',
      UNIT24: '99000',
      TERMTYPE: 'S',
      NETSALEAMT: '300218',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '창원대한',
      SALEVATAMT: '30022',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업1팀',
      ACCDATE: '20111225',
      SALEAMT: '330240',
      STARTDATE: ''
    },
    {
      NO: '027',
      CARNAMEMSTNAME2: 'New SM5  2000 CVTC Ⅱ RE AT 휘발유',
      RETURNDATE: '20120110',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1476120165705',
      RENTFEE: '160000',
      OBJCARNO: '60허5521',
      CARNO: '04허2270',
      ACCPERSONNAME: '',
      DATA_KEY: '27',
      CARNAMEMSTNAME: '소나타 Y20 2000 VVT Prime 고급형 AT 휘발유',
      RENTDATE: '20120106',
      UNIT24: '160000',
      TERMTYPE: 'S',
      NETSALEAMT: '199836',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: 'MT기획팀',
      SALEVATAMT: '19984',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '서대문지점',
      ACCDATE: '',
      SALEAMT: '219820',
      STARTDATE: ''
    },
    {
      NO: '028',
      CARNAMEMSTNAME2: '소나타 Y20 렌터카 2000 LPI Deluxe AT LPG',
      RETURNDATE: '20120109',
      ACCNO: '201201050599',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LD1230100150775',
      CONTRACTNO: 'SS1937120165790',
      RENTFEE: '165000',
      OBJCARNO: '44허1325',
      CARNO: '59허3300',
      ACCPERSONNAME: '김현철',
      DATA_KEY: '28',
      CARNAMEMSTNAME: 'NEW SM5 렌터카 2000 CVTC Ⅱ LPLi 고급형 AT LPG',
      RENTDATE: '20120106',
      UNIT24: '165000',
      TERMTYPE: 'S',
      NETSALEAMT: '152455',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '성수한국타이어예약소',
      SALEVATAMT: '15245',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '평택지점',
      ACCDATE: '20120105',
      SALEAMT: '167700',
      STARTDATE: ''
    },
    {
      NO: '029',
      CARNAMEMSTNAME2: '아반떼 M16 1600 LPI 렌터카 DELUXE AT LPG',
      RETURNDATE: '20120105',
      ACCNO: '201201020157',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1230111107986',
      CONTRACTNO: 'SS1822120160743',
      RENTFEE: '165000',
      OBJCARNO: '52허3919',
      CARNO: '28허4038',
      ACCPERSONNAME: '박수호',
      DATA_KEY: '29',
      CARNAMEMSTNAME: '소나타 Y20 렌터카 2000 LPI Luxury AT LPG',
      RENTDATE: '20120102',
      UNIT24: '109000',
      TERMTYPE: 'S',
      NETSALEAMT: '89345',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '대구하나',
      SALEVATAMT: '8935',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '평택지점',
      ACCDATE: '20120102',
      SALEAMT: '98280',
      STARTDATE: ''
    },
    {
      NO: '030',
      CARNAMEMSTNAME2: '싼타페 The Style 4WD 2200 E-VGT CLX DELUXE AT 디젤',
      RETURNDATE: '20120105',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1808111251970',
      RENTFEE: '190000',
      OBJCARNO: '47허5489',
      CARNO: '68허3461',
      ACCPERSONNAME: '',
      DATA_KEY: '30',
      CARNAMEMSTNAME: '투싼 ix 4WD 2000 E-VGT X20 Luxury AT 디젤',
      RENTDATE: '20111227',
      UNIT24: '199000',
      TERMTYPE: 'S',
      NETSALEAMT: '465433',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '동울산',
      SALEVATAMT: '46543',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '부산지점',
      ACCDATE: '',
      SALEAMT: '511976',
      STARTDATE: ''
    },
    {
      NO: '031',
      CARNAMEMSTNAME2: '소나타 Y20 렌터카 2000 LPI Deluxe AT LPG',
      RETURNDATE: '20120103',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1972120161341',
      RENTFEE: '165000',
      OBJCARNO: '42허5307',
      CARNO: '52허5526',
      ACCPERSONNAME: '',
      DATA_KEY: '31',
      CARNAMEMSTNAME: 'K5렌터카 2000 LPI 디럭스 AT LPG',
      RENTDATE: '20120102',
      UNIT24: '165000',
      TERMTYPE: 'S',
      NETSALEAMT: '60000',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '(폐쇄)순천봉화예약소',
      SALEVATAMT: '6000',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '광주지점',
      ACCDATE: '',
      SALEAMT: '66000',
      STARTDATE: ''
    },
    {
      NO: '032',
      CARNAMEMSTNAME2: '스파크 1000 DOHC L AT 휘발유',
      RETURNDATE: '20120109',
      ACCNO: '201201060756',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1452110477653',
      CONTRACTNO: 'SS1360120166227',
      RENTFEE: '95000',
      OBJCARNO: '62허4812',
      CARNO: '04허1293',
      ACCPERSONNAME: '어성환',
      DATA_KEY: '32',
      CARNAMEMSTNAME: '마티즈 크리에이티브 1000 DOHC GROOVE 스타 AT 휘발유',
      RENTDATE: '20120106',
      UNIT24: '95000',
      TERMTYPE: 'S',
      NETSALEAMT: '83022',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '진주사천지점',
      SALEVATAMT: '8302',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업1팀',
      ACCDATE: '20120106',
      SALEAMT: '91324',
      STARTDATE: ''
    },
    {
      NO: '033',
      CARNAMEMSTNAME2: '뉴아반떼 1600 VVT E16 VALUE AT 휘발유',
      RETURNDATE: '20120103',
      ACCNO: '201112293516',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LD1450100658550',
      CONTRACTNO: 'SS1894111258755',
      RENTFEE: '0',
      OBJCARNO: '05허4769',
      CARNO: '32허5749',
      ACCPERSONNAME: '김병준',
      DATA_KEY: '33',
      CARNAMEMSTNAME: 'SM3 1600 CVTC SE AT 휘발유',
      RENTDATE: '20111230',
      UNIT24: '99000',
      TERMTYPE: 'S',
      NETSALEAMT: '137989',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '(폐쇄)수지동화예약소',
      SALEVATAMT: '13799',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업1팀',
      ACCDATE: '20111229',
      SALEAMT: '151788',
      STARTDATE: ''
    },
    {
      NO: '034',
      CARNAMEMSTNAME2: 'K5렌터카 2000 LPI 디럭스 AT LPG',
      RETURNDATE: '20120105',
      ACCNO: '201201020069',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1457110906984',
      CONTRACTNO: 'SS1848120161913',
      RENTFEE: '165000',
      OBJCARNO: '52허3570',
      CARNO: '59허3441',
      ACCPERSONNAME: '김선연',
      DATA_KEY: '34',
      CARNAMEMSTNAME: 'K5렌터카 2000 LPI 디럭스 AT LPG',
      RENTDATE: '20120103',
      UNIT24: '165000',
      TERMTYPE: 'S',
      NETSALEAMT: '109091',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '수원삼정예약소',
      SALEVATAMT: '10909',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업1팀',
      ACCDATE: '20111231',
      SALEAMT: '120000',
      STARTDATE: ''
    },
    {
      NO: '035',
      CARNAMEMSTNAME2: '아반떼 M16 1600 LPI 렌터카 DELUXE AT LPG',
      RETURNDATE: '20120106',
      ACCNO: '201112283456',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1230110591451',
      CONTRACTNO: 'SS1914111254434',
      RENTFEE: '165000',
      OBJCARNO: '62허5308',
      CARNO: '52허7285',
      ACCPERSONNAME: '윤원재',
      DATA_KEY: '35',
      CARNAMEMSTNAME: '소나타 Y20 렌터카 2000 LPI Luxury AT LPG',
      RENTDATE: '20111229',
      UNIT24: '109000',
      TERMTYPE: 'S',
      NETSALEAMT: '214927',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '경기오포예약소',
      SALEVATAMT: '21493',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '평택지점',
      ACCDATE: '20111228',
      SALEAMT: '236420',
      STARTDATE: ''
    },
    {
      NO: '036',
      CARNAMEMSTNAME2: 'New SM5  2000 CVTC Ⅱ SE AT 휘발유',
      RETURNDATE: '20120109',
      ACCNO: '201109080953',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1460100354192',
      CONTRACTNO: 'SS1804120166406',
      RENTFEE: '142000',
      OBJCARNO: '56허9025',
      CARNO: '30허2652',
      ACCPERSONNAME: '김병준',
      DATA_KEY: '36',
      CARNAMEMSTNAME: '소나타 N20 2000 VVT Luxury AT 휘발유',
      RENTDATE: '20120106',
      UNIT24: '160000',
      TERMTYPE: 'S',
      NETSALEAMT: '126615',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '(폐쇄)영등포현주',
      SALEVATAMT: '12661',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업3팀',
      ACCDATE: '20110908',
      SALEAMT: '139276',
      STARTDATE: ''
    },
    {
      NO: '037',
      CARNAMEMSTNAME2: 'K5 2000 I4 세타 Ⅱ 디럭스 AT 휘발유',
      RETURNDATE: '20120110',
      ACCNO: '201112313766',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1230100659515',
      CONTRACTNO: 'SS1869120167365',
      RENTFEE: '266000',
      OBJCARNO: '60허5151',
      CARNO: '52허4214',
      ACCPERSONNAME: '김병준',
      DATA_KEY: '37',
      CARNAMEMSTNAME: '5G 그랜져 2400 GDI HG240 LUXURY AT 휘발유',
      RENTDATE: '20120109',
      UNIT24: '160000',
      TERMTYPE: 'S',
      NETSALEAMT: '52727',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '안산상록예약소',
      SALEVATAMT: '5273',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '평택지점',
      ACCDATE: '20111231',
      SALEAMT: '58000',
      STARTDATE: ''
    },
    {
      NO: '038',
      CARNAMEMSTNAME2: '쏘렌토 R 2WD 2000 E-VGT TLX 프리미엄 AT 디젤',
      RETURNDATE: '20120105',
      ACCNO: '201201040540',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1355100354345',
      CONTRACTNO: 'SS1914120162089',
      RENTFEE: '199000',
      OBJCARNO: '33허9301',
      CARNO: '52허6597',
      ACCPERSONNAME: '김대윤',
      DATA_KEY: '38',
      CARNAMEMSTNAME: '쏘렌토 R 4WD 2200 E-VGT TLX 고급형 AT 디젤',
      RENTDATE: '20120105',
      UNIT24: '199000',
      TERMTYPE: 'S',
      NETSALEAMT: '62182',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '경기오포예약소',
      SALEVATAMT: '6218',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '부산지점',
      ACCDATE: '20120104',
      SALEAMT: '68400',
      STARTDATE: ''
    },
    {
      NO: '039',
      CARNAMEMSTNAME2: '투싼 ix 2WD 2000 E-VGT X20 Deluxe AT 디젤',
      RETURNDATE: '20120109',
      ACCNO: '201201050586',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1450091046898',
      CONTRACTNO: 'SS1921120162342',
      RENTFEE: '270000',
      OBJCARNO: '56허8233',
      CARNO: '60허5188',
      ACCPERSONNAME: '김선연',
      DATA_KEY: '39',
      CARNAMEMSTNAME: '뉴 카니발R 9P 2200 E-VGT GX AT 디젤',
      RENTDATE: '20120105',
      UNIT24: '190000',
      TERMTYPE: 'S',
      NETSALEAMT: '211382',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '안산사동예약소',
      SALEVATAMT: '21138',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업5팀',
      ACCDATE: '20120105',
      SALEAMT: '232520',
      STARTDATE: ''
    },
    {
      NO: '040',
      CARNAMEMSTNAME2: '라세티 1600 DOHC EX일반형 AT 휘발유/LPG',
      RETURNDATE: '20120103',
      ACCNO: '201112293473',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1470080931355',
      CONTRACTNO: 'SS1869111254442',
      RENTFEE: '165000',
      OBJCARNO: '41허4100',
      CARNO: '60허6544',
      ACCPERSONNAME: '김현철',
      DATA_KEY: '40',
      CARNAMEMSTNAME: '소나타 Y20 렌터카 2000 LPI Luxury AT LPG',
      RENTDATE: '20111229',
      UNIT24: '99000',
      TERMTYPE: 'S',
      NETSALEAMT: '142280',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '안산상록예약소',
      SALEVATAMT: '14228',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업2팀',
      ACCDATE: '20111229',
      SALEAMT: '156508',
      STARTDATE: ''
    },
    {
      NO: '041',
      CARNAMEMSTNAME2: '모닝 1000 LPI LX 기본 블랙프리미엄 AT LPG',
      RETURNDATE: '20120110',
      ACCNO: '201201060715',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1100100252511',
      CONTRACTNO: 'SS1833120168582',
      RENTFEE: '165000',
      OBJCARNO: '59허1615',
      CARNO: '59허9108',
      ACCPERSONNAME: '김병준',
      DATA_KEY: '41',
      CARNAMEMSTNAME: 'NEW SM5 렌터카 2000 CVTC Ⅱ LPLi 고급형 AT LPG',
      RENTDATE: '20120106',
      UNIT24: '95000',
      TERMTYPE: 'S',
      NETSALEAMT: '97658',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '부천남부예약소',
      SALEVATAMT: '9766',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '인천지점',
      ACCDATE: '20120106',
      SALEAMT: '107424',
      STARTDATE: ''
    },
    {
      NO: '042',
      CARNAMEMSTNAME2: 'New SM5  2000 CVTC Ⅱ RE AT 휘발유',
      RETURNDATE: '20120106',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1937120161722',
      RENTFEE: '160000',
      OBJCARNO: '28허2609',
      CARNO: '62허5088',
      ACCPERSONNAME: '',
      DATA_KEY: '42',
      CARNAMEMSTNAME: '소나타 Y20 2000 I4 세타 Ⅱ Prime AT 휘발유',
      RENTDATE: '20120104',
      UNIT24: '160000',
      TERMTYPE: 'S',
      NETSALEAMT: '136844',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '성수한국타이어예약소',
      SALEVATAMT: '13684',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '영업4팀',
      ACCDATE: '',
      SALEAMT: '150528',
      STARTDATE: ''
    },
    {
      NO: '043',
      CARNAMEMSTNAME2: '아반떼 M16 GDi 1600 GDI DELUXE AT 휘발유',
      RETURNDATE: '20120106',
      ACCNO: '201112070719',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1420101062825',
      CONTRACTNO: 'SS1913120161724',
      RENTFEE: '142000',
      OBJCARNO: '63허4609',
      CARNO: '32허5921',
      ACCPERSONNAME: '윤원재',
      DATA_KEY: '43',
      CARNAMEMSTNAME: 'SM5 New Impression 2000 CVTC LE AT 휘발유',
      RENTDATE: '20120103',
      UNIT24: '109000',
      TERMTYPE: 'S',
      NETSALEAMT: '89345',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '성동성수예약소',
      SALEVATAMT: '8935',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업1팀',
      ACCDATE: '20111207',
      SALEAMT: '98280',
      STARTDATE: ''
    },
    {
      NO: '044',
      CARNAMEMSTNAME2: '뉴프라이드(5DR) 1500 VGT LX AT 디젤',
      RETURNDATE: '20120104',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1965111255011',
      RENTFEE: '165000',
      OBJCARNO: '28허2348',
      CARNO: '63허5307',
      ACCPERSONNAME: '',
      DATA_KEY: '44',
      CARNAMEMSTNAME: 'NEW SM5 렌터카 2000 CVTC Ⅱ LPLi 고급형 AT LPG',
      RENTDATE: '20111230',
      UNIT24: '99000',
      TERMTYPE: 'S',
      NETSALEAMT: '167771',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '김포장기예약소',
      SALEVATAMT: '16777',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '영업5팀',
      ACCDATE: '',
      SALEAMT: '184548',
      STARTDATE: ''
    },
    {
      NO: '045',
      CARNAMEMSTNAME2: '제네시스 3300 GDI BH330 GRAND PRIME PACK AT 휘발유',
      RETURNDATE: '20120110',
      ACCNO: '201201020107',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1350110703640',
      CONTRACTNO: 'SS1350120162375',
      RENTFEE: '292000',
      OBJCARNO: '68허3480',
      CARNO: '47허5836',
      ACCPERSONNAME: '박수호',
      DATA_KEY: '45',
      CARNAMEMSTNAME: '알페온 3000 SIDI 스페셜 AT 휘발유',
      RENTDATE: '20120103',
      UNIT24: '399000',
      TERMTYPE: 'S',
      NETSALEAMT: '539636',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '김해공항지점',
      SALEVATAMT: '53964',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '김해공항지점',
      ACCDATE: '20120102',
      SALEAMT: '593600',
      STARTDATE: ''
    },
    {
      NO: '046',
      CARNAMEMSTNAME2: '스포티지R 2WD 2000 E-VGT TLX 고급형 AT 디젤',
      RETURNDATE: '20120110',
      ACCNO: '201201040484',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1455111007581',
      CONTRACTNO: 'SS1878120162449',
      RENTFEE: '190000',
      OBJCARNO: '26허8225',
      CARNO: '06허4754',
      ACCPERSONNAME: '김병준',
      DATA_KEY: '46',
      CARNAMEMSTNAME: '스포티지R 4WD 2000 E-VGT LX AT 디젤',
      RENTDATE: '20120105',
      UNIT24: '190000',
      TERMTYPE: 'S',
      NETSALEAMT: '285727',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '성수트루예약소',
      SALEVATAMT: '28573',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업4팀',
      ACCDATE: '20120104',
      SALEAMT: '314300',
      STARTDATE: ''
    },
    {
      NO: '047',
      CARNAMEMSTNAME2: 'K5렌터카 2000 LPI 프레스티지 AT LPG',
      RETURNDATE: '20120102',
      ACCNO: '201112293575',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1480101264684',
      CONTRACTNO: 'SS1818111255368',
      RENTFEE: '165000',
      OBJCARNO: '31허4524',
      CARNO: '52허7340',
      ACCPERSONNAME: '김선연',
      DATA_KEY: '47',
      CARNAMEMSTNAME: '소나타 Y20 렌터카 2000 LPI Luxury AT LPG',
      RENTDATE: '20111229',
      UNIT24: '165000',
      TERMTYPE: 'S',
      NETSALEAMT: '185393',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '도곡예약소',
      SALEVATAMT: '18539',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '전주지점',
      ACCDATE: '20111229',
      SALEAMT: '203932',
      STARTDATE: ''
    },
    {
      NO: '048',
      CARNAMEMSTNAME2: 'All New 모닝 1000 MPI 스마트 스페셜 AT 휘발유',
      RETURNDATE: '20120105',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1476111252987',
      RENTFEE: '0',
      OBJCARNO: '06허4819',
      CARNO: '59허2124',
      ACCPERSONNAME: '',
      DATA_KEY: '48',
      CARNAMEMSTNAME: 'SM3 1600 CVTC LE16 AT 휘발유',
      RENTDATE: '20111227',
      UNIT24: '95000',
      TERMTYPE: 'S',
      NETSALEAMT: '206836',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: 'MT기획팀',
      SALEVATAMT: '20684',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '영업2팀',
      ACCDATE: '',
      SALEAMT: '227520',
      STARTDATE: ''
    },
    {
      NO: '049',
      CARNAMEMSTNAME2: '소나타 Y20 렌터카 2000 LPI Deluxe AT LPG',
      RETURNDATE: '20120103',
      ACCNO: '201201020108',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1280111209640',
      CONTRACTNO: 'SS1898120168222',
      RENTFEE: '266000',
      OBJCARNO: '52허6691',
      CARNO: '32허4423',
      ACCPERSONNAME: '김선연',
      DATA_KEY: '49',
      CARNAMEMSTNAME: '그랜져TG 2700 LPI Q270 모범형 PACK 2 AT LPG',
      RENTDATE: '20120102',
      UNIT24: '165000',
      TERMTYPE: 'S',
      NETSALEAMT: '54545',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '서울석촌예약소',
      SALEVATAMT: '5455',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '순천여수지점',
      ACCDATE: '20120102',
      SALEAMT: '60000',
      STARTDATE: ''
    },
    {
      NO: '050',
      CARNAMEMSTNAME2: '봉고Ⅲ 1톤 4X4 더블캡 2900 CRDI 장축 GX 고급형 MT 디젤',
      RETURNDATE: '20120105',
      ACCNO: '201112232641',
      REPAIRNO: '',
      DISCOUNTRATE: '50',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1476111249791',
      RENTFEE: '190000',
      OBJCARNO: '86우8937',
      CARNO: '15허2931',
      ACCPERSONNAME: '김선연',
      DATA_KEY: '50',
      CARNAMEMSTNAME: '액티언 2000 XVT CLUB (2WD) AT 디젤',
      RENTDATE: '20111223',
      UNIT24: '0',
      TERMTYPE: 'S',
      NETSALEAMT: '922000',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: 'MT기획팀',
      SALEVATAMT: '92200',
      REPAIRPERSONNAME: '',
      PROMOCODE: '리스대차',
      TERMTYPE2: '',
      DEPTNAME: 'AJ캐피탈',
      ACCDATE: '20111222',
      SALEAMT: '1014200',
      STARTDATE: ''
    },
    {
      NO: '051',
      CARNAMEMSTNAME2: 'i30 1600 VGT Luxury AT 디젤',
      RETURNDATE: '20120106',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1855120169555',
      RENTFEE: '150000',
      OBJCARNO: '60허6472',
      CARNO: '41허3815',
      ACCPERSONNAME: '',
      DATA_KEY: '51',
      CARNAMEMSTNAME: '소나타 트랜스폼 N20 2000 LPI Deluxe AT LPG',
      RENTDATE: '20120105',
      UNIT24: '116000',
      TERMTYPE: 'S',
      NETSALEAMT: '33091',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '부산연산역',
      SALEVATAMT: '3309',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '잠실지점',
      ACCDATE: '',
      SALEAMT: '36400',
      STARTDATE: ''
    },
    {
      NO: '052',
      CARNAMEMSTNAME2: '로체 이노베이션 렌트카 2000 LPI LX20 기본형 AT LPG',
      RETURNDATE: '20120105',
      ACCNO: '201112303726',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1474091046505',
      CONTRACTNO: 'SS1914120159301',
      RENTFEE: '165000',
      OBJCARNO: '04허1377',
      CARNO: '59허3356',
      ACCPERSONNAME: '김대윤',
      DATA_KEY: '52',
      CARNAMEMSTNAME: 'K5렌터카 2000 LPI 디럭스 AT LPG',
      RENTDATE: '20120102',
      UNIT24: '150000',
      TERMTYPE: 'S',
      NETSALEAMT: '133527',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '경기오포예약소',
      SALEVATAMT: '13353',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '잠실지점',
      ACCDATE: '20111230',
      SALEAMT: '146880',
      STARTDATE: ''
    },
    {
      NO: '053',
      CARNAMEMSTNAME2: '카니발R 리무진 9P 2200 E-VGT President AT 디젤',
      RETURNDATE: '20120104',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1476111252984',
      RENTFEE: '142000',
      OBJCARNO: '06허4531',
      CARNO: '41허4595',
      ACCPERSONNAME: '',
      DATA_KEY: '53',
      CARNAMEMSTNAME: 'SM5 New Impression 2000 CVTC LE AT 휘발유',
      RENTDATE: '20111227',
      UNIT24: '317000',
      TERMTYPE: 'S',
      NETSALEAMT: '300218',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: 'MT기획팀',
      SALEVATAMT: '30022',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '부평지점',
      ACCDATE: '',
      SALEAMT: '330240',
      STARTDATE: ''
    },
    {
      NO: '054',
      CARNAMEMSTNAME2: 'K5렌터카 2000 LPI 스마트 AT LPG',
      RETURNDATE: '20120105',
      ACCNO: '201201040511',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1457110266244',
      CONTRACTNO: 'SS1822120162135',
      RENTFEE: '165000',
      OBJCARNO: '04허6116',
      CARNO: '62허4074',
      ACCPERSONNAME: '정해성',
      DATA_KEY: '54',
      CARNAMEMSTNAME: 'K5렌터카 2000 LPI 디럭스 AT LPG',
      RENTDATE: '20120104',
      UNIT24: '165000',
      TERMTYPE: 'S',
      NETSALEAMT: '76364',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '대구하나',
      SALEVATAMT: '7636',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업1팀',
      ACCDATE: '20120104',
      SALEAMT: '84000',
      STARTDATE: ''
    },
    {
      NO: '055',
      CARNAMEMSTNAME2: '체어맨 H 3200 DOHC 600S  최고급형 AT 휘발유',
      RETURNDATE: '20120106',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '50',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1476120162140',
      RENTFEE: '447000',
      OBJCARNO: '40부1670',
      CARNO: '59허1629',
      ACCPERSONNAME: '',
      DATA_KEY: '55',
      CARNAMEMSTNAME: '체어맨 W 3600 IL6 CW 700 VVIP AT 휘발유',
      RENTDATE: '20120104',
      UNIT24: '377000',
      TERMTYPE: 'S',
      NETSALEAMT: '425332',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: 'MT기획팀',
      SALEVATAMT: '42533',
      REPAIRPERSONNAME: '',
      PROMOCODE: '리스대차',
      TERMTYPE2: '',
      DEPTNAME: 'AJ캐피탈',
      ACCDATE: '',
      SALEAMT: '467865',
      STARTDATE: ''
    },
    {
      NO: '056',
      CARNAMEMSTNAME2: '스파크 1000 DOHC L AT LPG',
      RETURNDATE: '20120105',
      ACCNO: '201201020139',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1110111007347',
      CONTRACTNO: 'SS1818120159831',
      RENTFEE: '99000',
      OBJCARNO: '52허3650',
      CARNO: '41허2222',
      ACCPERSONNAME: '김병준',
      DATA_KEY: '56',
      CARNAMEMSTNAME: '뉴아반떼 1600 VVT E16 DELUXE AT 휘발유',
      RENTDATE: '20120102',
      UNIT24: '95000',
      TERMTYPE: 'S',
      NETSALEAMT: '77564',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '도곡예약소',
      SALEVATAMT: '7756',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '인천공항지점',
      ACCDATE: '20120102',
      SALEAMT: '85320',
      STARTDATE: ''
    },
    {
      NO: '057',
      CARNAMEMSTNAME2: 'K7 The Prestige 2400 I4 세타 Ⅱ 2.4GDI 럭셔리 AT 휘발유',
      RETURNDATE: '20120105',
      ACCNO: '201201020061',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1456111107991',
      CONTRACTNO: 'SS1818120159837',
      RENTFEE: '266000',
      OBJCARNO: '39허7262',
      CARNO: '41허2387',
      ACCPERSONNAME: '윤원재',
      DATA_KEY: '57',
      CARNAMEMSTNAME: '그랜져TG 2700 DOHC Q270 LUXURY AT 휘발유',
      RENTDATE: '20120102',
      UNIT24: '266000',
      TERMTYPE: 'S',
      NETSALEAMT: '190473',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '도곡예약소',
      SALEVATAMT: '19047',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업5팀',
      ACCDATE: '20120102',
      SALEAMT: '209520',
      STARTDATE: ''
    },
    {
      NO: '058',
      CARNAMEMSTNAME2: '그랜져TG 2700 DOHC Q270 DELUXE AT 휘발유',
      RETURNDATE: '20120103',
      ACCNO: '201201020109',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1460090540237',
      CONTRACTNO: 'SS1818120159862',
      RENTFEE: '399000',
      OBJCARNO: '03허9053',
      CARNO: '60허5193',
      ACCPERSONNAME: '김병준',
      DATA_KEY: '58',
      CARNAMEMSTNAME: '제네시스 3300 람다 BH330 LUXURY AT 휘발유',
      RENTDATE: '20120102',
      UNIT24: '266000',
      TERMTYPE: 'S',
      NETSALEAMT: '88000',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '도곡예약소',
      SALEVATAMT: '8800',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업5팀',
      ACCDATE: '20120101',
      SALEAMT: '96800',
      STARTDATE: ''
    },
    {
      NO: '059',
      CARNAMEMSTNAME2: '에쿠스 3800 DOHC JS 프리미어 VIP AT 휘발유',
      RETURNDATE: '20120104',
      ACCNO: '201201010051',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1470080627838',
      CONTRACTNO: 'SS1818120159865',
      RENTFEE: '488000',
      OBJCARNO: '18허4138',
      CARNO: '63허8788',
      ACCPERSONNAME: '김현철',
      DATA_KEY: '59',
      CARNAMEMSTNAME: '에쿠스 TRUE PRESTIGE 3800 V6 람다 VS 380 프라임 AT 휘발유',
      RENTDATE: '20120102',
      UNIT24: '447000',
      TERMTYPE: 'S',
      NETSALEAMT: '295273',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '도곡예약소',
      SALEVATAMT: '29527',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업2팀',
      ACCDATE: '20120101',
      SALEAMT: '324800',
      STARTDATE: ''
    },
    {
      NO: '060',
      CARNAMEMSTNAME2: '엑센트 WIT 1600 VGT Premier AT 디젤',
      RETURNDATE: '20120109',
      ACCNO: '201112293546',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1452110805404',
      CONTRACTNO: 'SS1476111255262',
      RENTFEE: '150000',
      OBJCARNO: '39허4370',
      CARNO: '44허1078',
      ACCPERSONNAME: '김현철',
      DATA_KEY: '60',
      CARNAMEMSTNAME: '토스카 PREMIUM 6 2000 LPGi L6 2.0 AT LPG',
      RENTDATE: '20111229',
      UNIT24: '99000',
      TERMTYPE: 'S',
      NETSALEAMT: '275200',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: 'MT기획팀',
      SALEVATAMT: '27520',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업1팀',
      ACCDATE: '20111229',
      SALEAMT: '302720',
      STARTDATE: ''
    },
    {
      NO: '061',
      CARNAMEMSTNAME2: '제네시스 3300 람다 BH330 LUXURY AT 휘발유',
      RETURNDATE: '20120106',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1476111255264',
      RENTFEE: '349000',
      OBJCARNO: '12허4353',
      CARNO: '11허9831',
      ACCPERSONNAME: '',
      DATA_KEY: '61',
      CARNAMEMSTNAME: '뉴 오피러스 3300 V6 뮤 GH330 최고급 럭셔리 AT 휘발유',
      RENTDATE: '20111229',
      UNIT24: '399000',
      TERMTYPE: 'S',
      NETSALEAMT: '798255',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: 'MT기획팀',
      SALEVATAMT: '79825',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '청주지점',
      ACCDATE: '',
      SALEAMT: '878080',
      STARTDATE: ''
    },
    {
      NO: '062',
      CARNAMEMSTNAME2: '5G 그랜져 3000 GDI HG300 PRIME AT 휘발유',
      RETURNDATE: '20120103',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1836111255578',
      RENTFEE: '292000',
      OBJCARNO: '24허4567',
      CARNO: '63허8997',
      ACCPERSONNAME: '',
      DATA_KEY: '62',
      CARNAMEMSTNAME: 'K7 렌터카 2700 V6 뮤 VG270 럭셔리 AT LPG',
      RENTDATE: '20111230',
      UNIT24: '292000',
      TERMTYPE: 'S',
      NETSALEAMT: '350240',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '김천지점',
      SALEVATAMT: '35024',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '영업3팀',
      ACCDATE: '',
      SALEAMT: '385264',
      STARTDATE: ''
    },
    {
      NO: '063',
      CARNAMEMSTNAME2: '그랜드 스타렉스 12P WAGON 2500 VGT CVX Luxury AT 디젤',
      RETURNDATE: '20120110',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1300120162383',
      RENTFEE: '270000',
      OBJCARNO: '75허2038',
      CARNO: '20허3036',
      ACCPERSONNAME: '',
      DATA_KEY: '63',
      CARNAMEMSTNAME: '뉴 카니발 9P 2900 VGT GX AT 디젤',
      RENTDATE: '20120105',
      UNIT24: '219000',
      TERMTYPE: 'S',
      NETSALEAMT: '311135',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '울산지점',
      SALEVATAMT: '31113',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '울산지점',
      ACCDATE: '',
      SALEAMT: '342248',
      STARTDATE: ''
    },
    {
      NO: '064',
      CARNAMEMSTNAME2: '스파크 1000 DOHC L AT LPG',
      RETURNDATE: '20120103',
      ACCNO: '201201010008',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1452110906118',
      CONTRACTNO: 'SS1130120159795',
      RENTFEE: '95000',
      OBJCARNO: '52허3377',
      CARNO: '21허5778',
      ACCPERSONNAME: '김병준',
      DATA_KEY: '64',
      CARNAMEMSTNAME: '모닝 1000 LPI LX 기본 블랙프리미엄 AT LPG',
      RENTDATE: '20120102',
      UNIT24: '95000',
      TERMTYPE: 'S',
      NETSALEAMT: '34473',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '수원지점',
      SALEVATAMT: '3447',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업1팀',
      ACCDATE: '20120101',
      SALEAMT: '37920',
      STARTDATE: ''
    },
    {
      NO: '065',
      CARNAMEMSTNAME2: '아반떼 M16 1600 LPI 렌터카 DELUXE AT LPG',
      RETURNDATE: '20120105',
      ACCNO: '201201040408',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1250111007746',
      CONTRACTNO: 'SS1818120161608',
      RENTFEE: '165000',
      OBJCARNO: '52허3825',
      CARNO: '27허7435',
      ACCPERSONNAME: '김현철',
      DATA_KEY: '65',
      CARNAMEMSTNAME: '소나타 Y20 렌터카 2000 LPI Premier AT LPG',
      RENTDATE: '20120104',
      UNIT24: '109000',
      TERMTYPE: 'S',
      NETSALEAMT: '52945',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '도곡예약소',
      SALEVATAMT: '5295',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '대전지점',
      ACCDATE: '20120103',
      SALEAMT: '58240',
      STARTDATE: ''
    },
    {
      NO: '066',
      CARNAMEMSTNAME2: '그랜져TG 2700 LPI Q270 모범형 AT LPG',
      RETURNDATE: '20120102',
      ACCNO: '201112283373',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1460080829793',
      CONTRACTNO: 'SS1476111253858',
      RENTFEE: '266000',
      OBJCARNO: '46허5708',
      CARNO: '32허5896',
      ACCPERSONNAME: '김대윤',
      DATA_KEY: '66',
      CARNAMEMSTNAME: '그랜져TG 2700 LPI Q270 모범형 PACK 2 AT LPG',
      RENTDATE: '20111228',
      UNIT24: '266000',
      TERMTYPE: 'S',
      NETSALEAMT: '378345',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: 'MT기획팀',
      SALEVATAMT: '37835',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업1팀',
      ACCDATE: '20111228',
      SALEAMT: '416180',
      STARTDATE: ''
    },
    {
      NO: '067',
      CARNAMEMSTNAME2: '카니발R 리무진 9P 2200 E-VGT President AT 디젤',
      RETURNDATE: '20120103',
      ACCNO: '201112283442',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1480100962280',
      CONTRACTNO: 'SS1965111254276',
      RENTFEE: '349000',
      OBJCARNO: '31허4511',
      CARNO: '59허1204',
      ACCPERSONNAME: '김현철',
      DATA_KEY: '67',
      CARNAMEMSTNAME: '베라크루즈 4WD 3000 E-VGT 300VX Luxury AT 디젤',
      RENTDATE: '20111229',
      UNIT24: '317000',
      TERMTYPE: 'S',
      NETSALEAMT: '475822',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '김포장기예약소',
      SALEVATAMT: '47582',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '전주지점',
      ACCDATE: '20111228',
      SALEAMT: '523404',
      STARTDATE: ''
    },
    {
      NO: '068',
      CARNAMEMSTNAME2: '그랜져 THE LUXURY 3300 DOHC ALCANTARA PACK L330 VIP AT 휘발유',
      RETURNDATE: '20120104',
      ACCNO: '201201030264',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1450100354256',
      CONTRACTNO: 'SS1818120160722',
      RENTFEE: '399000',
      OBJCARNO: '56허9059',
      CARNO: '60허5193',
      ACCPERSONNAME: '김병준',
      DATA_KEY: '68',
      CARNAMEMSTNAME: '제네시스 3300 람다 BH330 LUXURY AT 휘발유',
      RENTDATE: '20120103',
      UNIT24: '292000',
      TERMTYPE: 'S',
      NETSALEAMT: '101455',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '도곡예약소',
      SALEVATAMT: '10145',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업1팀',
      ACCDATE: '20120102',
      SALEAMT: '111600',
      STARTDATE: ''
    },
    {
      NO: '069',
      CARNAMEMSTNAME2: '그랜져TG 2700 DOHC Q270 DELUXE AT 휘발유',
      RETURNDATE: '20120109',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1260120160822',
      RENTFEE: '266000',
      OBJCARNO: '26허5893',
      CARNO: '42허5441',
      ACCPERSONNAME: '',
      DATA_KEY: '69',
      CARNAMEMSTNAME: '그랜져TG 2700 LPI Q270 모범형 PACK 1 AT LPG',
      RENTDATE: '20120102',
      UNIT24: '266000',
      TERMTYPE: 'S',
      NETSALEAMT: '492800',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '광주지점',
      SALEVATAMT: '49280',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '영업2팀',
      ACCDATE: '',
      SALEAMT: '542080',
      STARTDATE: ''
    },
    {
      NO: '070',
      CARNAMEMSTNAME2: '뉴프라이드(5DR) 1500 VGT LX AT 디젤',
      RETURNDATE: '20120103',
      ACCNO: '201112283382',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1450081234668',
      CONTRACTNO: 'SS1913111254147',
      RENTFEE: '109000',
      OBJCARNO: '32허2305',
      CARNO: '63허8839',
      ACCPERSONNAME: '김대윤',
      DATA_KEY: '70',
      CARNAMEMSTNAME: '아반떼 M16 GDi 1600 GDI LUXURY AT 휘발유',
      RENTDATE: '20111228',
      UNIT24: '99000',
      TERMTYPE: 'S',
      NETSALEAMT: '171971',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '성동성수예약소',
      SALEVATAMT: '17197',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업5팀',
      ACCDATE: '20111228',
      SALEAMT: '189168',
      STARTDATE: ''
    },
    {
      NO: '071',
      CARNAMEMSTNAME2: '쏘렌토 R 4WD 2200 E-VGT TLX 고급형 AT 디젤',
      RETURNDATE: '20120104',
      ACCNO: '201112283426',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1433111108696',
      CONTRACTNO: 'SS1866111254507',
      RENTFEE: '199000',
      OBJCARNO: '52허5324',
      CARNO: '26허7774',
      ACCPERSONNAME: '이준엽',
      DATA_KEY: '71',
      CARNAMEMSTNAME: '윈스톰 7인승 2000 VCDi LT-XTREME AT 디젤',
      RENTDATE: '20111229',
      UNIT24: '199000',
      TERMTYPE: 'S',
      NETSALEAMT: '335782',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '상주지점',
      SALEVATAMT: '33578',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '안양지점',
      ACCDATE: '20111228',
      SALEAMT: '369360',
      STARTDATE: ''
    },
    {
      NO: '072',
      CARNAMEMSTNAME2: '스파크 1000 DOHC LS AT 휘발유',
      RETURNDATE: '20120103',
      ACCNO: '201112273269',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1130111007125',
      CONTRACTNO: 'SS1869120160002',
      RENTFEE: '95000',
      OBJCARNO: '52허3647',
      CARNO: '56허9473',
      ACCPERSONNAME: '김병준',
      DATA_KEY: '72',
      CARNAMEMSTNAME: '모닝 1000 SOHC LX 기본형 AT 휘발유',
      RENTDATE: '20120102',
      UNIT24: '95000',
      TERMTYPE: 'S',
      NETSALEAMT: '31600',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '안산상록예약소',
      SALEVATAMT: '3160',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '수원지점',
      ACCDATE: '20111227',
      SALEAMT: '34760',
      STARTDATE: ''
    },
    {
      NO: '073',
      CARNAMEMSTNAME2: '오피러스 PREMIUM 2700 V6 뮤 GH270 디럭스 AT 휘발유',
      RETURNDATE: '20120109',
      ACCNO: '201201050549',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1330110366871',
      CONTRACTNO: 'SS1330120163051',
      RENTFEE: '292000',
      OBJCARNO: '04허6827',
      CARNO: '44허2244',
      ACCPERSONNAME: '정해성',
      DATA_KEY: '73',
      CARNAMEMSTNAME: 'K7 2700 V6 뮤 VG270 럭셔리 AT 휘발유',
      RENTDATE: '20120105',
      UNIT24: '307000',
      TERMTYPE: 'S',
      NETSALEAMT: '316800',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '창원지점',
      SALEVATAMT: '31680',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '창원지점',
      ACCDATE: '20120105',
      SALEAMT: '348480',
      STARTDATE: ''
    },
    {
      NO: '074',
      CARNAMEMSTNAME2: 'All New 모닝 바이퓨얼 1000 MPI 스마트 AT 휘발유/LPG',
      RETURNDATE: '20120104',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1120120161182',
      RENTFEE: '109000',
      OBJCARNO: '45허4557',
      CARNO: '39허3606',
      ACCPERSONNAME: '',
      DATA_KEY: '74',
      CARNAMEMSTNAME: '아반떼 M16 1600 LPI 렌터카 LUXURY AT LPG',
      RENTDATE: '20120103',
      UNIT24: '95000',
      TERMTYPE: 'S',
      NETSALEAMT: '28727',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '구로지점',
      SALEVATAMT: '2873',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '서울대지점',
      ACCDATE: '',
      SALEAMT: '31600',
      STARTDATE: ''
    },
    {
      NO: '075',
      CARNAMEMSTNAME2: 'New SM5  2000 CVTC Ⅱ LE AT 휘발유',
      RETURNDATE: '20120105',
      ACCNO: '201201030279',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1050110703851',
      CONTRACTNO: 'SS1974120161420',
      RENTFEE: '165000',
      OBJCARNO: '06허4719',
      CARNO: '59허3381',
      ACCPERSONNAME: '김현철',
      DATA_KEY: '75',
      CARNAMEMSTNAME: 'K5렌터카 2000 LPI 디럭스 AT LPG',
      RENTDATE: '20120103',
      UNIT24: '160000',
      TERMTYPE: 'S',
      NETSALEAMT: '105455',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '성남단대역예약소',
      SALEVATAMT: '10545',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '분당지점',
      ACCDATE: '20111229',
      SALEAMT: '116000',
      STARTDATE: ''
    },
    {
      NO: '076',
      CARNAMEMSTNAME2: '소나타 Y20 렌터카 2000 LPI Luxury AT LPG',
      RETURNDATE: '20120110',
      ACCNO: '201201060754',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1410110265779',
      CONTRACTNO: 'SS1844120174156',
      RENTFEE: '266000',
      OBJCARNO: '26허6655',
      CARNO: '38허4388',
      ACCPERSONNAME: '김병준',
      DATA_KEY: '76',
      CARNAMEMSTNAME: '그랜져TG 2700 LPI Q270 모범형 AT LPG',
      RENTDATE: '20120106',
      UNIT24: '165000',
      TERMTYPE: 'S',
      NETSALEAMT: '196364',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '주안예약소',
      SALEVATAMT: '19636',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '부천지점',
      ACCDATE: '20120106',
      SALEAMT: '216000',
      STARTDATE: ''
    },
    {
      NO: '077',
      CARNAMEMSTNAME2: '소나타 Y20 렌터카 2000 LPI Luxury AT LPG',
      RETURNDATE: '20120105',
      ACCNO: '201201020100',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'SS1130111241197',
      CONTRACTNO: 'SS1848120161910',
      RENTFEE: '165000',
      OBJCARNO: '60허6594',
      CARNO: '09허9282',
      ACCPERSONNAME: '김병준',
      DATA_KEY: '77',
      CARNAMEMSTNAME: '소나타 Y20 렌터카 2000 LPI Luxury AT LPG',
      RENTDATE: '20120102',
      UNIT24: '165000',
      TERMTYPE: 'S',
      NETSALEAMT: '147273',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '수원삼정예약소',
      SALEVATAMT: '14727',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'M',
      DEPTNAME: '수원지점',
      ACCDATE: '20120102',
      SALEAMT: '162000',
      STARTDATE: ''
    },
    {
      NO: '078',
      CARNAMEMSTNAME2: '소나타 Y20 렌터카 2000 LPI Deluxe AT LPG',
      RETURNDATE: '20120105',
      ACCNO: '201201030356',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1130100759549',
      CONTRACTNO: 'SS1818120161618',
      RENTFEE: '165000',
      OBJCARNO: '60허5081',
      CARNO: '52허7340',
      ACCPERSONNAME: '윤원재',
      DATA_KEY: '78',
      CARNAMEMSTNAME: '소나타 Y20 렌터카 2000 LPI Luxury AT LPG',
      RENTDATE: '20120104',
      UNIT24: '165000',
      TERMTYPE: 'S',
      NETSALEAMT: '87273',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '도곡예약소',
      SALEVATAMT: '8727',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '수원지점',
      ACCDATE: '20111230',
      SALEAMT: '96000',
      STARTDATE: ''
    },
    {
      NO: '079',
      CARNAMEMSTNAME2: '소나타 트랜스폼 N20 2000 LPI 일반형 AT LPG',
      RETURNDATE: '20120105',
      ACCNO: '201112303609',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1130100353613',
      CONTRACTNO: 'SS1837111258706',
      RENTFEE: '150000',
      OBJCARNO: '56허8892',
      CARNO: '27허5995',
      ACCPERSONNAME: '정해성',
      DATA_KEY: '79',
      CARNAMEMSTNAME: '소나타 N20 2000 LPI LUX 기본형 AT LPG',
      RENTDATE: '20111229',
      UNIT24: '150000',
      TERMTYPE: 'S',
      NETSALEAMT: '276945',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '부산태원',
      SALEVATAMT: '27695',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '수원지점',
      ACCDATE: '20111229',
      SALEAMT: '304640',
      STARTDATE: ''
    },
    {
      NO: '080',
      CARNAMEMSTNAME2: '소나타 트랜스폼 N20 2000 LPI TAXI VTX AT LPG',
      RETURNDATE: '20120107',
      ACCNO: '201201020060',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1455110368374',
      CONTRACTNO: 'SS1943120159496',
      RENTFEE: '150000',
      OBJCARNO: '62허4376',
      CARNO: '69허1796',
      ACCPERSONNAME: '이준엽',
      DATA_KEY: '80',
      CARNAMEMSTNAME: '소나타 N20 2000 LPI DLX 기본형 AT LPG',
      RENTDATE: '20120102',
      UNIT24: '150000',
      TERMTYPE: 'S',
      NETSALEAMT: '251985',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '음성대소예약소',
      SALEVATAMT: '25199',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업4팀',
      ACCDATE: '20120101',
      SALEAMT: '277184',
      STARTDATE: ''
    },
    {
      NO: '081',
      CARNAMEMSTNAME2: '그랜드 카니발R 11P 2200 E-VGT GLX AT 디젤',
      RETURNDATE: '20120104',
      ACCNO: '201112293528',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1130111209197',
      CONTRACTNO: 'SS1937111258624',
      RENTFEE: '199000',
      OBJCARNO: '74허3317',
      CARNO: '41허2873',
      ACCPERSONNAME: '김현철',
      DATA_KEY: '81',
      CARNAMEMSTNAME: '뉴싼타페 2000 VGT CLX 고급형 AT 디젤',
      RENTDATE: '20111230',
      UNIT24: '317000',
      TERMTYPE: 'S',
      NETSALEAMT: '318251',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '성수한국타이어예약소',
      SALEVATAMT: '31825',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '수원지점',
      ACCDATE: '20111229',
      SALEAMT: '350076',
      STARTDATE: ''
    },
    {
      NO: '082',
      CARNAMEMSTNAME2: '베르나 트랜스폼 1500 VGT TRENDY AT 디젤',
      RETURNDATE: '20120110',
      ACCNO: '201111111259',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1460100252945',
      CONTRACTNO: 'SS1878120166104',
      RENTFEE: '165000',
      OBJCARNO: '56허8856',
      CARNO: '59허9109',
      ACCPERSONNAME: '김병준',
      DATA_KEY: '82',
      CARNAMEMSTNAME: 'NEW SM5 렌터카 2000 CVTC Ⅱ LPLi 고급형 AT LPG',
      RENTDATE: '20120106',
      UNIT24: '95000',
      TERMTYPE: 'S',
      NETSALEAMT: '112582',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '성수트루예약소',
      SALEVATAMT: '11258',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업5팀',
      ACCDATE: '20111111',
      SALEAMT: '123840',
      STARTDATE: ''
    },
    {
      NO: '083',
      CARNAMEMSTNAME2: 'K5렌터카 2000 LPI 럭셔리 AT LPG',
      RETURNDATE: '20120109',
      ACCNO: '201201040447',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1454110265964',
      CONTRACTNO: 'SS1903120161485',
      RENTFEE: '160000',
      OBJCARNO: '26허5296',
      CARNO: '05허6140',
      ACCPERSONNAME: '김현철',
      DATA_KEY: '83',
      CARNAMEMSTNAME: 'K5 2000 I4 세타 Ⅱ 스마트 스페셜 AT 휘발유',
      RENTDATE: '20120104',
      UNIT24: '165000',
      TERMTYPE: 'S',
      NETSALEAMT: '252302',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '구로현주예약소',
      SALEVATAMT: '25230',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업3팀',
      ACCDATE: '20120104',
      SALEAMT: '277532',
      STARTDATE: ''
    },
    {
      NO: '084',
      CARNAMEMSTNAME2: '소나타 Y20 렌터카 2000 LPI Deluxe AT LPG',
      RETURNDATE: '20120109',
      ACCNO: '201112273194',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1351110906780',
      CONTRACTNO: 'SS1808120174171',
      RENTFEE: '165000',
      OBJCARNO: '26허7378',
      CARNO: '13허2312',
      ACCPERSONNAME: '어성환',
      DATA_KEY: '84',
      CARNAMEMSTNAME: '소나타 Y20 렌터카 2000 LPI Luxury AT LPG',
      RENTDATE: '20120106',
      UNIT24: '165000',
      TERMTYPE: 'S',
      NETSALEAMT: '162818',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '동울산',
      SALEVATAMT: '16282',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '해운대지점',
      ACCDATE: '20111227',
      SALEAMT: '179100',
      STARTDATE: ''
    },
    {
      NO: '085',
      CARNAMEMSTNAME2: '로체 이노베이션 렌트카 2000 LPI LX20 기본형 스페셜 AT LPG',
      RETURNDATE: '20120106',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1837111250105',
      RENTFEE: '165000',
      OBJCARNO: '16허7669',
      CARNO: '47허6147',
      ACCPERSONNAME: '',
      DATA_KEY: '85',
      CARNAMEMSTNAME: 'NEW SM5 렌터카 2000 CVTC Ⅱ LPLi 고급형 AT LPG',
      RENTDATE: '20111225',
      UNIT24: '150000',
      TERMTYPE: 'S',
      NETSALEAMT: '493556',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '부산태원',
      SALEVATAMT: '49356',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '대구지점(동대구역)',
      ACCDATE: '',
      SALEAMT: '542912',
      STARTDATE: ''
    },
    {
      NO: '086',
      CARNAMEMSTNAME2: '소나타 트랜스폼 N20 2000 LPI Luxury AT LPG',
      RETURNDATE: '20120107',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '0',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1370111257305',
      RENTFEE: '150000',
      OBJCARNO: '59허2520',
      CARNO: '59허2592',
      ACCPERSONNAME: '',
      DATA_KEY: '86',
      CARNAMEMSTNAME: '소나타 트랜스폼 N20 2000 LPI Luxury AT LPG',
      RENTDATE: '20111231',
      UNIT24: '150000',
      TERMTYPE: 'S',
      NETSALEAMT: '707909',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '제주지사',
      SALEVATAMT: '70791',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: '',
      DEPTNAME: '제주지사',
      ACCDATE: '',
      SALEAMT: '778700',
      STARTDATE: ''
    },
    {
      NO: '087',
      CARNAMEMSTNAME2: '로체 이노베이션 렌트카 2000 LPI LX20 최고급형 AT LPG',
      RETURNDATE: '20120107',
      ACCNO: '201112303720',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1450080829487',
      CONTRACTNO: 'SS1913111259016',
      RENTFEE: '165000',
      OBJCARNO: '38허4428',
      CARNO: '52허5524',
      ACCPERSONNAME: '김대윤',
      DATA_KEY: '87',
      CARNAMEMSTNAME: 'K5렌터카 2000 LPI 디럭스 AT LPG',
      RENTDATE: '20111230',
      UNIT24: '150000',
      TERMTYPE: 'S',
      NETSALEAMT: '316509',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '성동성수예약소',
      SALEVATAMT: '31651',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: 'SU6팀',
      ACCDATE: '20111230',
      SALEAMT: '348160',
      STARTDATE: ''
    },
    {
      NO: '088',
      CARNAMEMSTNAME2: '아반떼 M16 1600 LPI 렌터카 DELUXE AT LPG',
      RETURNDATE: '20120103',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1961111263144',
      RENTFEE: '165000',
      OBJCARNO: '04허6787',
      CARNO: '44허7095',
      ACCPERSONNAME: '',
      DATA_KEY: '88',
      CARNAMEMSTNAME: '소나타 Y20 렌터카 2000 LPI Luxury AT LPG',
      RENTDATE: '20111228',
      UNIT24: '109000',
      TERMTYPE: 'S',
      NETSALEAMT: '185309',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '전주타이어클럽',
      SALEVATAMT: '18531',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '영업1팀',
      ACCDATE: '',
      SALEAMT: '203840',
      STARTDATE: ''
    },
    {
      NO: '089',
      CARNAMEMSTNAME2: '그랜져TG 2700 DOHC Q270 DELUXE AT 휘발유',
      RETURNDATE: '20120110',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1937120163326',
      RENTFEE: '266000',
      OBJCARNO: '32허4467',
      CARNO: '06허4518',
      ACCPERSONNAME: '',
      DATA_KEY: '89',
      CARNAMEMSTNAME: '5G 그랜져 2400 GDI HG240 LUXURY AT 휘발유',
      RENTDATE: '20120106',
      UNIT24: '266000',
      TERMTYPE: 'S',
      NETSALEAMT: '299164',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '성수한국타이어예약소',
      SALEVATAMT: '29916',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '안양지점',
      ACCDATE: '',
      SALEAMT: '329080',
      STARTDATE: ''
    },
    {
      NO: '090',
      CARNAMEMSTNAME2: '5G 그랜져 3000 GDI HG300 PRIME AT 휘발유',
      RETURNDATE: '20120110',
      ACCNO: '201201060788',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1453110470852',
      CONTRACTNO: 'SS1945120166364',
      RENTFEE: '399000',
      OBJCARNO: '44허5276',
      CARNO: '63허8889',
      ACCPERSONNAME: '김대윤',
      DATA_KEY: '90',
      CARNAMEMSTNAME: '제네시스 3300 람다 BH330 GRAND PRIME PACK AT 휘발유',
      RENTDATE: '20120109',
      UNIT24: '292000',
      TERMTYPE: 'S',
      NETSALEAMT: '115636',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '일산탄현예약소',
      SALEVATAMT: '11564',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업2팀',
      ACCDATE: '20120106',
      SALEAMT: '127200',
      STARTDATE: ''
    },
    {
      NO: '091',
      CARNAMEMSTNAME2: 'New SM5  2000 CVTC Ⅱ XE AT 휘발유',
      RETURNDATE: '20120105',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1355120166620',
      RENTFEE: '160000',
      OBJCARNO: '47허5999',
      CARNO: '47허5860',
      ACCPERSONNAME: '',
      DATA_KEY: '91',
      CARNAMEMSTNAME: 'New SM5  2000 CVTC Ⅱ SE Plus AT 휘발유',
      RENTDATE: '20120104',
      UNIT24: '160000',
      TERMTYPE: 'S',
      NETSALEAMT: '52727',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '부산지점',
      SALEVATAMT: '5273',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '부산지점',
      ACCDATE: '',
      SALEAMT: '58000',
      STARTDATE: ''
    },
    {
      NO: '092',
      CARNAMEMSTNAME2: '체어맨 H 2800 DOHC 500S VIP AT 휘발유',
      RETURNDATE: '20120104',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1921111258568',
      RENTFEE: '399000',
      OBJCARNO: '56허8771',
      CARNO: '33허9033',
      ACCPERSONNAME: '',
      DATA_KEY: '92',
      CARNAMEMSTNAME: '체어맨 W 3200 IL6 CW 600 Prestige AT 휘발유',
      RENTDATE: '20111231',
      UNIT24: '349000',
      TERMTYPE: 'S',
      NETSALEAMT: '484567',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '안산사동예약소',
      SALEVATAMT: '48457',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '인천지점',
      ACCDATE: '',
      SALEAMT: '533024',
      STARTDATE: ''
    },
    {
      NO: '093',
      CARNAMEMSTNAME2: 'NEW SM5 렌터카 2000 CVTC Ⅱ LPLi 고급형 AT LPG',
      RETURNDATE: '20120103',
      ACCNO: '201201020088',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1170110164881',
      CONTRACTNO: 'SS1360120160153',
      RENTFEE: '165000',
      OBJCARNO: '60허6809',
      CARNO: '63허5333',
      ACCPERSONNAME: '정해성',
      DATA_KEY: '93',
      CARNAMEMSTNAME: 'NEW SM5 렌터카 2000 CVTC Ⅱ LPLi 고급형 AT LPG',
      RENTDATE: '20120101',
      UNIT24: '165000',
      TERMTYPE: 'S',
      NETSALEAMT: '109091',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '진주사천지점',
      SALEVATAMT: '10909',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '청주지점',
      ACCDATE: '20120101',
      SALEAMT: '120000',
      STARTDATE: ''
    },
    {
      NO: '094',
      CARNAMEMSTNAME2: '그랜드 스타렉스 12P WAGON 2500 VGT CVX Deluxe AT 디젤',
      RETURNDATE: '20120105',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1476111259609',
      RENTFEE: '199000',
      OBJCARNO: '76허1389',
      CARNO: '56허9002',
      ACCPERSONNAME: '',
      DATA_KEY: '94',
      CARNAMEMSTNAME: '싼타페 The Style 2WD 2000 E-VGT MLX LUXURY AT 디젤',
      RENTDATE: '20111227',
      UNIT24: '219000',
      TERMTYPE: 'S',
      NETSALEAMT: '459524',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: 'MT기획팀',
      SALEVATAMT: '45952',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '영업3팀',
      ACCDATE: '',
      SALEAMT: '505476',
      STARTDATE: ''
    },
    {
      NO: '095',
      CARNAMEMSTNAME2: '투싼 ix 4WD 2000 E-VGT X20 Luxury AT 디젤',
      RETURNDATE: '20120102',
      ACCNO: '201112202107',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1452110367219',
      CONTRACTNO: 'SS1476111259619',
      RENTFEE: '199000',
      OBJCARNO: '62허4325',
      CARNO: '10허6223',
      ACCPERSONNAME: '이준엽',
      DATA_KEY: '95',
      CARNAMEMSTNAME: '싼타페 4WD 2200 VGT CLX 기본형 AT 디젤',
      RENTDATE: '20111226',
      UNIT24: '190000',
      TERMTYPE: 'S',
      NETSALEAMT: '348218',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: 'MT기획팀',
      SALEVATAMT: '34822',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업1팀',
      ACCDATE: '20111220',
      SALEAMT: '383040',
      STARTDATE: ''
    },
    {
      NO: '096',
      CARNAMEMSTNAME2: '투싼 ix 4WD 2000 E-VGT X20 Luxury AT 디젤',
      RETURNDATE: '20120104',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1891120159728',
      RENTFEE: '199000',
      OBJCARNO: '44허6461',
      CARNO: '05허5757',
      ACCPERSONNAME: '',
      DATA_KEY: '96',
      CARNAMEMSTNAME: '싼타페 The Style 4WD 2200 E-VGT CLX DELUXE AT 디젤',
      RENTDATE: '20120102',
      UNIT24: '190000',
      TERMTYPE: 'S',
      NETSALEAMT: '123091',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '시흥정왕예약소',
      SALEVATAMT: '12309',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '영업1팀',
      ACCDATE: '',
      SALEAMT: '135400',
      STARTDATE: ''
    },
    {
      NO: '097',
      CARNAMEMSTNAME2: '소나타 Y20 렌터카 2000 LPI Deluxe AT LPG',
      RETURNDATE: '20120106',
      ACCNO: '201201030267',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1433101163592',
      CONTRACTNO: 'SS1433120160497',
      RENTFEE: '165000',
      OBJCARNO: '63허7452',
      CARNO: '62허5901',
      ACCPERSONNAME: '김대윤',
      DATA_KEY: '97',
      CARNAMEMSTNAME: '소나타 Y20 렌터카 2000 LPI Luxury AT LPG',
      RENTDATE: '20120103',
      UNIT24: '165000',
      TERMTYPE: 'S',
      NETSALEAMT: '157636',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '안양지점',
      SALEVATAMT: '15764',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '안양지점',
      ACCDATE: '20111230',
      SALEAMT: '173400',
      STARTDATE: ''
    },
    {
      NO: '098',
      CARNAMEMSTNAME2: '소나타 Y20 2000 I4 세타 Ⅱ Grand AT 휘발유',
      RETURNDATE: '20120105',
      ACCNO: '201201010047',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1100111007792',
      CONTRACTNO: 'SS1804120160689',
      RENTFEE: '142000',
      OBJCARNO: '52허3792',
      CARNO: '30허2652',
      ACCPERSONNAME: '김대윤',
      DATA_KEY: '98',
      CARNAMEMSTNAME: '소나타 N20 2000 VVT Luxury AT 휘발유',
      RENTDATE: '20120103',
      UNIT24: '160000',
      TERMTYPE: 'S',
      NETSALEAMT: '98276',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '(폐쇄)영등포현주',
      SALEVATAMT: '9828',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '인천지점',
      ACCDATE: '20120101',
      SALEAMT: '108104',
      STARTDATE: ''
    },
    {
      NO: '099',
      CARNAMEMSTNAME2: '싼타페 The Style 2WD 2000 E-VGT CLX DELUXE AT 디젤',
      RETURNDATE: '20120104',
      ACCNO: '201112273216',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1454110906263',
      CONTRACTNO: 'SS1819111259186',
      RENTFEE: '199000',
      OBJCARNO: '45허4361',
      CARNO: '63허8961',
      ACCPERSONNAME: '정해성',
      DATA_KEY: '99',
      CARNAMEMSTNAME: '싼타페 The Style 4WD 2200 E-VGT CLX DELUXE AT 디젤',
      RENTDATE: '20111230',
      UNIT24: '199000',
      TERMTYPE: 'S',
      NETSALEAMT: '526993',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '공주지점',
      SALEVATAMT: '52699',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업3팀',
      ACCDATE: '20111227',
      SALEAMT: '579692',
      STARTDATE: ''
    },
    {
      NO: '100',
      CARNAMEMSTNAME2: '엑센트 1400 CVVT LUXURY AT 휘발유',
      RETURNDATE: '20120105',
      ACCNO: '201112303680',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1452110602791',
      CONTRACTNO: 'SS1878120159259',
      RENTFEE: '160000',
      OBJCARNO: '59허9037',
      CARNO: '62허5402',
      ACCPERSONNAME: '김선연',
      DATA_KEY: '100',
      CARNAMEMSTNAME: 'K5 2000 I4 세타 Ⅱ 스마트 스페셜 AT 휘발유',
      RENTDATE: '20120102',
      UNIT24: '99000',
      TERMTYPE: 'S',
      NETSALEAMT: '84436',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '성수트루예약소',
      SALEVATAMT: '8444',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업1팀',
      ACCDATE: '20111230',
      SALEAMT: '92880',
      STARTDATE: ''
    },
    {
      NO: '101',
      CARNAMEMSTNAME2: '그랜져TG 2700 LPI Q270 모범형 AT LPG',
      RETURNDATE: '20120104',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1476120161911',
      RENTFEE: '266000',
      OBJCARNO: '41허4894',
      CARNO: '08허1059',
      ACCPERSONNAME: '',
      DATA_KEY: '101',
      CARNAMEMSTNAME: '그랜져 THE LUXURY 2700 LPI 렌터카 Q270 모범형 PACKⅠ AT LPG',
      RENTDATE: '20120102',
      UNIT24: '266000',
      TERMTYPE: 'S',
      NETSALEAMT: '192720',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: 'MT기획팀',
      SALEVATAMT: '19272',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '수원지점',
      ACCDATE: '',
      SALEAMT: '211992',
      STARTDATE: ''
    },
    {
      NO: '102',
      CARNAMEMSTNAME2: 'New SM5  2000 CVTC Ⅱ SE AT 휘발유',
      RETURNDATE: '20120110',
      ACCNO: '201109080953',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1460100354192',
      CONTRACTNO: 'SS1476120167462',
      RENTFEE: '109000',
      OBJCARNO: '56허9025',
      CARNO: '32허8002',
      ACCPERSONNAME: '김병준',
      DATA_KEY: '102',
      CARNAMEMSTNAME: 'New SM3 1600 γ - 1.6 LPi 엔진 LE Plus AT 휘발유',
      RENTDATE: '20120109',
      UNIT24: '160000',
      TERMTYPE: 'S',
      NETSALEAMT: '43018',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: 'MT기획팀',
      SALEVATAMT: '4302',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업3팀',
      ACCDATE: '20110908',
      SALEAMT: '47320',
      STARTDATE: ''
    },
    {
      NO: '103',
      CARNAMEMSTNAME2: '소나타 Y20 2000 VVT Grand AT 휘발유',
      RETURNDATE: '20120110',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1972120167671',
      RENTFEE: '165000',
      OBJCARNO: '16허7680',
      CARNO: '52허5526',
      ACCPERSONNAME: '',
      DATA_KEY: '103',
      CARNAMEMSTNAME: 'K5렌터카 2000 LPI 디럭스 AT LPG',
      RENTDATE: '20120106',
      UNIT24: '160000',
      TERMTYPE: 'S',
      NETSALEAMT: '180353',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '(폐쇄)순천봉화예약소',
      SALEVATAMT: '18035',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '대구지점(동대구역)',
      ACCDATE: '',
      SALEAMT: '198388',
      STARTDATE: ''
    },
    {
      NO: '104',
      CARNAMEMSTNAME2: '에쿠스 TRUE PRESTIGE 3800 V6 람다 VS 380 프라임 AT 휘발유',
      RETURNDATE: '20120109',
      ACCNO: '201201030261',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1420100251767',
      CONTRACTNO: 'SS1937120162698',
      RENTFEE: '488000',
      OBJCARNO: '44허1561',
      CARNO: '04허2290',
      ACCPERSONNAME: '김선연',
      DATA_KEY: '104',
      CARNAMEMSTNAME: '에쿠스 TRUE PRESTIGE 3800 V6 람다 VS 380 럭셔리 AT 휘발유',
      RENTDATE: '20120105',
      UNIT24: '488000',
      TERMTYPE: 'S',
      NETSALEAMT: '601618',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '성수한국타이어예약소',
      SALEVATAMT: '60162',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업5팀',
      ACCDATE: '20120103',
      SALEAMT: '661780',
      STARTDATE: ''
    },
    {
      NO: '105',
      CARNAMEMSTNAME2: '5G 그랜져 3000 LPI HG300 렌터카 Prime AT LPG',
      RETURNDATE: '20120105',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1869120162170',
      RENTFEE: '399000',
      OBJCARNO: '52허5999',
      CARNO: '63허8929',
      ACCPERSONNAME: '',
      DATA_KEY: '105',
      CARNAMEMSTNAME: '제네시스 3300 람다 BH330 GRAND AT 휘발유',
      RENTDATE: '20120105',
      UNIT24: '292000',
      TERMTYPE: 'S',
      NETSALEAMT: '96364',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '안산상록예약소',
      SALEVATAMT: '9636',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '상암지점',
      ACCDATE: '',
      SALEAMT: '106000',
      STARTDATE: ''
    },
    {
      NO: '106',
      CARNAMEMSTNAME2: '소나타 Y20 렌터카 2000 LPI Luxury AT LPG',
      RETURNDATE: '20120110',
      ACCNO: '201201030328',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1250101264660',
      CONTRACTNO: 'SS1944120162333',
      RENTFEE: '165000',
      OBJCARNO: '22허1382',
      CARNO: '52허7339',
      ACCPERSONNAME: '박수호',
      DATA_KEY: '106',
      CARNAMEMSTNAME: '소나타 Y20 렌터카 2000 LPI Luxury AT LPG',
      RENTDATE: '20120105',
      UNIT24: '165000',
      TERMTYPE: 'S',
      NETSALEAMT: '280287',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '대전태화예약소',
      SALEVATAMT: '28029',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '대전지점',
      ACCDATE: '20120103',
      SALEAMT: '308316',
      STARTDATE: ''
    },
    {
      NO: '107',
      CARNAMEMSTNAME2: 'New SM5  2000 CVTC Ⅱ LE AT 휘발유',
      RETURNDATE: '20120110',
      ACCNO: '201201060744',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1456110165550',
      CONTRACTNO: 'SS1818120166334',
      RENTFEE: '160000',
      OBJCARNO: '62허4064',
      CARNO: '60허5227',
      ACCPERSONNAME: '김대윤',
      DATA_KEY: '107',
      CARNAMEMSTNAME: 'K5 2000 I4 세타 Ⅱ 스마트 스페셜 AT 휘발유',
      RENTDATE: '20120109',
      UNIT24: '160000',
      TERMTYPE: 'S',
      NETSALEAMT: '63273',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '도곡예약소',
      SALEVATAMT: '6327',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업2팀',
      ACCDATE: '20120103',
      SALEAMT: '69600',
      STARTDATE: ''
    },
    {
      NO: '108',
      CARNAMEMSTNAME2: '아반떼 M16 1600 LPI 렌터카 DELUXE AT LPG',
      RETURNDATE: '20120109',
      ACCNO: '201201040392',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1474110368872',
      CONTRACTNO: 'SS1890120166340',
      RENTFEE: '165000',
      OBJCARNO: '44허5152',
      CARNO: '06허2742',
      ACCPERSONNAME: '이준엽',
      DATA_KEY: '108',
      CARNAMEMSTNAME: 'K5렌터카 2000 LPI 디럭스 AT LPG',
      RENTDATE: '20120104',
      UNIT24: '109000',
      TERMTYPE: 'S',
      NETSALEAMT: '171105',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '제천예약소',
      SALEVATAMT: '17111',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '잠실지점',
      ACCDATE: '20120104',
      SALEAMT: '188216',
      STARTDATE: ''
    },
    {
      NO: '109',
      CARNAMEMSTNAME2: '에쿠스 TRUE PRESTIGE 3800 V6 람다 VS 380 프라임 AT 휘발유',
      RETURNDATE: '20120102',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1937111254806',
      RENTFEE: '488000',
      OBJCARNO: '05허4107',
      CARNO: '68허3494',
      ACCPERSONNAME: '',
      DATA_KEY: '109',
      CARNAMEMSTNAME: '에쿠스 TRUE PRESTIGE 3800 GDI VS 380 프라임 AT 휘발유',
      RENTDATE: '20111229',
      UNIT24: '488000',
      TERMTYPE: 'S',
      NETSALEAMT: '501647',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '성수한국타이어예약소',
      SALEVATAMT: '50165',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: 'SU7팀',
      ACCDATE: '',
      SALEAMT: '551812',
      STARTDATE: ''
    },
    {
      NO: '110',
      CARNAMEMSTNAME2: '소나타 트랜스폼 N20 2000 LPI Deluxe AT LPG',
      RETURNDATE: '20120102',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1944111259378',
      RENTFEE: '109000',
      OBJCARNO: '18허7294',
      CARNO: '05허6063',
      ACCPERSONNAME: '',
      DATA_KEY: '110',
      CARNAMEMSTNAME: '아반떼 M16 1600 LPI 렌터카 LUXURY AT LPG',
      RENTDATE: '20111231',
      UNIT24: '150000',
      TERMTYPE: 'S',
      NETSALEAMT: '78756',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '대전태화예약소',
      SALEVATAMT: '7876',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '영업2팀',
      ACCDATE: '',
      SALEAMT: '86632',
      STARTDATE: ''
    },
    {
      NO: '111',
      CARNAMEMSTNAME2: '소나타 Y20 렌터카 2000 LPI Deluxe AT LPG',
      RETURNDATE: '20120104',
      ACCNO: '201112212352',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1260111209556',
      CONTRACTNO: 'SS1944111249833',
      RENTFEE: '165000',
      OBJCARNO: '52허6736',
      CARNO: '52허7339',
      ACCPERSONNAME: '정해성',
      DATA_KEY: '111',
      CARNAMEMSTNAME: '소나타 Y20 렌터카 2000 LPI Luxury AT LPG',
      RENTDATE: '20111222',
      UNIT24: '165000',
      TERMTYPE: 'S',
      NETSALEAMT: '577636',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '대전태화예약소',
      SALEVATAMT: '57764',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '광주지점',
      ACCDATE: '20111221',
      SALEAMT: '635400',
      STARTDATE: ''
    },
    {
      NO: '112',
      CARNAMEMSTNAME2: '소나타 Y20 2000 I4 세타 Ⅱ Premier AT 휘발유',
      RETURNDATE: '20120105',
      ACCNO: '201201020134',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1100110165642',
      CONTRACTNO: 'SS1476120161591',
      RENTFEE: '160000',
      OBJCARNO: '05허6892',
      CARNO: '27허1541',
      ACCPERSONNAME: '윤원재',
      DATA_KEY: '112',
      CARNAMEMSTNAME: '소나타 Y20 2000 VVT Prime 최고급형 AT 휘발유',
      RENTDATE: '20120102',
      UNIT24: '160000',
      TERMTYPE: 'S',
      NETSALEAMT: '142204',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: 'MT기획팀',
      SALEVATAMT: '14220',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '인천지점',
      ACCDATE: '20120102',
      SALEAMT: '156424',
      STARTDATE: ''
    },
    {
      NO: '113',
      CARNAMEMSTNAME2: 'K7 렌터카 2700 V6 뮤 VG270 럭셔리 AT LPG',
      RETURNDATE: '20120104',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1894120160177',
      RENTFEE: '165000',
      OBJCARNO: '63허1471',
      CARNO: '05허5635',
      ACCPERSONNAME: '',
      DATA_KEY: '113',
      CARNAMEMSTNAME: '소나타 Y20 렌터카 2000 LPI Deluxe AT LPG',
      RENTDATE: '20120103',
      UNIT24: '292000',
      TERMTYPE: 'S',
      NETSALEAMT: '54545',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '(폐쇄)수지동화예약소',
      SALEVATAMT: '5455',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '포항지점',
      ACCDATE: '',
      SALEAMT: '60000',
      STARTDATE: ''
    },
    {
      NO: '114',
      CARNAMEMSTNAME2: '소나타 Y20 2000 VVT Prime 고급형 AT 휘발유',
      RETURNDATE: '20120102',
      ACCNO: '201112252949',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1460100456085',
      CONTRACTNO: 'SS1903111250438',
      RENTFEE: '160000',
      OBJCARNO: '05허4330',
      CARNO: '05허6140',
      ACCPERSONNAME: '윤원재',
      DATA_KEY: '114',
      CARNAMEMSTNAME: 'K5 2000 I4 세타 Ⅱ 스마트 스페셜 AT 휘발유',
      RENTDATE: '20111226',
      UNIT24: '160000',
      TERMTYPE: 'S',
      NETSALEAMT: '295273',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '구로현주예약소',
      SALEVATAMT: '29527',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업5팀',
      ACCDATE: '20111225',
      SALEAMT: '324800',
      STARTDATE: ''
    },
    {
      NO: '115',
      CARNAMEMSTNAME2: 'i30 1600 VVT Luxury AT 휘발유',
      RETURNDATE: '20120102',
      ACCNO: '201112263151',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'SS1080111120391',
      CONTRACTNO: 'SS1476111252978',
      RENTFEE: '99000',
      OBJCARNO: '41허5483',
      CARNO: '04허2259',
      ACCPERSONNAME: '김대윤',
      DATA_KEY: '115',
      CARNAMEMSTNAME: '뉴아반떼 1600 VVT S16 LUXURY  AT 휘발유',
      RENTDATE: '20111227',
      UNIT24: '116000',
      TERMTYPE: 'S',
      NETSALEAMT: '185309',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: 'MT기획팀',
      SALEVATAMT: '18531',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'M',
      DEPTNAME: '강남지점',
      ACCDATE: '20111226',
      SALEAMT: '203840',
      STARTDATE: ''
    },
    {
      NO: '116',
      CARNAMEMSTNAME2: 'K7 렌터카 2700 V6 뮤 VG270 프레스티지 AT LPG',
      RETURNDATE: '20120107',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1476111253000',
      RENTFEE: '307000',
      OBJCARNO: '63허3483',
      CARNO: '59허2080',
      ACCPERSONNAME: '',
      DATA_KEY: '116',
      CARNAMEMSTNAME: '뉴 오피러스렌트카 2700 V6 뮤 GH270 고급 럭셔리 AT LPG',
      RENTDATE: '20111227',
      UNIT24: '292000',
      TERMTYPE: 'S',
      NETSALEAMT: '824560',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: 'MT기획팀',
      SALEVATAMT: '82456',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '서대문지점',
      ACCDATE: '',
      SALEAMT: '907016',
      STARTDATE: ''
    },
    {
      NO: '117',
      CARNAMEMSTNAME2: '소나타 Y20 렌터카 2000 LPI Luxury AT LPG',
      RETURNDATE: '20120106',
      ACCNO: '201201040409',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1130111108513',
      CONTRACTNO: 'SS1901120162488',
      RENTFEE: '165000',
      OBJCARNO: '39허7372',
      CARNO: '59허2747',
      ACCPERSONNAME: '김선연',
      DATA_KEY: '117',
      CARNAMEMSTNAME: '소나타 Y20 렌터카 2000 LPI Luxury AT LPG',
      RENTDATE: '20120104',
      UNIT24: '165000',
      TERMTYPE: 'S',
      NETSALEAMT: '106327',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '경기광주예약소',
      SALEVATAMT: '10633',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '수원지점',
      ACCDATE: '20120104',
      SALEAMT: '116960',
      STARTDATE: ''
    },
    {
      NO: '118',
      CARNAMEMSTNAME2: '그랜져 THE LUXURY 2700 DOHC Q270 LUXURY SMART PACK AT 휘발유',
      RETURNDATE: '20120104',
      ACCNO: '201201030270',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1050100455548',
      CONTRACTNO: 'SS1974120162085',
      RENTFEE: '292000',
      OBJCARNO: '05허4233',
      CARNO: '56허9540',
      ACCPERSONNAME: '김선연',
      DATA_KEY: '118',
      CARNAMEMSTNAME: 'K7 렌터카 2700 V6 뮤 VG270 럭셔리 AT LPG',
      RENTDATE: '20120103',
      UNIT24: '266000',
      TERMTYPE: 'S',
      NETSALEAMT: '96800',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '성남단대역예약소',
      SALEVATAMT: '9680',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '분당지점',
      ACCDATE: '20120103',
      SALEAMT: '106480',
      STARTDATE: ''
    },
    {
      NO: '119',
      CARNAMEMSTNAME2: '뉴아반떼 1600 VVT E16 VALUE AT 휘발유/LPG',
      RETURNDATE: '20120107',
      ACCNO: '201201040450',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1450080222977',
      CONTRACTNO: 'SS1974120162090',
      RENTFEE: '109000',
      OBJCARNO: '26허8439',
      CARNO: '59허3611',
      ACCPERSONNAME: '김병준',
      DATA_KEY: '119',
      CARNAMEMSTNAME: '아반떼 M16 GDi 1600 GDI LUXURY AT 휘발유',
      RENTDATE: '20120104',
      UNIT24: '99000',
      TERMTYPE: 'S',
      NETSALEAMT: '89327',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '성남단대역예약소',
      SALEVATAMT: '8933',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업4팀',
      ACCDATE: '20120104',
      SALEAMT: '98260',
      STARTDATE: ''
    },
    {
      NO: '120',
      CARNAMEMSTNAME2: '투싼 5P 2000 VGT 에스티(esT) AT 디젤',
      RETURNDATE: '20120104',
      ACCNO: '201112283334',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1050080322988',
      CONTRACTNO: 'SS1921111252907',
      RENTFEE: '190000',
      OBJCARNO: '26허8611',
      CARNO: '28허2266',
      ACCPERSONNAME: '김병준',
      DATA_KEY: '120',
      CARNAMEMSTNAME: '슈퍼 렉스턴 2700 XDi RX6 (4WD) 고급형 AT 디젤',
      RENTDATE: '20111228',
      UNIT24: '190000',
      TERMTYPE: 'S',
      NETSALEAMT: '338789',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '안산사동예약소',
      SALEVATAMT: '33879',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '분당지점',
      ACCDATE: '20111227',
      SALEAMT: '372668',
      STARTDATE: ''
    },
    {
      NO: '121',
      CARNAMEMSTNAME2: '아반떼 M16 1600 LPI 렌터카 LUXURY AT LPG',
      RETURNDATE: '20120106',
      ACCNO: '201201050560',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1020110603179',
      CONTRACTNO: 'SS1476120163282',
      RENTFEE: '0',
      OBJCARNO: '44허7040',
      CARNO: '59허2266',
      ACCPERSONNAME: '김병준',
      DATA_KEY: '121',
      CARNAMEMSTNAME: 'SM5 2000 LPI 렌터카 모범형 AT LPG',
      RENTDATE: '20120105',
      UNIT24: '109000',
      TERMTYPE: 'S',
      NETSALEAMT: '36400',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: 'MT기획팀',
      SALEVATAMT: '3640',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '서대문지점',
      ACCDATE: '20120105',
      SALEAMT: '40040',
      STARTDATE: ''
    },
    {
      NO: '122',
      CARNAMEMSTNAME2: '소나타 Y20 2000 VVT Premier 최고급형 AT 휘발유',
      RETURNDATE: '20120103',
      ACCNO: '201112263035',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1450100252530',
      CONTRACTNO: 'SS1230111250674',
      RENTFEE: '160000',
      OBJCARNO: '56허8842',
      CARNO: '62허5839',
      ACCPERSONNAME: '윤원재',
      DATA_KEY: '122',
      CARNAMEMSTNAME: '소나타 Y20 2000 I4 세타 Ⅱ Prime AT 휘발유',
      RENTDATE: '20111226',
      UNIT24: '160000',
      TERMTYPE: 'S',
      NETSALEAMT: '337455',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '평택지점',
      SALEVATAMT: '33745',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업2팀',
      ACCDATE: '20111226',
      SALEAMT: '371200',
      STARTDATE: ''
    },
    {
      NO: '123',
      CARNAMEMSTNAME2: '오피러스 PREMIUM 렌터카 2700 V6 뮤 GH270 고급형-럭셔리 AT LPG',
      RETURNDATE: '20120106',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1300120163761',
      RENTFEE: '165000',
      OBJCARNO: '20허3839',
      CARNO: '47허5572',
      ACCPERSONNAME: '',
      DATA_KEY: '123',
      CARNAMEMSTNAME: 'K5렌터카 2000 LPI 디럭스 AT LPG',
      RENTDATE: '20120105',
      UNIT24: '307000',
      TERMTYPE: 'S',
      NETSALEAMT: '54545',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '울산지점',
      SALEVATAMT: '5455',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '울산지점',
      ACCDATE: '',
      SALEAMT: '60000',
      STARTDATE: ''
    },
    {
      NO: '124',
      CARNAMEMSTNAME2: '소나타 N20 2000 VVT DLX 고급형 AT 휘발유',
      RETURNDATE: '20120102',
      ACCNO: '201112303668',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1460071018521',
      CONTRACTNO: 'SS1869111255677',
      RENTFEE: '165000',
      OBJCARNO: '26허6313',
      CARNO: '62허4144',
      ACCPERSONNAME: '김선연',
      DATA_KEY: '124',
      CARNAMEMSTNAME: 'K5렌터카 2000 LPI 디럭스 AT LPG',
      RENTDATE: '20111230',
      UNIT24: '142000',
      TERMTYPE: 'S',
      NETSALEAMT: '126604',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '안산상록예약소',
      SALEVATAMT: '12660',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업2팀',
      ACCDATE: '20111223',
      SALEAMT: '139264',
      STARTDATE: ''
    },
    {
      NO: '125',
      CARNAMEMSTNAME2: '제네시스 3300 GDI BH330 LUXURY VIP PACK AT 휘발유',
      RETURNDATE: '20120106',
      ACCNO: '201112303654',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1050110480531',
      CONTRACTNO: 'SS1937120159822',
      RENTFEE: '488000',
      OBJCARNO: '62허4872',
      CARNO: '68허3494',
      ACCPERSONNAME: '김현철',
      DATA_KEY: '125',
      CARNAMEMSTNAME: '에쿠스 TRUE PRESTIGE 3800 GDI VS 380 프라임 AT 휘발유',
      RENTDATE: '20120102',
      UNIT24: '399000',
      TERMTYPE: 'S',
      NETSALEAMT: '507171',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '성수한국타이어예약소',
      SALEVATAMT: '50717',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '분당지점',
      ACCDATE: '20111230',
      SALEAMT: '557888',
      STARTDATE: ''
    },
    {
      NO: '126',
      CARNAMEMSTNAME2: '포터초장축 2500 CRDI 더블캡 SUP 고급형 AT 디젤',
      RETURNDATE: '20120107',
      ACCNO: '201201030329',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1450060800066',
      CONTRACTNO: 'SS1914120163863',
      RENTFEE: '165000',
      OBJCARNO: '80도7492',
      CARNO: '52허7286',
      ACCPERSONNAME: '윤원재',
      DATA_KEY: '126',
      CARNAMEMSTNAME: '소나타 Y20 렌터카 2000 LPI Luxury AT LPG',
      RENTDATE: '20120104',
      UNIT24: '0',
      TERMTYPE: 'S',
      NETSALEAMT: '147273',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '경기오포예약소',
      SALEVATAMT: '14727',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업4팀',
      ACCDATE: '20120103',
      SALEAMT: '162000',
      STARTDATE: ''
    },
    {
      NO: '127',
      CARNAMEMSTNAME2: '5G 그랜져 3000 LPI HG300 렌터카 Prime AT LPG',
      RETURNDATE: '20120104',
      ACCNO: '201112232687',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1351111007205',
      CONTRACTNO: 'SS1350111251835',
      RENTFEE: '266000',
      OBJCARNO: '47허5916',
      CARNO: '47허5512',
      ACCPERSONNAME: '정해성',
      DATA_KEY: '127',
      CARNAMEMSTNAME: '그랜져 THE LUXURY 2700 LPI 렌터카 Q270 모범형 AT LPG',
      RENTDATE: '20111225',
      UNIT24: '292000',
      TERMTYPE: 'S',
      NETSALEAMT: '712360',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '김해공항지점',
      SALEVATAMT: '71236',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '해운대지점',
      ACCDATE: '20111223',
      SALEAMT: '783596',
      STARTDATE: ''
    },
    {
      NO: '128',
      CARNAMEMSTNAME2: '아반떼 M16 1600 LPI 렌터카 LUXURY AT LPG',
      RETURNDATE: '20120105',
      ACCNO: '201201050560',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1020110603179',
      CONTRACTNO: 'SS1476120163221',
      RENTFEE: '99000',
      OBJCARNO: '44허7040',
      CARNO: '41허2380',
      ACCPERSONNAME: '김병준',
      DATA_KEY: '128',
      CARNAMEMSTNAME: '뉴아반떼 1600 VVT E16 DELUXE AT 휘발유/LPG',
      RENTDATE: '20120105',
      UNIT24: '109000',
      TERMTYPE: 'S',
      NETSALEAMT: '33091',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: 'MT기획팀',
      SALEVATAMT: '3309',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '서대문지점',
      ACCDATE: '20120105',
      SALEAMT: '36400',
      STARTDATE: ''
    },
    {
      NO: '129',
      CARNAMEMSTNAME2: '모닝 1000 SOHC LX 고급형 AT 휘발유',
      RETURNDATE: '20120110',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1476120163281',
      RENTFEE: '95000',
      OBJCARNO: '41허4617',
      CARNO: '41허2941',
      ACCPERSONNAME: '',
      DATA_KEY: '129',
      CARNAMEMSTNAME: '모닝 1000 SOHC L AT 휘발유',
      RENTDATE: '20120105',
      UNIT24: '95000',
      TERMTYPE: 'S',
      NETSALEAMT: '123484',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: 'MT기획팀',
      SALEVATAMT: '12348',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '인천지점',
      ACCDATE: '',
      SALEAMT: '135832',
      STARTDATE: ''
    },
    {
      NO: '130',
      CARNAMEMSTNAME2: '에쿠스 TRUE PRESTIGE 3800 V6 람다 VS 380 럭셔리 AT 휘발유',
      RETURNDATE: '20120109',
      ACCNO: '201112242756',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1140100353991',
      CONTRACTNO: 'SS1476111251805',
      RENTFEE: '488000',
      OBJCARNO: '59허1630',
      CARNO: '44허1011',
      ACCPERSONNAME: '김병준',
      DATA_KEY: '130',
      CARNAMEMSTNAME: '에쿠스 TRUE PRESTIGE 3800 V6 람다 VS 380 럭셔리 AT 휘발유',
      RENTDATE: '20111226',
      UNIT24: '488000',
      TERMTYPE: 'S',
      NETSALEAMT: '1681578',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: 'MT기획팀',
      SALEVATAMT: '168158',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '안산지점',
      ACCDATE: '20111224',
      SALEAMT: '1849736',
      STARTDATE: ''
    },
    {
      NO: '131',
      CARNAMEMSTNAME2: 'SM7 New Art 2300 VQ23 SE Plus AT 휘발유',
      RETURNDATE: '20120110',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1891120163935',
      RENTFEE: '292000',
      OBJCARNO: '26허8028',
      CARNO: '52허5727',
      ACCPERSONNAME: '',
      DATA_KEY: '131',
      CARNAMEMSTNAME: '5G 그랜져 3000 LPI HG300 렌터카 Prime AT LPG',
      RENTDATE: '20120106',
      UNIT24: '266000',
      TERMTYPE: 'S',
      NETSALEAMT: '316800',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '시흥정왕예약소',
      SALEVATAMT: '31680',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '영업1팀',
      ACCDATE: '',
      SALEAMT: '348480',
      STARTDATE: ''
    },
    {
      NO: '132',
      CARNAMEMSTNAME2: '소나타 트랜스폼 N20 2000 LPI 일반형 AT LPG',
      RETURNDATE: '20120103',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1937111254322',
      RENTFEE: '150000',
      OBJCARNO: '45허4507',
      CARNO: '68허3076',
      ACCPERSONNAME: '',
      DATA_KEY: '132',
      CARNAMEMSTNAME: '로체 이노베이션 렌트카 2000 LPI LX20 기본형 스페셜 AT LPG',
      RENTDATE: '20111229',
      UNIT24: '150000',
      TERMTYPE: 'S',
      NETSALEAMT: '212644',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '성수한국타이어예약소',
      SALEVATAMT: '21264',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '영업5팀',
      ACCDATE: '',
      SALEAMT: '233908',
      STARTDATE: ''
    },
    {
      NO: '133',
      CARNAMEMSTNAME2: '아반떼 M16 GDi 1600 GDI LUXURY AT 휘발유',
      RETURNDATE: '20120104',
      ACCNO: '201112283454',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1450101164364',
      CONTRACTNO: 'SS1903120158851',
      RENTFEE: '165000',
      OBJCARNO: '60허6411',
      CARNO: '60허6539',
      ACCPERSONNAME: '김선연',
      DATA_KEY: '133',
      CARNAMEMSTNAME: '소나타 Y20 렌터카 2000 LPI Luxury AT LPG',
      RENTDATE: '20120102',
      UNIT24: '109000',
      TERMTYPE: 'S',
      NETSALEAMT: '85884',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '구로현주예약소',
      SALEVATAMT: '8588',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업2팀',
      ACCDATE: '20111228',
      SALEAMT: '94472',
      STARTDATE: ''
    },
    {
      NO: '134',
      CARNAMEMSTNAME2: '뉴프라이드(5DR) 1500 VGT LX AT 디젤',
      RETURNDATE: '20120103',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1476111259248',
      RENTFEE: '99000',
      OBJCARNO: '32허2302',
      CARNO: '38허3422',
      ACCPERSONNAME: '',
      DATA_KEY: '134',
      CARNAMEMSTNAME: '뉴프라이드 1500 VGT SLX AT 디젤',
      RENTDATE: '20111230',
      UNIT24: '99000',
      TERMTYPE: 'S',
      NETSALEAMT: '125415',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: 'MT기획팀',
      SALEVATAMT: '12541',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '영업5팀',
      ACCDATE: '',
      SALEAMT: '137956',
      STARTDATE: ''
    },
    {
      NO: '135',
      CARNAMEMSTNAME2: '5G 그랜져 3000 LPI HG300 렌터카 Prime AT LPG',
      RETURNDATE: '20120109',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1891120159729',
      RENTFEE: '292000',
      OBJCARNO: '63허2201',
      CARNO: '45허4280',
      ACCPERSONNAME: '',
      DATA_KEY: '135',
      CARNAMEMSTNAME: '5G 그랜져 3000 LPI HG300 렌터카 Prime AT LPG',
      RENTDATE: '20120102',
      UNIT24: '292000',
      TERMTYPE: 'S',
      NETSALEAMT: '557945',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '시흥정왕예약소',
      SALEVATAMT: '55795',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '평택지점',
      ACCDATE: '',
      SALEAMT: '613740',
      STARTDATE: ''
    },
    {
      NO: '136',
      CARNAMEMSTNAME2: '모닝 1000 LPI LX 기본 블랙프리미엄 AT LPG',
      RETURNDATE: '20120105',
      ACCNO: '201201020092',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1130100659128',
      CONTRACTNO: 'SS1802120160074',
      RENTFEE: '150000',
      OBJCARNO: '05허5592',
      CARNO: '59허1938',
      ACCPERSONNAME: '이준엽',
      DATA_KEY: '136',
      CARNAMEMSTNAME: '소나타 N20 2000 LPI LUX 기본형 AT LPG',
      RENTDATE: '20120103',
      UNIT24: '95000',
      TERMTYPE: 'S',
      NETSALEAMT: '62913',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '천안코리아',
      SALEVATAMT: '6291',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '수원지점',
      ACCDATE: '20120102',
      SALEAMT: '69204',
      STARTDATE: ''
    },
    {
      NO: '137',
      CARNAMEMSTNAME2: '베르나 트랜스폼 1500 VGT TRENDY AT 디젤',
      RETURNDATE: '20120104',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1476120160407',
      RENTFEE: '99000',
      OBJCARNO: '05허5541',
      CARNO: '28허4003',
      ACCPERSONNAME: '',
      DATA_KEY: '137',
      CARNAMEMSTNAME: '뉴프라이드 1500 VGT LX AT 디젤',
      RENTDATE: '20120102',
      UNIT24: '95000',
      TERMTYPE: 'S',
      NETSALEAMT: '60618',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: 'MT기획팀',
      SALEVATAMT: '6062',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '잠실지점',
      ACCDATE: '',
      SALEAMT: '66680',
      STARTDATE: ''
    },
    {
      NO: '138',
      CARNAMEMSTNAME2: '그랜드 카니발R 11P 2200 E-VGT President AT 디젤',
      RETURNDATE: '20120109',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1020120164101',
      RENTFEE: '270000',
      OBJCARNO: '74허6368',
      CARNO: '60허5283',
      ACCPERSONNAME: '',
      DATA_KEY: '138',
      CARNAMEMSTNAME: '뉴 카니발R 9P 2200 E-VGT GX AT 디젤',
      RENTDATE: '20120106',
      UNIT24: '317000',
      TERMTYPE: 'S',
      NETSALEAMT: '240524',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '서대문지점',
      SALEVATAMT: '24052',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '강동지점',
      ACCDATE: '',
      SALEAMT: '264576',
      STARTDATE: ''
    },
    {
      NO: '139',
      CARNAMEMSTNAME2: 'NEW 다마스코치 800 LPGi 5P Libig MT LPG',
      RETURNDATE: '20120102',
      ACCNO: '201112263023',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1511111007431',
      CONTRACTNO: 'SS1878111255829',
      RENTFEE: '165000',
      OBJCARNO: '72허6209',
      CARNO: '63허8751',
      ACCPERSONNAME: '김병준',
      DATA_KEY: '139',
      CARNAMEMSTNAME: 'NEW SM5 렌터카 2000 CVTC Ⅱ LPLi 고급형 AT LPG',
      RENTDATE: '20111230',
      UNIT24: '0',
      TERMTYPE: 'S',
      NETSALEAMT: '77556',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '성수트루예약소',
      SALEVATAMT: '7756',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '서울대지점',
      ACCDATE: '20111226',
      SALEAMT: '85312',
      STARTDATE: ''
    },
    {
      NO: '140',
      CARNAMEMSTNAME2: 'SM5 New Impression 2000 CVTC LE AT 휘발유',
      RETURNDATE: '20120104',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1968111255837',
      RENTFEE: '160000',
      OBJCARNO: '15허3551',
      CARNO: '44허2057',
      ACCPERSONNAME: '',
      DATA_KEY: '140',
      CARNAMEMSTNAME: '소나타 Y20 2000 VVT Grand AT 휘발유',
      RENTDATE: '20111230',
      UNIT24: '142000',
      TERMTYPE: 'S',
      NETSALEAMT: '215549',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '인천계양예약소',
      SALEVATAMT: '21555',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: '',
      DEPTNAME: '부천지점',
      ACCDATE: '',
      SALEAMT: '237104',
      STARTDATE: ''
    },
    {
      NO: '141',
      CARNAMEMSTNAME2: 'K5렌터카 2000 LPI 디럭스 AT LPG',
      RETURNDATE: '20120103',
      ACCNO: '201112273208',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1130110906354',
      CONTRACTNO: 'SS1848111255848',
      RENTFEE: '165000',
      OBJCARNO: '52허3453',
      CARNO: '60허5577',
      ACCPERSONNAME: '김대윤',
      DATA_KEY: '141',
      CARNAMEMSTNAME: 'K5렌터카 2000 LPI 디럭스 AT LPG',
      RENTDATE: '20111228',
      UNIT24: '165000',
      TERMTYPE: 'S',
      NETSALEAMT: '283615',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '수원삼정예약소',
      SALEVATAMT: '28361',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '수원지점',
      ACCDATE: '20111225',
      SALEAMT: '311976',
      STARTDATE: ''
    },
    {
      NO: '142',
      CARNAMEMSTNAME2: '캡티바7P 2200 VCDi 4WD LT AT 디젤',
      RETURNDATE: '20120105',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1240120160515',
      RENTFEE: '165000',
      OBJCARNO: '62허5041',
      CARNO: '62허5504',
      ACCPERSONNAME: '',
      DATA_KEY: '142',
      CARNAMEMSTNAME: 'K5렌터카 2000 LPI 디럭스 AT LPG',
      RENTDATE: '20120103',
      UNIT24: '199000',
      TERMTYPE: 'S',
      NETSALEAMT: '108545',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '대구지점(동대구역)',
      SALEVATAMT: '10855',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '동대문지점',
      ACCDATE: '',
      SALEAMT: '119400',
      STARTDATE: ''
    },
    {
      NO: '143',
      CARNAMEMSTNAME2: 'New SM3 1600 γ - 1.6 LPi 엔진 LE Plus AT 휘발유',
      RETURNDATE: '20120103',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1390120164292',
      RENTFEE: '109000',
      OBJCARNO: '32허8000',
      CARNO: '47허6648',
      ACCPERSONNAME: '',
      DATA_KEY: '143',
      CARNAMEMSTNAME: 'New SM3 1600 γ - 1.6 LPi 엔진 LE Plus AT 휘발유',
      RENTDATE: '20120102',
      UNIT24: '109000',
      TERMTYPE: 'S',
      NETSALEAMT: '33091',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '홍대영업소',
      SALEVATAMT: '3309',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '서대문지점',
      ACCDATE: '',
      SALEAMT: '36400',
      STARTDATE: ''
    },
    {
      NO: '144',
      CARNAMEMSTNAME2: 'All New 모닝 바이퓨얼 1000 MPI 스마트 AT 휘발유/LPG',
      RETURNDATE: '20120106',
      ACCNO: '201201030345',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1040110906792',
      CONTRACTNO: 'SS1947120160845',
      RENTFEE: '150000',
      OBJCARNO: '45허4571',
      CARNO: '32허3114',
      ACCPERSONNAME: '이준엽',
      DATA_KEY: '144',
      CARNAMEMSTNAME: '소나타 트랜스폼 N20 2000 LPI Deluxe AT LPG',
      RENTDATE: '20120104',
      UNIT24: '95000',
      TERMTYPE: 'S',
      NETSALEAMT: '65644',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '청원서울예약소',
      SALEVATAMT: '6564',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '강동지점',
      ACCDATE: '20120103',
      SALEAMT: '72208',
      STARTDATE: ''
    },
    {
      NO: '145',
      CARNAMEMSTNAME2: '소나타 Y20 렌터카 2000 LPI Luxury AT LPG',
      RETURNDATE: '20120109',
      ACCNO: '201201070864',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1440110165465',
      CONTRACTNO: 'SS1818120166354',
      RENTFEE: '165000',
      OBJCARNO: '60허6942',
      CARNO: '52허7340',
      ACCPERSONNAME: '김현철',
      DATA_KEY: '145',
      CARNAMEMSTNAME: '소나타 Y20 렌터카 2000 LPI Luxury AT LPG',
      RENTDATE: '20120107',
      UNIT24: '165000',
      TERMTYPE: 'S',
      NETSALEAMT: '146640',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '도곡예약소',
      SALEVATAMT: '14664',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '동대문지점',
      ACCDATE: '20120107',
      SALEAMT: '161304',
      STARTDATE: ''
    },
    {
      NO: '146',
      CARNAMEMSTNAME2: '그랜드 카니발R 11P 2200 E-VGT GLX R스페셜 AT 디젤',
      RETURNDATE: '20120103',
      ACCNO: '201112303647',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1040110165542',
      CONTRACTNO: 'SS1818111258578',
      RENTFEE: '292000',
      OBJCARNO: '76허1359',
      CARNO: '28허2928',
      ACCPERSONNAME: '김현철',
      DATA_KEY: '146',
      CARNAMEMSTNAME: 'K7 렌터카 2700 V6 뮤 VG270 럭셔리 AT LPG',
      RENTDATE: '20111230',
      UNIT24: '317000',
      TERMTYPE: 'S',
      NETSALEAMT: '325160',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '도곡예약소',
      SALEVATAMT: '32516',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '강동지점',
      ACCDATE: '20111230',
      SALEAMT: '357676',
      STARTDATE: ''
    },
    {
      NO: '147',
      CARNAMEMSTNAME2: '토스카 PREMIUM 6 2000 DOHC L6 2.0 SX AT 휘발유',
      RETURNDATE: '20120103',
      ACCNO: '201112283323',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1460091148249',
      CONTRACTNO: 'SS1837111255816',
      RENTFEE: '160000',
      OBJCARNO: '56허8278',
      CARNO: '10허6226',
      ACCPERSONNAME: '이준엽',
      DATA_KEY: '147',
      CARNAMEMSTNAME: 'K5 2000 I4 세타 Ⅱ 스마트 스페셜 AT 휘발유',
      RENTDATE: '20111228',
      UNIT24: '142000',
      TERMTYPE: 'S',
      NETSALEAMT: '262691',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '부산태원',
      SALEVATAMT: '26269',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업5팀',
      ACCDATE: '20111228',
      SALEAMT: '288960',
      STARTDATE: ''
    },
    {
      NO: '148',
      CARNAMEMSTNAME2: '5G 그랜져 3000 GDI HG300 PRIME AT 휘발유',
      RETURNDATE: '20120102',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1476111249942',
      RENTFEE: '399000',
      OBJCARNO: '63허2204',
      CARNO: '32허4474',
      ACCPERSONNAME: '',
      DATA_KEY: '148',
      CARNAMEMSTNAME: '제네시스 3300 람다 BH330 GRAND PRIME PACK AT 휘발유',
      RENTDATE: '20111224',
      UNIT24: '292000',
      TERMTYPE: 'S',
      NETSALEAMT: '748745',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: 'MT기획팀',
      SALEVATAMT: '74875',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: 'SU7팀',
      ACCDATE: '',
      SALEAMT: '823620',
      STARTDATE: ''
    },
    {
      NO: '149',
      CARNAMEMSTNAME2: 'K5렌터카 2000 LPI 프레스티지 AT LPG',
      RETURNDATE: '20120110',
      ACCNO: '201201060743',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1310111209452',
      CONTRACTNO: 'SS1310120166548',
      RENTFEE: '165000',
      OBJCARNO: '13허3599',
      CARNO: '04허5515',
      ACCPERSONNAME: '박수호',
      DATA_KEY: '149',
      CARNAMEMSTNAME: 'K5렌터카 2000 LPI 디럭스 AT LPG',
      RENTDATE: '20120106',
      UNIT24: '165000',
      TERMTYPE: 'S',
      NETSALEAMT: '185440',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '경주영업소',
      SALEVATAMT: '18544',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '포항지점',
      ACCDATE: '20120106',
      SALEAMT: '203984',
      STARTDATE: ''
    },
    {
      NO: '150',
      CARNAMEMSTNAME2: '소나타 Y20 2000 VVT Prime 고급형 AT 휘발유',
      RETURNDATE: '20120105',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1511120160683',
      RENTFEE: '160000',
      OBJCARNO: '44허2096',
      CARNO: '60허5242',
      ACCPERSONNAME: '',
      DATA_KEY: '150',
      CARNAMEMSTNAME: 'K5 2000 I4 세타 Ⅱ 스마트 스페셜 AT 휘발유',
      RENTDATE: '20120103',
      UNIT24: '160000',
      TERMTYPE: 'S',
      NETSALEAMT: '102218',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '서울대지점',
      SALEVATAMT: '10222',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '영업5팀',
      ACCDATE: '',
      SALEAMT: '112440',
      STARTDATE: ''
    },
    {
      NO: '151',
      CARNAMEMSTNAME2: '베르나 트랜스폼 1500 VGT PREMIER AT 디젤',
      RETURNDATE: '20120106',
      ACCNO: '201201030378',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1461100456947',
      CONTRACTNO: 'SS1818120161631',
      RENTFEE: '160000',
      OBJCARNO: '44허2167',
      CARNO: '60허5227',
      ACCPERSONNAME: '김대윤',
      DATA_KEY: '151',
      CARNAMEMSTNAME: 'K5 2000 I4 세타 Ⅱ 스마트 스페셜 AT 휘발유',
      RENTDATE: '20120103',
      UNIT24: '95000',
      TERMTYPE: 'S',
      NETSALEAMT: '84211',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '도곡예약소',
      SALEVATAMT: '8421',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업3팀',
      ACCDATE: '20120103',
      SALEAMT: '92632',
      STARTDATE: ''
    },
    {
      NO: '152',
      CARNAMEMSTNAME2: '소나타 Y20 렌터카 2000 LPI Deluxe AT LPG',
      RETURNDATE: '20120110',
      ACCNO: '201201040460',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1420100861093',
      CONTRACTNO: 'SS1836120161791',
      RENTFEE: '150000',
      OBJCARNO: '13허6162',
      CARNO: '26허9327',
      ACCPERSONNAME: '이준엽',
      DATA_KEY: '152',
      CARNAMEMSTNAME: '소나타 N20 2000 LPI DLX 기본형 AT LPG',
      RENTDATE: '20120104',
      UNIT24: '165000',
      TERMTYPE: 'S',
      NETSALEAMT: '267055',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '김천지점',
      SALEVATAMT: '26705',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업4팀',
      ACCDATE: '20120104',
      SALEAMT: '293760',
      STARTDATE: ''
    },
    {
      NO: '153',
      CARNAMEMSTNAME2: '소나타 Y20 렌터카 2000 LPI Luxury AT LPG',
      RETURNDATE: '20120104',
      ACCNO: '201112263161',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1410091248646',
      CONTRACTNO: 'SS1869120161878',
      RENTFEE: '165000',
      OBJCARNO: '05허1915',
      CARNO: '56허9415',
      ACCPERSONNAME: '윤원재',
      DATA_KEY: '153',
      CARNAMEMSTNAME: '소나타 Y20 렌터카 2000 LPI Luxury AT LPG',
      RENTDATE: '20120102',
      UNIT24: '165000',
      TERMTYPE: 'S',
      NETSALEAMT: '135000',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '안산상록예약소',
      SALEVATAMT: '13500',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '부천지점',
      ACCDATE: '20111226',
      SALEAMT: '148500',
      STARTDATE: ''
    },
    {
      NO: '154',
      CARNAMEMSTNAME2: '윈스톰 7인승 2000 VCDi LT-XTREME AT 디젤',
      RETURNDATE: '20120110',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1862120161905',
      RENTFEE: '199000',
      OBJCARNO: '26허7841',
      CARNO: '04허5475',
      ACCPERSONNAME: '',
      DATA_KEY: '154',
      CARNAMEMSTNAME: '싼타페 The Style 4WD 2200 E-VGT CLX DELUXE AT 디젤',
      RENTDATE: '20120103',
      UNIT24: '199000',
      TERMTYPE: 'S',
      NETSALEAMT: '348218',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '대구동구',
      SALEVATAMT: '34822',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '영업4팀',
      ACCDATE: '',
      SALEAMT: '383040',
      STARTDATE: ''
    },
    {
      NO: '155',
      CARNAMEMSTNAME2: 'SM5 2000 LPI 렌터카 모범형 AT LPG',
      RETURNDATE: '20120105',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1855120169539',
      RENTFEE: '150000',
      OBJCARNO: '59허2029',
      CARNO: '41허3815',
      ACCPERSONNAME: '',
      DATA_KEY: '155',
      CARNAMEMSTNAME: '소나타 트랜스폼 N20 2000 LPI Deluxe AT LPG',
      RENTDATE: '20120103',
      UNIT24: '0',
      TERMTYPE: 'S',
      NETSALEAMT: '97891',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '부산연산역',
      SALEVATAMT: '9789',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '서대문지점',
      ACCDATE: '',
      SALEAMT: '107680',
      STARTDATE: ''
    },
    {
      NO: '156',
      CARNAMEMSTNAME2: '에쿠스 TRUE PRESTIGE 3800 V6 람다 VS 380 프라임 VIP PACK AT 휘발유',
      RETURNDATE: '20120110',
      ACCNO: '201201040507',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1250100659556',
      CONTRACTNO: 'SS1944120162334',
      RENTFEE: '292000',
      OBJCARNO: '10허6105',
      CARNO: '52허5711',
      ACCPERSONNAME: '정해성',
      DATA_KEY: '156',
      CARNAMEMSTNAME: '5G 그랜져 3000 LPI HG300 렌터카 Prime AT LPG',
      RENTDATE: '20120105',
      UNIT24: '488000',
      TERMTYPE: 'S',
      NETSALEAMT: '491004',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '대전태화예약소',
      SALEVATAMT: '49100',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '대전지점',
      ACCDATE: '20120103',
      SALEAMT: '540104',
      STARTDATE: ''
    },
    {
      NO: '157',
      CARNAMEMSTNAME2: '토스카 PREMIUM 6 2000 LPGi L6 2.0 AT LPG',
      RETURNDATE: '20120110',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1935120163466',
      RENTFEE: '165000',
      OBJCARNO: '60허5019',
      CARNO: '59허3390',
      ACCPERSONNAME: '',
      DATA_KEY: '157',
      CARNAMEMSTNAME: 'K5렌터카 2000 LPI 디럭스 AT LPG',
      RENTDATE: '20120102',
      UNIT24: '150000',
      TERMTYPE: 'S',
      NETSALEAMT: '356073',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '평택송화예약소',
      SALEVATAMT: '35607',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '청주지점',
      ACCDATE: '',
      SALEAMT: '391680',
      STARTDATE: ''
    },
    {
      NO: '158',
      CARNAMEMSTNAME2: '슈퍼 렉스턴 2700 XDi RX6 (4WD) 최고급형 AT 디젤',
      RETURNDATE: '20120109',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1935120163470',
      RENTFEE: '165000',
      OBJCARNO: '56허8936',
      CARNO: '60허6538',
      ACCPERSONNAME: '',
      DATA_KEY: '158',
      CARNAMEMSTNAME: '소나타 Y20 렌터카 2000 LPI Luxury AT LPG',
      RENTDATE: '20120103',
      UNIT24: '190000',
      TERMTYPE: 'S',
      NETSALEAMT: '305455',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '평택송화예약소',
      SALEVATAMT: '30545',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '안산지점',
      ACCDATE: '',
      SALEAMT: '336000',
      STARTDATE: ''
    },
    {
      NO: '159',
      CARNAMEMSTNAME2: '액티언스포츠 2000 XVT AX7(4WD) PASSION AT 디젤',
      RETURNDATE: '20120104',
      ACCNO: '201112242807',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1470090236016',
      CONTRACTNO: 'SS1819111250434',
      RENTFEE: '199000',
      OBJCARNO: '80무7822',
      CARNO: '63허8960',
      ACCPERSONNAME: '정해성',
      DATA_KEY: '159',
      CARNAMEMSTNAME: '싼타페 The Style 4WD 2200 E-VGT CLX DELUXE AT 디젤',
      RENTDATE: '20111226',
      UNIT24: '190000',
      TERMTYPE: 'S',
      NETSALEAMT: '465433',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '공주지점',
      SALEVATAMT: '46543',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업4팀',
      ACCDATE: '20111224',
      SALEAMT: '511976',
      STARTDATE: ''
    },
    {
      NO: '160',
      CARNAMEMSTNAME2: '뉴프라이드(5DR) 1500 VGT SLX AT 디젤',
      RETURNDATE: '20120105',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1100120160952',
      RENTFEE: '109000',
      OBJCARNO: '26허8798',
      CARNO: '52허5636',
      ACCPERSONNAME: '',
      DATA_KEY: '160',
      CARNAMEMSTNAME: '아반떼 M16 1600 LPI 렌터카 LUXURY AT LPG',
      RENTDATE: '20120103',
      UNIT24: '99000',
      TERMTYPE: 'S',
      NETSALEAMT: '86636',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '인천지점',
      SALEVATAMT: '8664',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '인천지점',
      ACCDATE: '',
      SALEAMT: '95300',
      STARTDATE: ''
    },
    {
      NO: '161',
      CARNAMEMSTNAME2: '소나타 Y20 렌터카 2000 LPI Luxury AT LPG',
      RETURNDATE: '20120107',
      ACCNO: '201112313737',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1180100455305',
      CONTRACTNO: 'SS1837111258764',
      RENTFEE: '165000',
      OBJCARNO: '49허6161',
      CARNO: '47허5994',
      ACCPERSONNAME: '어성환',
      DATA_KEY: '161',
      CARNAMEMSTNAME: '소나타 Y20 렌터카 2000 LPI Luxury AT LPG',
      RENTDATE: '20111231',
      UNIT24: '165000',
      TERMTYPE: 'S',
      NETSALEAMT: '305455',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '부산태원',
      SALEVATAMT: '30545',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '천안아산지점',
      ACCDATE: '20111231',
      SALEAMT: '336000',
      STARTDATE: ''
    },
    {
      NO: '162',
      CARNAMEMSTNAME2: '소나타 Y20 렌터카 2000 LPI Luxury AT LPG',
      RETURNDATE: '20120105',
      ACCNO: '201112303707',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1250100860889',
      CONTRACTNO: 'SS1812111259840',
      RENTFEE: '165000',
      OBJCARNO: '10허5968',
      CARNO: '60허6981',
      ACCPERSONNAME: '이준엽',
      DATA_KEY: '162',
      CARNAMEMSTNAME: 'K5렌터카 2000 LPI 디럭스 AT LPG',
      RENTDATE: '20111231',
      UNIT24: '165000',
      TERMTYPE: 'S',
      NETSALEAMT: '277927',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '전주코리아',
      SALEVATAMT: '27793',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '대전지점',
      ACCDATE: '20111230',
      SALEAMT: '305720',
      STARTDATE: ''
    },
    {
      NO: '163',
      CARNAMEMSTNAME2: '에쿠스 TRUE PRESTIGE 3800 GDI VS 380 럭셔리 AT 휘발유',
      RETURNDATE: '20120105',
      ACCNO: '201201040469',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1454110805667',
      CONTRACTNO: 'SS1818120161596',
      RENTFEE: '488000',
      OBJCARNO: '52허4254',
      CARNO: '63허8788',
      ACCPERSONNAME: '김선연',
      DATA_KEY: '163',
      CARNAMEMSTNAME: '에쿠스 TRUE PRESTIGE 3800 V6 람다 VS 380 프라임 AT 휘발유',
      RENTDATE: '20120104',
      UNIT24: '488000',
      TERMTYPE: 'S',
      NETSALEAMT: '147636',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '도곡예약소',
      SALEVATAMT: '14764',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업3팀',
      ACCDATE: '20120104',
      SALEAMT: '162400',
      STARTDATE: ''
    },
    {
      NO: '164',
      CARNAMEMSTNAME2: '쎄라토 1600 CVVT LX AT 휘발유/LPG',
      RETURNDATE: '20120108',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1816111250545',
      RENTFEE: '165000',
      OBJCARNO: '41허1653',
      CARNO: '56허9738',
      ACCPERSONNAME: '',
      DATA_KEY: '164',
      CARNAMEMSTNAME: '소나타 Y20 렌터카 2000 LPI Luxury AT LPG',
      RENTDATE: '20111226',
      UNIT24: '0',
      TERMTYPE: 'S',
      NETSALEAMT: '344145',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '광주진왕',
      SALEVATAMT: '34415',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '영업1팀',
      ACCDATE: '',
      SALEAMT: '378560',
      STARTDATE: ''
    },
    {
      NO: '165',
      CARNAMEMSTNAME2: '소나타 트랜스폼 N20 2000 LPI Luxury AT LPG',
      RETURNDATE: '20120104',
      ACCNO: '201112283338',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1130081133249',
      CONTRACTNO: 'SS1476111253963',
      RENTFEE: '150000',
      OBJCARNO: '41허4708',
      CARNO: '26허8950',
      ACCPERSONNAME: '김선연',
      DATA_KEY: '165',
      CARNAMEMSTNAME: '소나타 N20 2000 LPI LUX 기본형 AT LPG',
      RENTDATE: '20111228',
      UNIT24: '150000',
      TERMTYPE: 'S',
      NETSALEAMT: '295738',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: 'MT기획팀',
      SALEVATAMT: '29574',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '수원지점',
      ACCDATE: '20111228',
      SALEAMT: '325312',
      STARTDATE: ''
    },
    {
      NO: '166',
      CARNAMEMSTNAME2: '소나타 N20 2000 LPI 일반 고급형 AT LPG',
      RETURNDATE: '20120104',
      ACCNO: '201201040461',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1460080526473',
      CONTRACTNO: 'SS1822120173561',
      RENTFEE: '165000',
      OBJCARNO: '18허4028',
      CARNO: '40허6466',
      ACCPERSONNAME: '정해성',
      DATA_KEY: '166',
      CARNAMEMSTNAME: '소나타 Y20 렌터카 2000 LPI Luxury AT LPG',
      RENTDATE: '20120103',
      UNIT24: '150000',
      TERMTYPE: 'S',
      NETSALEAMT: '54400',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '대구하나',
      SALEVATAMT: '5440',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업3팀',
      ACCDATE: '20120102',
      SALEAMT: '59840',
      STARTDATE: ''
    },
    {
      NO: '167',
      CARNAMEMSTNAME2: '싼타페 The Style 4WD 2200 E-VGT MLX LUXURY AT 디젤',
      RETURNDATE: '20120105',
      ACCNO: '201201020222',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1460100861364',
      CONTRACTNO: 'SS1891120160652',
      RENTFEE: '199000',
      OBJCARNO: '63허1571',
      CARNO: '05허5759',
      ACCPERSONNAME: '김선연',
      DATA_KEY: '167',
      CARNAMEMSTNAME: '싼타페 The Style 4WD 2200 E-VGT CLX DELUXE AT 디젤',
      RENTDATE: '20120103',
      UNIT24: '199000',
      TERMTYPE: 'S',
      NETSALEAMT: '153902',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '시흥정왕예약소',
      SALEVATAMT: '15390',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업4팀',
      ACCDATE: '20120102',
      SALEAMT: '169292',
      STARTDATE: ''
    },
    {
      NO: '168',
      CARNAMEMSTNAME2: '5G 그랜져 3000 LPI HG300 렌터카 Prime AT LPG',
      RETURNDATE: '20120107',
      ACCNO: '201201040502',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1060110703970',
      CONTRACTNO: 'SS1974120162718',
      RENTFEE: '292000',
      OBJCARNO: '52허7394',
      CARNO: '56허9540',
      ACCPERSONNAME: '이준엽',
      DATA_KEY: '168',
      CARNAMEMSTNAME: 'K7 렌터카 2700 V6 뮤 VG270 럭셔리 AT LPG',
      RENTDATE: '20120105',
      UNIT24: '292000',
      TERMTYPE: 'S',
      NETSALEAMT: '230393',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '성남단대역예약소',
      SALEVATAMT: '23039',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '건대지점',
      ACCDATE: '20120104',
      SALEAMT: '253432',
      STARTDATE: ''
    },
    {
      NO: '169',
      CARNAMEMSTNAME2: 'K5렌터카 2000 LPI 럭셔리 AT LPG',
      RETURNDATE: '20120102',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1476111255263',
      RENTFEE: '165000',
      OBJCARNO: '63허8777',
      CARNO: '44허1005',
      ACCPERSONNAME: '',
      DATA_KEY: '169',
      CARNAMEMSTNAME: '소나타 Y20 렌터카 2000 LPI Luxury AT LPG',
      RENTDATE: '20111229',
      UNIT24: '165000',
      TERMTYPE: 'S',
      NETSALEAMT: '196364',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: 'MT기획팀',
      SALEVATAMT: '19636',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: 'SU6팀',
      ACCDATE: '',
      SALEAMT: '216000',
      STARTDATE: ''
    },
    {
      NO: '170',
      CARNAMEMSTNAME2: '뉴프라이드 1500 VGT LX AT 디젤',
      RETURNDATE: '20120109',
      ACCNO: '201112283326',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1100090844245',
      CONTRACTNO: 'SS1848111255833',
      RENTFEE: '150000',
      OBJCARNO: '41허5671',
      CARNO: '41허5391',
      ACCPERSONNAME: '윤원재',
      DATA_KEY: '170',
      CARNAMEMSTNAME: '토스카 PREMIUM 6 2000 LPGi L6 2.0 AT LPG',
      RENTDATE: '20111228',
      UNIT24: '99000',
      TERMTYPE: 'S',
      NETSALEAMT: '344145',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '수원삼정예약소',
      SALEVATAMT: '34415',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '인천지점',
      ACCDATE: '20111228',
      SALEAMT: '378560',
      STARTDATE: ''
    },
    {
      NO: '171',
      CARNAMEMSTNAME2: 'New SM5  2000 CVTC Ⅱ SE AT 휘발유',
      RETURNDATE: '20120104',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1907120160239',
      RENTFEE: '165000',
      OBJCARNO: '56허8995',
      CARNO: '42허5460',
      ACCPERSONNAME: '',
      DATA_KEY: '171',
      CARNAMEMSTNAME: '소나타 Y20 렌터카 2000 LPI Premier AT LPG',
      RENTDATE: '20120102',
      UNIT24: '160000',
      TERMTYPE: 'S',
      NETSALEAMT: '103309',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '당진원당예약소',
      SALEVATAMT: '10331',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '영업3팀',
      ACCDATE: '',
      SALEAMT: '113640',
      STARTDATE: ''
    },
    {
      NO: '172',
      CARNAMEMSTNAME2: 'All New 모닝 1000 MPI 스마트 스페셜 AT 휘발유',
      RETURNDATE: '20120106',
      ACCNO: '201201040531',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LD1050111209171',
      CONTRACTNO: 'SS1476120163224',
      RENTFEE: '99000',
      OBJCARNO: '39허7265',
      CARNO: '04허2259',
      ACCPERSONNAME: '김대윤',
      DATA_KEY: '172',
      CARNAMEMSTNAME: '뉴아반떼 1600 VVT S16 LUXURY  AT 휘발유',
      RENTDATE: '20120105',
      UNIT24: '95000',
      TERMTYPE: 'S',
      NETSALEAMT: '43091',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: 'MT기획팀',
      SALEVATAMT: '4309',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '분당지점',
      ACCDATE: '20120104',
      SALEAMT: '47400',
      STARTDATE: ''
    },
    {
      NO: '173',
      CARNAMEMSTNAME2: 'K5 2000 I4 세타 Ⅱ 럭셔리 AT 휘발유',
      RETURNDATE: '20120107',
      ACCNO: '201201050663',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1450101164607',
      CONTRACTNO: 'SS1818120163393',
      RENTFEE: '160000',
      OBJCARNO: '26허6076',
      CARNO: '60허5227',
      ACCPERSONNAME: '김현철',
      DATA_KEY: '173',
      CARNAMEMSTNAME: 'K5 2000 I4 세타 Ⅱ 스마트 스페셜 AT 휘발유',
      RENTDATE: '20120106',
      UNIT24: '160000',
      TERMTYPE: 'S',
      NETSALEAMT: '63273',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '도곡예약소',
      SALEVATAMT: '6327',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업1팀',
      ACCDATE: '20120105',
      SALEAMT: '69600',
      STARTDATE: ''
    },
    {
      NO: '174',
      CARNAMEMSTNAME2: 'New SM3 1600 CVTC PE AT 휘발유',
      RETURNDATE: '20120103',
      ACCNO: '201112293576',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1355100557488',
      CONTRACTNO: 'SS1837111258762',
      RENTFEE: '99000',
      OBJCARNO: '68허3228',
      CARNO: '41허5412',
      ACCPERSONNAME: '정해성',
      DATA_KEY: '174',
      CARNAMEMSTNAME: '뉴아반떼 1600 VVT S16 LUXURY  AT 휘발유',
      RENTDATE: '20111230',
      UNIT24: '109000',
      TERMTYPE: 'S',
      NETSALEAMT: '122273',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '부산태원',
      SALEVATAMT: '12227',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '부산지점',
      ACCDATE: '20111229',
      SALEAMT: '134500',
      STARTDATE: ''
    },
    {
      NO: '175',
      CARNAMEMSTNAME2: '엑센트 1600 VGT PREMIER AT 디젤',
      RETURNDATE: '20120103',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1945120158882',
      RENTFEE: '99000',
      OBJCARNO: '05허7810',
      CARNO: '44허2221',
      ACCPERSONNAME: '',
      DATA_KEY: '175',
      CARNAMEMSTNAME: '뉴아반떼 1600 VVT S16 월드컵 SPECIAL EDITION AT 휘발유',
      RENTDATE: '20120102',
      UNIT24: '99000',
      TERMTYPE: 'S',
      NETSALEAMT: '49636',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '일산탄현예약소',
      SALEVATAMT: '4964',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '안양지점',
      ACCDATE: '',
      SALEAMT: '54600',
      STARTDATE: ''
    },
    {
      NO: '176',
      CARNAMEMSTNAME2: '싼타페 The Style 4WD 2200 E-VGT CLX DELUXE AT 디젤',
      RETURNDATE: '20120103',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1944111251389',
      RENTFEE: '199000',
      OBJCARNO: '28허2352',
      CARNO: '63허5409',
      ACCPERSONNAME: '',
      DATA_KEY: '176',
      CARNAMEMSTNAME: '싼타페 The Style 4WD 2200 E-VGT CLX DELUXE AT 디젤',
      RENTDATE: '20111224',
      UNIT24: '199000',
      TERMTYPE: 'S',
      NETSALEAMT: '497455',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '대전태화예약소',
      SALEVATAMT: '49745',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '영업2팀',
      ACCDATE: '',
      SALEAMT: '547200',
      STARTDATE: ''
    },
    {
      NO: '177',
      CARNAMEMSTNAME2: '그랜져 THE LUXURY 2700 LPI 장애인용 Q270 왼발장애 AT LPG',
      RETURNDATE: '20120106',
      ACCNO: '201201010050',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1474101163689',
      CONTRACTNO: 'SS1878120159261',
      RENTFEE: '292000',
      OBJCARNO: '63허7492',
      CARNO: '28허2535',
      ACCPERSONNAME: '어성환',
      DATA_KEY: '177',
      CARNAMEMSTNAME: 'K7 렌터카 2700 V6 뮤 VG270 럭셔리 AT LPG',
      RENTDATE: '20120102',
      UNIT24: '266000',
      TERMTYPE: 'S',
      NETSALEAMT: '316800',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '성수트루예약소',
      SALEVATAMT: '31680',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '잠실지점',
      ACCDATE: '20120101',
      SALEAMT: '348480',
      STARTDATE: ''
    },
    {
      NO: '178',
      CARNAMEMSTNAME2: '오피러스 PREMIUM 2700 V6 뮤 GH270 스페셜-럭셔리 AT 휘발유',
      RETURNDATE: '20120103',
      ACCNO: '201112293547',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1461100962410',
      CONTRACTNO: 'SS1878120159265',
      RENTFEE: '266000',
      OBJCARNO: '63허3475',
      CARNO: '39허5889',
      ACCPERSONNAME: '김선연',
      DATA_KEY: '178',
      CARNAMEMSTNAME: 'K7 The Prestige 2400 I4 세타 Ⅱ 2.4GDI 럭셔리 AT 휘발유',
      RENTDATE: '20120102',
      UNIT24: '307000',
      TERMTYPE: 'S',
      NETSALEAMT: '84655',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '성수트루예약소',
      SALEVATAMT: '8465',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업5팀',
      ACCDATE: '20111228',
      SALEAMT: '93120',
      STARTDATE: ''
    },
    {
      NO: '179',
      CARNAMEMSTNAME2: '뉴 카니발R 9P 2200 E-VGT GX AT 디젤',
      RETURNDATE: '20120105',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1360120163256',
      RENTFEE: '219000',
      OBJCARNO: '47허5533',
      CARNO: '73허5883',
      ACCPERSONNAME: '',
      DATA_KEY: '179',
      CARNAMEMSTNAME: '그랜드 스타렉스 12P WAGON 2500 VGT CVX Premium AT 디젤',
      RENTDATE: '20120102',
      UNIT24: '270000',
      TERMTYPE: 'S',
      NETSALEAMT: '195364',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '진주사천지점',
      SALEVATAMT: '19536',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '진주사천지점',
      ACCDATE: '',
      SALEAMT: '214900',
      STARTDATE: ''
    },
    {
      NO: '180',
      CARNAMEMSTNAME2: '소나타 Y20 렌터카 2000 LPI Premier AT LPG',
      RETURNDATE: '20120106',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1961120163302',
      RENTFEE: '165000',
      OBJCARNO: '52허5953',
      CARNO: '44허7095',
      ACCPERSONNAME: '',
      DATA_KEY: '180',
      CARNAMEMSTNAME: '소나타 Y20 렌터카 2000 LPI Luxury AT LPG',
      RENTDATE: '20120105',
      UNIT24: '165000',
      TERMTYPE: 'S',
      NETSALEAMT: '54545',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '전주타이어클럽',
      SALEVATAMT: '5455',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '영업3팀',
      ACCDATE: '',
      SALEAMT: '60000',
      STARTDATE: ''
    },
    {
      NO: '181',
      CARNAMEMSTNAME2: '소나타 Y20 렌터카 2000 LPI Deluxe AT LPG',
      RETURNDATE: '20120105',
      ACCNO: '201112232632',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1130100353568',
      CONTRACTNO: 'SS1837111249968',
      RENTFEE: '109000',
      OBJCARNO: '47허5591',
      CARNO: '52허5639',
      ACCPERSONNAME: '이준엽',
      DATA_KEY: '181',
      CARNAMEMSTNAME: '아반떼 M16 1600 LPI 렌터카 LUXURY AT LPG',
      RENTDATE: '20111223',
      UNIT24: '165000',
      TERMTYPE: 'S',
      NETSALEAMT: '344145',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '부산태원',
      SALEVATAMT: '34415',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '수원지점',
      ACCDATE: '20111223',
      SALEAMT: '378560',
      STARTDATE: ''
    },
    {
      NO: '182',
      CARNAMEMSTNAME2: '제네시스 3300 람다 BH330 GRAND AT 휘발유',
      RETURNDATE: '20120110',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '50',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1956120164102',
      RENTFEE: '399000',
      OBJCARNO: '57더1773',
      CARNO: '44허5385',
      ACCPERSONNAME: '',
      DATA_KEY: '182',
      CARNAMEMSTNAME: '제네시스 3300 람다 BH330 LUXURY AT 휘발유',
      RENTDATE: '20120106',
      UNIT24: '399000',
      TERMTYPE: 'S',
      NETSALEAMT: '649855',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '상봉예약소',
      SALEVATAMT: '64985',
      REPAIRPERSONNAME: '',
      PROMOCODE: '리스대차',
      TERMTYPE2: '',
      DEPTNAME: 'AJ캐피탈',
      ACCDATE: '',
      SALEAMT: '714840',
      STARTDATE: ''
    },
    {
      NO: '183',
      CARNAMEMSTNAME2: '모하비 4WD 3000 V6 E-VGT KV300 AT 디젤',
      RETURNDATE: '20120102',
      ACCNO: '201112263133',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1300111209528',
      CONTRACTNO: 'SS1300111251607',
      RENTFEE: '292000',
      OBJCARNO: '20허2023',
      CARNO: '20허2047',
      ACCPERSONNAME: '박수호',
      DATA_KEY: '183',
      CARNAMEMSTNAME: 'K7 The Prestige 3000 V6 람다 3.0GDI 럭셔리 AT 휘발유',
      RENTDATE: '20111226',
      UNIT24: '349000',
      TERMTYPE: 'S',
      NETSALEAMT: '539636',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '울산지점',
      SALEVATAMT: '53964',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '울산지점',
      ACCDATE: '20111226',
      SALEAMT: '593600',
      STARTDATE: ''
    },
    {
      NO: '184',
      CARNAMEMSTNAME2: '소나타 Y20 2000 I4 세타 Ⅱ Prime AT 휘발유',
      RETURNDATE: '20120109',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1937111260200',
      RENTFEE: '165000',
      OBJCARNO: '60허6569',
      CARNO: '52허5493',
      ACCPERSONNAME: '',
      DATA_KEY: '184',
      CARNAMEMSTNAME: 'K5렌터카 2000 LPI 디럭스 AT LPG',
      RENTDATE: '20111230',
      UNIT24: '160000',
      TERMTYPE: 'S',
      NETSALEAMT: '421818',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '성수한국타이어예약소',
      SALEVATAMT: '42182',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '방배지점',
      ACCDATE: '',
      SALEAMT: '464000',
      STARTDATE: ''
    },
    {
      NO: '185',
      CARNAMEMSTNAME2: '투싼 ix 2WD 2000 E-VGT X20 Luxury AT 디젤',
      RETURNDATE: '20120102',
      ACCNO: '201112273266',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1456111108932',
      CONTRACTNO: 'SS1476111253961',
      RENTFEE: '199000',
      OBJCARNO: '39허7298',
      CARNO: '46허5703',
      ACCPERSONNAME: '이준엽',
      DATA_KEY: '185',
      CARNAMEMSTNAME: '쏘렌토 7P 2500 VGT LX 고급형 AT 디젤',
      RENTDATE: '20111228',
      UNIT24: '190000',
      TERMTYPE: 'S',
      NETSALEAMT: '285727',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: 'MT기획팀',
      SALEVATAMT: '28573',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업5팀',
      ACCDATE: '20111227',
      SALEAMT: '314300',
      STARTDATE: ''
    },
    {
      NO: '186',
      CARNAMEMSTNAME2: 'New SM5  2000 CVTC Ⅱ SE AT 휘발유',
      RETURNDATE: '20120103',
      ACCNO: '201112263068',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1453110483311',
      CONTRACTNO: 'SS1180111254088',
      RENTFEE: '142000',
      OBJCARNO: '62허5127',
      CARNO: '08허8596',
      ACCPERSONNAME: '정해성',
      DATA_KEY: '186',
      CARNAMEMSTNAME: 'SM5 New Impression 2000 CVTC LE Exclusive AT 휘발유',
      RENTDATE: '20111228',
      UNIT24: '160000',
      TERMTYPE: 'S',
      NETSALEAMT: '243916',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '천안아산지점',
      SALEVATAMT: '24392',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업2팀',
      ACCDATE: '20111226',
      SALEAMT: '268308',
      STARTDATE: ''
    },
    {
      NO: '187',
      CARNAMEMSTNAME2: '뉴마티즈 800 SOHC JOY MT 휘발유',
      RETURNDATE: '20120104',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1913111254213',
      RENTFEE: '109000',
      OBJCARNO: '41허4462',
      CARNO: '52허5670',
      ACCPERSONNAME: '',
      DATA_KEY: '187',
      CARNAMEMSTNAME: '아반떼 M16 1600 LPI 렌터카 LUXURY AT LPG',
      RENTDATE: '20111229',
      UNIT24: '95000',
      TERMTYPE: 'S',
      NETSALEAMT: '149367',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '성동성수예약소',
      SALEVATAMT: '14937',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '속초영업소',
      ACCDATE: '',
      SALEAMT: '164304',
      STARTDATE: ''
    },
    {
      NO: '188',
      CARNAMEMSTNAME2: '싼타페 2WD 2000 VGT CLX 최고급형 AT 디젤',
      RETURNDATE: '20120109',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1819120163616',
      RENTFEE: '199000',
      OBJCARNO: '47허6478',
      CARNO: '63허8960',
      ACCPERSONNAME: '',
      DATA_KEY: '188',
      CARNAMEMSTNAME: '싼타페 The Style 4WD 2200 E-VGT CLX DELUXE AT 디젤',
      RENTDATE: '20120106',
      UNIT24: '199000',
      TERMTYPE: 'S',
      NETSALEAMT: '191520',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '공주지점',
      SALEVATAMT: '19152',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '부산지점',
      ACCDATE: '',
      SALEAMT: '210672',
      STARTDATE: ''
    },
    {
      NO: '189',
      CARNAMEMSTNAME2: '제네시스 3800 GDI BH380 ROYAL VIP PACK AT 휘발유',
      RETURNDATE: '20120106',
      ACCNO: '201201030364',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1454111007618',
      CONTRACTNO: 'SS1913120161189',
      RENTFEE: '488000',
      OBJCARNO: '39허5950',
      CARNO: '05허4079',
      ACCPERSONNAME: '윤원재',
      DATA_KEY: '189',
      CARNAMEMSTNAME: '에쿠스 TRUE PRESTIGE 3800 V6 람다 VS 380 럭셔리 AT 휘발유',
      RENTDATE: '20120103',
      UNIT24: '447000',
      TERMTYPE: 'S',
      NETSALEAMT: '426669',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '성동성수예약소',
      SALEVATAMT: '42667',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업3팀',
      ACCDATE: '20120103',
      SALEAMT: '469336',
      STARTDATE: ''
    },
    {
      NO: '190',
      CARNAMEMSTNAME2: 'K5렌터카 2000 LPI 스마트 AT LPG',
      RETURNDATE: '20120109',
      ACCNO: '201201050654',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1456110366958',
      CONTRACTNO: 'SS1801120164168',
      RENTFEE: '165000',
      OBJCARNO: '24허5713',
      CARNO: '44허1321',
      ACCPERSONNAME: '김선연',
      DATA_KEY: '190',
      CARNAMEMSTNAME: '소나타 Y20 렌터카 2000 LPI Deluxe AT LPG',
      RENTDATE: '20120106',
      UNIT24: '165000',
      TERMTYPE: 'S',
      NETSALEAMT: '147258',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '인천21세기',
      SALEVATAMT: '14726',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업5팀',
      ACCDATE: '20120105',
      SALEAMT: '161984',
      STARTDATE: ''
    },
    {
      NO: '191',
      CARNAMEMSTNAME2: '뉴프라이드(5DR) 1500 VGT LX AT 디젤',
      RETURNDATE: '20120103',
      ACCNO: '201112263095',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1450080425333',
      CONTRACTNO: 'SS1921111252921',
      RENTFEE: '109000',
      OBJCARNO: '41허1711',
      CARNO: '63허2470',
      ACCPERSONNAME: '김현철',
      DATA_KEY: '191',
      CARNAMEMSTNAME: '아반떼 M16 1600 LPI 렌터카 LUXURY AT LPG',
      RENTDATE: '20111228',
      UNIT24: '99000',
      TERMTYPE: 'S',
      NETSALEAMT: '178691',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '안산사동예약소',
      SALEVATAMT: '17869',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업2팀',
      ACCDATE: '20111226',
      SALEAMT: '196560',
      STARTDATE: ''
    },
    {
      NO: '192',
      CARNAMEMSTNAME2: '뉴아반떼 1600 VVT E16 DELUXE AT 휘발유',
      RETURNDATE: '20120102',
      ACCNO: '201112283365',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LD1420080525997',
      CONTRACTNO: 'SS1913111253049',
      RENTFEE: '160000',
      OBJCARNO: '41허2220',
      CARNO: '56허9390',
      ACCPERSONNAME: '김현철',
      DATA_KEY: '192',
      CARNAMEMSTNAME: '소나타 Y20 2000 VVT Prime 고급형 AT 휘발유',
      RENTDATE: '20111228',
      UNIT24: '99000',
      TERMTYPE: 'S',
      NETSALEAMT: '158342',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '성동성수예약소',
      SALEVATAMT: '15834',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: 'SU6팀',
      ACCDATE: '20111228',
      SALEAMT: '174176',
      STARTDATE: ''
    },
    {
      NO: '193',
      CARNAMEMSTNAME2: '',
      RETURNDATE: '20120110',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '50',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1300120165795',
      RENTFEE: '190000',
      OBJCARNO: '',
      CARNO: '20허3091',
      ACCPERSONNAME: '',
      DATA_KEY: '193',
      CARNAMEMSTNAME: '투싼 2WD 2000 VGT MX 고급형 AT 디젤',
      RENTDATE: '20120107',
      UNIT24: '0',
      TERMTYPE: 'S',
      NETSALEAMT: '226177',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '울산지점',
      SALEVATAMT: '22618',
      REPAIRPERSONNAME: '',
      PROMOCODE: '리스대차',
      TERMTYPE2: '',
      DEPTNAME: '',
      ACCDATE: '',
      SALEAMT: '248795',
      STARTDATE: ''
    },
    {
      NO: '194',
      CARNAMEMSTNAME2: '카니발 그랜드 11P 2900 CRDI LIMITED 최고급형 AT 디젤',
      RETURNDATE: '20120105',
      ACCNO: '201201010012',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'SS1360111227985',
      CONTRACTNO: 'SS1360120160209',
      RENTFEE: '160000',
      OBJCARNO: '72허6227',
      CARNO: '59허9835',
      ACCPERSONNAME: '이준엽',
      DATA_KEY: '194',
      CARNAMEMSTNAME: '소나타 Y20 2000 I4 세타 Ⅱ Prime AT 휘발유',
      RENTDATE: '20120101',
      UNIT24: '317000',
      TERMTYPE: 'S',
      NETSALEAMT: '179244',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '진주사천지점',
      SALEVATAMT: '17924',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'M',
      DEPTNAME: '진주사천지점',
      ACCDATE: '20120101',
      SALEAMT: '197168',
      STARTDATE: ''
    },
    {
      NO: '195',
      CARNAMEMSTNAME2: '뉴프라이드(5DR) 1500 VGT LX AT 디젤',
      RETURNDATE: '20120109',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1921120167575',
      RENTFEE: '109000',
      OBJCARNO: '56허8099',
      CARNO: '59허3604',
      ACCPERSONNAME: '',
      DATA_KEY: '195',
      CARNAMEMSTNAME: '아반떼 M16 GDi 1600 GDI LUXURY AT 휘발유',
      RENTDATE: '20120106',
      UNIT24: '99000',
      TERMTYPE: 'S',
      NETSALEAMT: '89345',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '안산사동예약소',
      SALEVATAMT: '8935',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '영업4팀',
      ACCDATE: '',
      SALEAMT: '98280',
      STARTDATE: ''
    },
    {
      NO: '196',
      CARNAMEMSTNAME2: '오피러스 PREMIUM 2700 V6 뮤 GH270 스페셜 AT 휘발유',
      RETURNDATE: '20120110',
      ACCNO: '201201050592',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1461100659330',
      CONTRACTNO: 'SS1476120163222',
      RENTFEE: '399000',
      OBJCARNO: '60허5054',
      CARNO: '41허2396',
      ACCPERSONNAME: '김대윤',
      DATA_KEY: '196',
      CARNAMEMSTNAME: '제네시스 3300 람다 BH330 LUXURY AT 휘발유',
      RENTDATE: '20120105',
      UNIT24: '307000',
      TERMTYPE: 'S',
      NETSALEAMT: '436167',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: 'MT기획팀',
      SALEVATAMT: '43617',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업2팀',
      ACCDATE: '20120105',
      SALEAMT: '479784',
      STARTDATE: ''
    },
    {
      NO: '197',
      CARNAMEMSTNAME2: '카니발R 리무진 9P 2200 E-VGT President AT 디젤',
      RETURNDATE: '20120110',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1480120163319',
      RENTFEE: '270000',
      OBJCARNO: '42허5576',
      CARNO: '31허3824',
      ACCPERSONNAME: '',
      DATA_KEY: '197',
      CARNAMEMSTNAME: '뉴 카니발 9P 2900 VGT GLX AT 디젤',
      RENTDATE: '20120105',
      UNIT24: '317000',
      TERMTYPE: 'S',
      NETSALEAMT: '382993',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '전주지점',
      SALEVATAMT: '38299',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '광주지점',
      ACCDATE: '',
      SALEAMT: '421292',
      STARTDATE: ''
    },
    {
      NO: '198',
      CARNAMEMSTNAME2: '소나타 트랜스폼 N20 2000 LPI 일반형 AT LPG',
      RETURNDATE: '20120104',
      ACCNO: '201112313735',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1470101163724',
      CONTRACTNO: 'SS1848111259059',
      RENTFEE: '165000',
      OBJCARNO: '26허5206',
      CARNO: '09허9281',
      ACCPERSONNAME: '김선연',
      DATA_KEY: '198',
      CARNAMEMSTNAME: '소나타 Y20 렌터카 2000 LPI Luxury AT LPG',
      RENTDATE: '20111231',
      UNIT24: '150000',
      TERMTYPE: 'S',
      NETSALEAMT: '209618',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '수원삼정예약소',
      SALEVATAMT: '20962',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업5팀',
      ACCDATE: '20111231',
      SALEAMT: '230580',
      STARTDATE: ''
    },
    {
      NO: '199',
      CARNAMEMSTNAME2: '투싼 ix 4WD 2000 E-VGT X20 Luxury AT 디젤',
      RETURNDATE: '20120105',
      ACCNO: '201112293471',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1100100353828',
      CONTRACTNO: 'SS1476111255265',
      RENTFEE: '199000',
      OBJCARNO: '56허8957',
      CARNO: '32허5364',
      ACCPERSONNAME: '윤원재',
      DATA_KEY: '199',
      CARNAMEMSTNAME: '싼타페 4WD 2200 VGT CLX 고급형 AT 디젤',
      RENTDATE: '20111229',
      UNIT24: '190000',
      TERMTYPE: 'S',
      NETSALEAMT: '383662',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: 'MT기획팀',
      SALEVATAMT: '38366',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '인천지점',
      ACCDATE: '20111229',
      SALEAMT: '422028',
      STARTDATE: ''
    },
    {
      NO: '200',
      CARNAMEMSTNAME2: '그랜져TG 2700 LPI Q270 모범형 AT LPG',
      RETURNDATE: '20120109',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1240120165846',
      RENTFEE: '266000',
      OBJCARNO: '13허6179',
      CARNO: '60허5403',
      ACCPERSONNAME: '',
      DATA_KEY: '200',
      CARNAMEMSTNAME: '그랜져 THE LUXURY 2700 LPI 렌터카 Q270 모범형 PACKⅠ AT LPG',
      RENTDATE: '20120104',
      UNIT24: '266000',
      TERMTYPE: 'S',
      NETSALEAMT: '396000',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '대구지점(동대구역)',
      SALEVATAMT: '39600',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '구미지점',
      ACCDATE: '',
      SALEAMT: '435600',
      STARTDATE: ''
    },
    {
      NO: '201',
      CARNAMEMSTNAME2: '뉴프라이드 1500 VGT LX AT 디젤',
      RETURNDATE: '20120106',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1921111258776',
      RENTFEE: '109000',
      OBJCARNO: '47허6331',
      CARNO: '59허3601',
      ACCPERSONNAME: '',
      DATA_KEY: '201',
      CARNAMEMSTNAME: '아반떼 M16 GDi 1600 GDI LUXURY AT 휘발유',
      RENTDATE: '20111231',
      UNIT24: '99000',
      TERMTYPE: 'S',
      NETSALEAMT: '172062',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '안산사동예약소',
      SALEVATAMT: '17206',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '안양지점',
      ACCDATE: '',
      SALEAMT: '189268',
      STARTDATE: ''
    },
    {
      NO: '202',
      CARNAMEMSTNAME2: '그랜져 THE LUXURY 2700 LPI 렌터카 Q270 모범형 PACKⅠ AT LPG',
      RETURNDATE: '20120103',
      ACCNO: '201201030237',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1420100352967',
      CONTRACTNO: 'SS1938120160059',
      RENTFEE: '488000',
      OBJCARNO: '04허3145',
      CARNO: '26허5116',
      ACCPERSONNAME: '윤원재',
      DATA_KEY: '202',
      CARNAMEMSTNAME: '에쿠스 TRUE PRESTIGE 3800 V6 람다 VS 380 프라임 AT 휘발유',
      RENTDATE: '20120103',
      UNIT24: '266000',
      TERMTYPE: 'S',
      NETSALEAMT: '88000',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '군포산본예약소',
      SALEVATAMT: '8800',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업5팀',
      ACCDATE: '20120103',
      SALEAMT: '96800',
      STARTDATE: ''
    },
    {
      NO: '203',
      CARNAMEMSTNAME2: 'SM5 New Impression 2000 γ - 1.6 LPi 엔진 SE Black AT LPG',
      RETURNDATE: '20120105',
      ACCNO: '201112303721',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1100100150628',
      CONTRACTNO: 'SS1330120162359',
      RENTFEE: '165000',
      OBJCARNO: '44허1248',
      CARNO: '59허9080',
      ACCPERSONNAME: '정해성',
      DATA_KEY: '203',
      CARNAMEMSTNAME: 'NEW SM5 렌터카 2000 CVTC Ⅱ LPLi 고급형 AT LPG',
      RENTDATE: '20120102',
      UNIT24: '150000',
      TERMTYPE: 'S',
      NETSALEAMT: '133527',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '창원지점',
      SALEVATAMT: '13353',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '인천지점',
      ACCDATE: '20111230',
      SALEAMT: '146880',
      STARTDATE: ''
    },
    {
      NO: '204',
      CARNAMEMSTNAME2: '모닝 1000 SOHC L AT 휘발유',
      RETURNDATE: '20120102',
      ACCNO: '201112283450',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1450090742389',
      CONTRACTNO: 'SS1476111255274',
      RENTFEE: '95000',
      OBJCARNO: '26허8352',
      CARNO: '41허2935',
      ACCPERSONNAME: '김대윤',
      DATA_KEY: '204',
      CARNAMEMSTNAME: '모닝 1000 SOHC L AT 휘발유',
      RENTDATE: '20111229',
      UNIT24: '95000',
      TERMTYPE: 'S',
      NETSALEAMT: '120520',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: 'MT기획팀',
      SALEVATAMT: '12052',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: 'SU6팀',
      ACCDATE: '20111228',
      SALEAMT: '132572',
      STARTDATE: ''
    },
    {
      NO: '205',
      CARNAMEMSTNAME2: 'K7 2700 V6 뮤 VG270 럭셔리 AT 휘발유',
      RETURNDATE: '20120109',
      ACCNO: '201201070823',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1456110165630',
      CONTRACTNO: 'SS1818120166347',
      RENTFEE: '292000',
      OBJCARNO: '05허6012',
      CARNO: '28허2928',
      ACCPERSONNAME: '김대윤',
      DATA_KEY: '205',
      CARNAMEMSTNAME: 'K7 렌터카 2700 V6 뮤 VG270 럭셔리 AT LPG',
      RENTDATE: '20120109',
      UNIT24: '292000',
      TERMTYPE: 'S',
      NETSALEAMT: '88000',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '도곡예약소',
      SALEVATAMT: '8800',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업1팀',
      ACCDATE: '20120107',
      SALEAMT: '96800',
      STARTDATE: ''
    },
    {
      NO: '206',
      CARNAMEMSTNAME2: '뉴프라이드(5DR) 1500 VGT LX AT 디젤',
      RETURNDATE: '20120110',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1862120166581',
      RENTFEE: '150000',
      OBJCARNO: '32허2289',
      CARNO: '59허1917',
      ACCPERSONNAME: '',
      DATA_KEY: '206',
      CARNAMEMSTNAME: '소나타 N20 2000 LPI LUX 기본형 AT LPG',
      RENTDATE: '20120107',
      UNIT24: '99000',
      TERMTYPE: 'S',
      NETSALEAMT: '98778',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '대구동구',
      SALEVATAMT: '9878',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '영업2팀',
      ACCDATE: '',
      SALEAMT: '108656',
      STARTDATE: ''
    },
    {
      NO: '207',
      CARNAMEMSTNAME2: '소나타 Y20 2000 I4 세타 Ⅱ Prime Black AT 휘발유',
      RETURNDATE: '20120103',
      ACCNO: '201201020073',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1150101264645',
      CONTRACTNO: 'SS1476120160402',
      RENTFEE: '160000',
      OBJCARNO: '60허6642',
      CARNO: '04허2270',
      ACCPERSONNAME: '윤원재',
      DATA_KEY: '207',
      CARNAMEMSTNAME: '소나타 Y20 2000 VVT Prime 고급형 AT 휘발유',
      RENTDATE: '20120102',
      UNIT24: '160000',
      TERMTYPE: 'S',
      NETSALEAMT: '79091',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: 'MT기획팀',
      SALEVATAMT: '7909',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '도봉지점',
      ACCDATE: '20111226',
      SALEAMT: '87000',
      STARTDATE: ''
    },
    {
      NO: '208',
      CARNAMEMSTNAME2: 'K7 2700 V6 뮤 VG270 럭셔리 AT 휘발유',
      RETURNDATE: '20120109',
      ACCNO: '201201020189',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'SS1020090674049',
      CONTRACTNO: 'SS1878120160432',
      RENTFEE: '266000',
      OBJCARNO: '63허6563',
      CARNO: '62허4961',
      ACCPERSONNAME: '김현철',
      DATA_KEY: '208',
      CARNAMEMSTNAME: '5G 그랜져 2400 GDI HG240 LUXURY AT 휘발유',
      RENTDATE: '20120103',
      UNIT24: '292000',
      TERMTYPE: 'S',
      NETSALEAMT: '475200',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '성수트루예약소',
      SALEVATAMT: '47520',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'M',
      DEPTNAME: '서대문지점',
      ACCDATE: '20120102',
      SALEAMT: '522720',
      STARTDATE: ''
    },
    {
      NO: '209',
      CARNAMEMSTNAME2: '베르나 트랜스폼 1500 VGT PREMIER AT 디젤',
      RETURNDATE: '20120103',
      ACCNO: '201112303638',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1470090742845',
      CONTRACTNO: 'SS1220111259526',
      RENTFEE: '160000',
      OBJCARNO: '32허8097',
      CARNO: '62허4974',
      ACCPERSONNAME: '박수호',
      DATA_KEY: '209',
      CARNAMEMSTNAME: '소나타 Y20 2000 I4 세타 Ⅱ Prime AT 휘발유',
      RENTDATE: '20111230',
      UNIT24: '95000',
      TERMTYPE: 'S',
      NETSALEAMT: '115553',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '속초영업소',
      SALEVATAMT: '11555',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업3팀',
      ACCDATE: '20111230',
      SALEAMT: '127108',
      STARTDATE: ''
    },
    {
      NO: '210',
      CARNAMEMSTNAME2: '토스카 PREMIUM 6 2000 LPGi L6 2.0 AT LPG',
      RETURNDATE: '20120105',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1808120166685',
      RENTFEE: '165000',
      OBJCARNO: '44허1071',
      CARNO: '20허3804',
      ACCPERSONNAME: '',
      DATA_KEY: '210',
      CARNAMEMSTNAME: '소나타 Y20 렌터카 2000 LPI Premier AT LPG',
      RENTDATE: '20120103',
      UNIT24: '150000',
      TERMTYPE: 'S',
      NETSALEAMT: '130491',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '동울산',
      SALEVATAMT: '13049',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '영업2팀',
      ACCDATE: '',
      SALEAMT: '143540',
      STARTDATE: ''
    },
    {
      NO: '211',
      CARNAMEMSTNAME2: '소나타 Y20 렌터카 2000 LPI Luxury AT LPG',
      RETURNDATE: '20120106',
      ACCNO: '201201030357',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1170100455705',
      CONTRACTNO: 'SS1901120161379',
      RENTFEE: '165000',
      OBJCARNO: '12허4372',
      CARNO: '04허5697',
      ACCPERSONNAME: '김대윤',
      DATA_KEY: '211',
      CARNAMEMSTNAME: 'K5렌터카 2000 LPI 디럭스 AT LPG',
      RENTDATE: '20120104',
      UNIT24: '165000',
      TERMTYPE: 'S',
      NETSALEAMT: '119455',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '경기광주예약소',
      SALEVATAMT: '11945',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '청주지점',
      ACCDATE: '20120103',
      SALEAMT: '131400',
      STARTDATE: ''
    },
    {
      NO: '212',
      CARNAMEMSTNAME2: '그랜져TG 2400 DOHC Q240 기본형 AT 휘발유',
      RETURNDATE: '20120105',
      ACCNO: '201201040413',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1450091248684',
      CONTRACTNO: 'SS1818120161603',
      RENTFEE: '307000',
      OBJCARNO: '05허1910',
      CARNO: '62허4705',
      ACCPERSONNAME: '윤원재',
      DATA_KEY: '212',
      CARNAMEMSTNAME: '오피러스 PREMIUM 2700 V6 뮤 GH270 디럭스 AT 휘발유',
      RENTDATE: '20120104',
      UNIT24: '213000',
      TERMTYPE: 'S',
      NETSALEAMT: '91709',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '도곡예약소',
      SALEVATAMT: '9171',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업2팀',
      ACCDATE: '20120104',
      SALEAMT: '100880',
      STARTDATE: ''
    },
    {
      NO: '213',
      CARNAMEMSTNAME2: '봉고Ⅲ 1톤 4X4 더블캡 2900 CRDI 장축 GX 고급형 MT 디젤',
      RETURNDATE: '20120110',
      ACCNO: '201201091013',
      REPAIRNO: '',
      DISCOUNTRATE: '50',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1937120166935',
      RENTFEE: '199000',
      OBJCARNO: '86우8937',
      CARNO: '41허2873',
      ACCPERSONNAME: '윤원재',
      DATA_KEY: '213',
      CARNAMEMSTNAME: '뉴싼타페 2000 VGT CLX 고급형 AT 디젤',
      RENTDATE: '20120109',
      UNIT24: '0',
      TERMTYPE: 'S',
      NETSALEAMT: '85500',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '성수한국타이어예약소',
      SALEVATAMT: '8550',
      REPAIRPERSONNAME: '',
      PROMOCODE: '리스대차',
      TERMTYPE2: '',
      DEPTNAME: 'AJ캐피탈',
      ACCDATE: '20120109',
      SALEAMT: '94050',
      STARTDATE: ''
    },
    {
      NO: '214',
      CARNAMEMSTNAME2: '소나타 Y20 렌터카 2000 LPI Deluxe AT LPG',
      RETURNDATE: '20120110',
      ACCNO: '201201040533',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1456110376633',
      CONTRACTNO: 'SS1170120165928',
      RENTFEE: '165000',
      OBJCARNO: '62허4476',
      CARNO: '12허4376',
      ACCPERSONNAME: '정해성',
      DATA_KEY: '214',
      CARNAMEMSTNAME: '소나타 Y20 렌터카 2000 LPI Deluxe AT LPG',
      RENTDATE: '20120105',
      UNIT24: '165000',
      TERMTYPE: 'S',
      NETSALEAMT: '250636',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '청주지점',
      SALEVATAMT: '25064',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업1팀',
      ACCDATE: '20120104',
      SALEAMT: '275700',
      STARTDATE: ''
    },
    {
      NO: '215',
      CARNAMEMSTNAME2: '소나타 트랜스폼 N20 2000 LPI 일반형 AT LPG',
      RETURNDATE: '20120110',
      ACCNO: '201201090955',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1470101163748',
      CONTRACTNO: 'SS1816120166827',
      RENTFEE: '165000',
      OBJCARNO: '26허5016',
      CARNO: '52허7288',
      ACCPERSONNAME: '어성환',
      DATA_KEY: '215',
      CARNAMEMSTNAME: '소나타 Y20 렌터카 2000 LPI Luxury AT LPG',
      RENTDATE: '20120107',
      UNIT24: '150000',
      TERMTYPE: 'S',
      NETSALEAMT: '165109',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '광주진왕',
      SALEVATAMT: '16511',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업1팀',
      ACCDATE: '20120103',
      SALEAMT: '181620',
      STARTDATE: ''
    },
    {
      NO: '216',
      CARNAMEMSTNAME2: '뉴마티즈 800 SOHC VAN AT 휘발유',
      RETURNDATE: '20120105',
      ACCNO: '201201030271',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1450090742388',
      CONTRACTNO: 'SS1260120167119',
      RENTFEE: '165000',
      OBJCARNO: '41허5486',
      CARNO: '42허5436',
      ACCPERSONNAME: '어성환',
      DATA_KEY: '216',
      CARNAMEMSTNAME: '뉴카렌스 2000 LPI GX 고급형 AT LPG',
      RENTDATE: '20120103',
      UNIT24: '95000',
      TERMTYPE: 'S',
      NETSALEAMT: '71102',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '광주지점',
      SALEVATAMT: '7110',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업1팀',
      ACCDATE: '20120103',
      SALEAMT: '78212',
      STARTDATE: ''
    },
    {
      NO: '217',
      CARNAMEMSTNAME2: '뉴 카니발 리무진 9P 2900 VGT GLX AT 디젤',
      RETURNDATE: '20120106',
      ACCNO: '201201040421',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1420091046726',
      CONTRACTNO: 'SS1945120161687',
      RENTFEE: '270000',
      OBJCARNO: '56허8202',
      CARNO: '52허7412',
      ACCPERSONNAME: '김병준',
      DATA_KEY: '217',
      CARNAMEMSTNAME: '뉴 카니발R 9P 2200 E-VGT GX AT 디젤',
      RENTDATE: '20120104',
      UNIT24: '317000',
      TERMTYPE: 'S',
      NETSALEAMT: '186647',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '일산탄현예약소',
      SALEVATAMT: '18665',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업2팀',
      ACCDATE: '20120103',
      SALEAMT: '205312',
      STARTDATE: ''
    },
    {
      NO: '218',
      CARNAMEMSTNAME2: '투싼 ix 4WD 2000 E-VGT X20 Luxury AT 디젤',
      RETURNDATE: '20120105',
      ACCNO: '201201020111',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1470100558087',
      CONTRACTNO: 'SS1476120160404',
      RENTFEE: '190000',
      OBJCARNO: '05허4700',
      CARNO: '20허1233',
      ACCPERSONNAME: '윤원재',
      DATA_KEY: '218',
      CARNAMEMSTNAME: '투싼 2WD 2000 VGT JX 기본형 AT 디젤',
      RENTDATE: '20120102',
      UNIT24: '190000',
      TERMTYPE: 'S',
      NETSALEAMT: '148233',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: 'MT기획팀',
      SALEVATAMT: '14823',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업1팀',
      ACCDATE: '20120102',
      SALEAMT: '163056',
      STARTDATE: ''
    },
    {
      NO: '219',
      CARNAMEMSTNAME2: '제네시스 3800 람다 BH380 ROYAL AT 휘발유',
      RETURNDATE: '20120104',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1476120160411',
      RENTFEE: '488000',
      OBJCARNO: '03허9019',
      CARNO: '32허8846',
      ACCPERSONNAME: '',
      DATA_KEY: '219',
      CARNAMEMSTNAME: '에쿠스 TRUE PRESTIGE 3800 V6 람다 VS 380 럭셔리 AT 휘발유',
      RENTDATE: '20120102',
      UNIT24: '447000',
      TERMTYPE: 'S',
      NETSALEAMT: '323324',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: 'MT기획팀',
      SALEVATAMT: '32332',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '안양지점',
      ACCDATE: '',
      SALEAMT: '355656',
      STARTDATE: ''
    },
    {
      NO: '220',
      CARNAMEMSTNAME2: '소나타 트랜스폼 N20 2000 LPI 일반형 AT LPG',
      RETURNDATE: '20120104',
      ACCNO: '201110070740',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1210110703592',
      CONTRACTNO: 'SS1210111260552',
      RENTFEE: '165000',
      OBJCARNO: '55허2213',
      CARNO: '08허1086',
      ACCPERSONNAME: '이준엽',
      DATA_KEY: '220',
      CARNAMEMSTNAME: '소나타 Y20 렌터카 2000 LPI Luxury AT LPG',
      RENTDATE: '20111229',
      UNIT24: '150000',
      TERMTYPE: 'S',
      NETSALEAMT: '276945',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '구미지점',
      SALEVATAMT: '27695',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '구미지점',
      ACCDATE: '20111007',
      SALEAMT: '304640',
      STARTDATE: ''
    },
    {
      NO: '221',
      CARNAMEMSTNAME2: '소나타 트랜스폼 N20 2000 LPI 일반형 AT LPG',
      RETURNDATE: '20120110',
      ACCNO: '201201050545',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1130110470056',
      CONTRACTNO: 'SS1913120161852',
      RENTFEE: '165000',
      OBJCARNO: '62허4533',
      CARNO: '59허3405',
      ACCPERSONNAME: '김현철',
      DATA_KEY: '221',
      CARNAMEMSTNAME: 'K5렌터카 2000 LPI 디럭스 AT LPG',
      RENTDATE: '20120105',
      UNIT24: '150000',
      TERMTYPE: 'S',
      NETSALEAMT: '253113',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '성동성수예약소',
      SALEVATAMT: '25311',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '수원지점',
      ACCDATE: '20120105',
      SALEAMT: '278424',
      STARTDATE: ''
    },
    {
      NO: '222',
      CARNAMEMSTNAME2: '그랜드 스타렉스 12P WAGON 2500 VGT CVX Deluxe AT 디젤',
      RETURNDATE: '20120105',
      ACCNO: '201112273245',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1180100658519',
      CONTRACTNO: 'SS1180111254089',
      RENTFEE: '317000',
      OBJCARNO: '72허4259',
      CARNO: '72허6329',
      ACCPERSONNAME: '정해성',
      DATA_KEY: '222',
      CARNAMEMSTNAME: '카니발 그랜드 11P 2600 LPI GX 그랜드팩 AT LPG',
      RENTDATE: '20111228',
      UNIT24: '219000',
      TERMTYPE: 'S',
      NETSALEAMT: '521018',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '천안아산지점',
      SALEVATAMT: '52102',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '천안아산지점',
      ACCDATE: '20111227',
      SALEAMT: '573120',
      STARTDATE: ''
    },
    {
      NO: '223',
      CARNAMEMSTNAME2: '그랜드 카니발 11P 2900 VGT GX AT 디젤',
      RETURNDATE: '20120109',
      ACCNO: '201201030327',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1450090337668',
      CONTRACTNO: 'SS1907120167230',
      RENTFEE: '219000',
      OBJCARNO: '72허4230',
      CARNO: '72허9326',
      ACCPERSONNAME: '정해성',
      DATA_KEY: '223',
      CARNAMEMSTNAME: '그랜드 스타렉스 12P WAGON 2500 VGT CVX Premium AT 디젤',
      RENTDATE: '20120109',
      UNIT24: '317000',
      TERMTYPE: 'S',
      NETSALEAMT: '0',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '당진원당예약소',
      SALEVATAMT: '0',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업5팀',
      ACCDATE: '20120103',
      SALEAMT: '0',
      STARTDATE: ''
    },
    {
      NO: '224',
      CARNAMEMSTNAME2: 'SM5 New Impression 렌터카 2000 LPLi 렌터카 Premium Black AT LPG',
      RETURNDATE: '20120102',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1140111255757',
      RENTFEE: '165000',
      OBJCARNO: '32허8133',
      CARNO: '56허9061',
      ACCPERSONNAME: '',
      DATA_KEY: '224',
      CARNAMEMSTNAME: '소나타 Y20 렌터카 2000 LPI Premier AT LPG',
      RENTDATE: '20111229',
      UNIT24: '150000',
      TERMTYPE: 'S',
      NETSALEAMT: '182735',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '안산지점',
      SALEVATAMT: '18273',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '안산지점',
      ACCDATE: '',
      SALEAMT: '201008',
      STARTDATE: ''
    },
    {
      NO: '225',
      CARNAMEMSTNAME2: '소나타 N20 2000 LPI 일반 고급형 AT LPG',
      RETURNDATE: '20120110',
      ACCNO: '201201010041',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1460080526510',
      CONTRACTNO: 'SS1812120159780',
      RENTFEE: '165000',
      OBJCARNO: '18허3797',
      CARNO: '56허9450',
      ACCPERSONNAME: '정해성',
      DATA_KEY: '225',
      CARNAMEMSTNAME: '소나타 Y20 렌터카 2000 LPI Luxury AT LPG',
      RENTDATE: '20120101',
      UNIT24: '150000',
      TERMTYPE: 'S',
      NETSALEAMT: '356073',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '전주코리아',
      SALEVATAMT: '35607',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업3팀',
      ACCDATE: '20120101',
      SALEAMT: '391680',
      STARTDATE: ''
    },
    {
      NO: '226',
      CARNAMEMSTNAME2: '라세티 프리미어 1600 DOHC SE 고급형 AT 휘발유',
      RETURNDATE: '20120102',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1340111253150',
      RENTFEE: '99000',
      OBJCARNO: '28허4020',
      CARNO: '56허8063',
      ACCPERSONNAME: '',
      DATA_KEY: '226',
      CARNAMEMSTNAME: '뉴아반떼 1600 VVT E16 DELUXE AT 휘발유',
      RENTDATE: '20111228',
      UNIT24: '99000',
      TERMTYPE: 'S',
      NETSALEAMT: '142280',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '거제지점',
      SALEVATAMT: '14228',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '거제지점',
      ACCDATE: '',
      SALEAMT: '156508',
      STARTDATE: ''
    },
    {
      NO: '227',
      CARNAMEMSTNAME2: '제네시스 3300 람다 BH330 LUXURY PRIME PACK AT 휘발유',
      RETURNDATE: '20120107',
      ACCNO: '201201010018',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1420091148210',
      CONTRACTNO: 'SS1921120161810',
      RENTFEE: '292000',
      OBJCARNO: '04허2256',
      CARNO: '52허5724',
      ACCPERSONNAME: '김선연',
      DATA_KEY: '227',
      CARNAMEMSTNAME: '5G 그랜져 3000 LPI HG300 렌터카 Prime AT LPG',
      RENTDATE: '20120101',
      UNIT24: '399000',
      TERMTYPE: 'S',
      NETSALEAMT: '501033',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '안산사동예약소',
      SALEVATAMT: '50103',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업3팀',
      ACCDATE: '20120101',
      SALEAMT: '551136',
      STARTDATE: ''
    },
    {
      NO: '228',
      CARNAMEMSTNAME2: '봉고Ⅲ 1톤 4X4 더블캡 2900 CRDI 장축 GX 고급형 MT 디젤',
      RETURNDATE: '20120110',
      ACCNO: '201201030262',
      REPAIRNO: '',
      DISCOUNTRATE: '50',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1476120162117',
      RENTFEE: '190000',
      OBJCARNO: '81두5710',
      CARNO: '20허1179',
      ACCPERSONNAME: '정해성',
      DATA_KEY: '228',
      CARNAMEMSTNAME: '투싼 2WD 2000 VGT JX 기본형 AT 디젤',
      RENTDATE: '20120103',
      UNIT24: '0',
      TERMTYPE: 'S',
      NETSALEAMT: '445273',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: 'MT기획팀',
      SALEVATAMT: '44527',
      REPAIRPERSONNAME: '',
      PROMOCODE: '리스대차',
      TERMTYPE2: '',
      DEPTNAME: 'AJ캐피탈',
      ACCDATE: '20120103',
      SALEAMT: '489800',
      STARTDATE: ''
    },
    {
      NO: '229',
      CARNAMEMSTNAME2: 'NEW 다마스 VAN 800 LPG 2P 판넬VAN DLX MT LPG',
      RETURNDATE: '20120105',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '50',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1476120162142',
      RENTFEE: '150000',
      OBJCARNO: '80무6607',
      CARNO: '05허1952',
      ACCPERSONNAME: '',
      DATA_KEY: '229',
      CARNAMEMSTNAME: '로체 이노베이션 렌트카 2000 LPI LX20 기본형 AT LPG',
      RENTDATE: '20120104',
      UNIT24: '0',
      TERMTYPE: 'S',
      NETSALEAMT: '118909',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: 'MT기획팀',
      SALEVATAMT: '11891',
      REPAIRPERSONNAME: '',
      PROMOCODE: '리스대차',
      TERMTYPE2: '',
      DEPTNAME: 'AJ캐피탈',
      ACCDATE: '',
      SALEAMT: '130800',
      STARTDATE: ''
    },
    {
      NO: '230',
      CARNAMEMSTNAME2: '소나타 Y20 렌터카 2000 LPI Deluxe AT LPG',
      RETURNDATE: '20120102',
      ACCNO: '201112273176',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1130111108626',
      CONTRACTNO: 'SS1848111255843',
      RENTFEE: '165000',
      OBJCARNO: '39허7364',
      CARNO: '59허3441',
      ACCPERSONNAME: '김선연',
      DATA_KEY: '230',
      CARNAMEMSTNAME: 'K5렌터카 2000 LPI 디럭스 AT LPG',
      RENTDATE: '20111228',
      UNIT24: '165000',
      TERMTYPE: 'S',
      NETSALEAMT: '255818',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '수원삼정예약소',
      SALEVATAMT: '25582',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '수원지점',
      ACCDATE: '20111223',
      SALEAMT: '281400',
      STARTDATE: ''
    },
    {
      NO: '231',
      CARNAMEMSTNAME2: '베르나 트랜스폼 1500 VGT PREMIER AT 디젤',
      RETURNDATE: '20120102',
      ACCNO: '201112273247',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1170101062793',
      CONTRACTNO: 'SS1260111255869',
      RENTFEE: '150000',
      OBJCARNO: '12허4461',
      CARNO: '42허5404',
      ACCPERSONNAME: '이준엽',
      DATA_KEY: '231',
      CARNAMEMSTNAME: '소나타 트랜스폼 N20 2000 LPI Luxury AT LPG',
      RENTDATE: '20111227',
      UNIT24: '95000',
      TERMTYPE: 'S',
      NETSALEAMT: '162593',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '광주지점',
      SALEVATAMT: '16259',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '청주지점',
      ACCDATE: '20111227',
      SALEAMT: '178852',
      STARTDATE: ''
    },
    {
      NO: '232',
      CARNAMEMSTNAME2: '소나타 Y20 렌터카 2000 LPI Luxury AT LPG',
      RETURNDATE: '20120107',
      ACCNO: '201201060745',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1453110265692',
      CONTRACTNO: 'SS1822120164043',
      RENTFEE: '165000',
      OBJCARNO: '05허6895',
      CARNO: '28허4040',
      ACCPERSONNAME: '이준엽',
      DATA_KEY: '232',
      CARNAMEMSTNAME: '소나타 Y20 렌터카 2000 LPI Luxury AT LPG',
      RENTDATE: '20120105',
      UNIT24: '165000',
      TERMTYPE: 'S',
      NETSALEAMT: '106327',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '대구하나',
      SALEVATAMT: '10633',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업2팀',
      ACCDATE: '20120105',
      SALEAMT: '116960',
      STARTDATE: ''
    },
    {
      NO: '233',
      CARNAMEMSTNAME2: '그랜져 THE LUXURY 2700 LPI 렌터카 Q270 모범형 PACKⅠ AT LPG',
      RETURNDATE: '20120105',
      ACCNO: '201201030237',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1420100352967',
      CONTRACTNO: 'SS1938120160592',
      RENTFEE: '292000',
      OBJCARNO: '04허3145',
      CARNO: '52허5913',
      ACCPERSONNAME: '윤원재',
      DATA_KEY: '233',
      CARNAMEMSTNAME: '5G 그랜져 3000 LPI HG300 렌터카 Prime AT LPG',
      RENTDATE: '20120103',
      UNIT24: '266000',
      TERMTYPE: 'S',
      NETSALEAMT: '184360',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '군포산본예약소',
      SALEVATAMT: '18436',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업5팀',
      ACCDATE: '20120103',
      SALEAMT: '202796',
      STARTDATE: ''
    },
    {
      NO: '234',
      CARNAMEMSTNAME2: 'K5렌터카 2000 LPI 디럭스 AT LPG',
      RETURNDATE: '20120103',
      ACCNO: '201112293567',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1360110164856',
      CONTRACTNO: 'SS1360111254847',
      RENTFEE: '165000',
      OBJCARNO: '28허3026',
      CARNO: '59허9085',
      ACCPERSONNAME: '정해성',
      DATA_KEY: '234',
      CARNAMEMSTNAME: 'NEW SM5 렌터카 2000 CVTC Ⅱ LPLi 고급형 AT LPG',
      RENTDATE: '20111229',
      UNIT24: '165000',
      TERMTYPE: 'S',
      NETSALEAMT: '245455',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '진주사천지점',
      SALEVATAMT: '24545',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '진주사천지점',
      ACCDATE: '20111223',
      SALEAMT: '270000',
      STARTDATE: ''
    },
    {
      NO: '235',
      CARNAMEMSTNAME2: '아반떼 M16 1600 LPI 렌터카 DELUXE AT LPG',
      RETURNDATE: '20120108',
      ACCNO: '201112273312',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1230110704837',
      CONTRACTNO: 'SS1250111254183',
      RENTFEE: '109000',
      OBJCARNO: '45허4289',
      CARNO: '20허1167',
      ACCPERSONNAME: '박수호',
      DATA_KEY: '235',
      CARNAMEMSTNAME: 'New SM3 1600 CVTC RE AT 휘발유',
      RENTDATE: '20111228',
      UNIT24: '109000',
      TERMTYPE: 'S',
      NETSALEAMT: '291200',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '대전지점',
      SALEVATAMT: '29120',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '평택지점',
      ACCDATE: '20111227',
      SALEAMT: '320320',
      STARTDATE: ''
    },
    {
      NO: '236',
      CARNAMEMSTNAME2: '그랜져 THE LUXURY 2700 LPI 렌터카 Q270 모범형 PACKⅠ AT LPG',
      RETURNDATE: '20120103',
      ACCNO: '201112273186',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1140110602751',
      CONTRACTNO: 'SS1818111252180',
      RENTFEE: '307000',
      OBJCARNO: '59허9251',
      CARNO: '63허6622',
      ACCPERSONNAME: '김병준',
      DATA_KEY: '236',
      CARNAMEMSTNAME: '오피러스 PREMIUM 렌터카 2700 V6 뮤 GH270 럭셔리 AT LPG',
      RENTDATE: '20111227',
      UNIT24: '266000',
      TERMTYPE: 'S',
      NETSALEAMT: '509520',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '도곡예약소',
      SALEVATAMT: '50952',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '안산지점',
      ACCDATE: '20111227',
      SALEAMT: '560472',
      STARTDATE: ''
    },
    {
      NO: '237',
      CARNAMEMSTNAME2: '카니발R 리무진 9P 2200 E-VGT President AT 디젤',
      RETURNDATE: '20120110',
      ACCNO: '201112263135',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1080111007721',
      CONTRACTNO: 'SS1974111252302',
      RENTFEE: '270000',
      OBJCARNO: '52허3869',
      CARNO: '63허2211',
      ACCPERSONNAME: '김대윤',
      DATA_KEY: '237',
      CARNAMEMSTNAME: '뉴 카니발R 9P 2200 E-VGT GX AT 디젤',
      RENTDATE: '20111227',
      UNIT24: '317000',
      TERMTYPE: 'S',
      NETSALEAMT: '997818',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '성남단대역예약소',
      SALEVATAMT: '99782',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '강남지점',
      ACCDATE: '20111226',
      SALEAMT: '1097600',
      STARTDATE: ''
    },
    {
      NO: '238',
      CARNAMEMSTNAME2: '에쿠스 TRUE PRESTIGE 3800 GDI VS 380 프라임 AT 휘발유',
      RETURNDATE: '20120105',
      ACCNO: '201201020062',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'SS1020111225513',
      CONTRACTNO: 'SS1440120160702',
      RENTFEE: '488000',
      OBJCARNO: '06허4583',
      CARNO: '13허2221',
      ACCPERSONNAME: '김대윤',
      DATA_KEY: '238',
      CARNAMEMSTNAME: '에쿠스 TRUE PRESTIGE 3800 V6 람다 VS 380 프라임 VIP PACK AT 휘발유',
      RENTDATE: '20120103',
      UNIT24: '488000',
      TERMTYPE: 'S',
      NETSALEAMT: '295273',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '동대문지점',
      SALEVATAMT: '29527',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'M',
      DEPTNAME: '서대문지점',
      ACCDATE: '20111231',
      SALEAMT: '324800',
      STARTDATE: ''
    },
    {
      NO: '239',
      CARNAMEMSTNAME2: '싼타페 2WD 2000 VGT MLX 고급형 AT 디젤',
      RETURNDATE: '20120104',
      ACCNO: '201201030284',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1060090640967',
      CONTRACTNO: 'SS1060120160396',
      RENTFEE: '199000',
      OBJCARNO: '32허7286',
      CARNO: '04허2184',
      ACCPERSONNAME: '김현철',
      DATA_KEY: '239',
      CARNAMEMSTNAME: '쏘렌토 R 4WD 2200 E-VGT LX 고급형 AT 디젤',
      RENTDATE: '20120103',
      UNIT24: '199000',
      TERMTYPE: 'S',
      NETSALEAMT: '93273',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '건대지점',
      SALEVATAMT: '9327',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '건대지점',
      ACCDATE: '20111230',
      SALEAMT: '102600',
      STARTDATE: ''
    },
    {
      NO: '240',
      CARNAMEMSTNAME2: '아반떼 M16 GDi 1600 GDI LUXURY AT 휘발유',
      RETURNDATE: '20120105',
      ACCNO: '201112303589',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'SS1440111071806',
      CONTRACTNO: 'SS1921120160568',
      RENTFEE: '109000',
      OBJCARNO: '39허3567',
      CARNO: '52허5663',
      ACCPERSONNAME: '김대윤',
      DATA_KEY: '240',
      CARNAMEMSTNAME: '아반떼 M16 1600 LPI 렌터카 LUXURY AT LPG',
      RENTDATE: '20120102',
      UNIT24: '109000',
      TERMTYPE: 'S',
      NETSALEAMT: '88964',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '안산사동예약소',
      SALEVATAMT: '8896',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'M',
      DEPTNAME: '동대문지점',
      ACCDATE: '20111230',
      SALEAMT: '97860',
      STARTDATE: ''
    },
    {
      NO: '241',
      CARNAMEMSTNAME2: '카니발R 리무진 9P 2200 E-VGT GLX AT 디젤',
      RETURNDATE: '20120109',
      ACCNO: '201201060797',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1420101264333',
      CONTRACTNO: 'SS1844120174168',
      RENTFEE: '150000',
      OBJCARNO: '28허2932',
      CARNO: '47허6268',
      ACCPERSONNAME: '김대윤',
      DATA_KEY: '241',
      CARNAMEMSTNAME: '소나타 N20 2000 LPI DLX 기본형 AT LPG',
      RENTDATE: '20120106',
      UNIT24: '317000',
      TERMTYPE: 'S',
      NETSALEAMT: '133487',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '주안예약소',
      SALEVATAMT: '13349',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업4팀',
      ACCDATE: '20120106',
      SALEAMT: '146836',
      STARTDATE: ''
    },
    {
      NO: '242',
      CARNAMEMSTNAME2: '소나타 Y20 2000 VVT Prime 고급형 AT 휘발유',
      RETURNDATE: '20120105',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1250120161896',
      RENTFEE: '142000',
      OBJCARNO: '56허9202',
      CARNO: '10허6045',
      ACCPERSONNAME: '',
      DATA_KEY: '242',
      CARNAMEMSTNAME: '소나타 트랜스폼 N20 2000 VVT Premier 최고급형 Safety Pack1 AT 휘발유',
      RENTDATE: '20120104',
      UNIT24: '160000',
      TERMTYPE: 'S',
      NETSALEAMT: '51600',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '대전지점',
      SALEVATAMT: '5160',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '영업1팀',
      ACCDATE: '',
      SALEAMT: '56760',
      STARTDATE: ''
    },
    {
      NO: '243',
      CARNAMEMSTNAME2: '토스카 PREMIUM 6 2000 LPGi L6 2.0 AT LPG',
      RETURNDATE: '20120105',
      ACCNO: '201201030242',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1470100557869',
      CONTRACTNO: 'SS1355120160484',
      RENTFEE: '150000',
      OBJCARNO: '56허9834',
      CARNO: '47허5324',
      ACCPERSONNAME: '박수호',
      DATA_KEY: '243',
      CARNAMEMSTNAME: '로체 이노베이션 렌트카 2000 LPI LX20 기본형 스페셜 AT LPG',
      RENTDATE: '20120103',
      UNIT24: '150000',
      TERMTYPE: 'S',
      NETSALEAMT: '103607',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '부산지점',
      SALEVATAMT: '10361',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업2팀',
      ACCDATE: '20120103',
      SALEAMT: '113968',
      STARTDATE: ''
    },
    {
      NO: '244',
      CARNAMEMSTNAME2: '5G 그랜져 2400 GDI HG240 LUXURY AT 휘발유',
      RETURNDATE: '20120103',
      ACCNO: '201112283387',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'SS1100110934338',
      CONTRACTNO: 'SS1476111253842',
      RENTFEE: '399000',
      OBJCARNO: '06허4503',
      CARNO: '41허2396',
      ACCPERSONNAME: '박수호',
      DATA_KEY: '244',
      CARNAMEMSTNAME: '제네시스 3300 람다 BH330 LUXURY AT 휘발유',
      RENTDATE: '20111228',
      UNIT24: '266000',
      TERMTYPE: 'S',
      NETSALEAMT: '457462',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: 'MT기획팀',
      SALEVATAMT: '45746',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'M',
      DEPTNAME: '인천지점',
      ACCDATE: '20111228',
      SALEAMT: '503208',
      STARTDATE: ''
    },
    {
      NO: '245',
      CARNAMEMSTNAME2: '소나타 Y20 2000 I4 세타 Ⅱ Premier AT 휘발유',
      RETURNDATE: '20120105',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1808111254707',
      RENTFEE: '165000',
      OBJCARNO: '20허4142',
      CARNO: '13허2315',
      ACCPERSONNAME: '',
      DATA_KEY: '245',
      CARNAMEMSTNAME: '소나타 Y20 렌터카 2000 LPI Luxury AT LPG',
      RENTDATE: '20111229',
      UNIT24: '160000',
      TERMTYPE: 'S',
      NETSALEAMT: '310302',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '동울산',
      SALEVATAMT: '31030',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '울산지점',
      ACCDATE: '',
      SALEAMT: '341332',
      STARTDATE: ''
    },
    {
      NO: '246',
      CARNAMEMSTNAME2: '쎄라토 1600 CVVT LX AT 휘발유/LPG',
      RETURNDATE: '20120104',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1476111253856',
      RENTFEE: '99000',
      OBJCARNO: '26허8245',
      CARNO: '41허2380',
      ACCPERSONNAME: '',
      DATA_KEY: '246',
      CARNAMEMSTNAME: '뉴아반떼 1600 VVT E16 DELUXE AT 휘발유/LPG',
      RENTDATE: '20111228',
      UNIT24: '0',
      TERMTYPE: 'S',
      NETSALEAMT: '188455',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: 'MT기획팀',
      SALEVATAMT: '18845',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '영업1팀',
      ACCDATE: '',
      SALEAMT: '207300',
      STARTDATE: ''
    },
    {
      NO: '247',
      CARNAMEMSTNAME2: 'K5렌터카 2000 LPI 디럭스 AT LPG',
      RETURNDATE: '20120102',
      ACCNO: '201112283353',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'SS1170111123658',
      CONTRACTNO: 'SS1869111255122',
      RENTFEE: '266000',
      OBJCARNO: '62허5498',
      CARNO: '52허4214',
      ACCPERSONNAME: '김선연',
      DATA_KEY: '247',
      CARNAMEMSTNAME: '5G 그랜져 2400 GDI HG240 LUXURY AT 휘발유',
      RENTDATE: '20111229',
      UNIT24: '165000',
      TERMTYPE: 'S',
      NETSALEAMT: '185338',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '안산상록예약소',
      SALEVATAMT: '18534',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'M',
      DEPTNAME: '청주지점',
      ACCDATE: '20111228',
      SALEAMT: '203872',
      STARTDATE: ''
    },
    {
      NO: '248',
      CARNAMEMSTNAME2: 'K7 렌터카 2700 V6 뮤 VG270 럭셔리 AT LPG',
      RETURNDATE: '20120110',
      ACCNO: '201107294036',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1461100760919',
      CONTRACTNO: 'SS1914120166338',
      RENTFEE: '292000',
      OBJCARNO: '63허1656',
      CARNO: '52허5901',
      ACCPERSONNAME: '김선연',
      DATA_KEY: '248',
      CARNAMEMSTNAME: '5G 그랜져 3000 LPI HG300 렌터카 Prime AT LPG',
      RENTDATE: '20120109',
      UNIT24: '292000',
      TERMTYPE: 'S',
      NETSALEAMT: '153309',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '경기오포예약소',
      SALEVATAMT: '15331',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업3팀',
      ACCDATE: '20110727',
      SALEAMT: '168640',
      STARTDATE: ''
    },
    {
      NO: '249',
      CARNAMEMSTNAME2: '그랜져TG 2700 DOHC Q270 DELUXE AT 휘발유',
      RETURNDATE: '20120106',
      ACCNO: '201112222425',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1450090641273',
      CONTRACTNO: 'SS1120111260036',
      RENTFEE: '266000',
      OBJCARNO: '32허7325',
      CARNO: '18허4136',
      ACCPERSONNAME: '김현철',
      DATA_KEY: '249',
      CARNAMEMSTNAME: '그랜져TG 2700 DOHC Q270 PREMIER AT 휘발유',
      RENTDATE: '20111227',
      UNIT24: '266000',
      TERMTYPE: 'S',
      NETSALEAMT: '704000',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '구로지점',
      SALEVATAMT: '70400',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업5팀',
      ACCDATE: '20111222',
      SALEAMT: '774400',
      STARTDATE: ''
    },
    {
      NO: '250',
      CARNAMEMSTNAME2: '소나타 트랜스폼 N20 2000 LPI 일반형 AT LPG',
      RETURNDATE: '20120110',
      ACCNO: '201201050570',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1456110906899',
      CONTRACTNO: 'SS1812120166929',
      RENTFEE: '266000',
      OBJCARNO: '45허4505',
      CARNO: '31허3814',
      ACCPERSONNAME: '박수호',
      DATA_KEY: '250',
      CARNAMEMSTNAME: '그랜져TG 2700 LPI Q270 모범형 PACK 1 AT LPG',
      RENTDATE: '20120105',
      UNIT24: '150000',
      TERMTYPE: 'S',
      NETSALEAMT: '222545',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '전주코리아',
      SALEVATAMT: '22255',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업1팀',
      ACCDATE: '20120105',
      SALEAMT: '244800',
      STARTDATE: ''
    },
    {
      NO: '251',
      CARNAMEMSTNAME2: '소나타 Y20 2000 I4 세타 Ⅱ Premier AT 휘발유',
      RETURNDATE: '20120106',
      ACCNO: '201201020123',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1455110165677',
      CONTRACTNO: 'SS1476120162763',
      RENTFEE: '142000',
      OBJCARNO: '05허6891',
      CARNO: '41허4575',
      ACCPERSONNAME: '이준엽',
      DATA_KEY: '251',
      CARNAMEMSTNAME: '소나타 트랜스폼 N20 2000 VVT Luxury AT 휘발유',
      RENTDATE: '20120103',
      UNIT24: '160000',
      TERMTYPE: 'S',
      NETSALEAMT: '140025',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: 'MT기획팀',
      SALEVATAMT: '14003',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업4팀',
      ACCDATE: '20120102',
      SALEAMT: '154028',
      STARTDATE: ''
    },
    {
      NO: '252',
      CARNAMEMSTNAME2: '뉴스포티지 2000 VGT TLX 고급형 AT 디젤',
      RETURNDATE: '20120103',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1972120167664',
      RENTFEE: '190000',
      OBJCARNO: '17허8649',
      CARNO: '68허3364',
      ACCPERSONNAME: '',
      DATA_KEY: '252',
      CARNAMEMSTNAME: '스포티지R 4WD 2000 E-VGT LX AT 디젤',
      RENTDATE: '20120102',
      UNIT24: '190000',
      TERMTYPE: 'S',
      NETSALEAMT: '60400',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '(폐쇄)순천봉화예약소',
      SALEVATAMT: '6040',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '순천여수지점',
      ACCDATE: '',
      SALEAMT: '66440',
      STARTDATE: ''
    },
    {
      NO: '253',
      CARNAMEMSTNAME2: '5G 그랜져 3000 LPI HG300 렌터카 Executive AT LPG',
      RETURNDATE: '20120106',
      ACCNO: '201201040475',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1456110603046',
      CONTRACTNO: 'SS1822120163112',
      RENTFEE: '292000',
      OBJCARNO: '59허9958',
      CARNO: '28허2404',
      ACCPERSONNAME: '어성환',
      DATA_KEY: '253',
      CARNAMEMSTNAME: 'K7 렌터카 2700 V6 뮤 VG270 럭셔리 AT LPG',
      RENTDATE: '20120105',
      UNIT24: '292000',
      TERMTYPE: 'S',
      NETSALEAMT: '157491',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '대구하나',
      SALEVATAMT: '15749',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업2팀',
      ACCDATE: '20120104',
      SALEAMT: '173240',
      STARTDATE: ''
    },
    {
      NO: '254',
      CARNAMEMSTNAME2: '쏘울 1600 VGT U 고급형 AT 디젤',
      RETURNDATE: '20120110',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1913120166066',
      RENTFEE: '142000',
      OBJCARNO: '62허4752',
      CARNO: '32허5921',
      ACCPERSONNAME: '',
      DATA_KEY: '254',
      CARNAMEMSTNAME: 'SM5 New Impression 2000 CVTC LE AT 휘발유',
      RENTDATE: '20120107',
      UNIT24: '109000',
      TERMTYPE: 'S',
      NETSALEAMT: '89335',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '성동성수예약소',
      SALEVATAMT: '8933',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '영업2팀',
      ACCDATE: '',
      SALEAMT: '98268',
      STARTDATE: ''
    },
    {
      NO: '255',
      CARNAMEMSTNAME2: '토스카 2000 DOHC L6 2.0 일반형 AT LPG',
      RETURNDATE: '20120103',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1937111254816',
      RENTFEE: '150000',
      OBJCARNO: '41허2198',
      CARNO: '62허4238',
      ACCPERSONNAME: '',
      DATA_KEY: '255',
      CARNAMEMSTNAME: '토스카 PREMIUM 6 2000 LPGi L6 2.0 AT LPG',
      RENTDATE: '20111229',
      UNIT24: '0',
      TERMTYPE: 'S',
      NETSALEAMT: '212600',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '성수한국타이어예약소',
      SALEVATAMT: '21260',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '영업1팀',
      ACCDATE: '',
      SALEAMT: '233860',
      STARTDATE: ''
    },
    {
      NO: '256',
      CARNAMEMSTNAME2: 'SM7 New art 2300 VQ23 SE AT 휘발유',
      RETURNDATE: '20120110',
      ACCNO: '201112303626',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1450090944888',
      CONTRACTNO: 'SS1476111259245',
      RENTFEE: '266000',
      OBJCARNO: '56허8032',
      CARNO: '09허6509',
      ACCPERSONNAME: '김선연',
      DATA_KEY: '256',
      CARNAMEMSTNAME: 'SM7 New art 2300 VQ23 LE AT 휘발유',
      RENTDATE: '20111230',
      UNIT24: '266000',
      TERMTYPE: 'S',
      NETSALEAMT: '807840',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: 'MT기획팀',
      SALEVATAMT: '80784',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업5팀',
      ACCDATE: '20111230',
      SALEAMT: '888624',
      STARTDATE: ''
    },
    {
      NO: '257',
      CARNAMEMSTNAME2: '모닝 1000 SOHC L AT 휘발유',
      RETURNDATE: '20120103',
      ACCNO: '201112303606',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1511090336492',
      CONTRACTNO: 'SS1476111259247',
      RENTFEE: '95000',
      OBJCARNO: '15허3055',
      CARNO: '41허2941',
      ACCPERSONNAME: '김대윤',
      DATA_KEY: '257',
      CARNAMEMSTNAME: '모닝 1000 SOHC L AT 휘발유',
      RENTDATE: '20111230',
      UNIT24: '95000',
      TERMTYPE: 'S',
      NETSALEAMT: '97658',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: 'MT기획팀',
      SALEVATAMT: '9766',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '서울대지점',
      ACCDATE: '20111230',
      SALEAMT: '107424',
      STARTDATE: ''
    },
    {
      NO: '258',
      CARNAMEMSTNAME2: '그랜드 스타렉스 12P WAGON 2500 VGT CVX Deluxe AT 디젤',
      RETURNDATE: '20120105',
      ACCNO: '201201020152',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1060100455758',
      CONTRACTNO: 'SS1878120160426',
      RENTFEE: '165000',
      OBJCARNO: '72허4291',
      CARNO: '60허6537',
      ACCPERSONNAME: '김병준',
      DATA_KEY: '258',
      CARNAMEMSTNAME: '소나타 Y20 렌터카 2000 LPI Luxury AT LPG',
      RENTDATE: '20120102',
      UNIT24: '219000',
      TERMTYPE: 'S',
      NETSALEAMT: '147229',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '성수트루예약소',
      SALEVATAMT: '14723',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '건대지점',
      ACCDATE: '20120102',
      SALEAMT: '161952',
      STARTDATE: ''
    },
    {
      NO: '259',
      CARNAMEMSTNAME2: '아반떼 M16 1600 LPI 렌터카 DELUXE AT LPG',
      RETURNDATE: '20120104',
      ACCNO: '201112293507',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1351110590572',
      CONTRACTNO: 'SS1837111255800',
      RENTFEE: '165000',
      OBJCARNO: '68허3396',
      CARNO: '47허5936',
      ACCPERSONNAME: '박수호',
      DATA_KEY: '259',
      CARNAMEMSTNAME: '소나타 Y20 렌터카 2000 LPI Luxury AT LPG',
      RENTDATE: '20111230',
      UNIT24: '109000',
      TERMTYPE: 'S',
      NETSALEAMT: '164629',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '부산태원',
      SALEVATAMT: '16463',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '해운대지점',
      ACCDATE: '20111229',
      SALEAMT: '181092',
      STARTDATE: ''
    },
    {
      NO: '260',
      CARNAMEMSTNAME2: 'K5렌터카 2000 LPI 스마트 AT LPG',
      RETURNDATE: '20120110',
      ACCNO: '201201091070',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1200100861574',
      CONTRACTNO: 'SS1832120166979',
      RENTFEE: '116000',
      OBJCARNO: '23허2762',
      CARNO: '63허8930',
      ACCPERSONNAME: '이준엽',
      DATA_KEY: '260',
      CARNAMEMSTNAME: 'i30 1600 VGT Luxury AT 디젤',
      RENTDATE: '20120109',
      UNIT24: '165000',
      TERMTYPE: 'S',
      NETSALEAMT: '49636',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '춘천효성예약소',
      SALEVATAMT: '4964',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '원주지점',
      ACCDATE: '20120109',
      SALEAMT: '54600',
      STARTDATE: ''
    },
    {
      NO: '261',
      CARNAMEMSTNAME2: 'New SM5 장애우용 2000 CVTC Ⅱ LPLi LE AT LPG',
      RETURNDATE: '20120106',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1355120162262',
      RENTFEE: '165000',
      OBJCARNO: '47허5632',
      CARNO: '63허8740',
      ACCPERSONNAME: '',
      DATA_KEY: '261',
      CARNAMEMSTNAME: 'NEW SM5 렌터카 2000 CVTC Ⅱ LPLi 최고급형 AT LPG',
      RENTDATE: '20120104',
      UNIT24: '165000',
      TERMTYPE: 'S',
      NETSALEAMT: '114273',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '부산지점',
      SALEVATAMT: '11427',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '부산지점',
      ACCDATE: '',
      SALEAMT: '125700',
      STARTDATE: ''
    },
    {
      NO: '262',
      CARNAMEMSTNAME2: '뉴아반떼 1600 VVT E16 DELUXE AT 휘발유',
      RETURNDATE: '20120103',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1862120160910',
      RENTFEE: '150000',
      OBJCARNO: '41허3443',
      CARNO: '59허1917',
      ACCPERSONNAME: '',
      DATA_KEY: '262',
      CARNAMEMSTNAME: '소나타 N20 2000 LPI LUX 기본형 AT LPG',
      RENTDATE: '20120102',
      UNIT24: '99000',
      TERMTYPE: 'S',
      NETSALEAMT: '33091',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '대구동구',
      SALEVATAMT: '3309',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '대구지점(동대구역)',
      ACCDATE: '',
      SALEAMT: '36400',
      STARTDATE: ''
    },
    {
      NO: '263',
      CARNAMEMSTNAME2: '쏘렌토 R 4WD 2200 E-VGT TLX 고급형 AT 디젤',
      RETURNDATE: '20120110',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1474120161104',
      RENTFEE: '190000',
      OBJCARNO: '60허6718',
      CARNO: '60허6082',
      ACCPERSONNAME: '',
      DATA_KEY: '263',
      CARNAMEMSTNAME: '스포티지R 4WD 2000 E-VGT LX AT 디젤',
      RENTDATE: '20120103',
      UNIT24: '199000',
      TERMTYPE: 'S',
      NETSALEAMT: '365942',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '잠실지점',
      SALEVATAMT: '36594',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '잠실지점',
      ACCDATE: '',
      SALEAMT: '402536',
      STARTDATE: ''
    },
    {
      NO: '264',
      CARNAMEMSTNAME2: '소나타 Y20 렌터카 2000 LPI Deluxe AT LPG',
      RETURNDATE: '20120110',
      ACCNO: '201201080896',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1020110471771',
      CONTRACTNO: 'SS1903120166445',
      RENTFEE: '165000',
      OBJCARNO: '44허5256',
      CARNO: '52허7368',
      ACCPERSONNAME: '김대윤',
      DATA_KEY: '264',
      CARNAMEMSTNAME: '소나타 Y20 렌터카 2000 LPI Luxury AT LPG',
      RENTDATE: '20120109',
      UNIT24: '165000',
      TERMTYPE: 'S',
      NETSALEAMT: '92436',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '구로현주예약소',
      SALEVATAMT: '9244',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '서대문지점',
      ACCDATE: '20111223',
      SALEAMT: '101680',
      STARTDATE: ''
    },
    {
      NO: '265',
      CARNAMEMSTNAME2: 'K5 2000 I4 세타 Ⅱ 프레스티지 AT 휘발유',
      RETURNDATE: '20120105',
      ACCNO: '201201030257',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1470100962675',
      CONTRACTNO: 'SS1974120160165',
      RENTFEE: '165000',
      OBJCARNO: '63허4581',
      CARNO: '59허3388',
      ACCPERSONNAME: '김대윤',
      DATA_KEY: '265',
      CARNAMEMSTNAME: 'K5렌터카 2000 LPI 디럭스 AT LPG',
      RENTDATE: '20120103',
      UNIT24: '160000',
      TERMTYPE: 'S',
      NETSALEAMT: '105455',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '성남단대역예약소',
      SALEVATAMT: '10545',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업3팀',
      ACCDATE: '20120103',
      SALEAMT: '116000',
      STARTDATE: ''
    },
    {
      NO: '266',
      CARNAMEMSTNAME2: '소나타 N20 2000 LPI DLX 기본형 AT LPG',
      RETURNDATE: '20120106',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1945120160438',
      RENTFEE: '150000',
      OBJCARNO: '41허2485',
      CARNO: '41허5662',
      ACCPERSONNAME: '',
      DATA_KEY: '266',
      CARNAMEMSTNAME: '소나타 트랜스폼 N20 2000 LPI 고급형 AT LPG',
      RENTDATE: '20120102',
      UNIT24: '150000',
      TERMTYPE: 'S',
      NETSALEAMT: '168116',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '일산탄현예약소',
      SALEVATAMT: '16812',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '동대문지점',
      ACCDATE: '',
      SALEAMT: '184928',
      STARTDATE: ''
    },
    {
      NO: '267',
      CARNAMEMSTNAME2: '뉴아반떼 1600 VVT S16 LUXURY  AT 휘발유',
      RETURNDATE: '20120104',
      ACCNO: '201112273273',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1450100252684',
      CONTRACTNO: 'SS1476111253849',
      RENTFEE: '142000',
      OBJCARNO: '09허9126',
      CARNO: '15허3033',
      ACCPERSONNAME: '정해성',
      DATA_KEY: '267',
      CARNAMEMSTNAME: '소나타 트랜스폼 N20 2000 VVT Elegance 고급형 Safety Pack1 AT 휘발유',
      RENTDATE: '20111228',
      UNIT24: '99000',
      TERMTYPE: 'S',
      NETSALEAMT: '185309',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: 'MT기획팀',
      SALEVATAMT: '18531',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업2팀',
      ACCDATE: '20111227',
      SALEAMT: '203840',
      STARTDATE: ''
    },
    {
      NO: '268',
      CARNAMEMSTNAME2: '그랜져TG 2700 LPI Q270 모범형 PACK 1 AT LPG',
      RETURNDATE: '20120110',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1833120176168',
      RENTFEE: '307000',
      OBJCARNO: '20허2032',
      CARNO: '60허5453',
      ACCPERSONNAME: '',
      DATA_KEY: '268',
      CARNAMEMSTNAME: '오피러스 PREMIUM 렌터카 2700 V6 뮤 GH270 최고급형 AT LPG',
      RENTDATE: '20120110',
      UNIT24: '266000',
      TERMTYPE: 'S',
      NETSALEAMT: '88000',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '부천남부예약소',
      SALEVATAMT: '8800',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '영업2팀',
      ACCDATE: '',
      SALEAMT: '96800',
      STARTDATE: ''
    },
    {
      NO: '269',
      CARNAMEMSTNAME2: 'New SM5  2000 CVTC Ⅱ LE AT 휘발유',
      RETURNDATE: '20120106',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1476120165683',
      RENTFEE: '160000',
      OBJCARNO: '56허9927',
      CARNO: '27허1541',
      ACCPERSONNAME: '',
      DATA_KEY: '269',
      CARNAMEMSTNAME: '소나타 Y20 2000 VVT Prime 최고급형 AT 휘발유',
      RENTDATE: '20120105',
      UNIT24: '160000',
      TERMTYPE: 'S',
      NETSALEAMT: '84364',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: 'MT기획팀',
      SALEVATAMT: '8436',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '영업2팀',
      ACCDATE: '',
      SALEAMT: '92800',
      STARTDATE: ''
    },
    {
      NO: '270',
      CARNAMEMSTNAME2: 'K5 2000 I4 세타 Ⅱ 스마트 스페셜 AT 휘발유',
      RETURNDATE: '20120104',
      ACCNO: '201112283463',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1480110906950',
      CONTRACTNO: 'SS1878111254231',
      RENTFEE: '160000',
      OBJCARNO: '06허4640',
      CARNO: '62허4982',
      ACCPERSONNAME: '김대윤',
      DATA_KEY: '270',
      CARNAMEMSTNAME: '소나타 Y20 2000 I4 세타 Ⅱ Prime AT 휘발유',
      RENTDATE: '20111229',
      UNIT24: '160000',
      TERMTYPE: 'S',
      NETSALEAMT: '295273',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '성수트루예약소',
      SALEVATAMT: '29527',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '전주지점',
      ACCDATE: '20111228',
      SALEAMT: '324800',
      STARTDATE: ''
    },
    {
      NO: '271',
      CARNAMEMSTNAME2: 'K5렌터카 2000 LPI 스마트 AT LPG',
      RETURNDATE: '20120102',
      ACCNO: '201112303600',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1330110907038',
      CONTRACTNO: 'SS1866111258878',
      RENTFEE: '165000',
      OBJCARNO: '16허7528',
      CARNO: '52허7354',
      ACCPERSONNAME: '정해성',
      DATA_KEY: '271',
      CARNAMEMSTNAME: '소나타 Y20 렌터카 2000 LPI Luxury AT LPG',
      RENTDATE: '20111230',
      UNIT24: '165000',
      TERMTYPE: 'S',
      NETSALEAMT: '184425',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '상주지점',
      SALEVATAMT: '18443',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '창원지점',
      ACCDATE: '20111230',
      SALEAMT: '202868',
      STARTDATE: ''
    },
    {
      NO: '272',
      CARNAMEMSTNAME2: '베르나 트랜스폼 1500 VGT TRENDY AT 디젤',
      RETURNDATE: '20120106',
      ACCNO: '201112263137',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1460100252942',
      CONTRACTNO: 'SS1878120161237',
      RENTFEE: '165000',
      OBJCARNO: '59허1645',
      CARNO: '59허9109',
      ACCPERSONNAME: '김선연',
      DATA_KEY: '272',
      CARNAMEMSTNAME: 'NEW SM5 렌터카 2000 CVTC Ⅱ LPLi 고급형 AT LPG',
      RENTDATE: '20120103',
      UNIT24: '95000',
      TERMTYPE: 'S',
      NETSALEAMT: '84436',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '성수트루예약소',
      SALEVATAMT: '8444',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업5팀',
      ACCDATE: '20111226',
      SALEAMT: '92880',
      STARTDATE: ''
    },
    {
      NO: '273',
      CARNAMEMSTNAME2: '알페온 3000 SIDI CL300 디럭스 AT 휘발유',
      RETURNDATE: '20120103',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1933111252669',
      RENTFEE: '399000',
      OBJCARNO: '60허6830',
      CARNO: '05허5823',
      ACCPERSONNAME: '',
      DATA_KEY: '273',
      CARNAMEMSTNAME: '제네시스 3300 람다 BH330 LUXURY AT 휘발유',
      RENTDATE: '20111227',
      UNIT24: '292000',
      TERMTYPE: 'S',
      NETSALEAMT: '594564',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '화성동탄예약소',
      SALEVATAMT: '59456',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '수원지점',
      ACCDATE: '',
      SALEAMT: '654020',
      STARTDATE: ''
    },
    {
      NO: '274',
      CARNAMEMSTNAME2: '로체 이노베이션 렌트카 2000 LPI LX20 기본형 스페셜 AT LPG',
      RETURNDATE: '20120103',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1476111259613',
      RENTFEE: '150000',
      OBJCARNO: '05허4046',
      CARNO: '05허1952',
      ACCPERSONNAME: '',
      DATA_KEY: '274',
      CARNAMEMSTNAME: '로체 이노베이션 렌트카 2000 LPI LX20 기본형 AT LPG',
      RENTDATE: '20111230',
      UNIT24: '150000',
      TERMTYPE: 'S',
      NETSALEAMT: '187433',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: 'MT기획팀',
      SALEVATAMT: '18743',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '영업2팀',
      ACCDATE: '',
      SALEAMT: '206176',
      STARTDATE: ''
    },
    {
      NO: '275',
      CARNAMEMSTNAME2: '그랜져 THE LUXURY 2700 LPI 렌터카 Q270 모범형 PACKⅡ AT LPG',
      RETURNDATE: '20120104',
      ACCNO: '201112232618',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1240100860761',
      CONTRACTNO: 'SS1938111245732',
      RENTFEE: '399000',
      OBJCARNO: '60허5585',
      CARNO: '31허3900',
      ACCPERSONNAME: '김선연',
      DATA_KEY: '275',
      CARNAMEMSTNAME: '제네시스 3300 람다 BH330 LUXURY AT 휘발유',
      RENTDATE: '20111223',
      UNIT24: '266000',
      TERMTYPE: 'S',
      NETSALEAMT: '861520',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '군포산본예약소',
      SALEVATAMT: '86152',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '대구지점(동대구역)',
      ACCDATE: '20111222',
      SALEAMT: '947672',
      STARTDATE: ''
    },
    {
      NO: '276',
      CARNAMEMSTNAME2: '체어맨 W 3200 IL6 CW 600 Prestige AT 휘발유',
      RETURNDATE: '20120110',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1921111256423',
      RENTFEE: '447000',
      OBJCARNO: '10허5985',
      CARNO: '32허2169',
      ACCPERSONNAME: '',
      DATA_KEY: '276',
      CARNAMEMSTNAME: '체어맨 W 3600 XGi CW 700 Luxury AT 휘발유',
      RENTDATE: '20111230',
      UNIT24: '399000',
      TERMTYPE: 'S',
      NETSALEAMT: '1313225',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '안산사동예약소',
      SALEVATAMT: '131323',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '대전지점',
      ACCDATE: '',
      SALEAMT: '1444548',
      STARTDATE: ''
    },
    {
      NO: '277',
      CARNAMEMSTNAME2: '싼타페 The Style 2WD 2000 E-VGT MLX LUXURY AT 디젤',
      RETURNDATE: '20120102',
      ACCNO: '201112303598',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1461100861379',
      CONTRACTNO: 'SS1837111259138',
      RENTFEE: '0',
      OBJCARNO: '63허1549',
      CARNO: '27허5385',
      ACCPERSONNAME: '이준엽',
      DATA_KEY: '277',
      CARNAMEMSTNAME: '카이런 2000 XVT LV5 고급형 AT 디젤',
      RENTDATE: '20111230',
      UNIT24: '199000',
      TERMTYPE: 'S',
      NETSALEAMT: '185615',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '부산태원',
      SALEVATAMT: '18561',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업4팀',
      ACCDATE: '20111229',
      SALEAMT: '204176',
      STARTDATE: ''
    },
    {
      NO: '278',
      CARNAMEMSTNAME2: '뉴카렌스 2000 LPI GX 고급형 AT LPG',
      RETURNDATE: '20120105',
      ACCNO: '201201010004',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1250100557773',
      CONTRACTNO: 'SS1818120159858',
      RENTFEE: '165000',
      OBJCARNO: '10허5941',
      CARNO: '62허4067',
      ACCPERSONNAME: '이준엽',
      DATA_KEY: '278',
      CARNAMEMSTNAME: 'K5렌터카 2000 LPI 디럭스 AT LPG',
      RENTDATE: '20120102',
      UNIT24: '165000',
      TERMTYPE: 'S',
      NETSALEAMT: '147240',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '도곡예약소',
      SALEVATAMT: '14724',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '대전지점',
      ACCDATE: '20120101',
      SALEAMT: '161964',
      STARTDATE: ''
    },
    {
      NO: '279',
      CARNAMEMSTNAME2: '뉴싼타페 2200 VGT CLX 고급형 AT 디젤',
      RETURNDATE: '20120102',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1939111252429',
      RENTFEE: '190000',
      OBJCARNO: '18허4219',
      CARNO: '63허9037',
      ACCPERSONNAME: '',
      DATA_KEY: '279',
      CARNAMEMSTNAME: '투싼 ix 4WD 2000 E-VGT X20 Luxury AT 디젤',
      RENTDATE: '20111227',
      UNIT24: '199000',
      TERMTYPE: 'S',
      NETSALEAMT: '323247',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '광명철산예약소',
      SALEVATAMT: '32325',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '수원지점',
      ACCDATE: '',
      SALEAMT: '355572',
      STARTDATE: ''
    },
    {
      NO: '280',
      CARNAMEMSTNAME2: '소나타 Y20 렌터카 2000 LPI Deluxe AT LPG',
      RETURNDATE: '20120103',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1853111259359',
      RENTFEE: '165000',
      OBJCARNO: '13허2898',
      CARNO: '13허3558',
      ACCPERSONNAME: '',
      DATA_KEY: '280',
      CARNAMEMSTNAME: '소나타 Y20 렌터카 2000 LPI Luxury AT LPG',
      RENTDATE: '20111231',
      UNIT24: '165000',
      TERMTYPE: 'S',
      NETSALEAMT: '168000',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '포항마스터예약소',
      SALEVATAMT: '16800',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '포항지점',
      ACCDATE: '',
      SALEAMT: '184800',
      STARTDATE: ''
    },
    {
      NO: '281',
      CARNAMEMSTNAME2: '그랜져 THE LUXURY 2700 LPI 렌터카 Q270 모범형 PACKⅠ AT LPG',
      RETURNDATE: '20120104',
      ACCNO: '201112303698',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'SS1080091252394',
      CONTRACTNO: 'SS1914111259362',
      RENTFEE: '292000',
      OBJCARNO: '60허6646',
      CARNO: '52허5901',
      ACCPERSONNAME: '김대윤',
      DATA_KEY: '281',
      CARNAMEMSTNAME: '5G 그랜져 3000 LPI HG300 렌터카 Prime AT LPG',
      RENTDATE: '20111231',
      UNIT24: '266000',
      TERMTYPE: 'S',
      NETSALEAMT: '299164',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '경기오포예약소',
      SALEVATAMT: '29916',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'M',
      DEPTNAME: '강남지점',
      ACCDATE: '20111230',
      SALEAMT: '329080',
      STARTDATE: ''
    },
    {
      NO: '282',
      CARNAMEMSTNAME2: '소나타 Y20 렌터카 2000 LPI Deluxe AT LPG',
      RETURNDATE: '20120105',
      ACCNO: '201112313793',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1200110165058',
      CONTRACTNO: 'SS1200120159369',
      RENTFEE: '165000',
      OBJCARNO: '69허1190',
      CARNO: '60허6526',
      ACCPERSONNAME: '어성환',
      DATA_KEY: '282',
      CARNAMEMSTNAME: '소나타 Y20 렌터카 2000 LPI Luxury AT LPG',
      RENTDATE: '20120102',
      UNIT24: '165000',
      TERMTYPE: 'S',
      NETSALEAMT: '147240',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '원주지점',
      SALEVATAMT: '14724',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '원주지점',
      ACCDATE: '20111231',
      SALEAMT: '161964',
      STARTDATE: ''
    },
    {
      NO: '283',
      CARNAMEMSTNAME2: '그랜져 THE LUXURY 2700 LPI 렌터카 Q270 모범형 AT LPG',
      RETURNDATE: '20120105',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1410120159912',
      RENTFEE: '292000',
      OBJCARNO: '63허7493',
      CARNO: '05허5714',
      ACCPERSONNAME: '',
      DATA_KEY: '283',
      CARNAMEMSTNAME: 'K7 2700 V6 뮤 VG270 프레스티지 AT 휘발유',
      RENTDATE: '20120102',
      UNIT24: '266000',
      TERMTYPE: 'S',
      NETSALEAMT: '237578',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '부천지점',
      SALEVATAMT: '23758',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '부천지점',
      ACCDATE: '',
      SALEAMT: '261336',
      STARTDATE: ''
    },
    {
      NO: '284',
      CARNAMEMSTNAME2: '그랜져TG 2700 DOHC Q270 DELUXE AT 휘발유',
      RETURNDATE: '20120110',
      ACCNO: '201201010022',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1210080930728',
      CONTRACTNO: 'SS1822120159915',
      RENTFEE: '266000',
      OBJCARNO: '13허6204',
      CARNO: '60허5381',
      ACCPERSONNAME: '정해성',
      DATA_KEY: '284',
      CARNAMEMSTNAME: '그랜져 THE LUXURY 2700 LPI 렌터카 Q270 모범형 PACKⅠ AT LPG',
      RENTDATE: '20120102',
      UNIT24: '266000',
      TERMTYPE: 'S',
      NETSALEAMT: '588280',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '대구하나',
      SALEVATAMT: '58828',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '구미지점',
      ACCDATE: '20120101',
      SALEAMT: '647108',
      STARTDATE: ''
    },
    {
      NO: '285',
      CARNAMEMSTNAME2: '소나타 Y20 렌터카 2000 LPI Deluxe AT LPG',
      RETURNDATE: '20120105',
      ACCNO: '201201020204',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1260111209623',
      CONTRACTNO: 'SS1869120159998',
      RENTFEE: '165000',
      OBJCARNO: '52허6731',
      CARNO: '62허4144',
      ACCPERSONNAME: '윤원재',
      DATA_KEY: '285',
      CARNAMEMSTNAME: 'K5렌터카 2000 LPI 디럭스 AT LPG',
      RENTDATE: '20120102',
      UNIT24: '165000',
      TERMTYPE: 'S',
      NETSALEAMT: '147211',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '안산상록예약소',
      SALEVATAMT: '14721',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '광주지점',
      ACCDATE: '20120102',
      SALEAMT: '161932',
      STARTDATE: ''
    },
    {
      NO: '286',
      CARNAMEMSTNAME2: '뉴아반떼 1600 VVT E16 DELUXE AT 휘발유',
      RETURNDATE: '20120104',
      ACCNO: '201201020192',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1461090945886',
      CONTRACTNO: 'SS1913120160280',
      RENTFEE: '142000',
      OBJCARNO: '04허1319',
      CARNO: '30허2648',
      ACCPERSONNAME: '윤원재',
      DATA_KEY: '286',
      CARNAMEMSTNAME: '소나타 N20 2000 VVT Luxury AT 휘발유',
      RENTDATE: '20120102',
      UNIT24: '99000',
      TERMTYPE: 'S',
      NETSALEAMT: '64836',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '성동성수예약소',
      SALEVATAMT: '6484',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업4팀',
      ACCDATE: '20120102',
      SALEAMT: '71320',
      STARTDATE: ''
    },
    {
      NO: '287',
      CARNAMEMSTNAME2: '소나타 트랜스폼 N20 2000 LPI 일반형 AT LPG',
      RETURNDATE: '20120107',
      ACCNO: '201201020171',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1470101163745',
      CONTRACTNO: 'SS1816111259886',
      RENTFEE: '165000',
      OBJCARNO: '26허5065',
      CARNO: '52허7288',
      ACCPERSONNAME: '정해성',
      DATA_KEY: '287',
      CARNAMEMSTNAME: '소나타 Y20 렌터카 2000 LPI Luxury AT LPG',
      RENTDATE: '20111231',
      UNIT24: '150000',
      TERMTYPE: 'S',
      NETSALEAMT: '276945',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '광주진왕',
      SALEVATAMT: '27695',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업5팀',
      ACCDATE: '20111231',
      SALEAMT: '304640',
      STARTDATE: ''
    },
    {
      NO: '288',
      CARNAMEMSTNAME2: '소나타 Y20 렌터카 2000 LPI Luxury AT LPG',
      RETURNDATE: '20120104',
      ACCNO: '201201020128',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1470100760562',
      CONTRACTNO: 'SS1801120160435',
      RENTFEE: '165000',
      OBJCARNO: '60허5573',
      CARNO: '44허1321',
      ACCPERSONNAME: '김대윤',
      DATA_KEY: '288',
      CARNAMEMSTNAME: '소나타 Y20 렌터카 2000 LPI Deluxe AT LPG',
      RENTDATE: '20120102',
      UNIT24: '165000',
      TERMTYPE: 'S',
      NETSALEAMT: '114273',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '인천21세기',
      SALEVATAMT: '11427',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업2팀',
      ACCDATE: '20111231',
      SALEAMT: '125700',
      STARTDATE: ''
    },
    {
      NO: '289',
      CARNAMEMSTNAME2: '소나타 Y20 2000 I4 세타 Ⅱ Royal AT 휘발유',
      RETURNDATE: '20120104',
      ACCNO: '201201020214',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1456110367067',
      CONTRACTNO: 'SS1913120160282',
      RENTFEE: '160000',
      OBJCARNO: '04허6916',
      CARNO: '56허9390',
      ACCPERSONNAME: '김선연',
      DATA_KEY: '289',
      CARNAMEMSTNAME: '소나타 Y20 2000 VVT Prime 고급형 AT 휘발유',
      RENTDATE: '20120103',
      UNIT24: '160000',
      TERMTYPE: 'S',
      NETSALEAMT: '73818',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '성동성수예약소',
      SALEVATAMT: '7382',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업1팀',
      ACCDATE: '20120102',
      SALEAMT: '81200',
      STARTDATE: ''
    },
    {
      NO: '290',
      CARNAMEMSTNAME2: '5G 그랜져 3000 GDI HG300 NOBLE AT 휘발유',
      RETURNDATE: '20120109',
      ACCNO: '201201030353',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1458110367097',
      CONTRACTNO: 'SS1818120161628',
      RENTFEE: '292000',
      OBJCARNO: '62허4311',
      CARNO: '05허7564',
      ACCPERSONNAME: '김병준',
      DATA_KEY: '290',
      CARNAMEMSTNAME: 'K7 The Prestige 렌터카 3000 V6 람다 3.0LPI 럭셔리 AT LPG',
      RENTDATE: '20120104',
      UNIT24: '292000',
      TERMTYPE: 'S',
      NETSALEAMT: '491004',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '도곡예약소',
      SALEVATAMT: '49100',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업5팀',
      ACCDATE: '20111229',
      SALEAMT: '540104',
      STARTDATE: ''
    },
    {
      NO: '291',
      CARNAMEMSTNAME2: '소나타 트랜스폼 N20 2000 LPI 일반형 AT LPG',
      RETURNDATE: '20120110',
      ACCNO: '201201030239',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1470101163796',
      CONTRACTNO: 'SS1937120161726',
      RENTFEE: '150000',
      OBJCARNO: '63허7476',
      CARNO: '62허4238',
      ACCPERSONNAME: '정해성',
      DATA_KEY: '291',
      CARNAMEMSTNAME: '토스카 PREMIUM 6 2000 LPGi L6 2.0 AT LPG',
      RENTDATE: '20120104',
      UNIT24: '150000',
      TERMTYPE: 'S',
      NETSALEAMT: '276945',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '성수한국타이어예약소',
      SALEVATAMT: '27695',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업1팀',
      ACCDATE: '20120103',
      SALEAMT: '304640',
      STARTDATE: ''
    },
    {
      NO: '292',
      CARNAMEMSTNAME2: '5G 그랜져 3000 LPI HG300 렌터카 Prime AT LPG',
      RETURNDATE: '20120105',
      ACCNO: '201201040502',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1060110703970',
      CONTRACTNO: 'SS1904120161770',
      RENTFEE: '150000',
      OBJCARNO: '52허7394',
      CARNO: '41허2998',
      ACCPERSONNAME: '이준엽',
      DATA_KEY: '292',
      CARNAMEMSTNAME: '소나타 N20 2000 LPI DLX 기본형 AT LPG',
      RENTDATE: '20120104',
      UNIT24: '292000',
      TERMTYPE: 'S',
      NETSALEAMT: '49455',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '원주순호예약소',
      SALEVATAMT: '4945',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '건대지점',
      ACCDATE: '20120104',
      SALEAMT: '54400',
      STARTDATE: ''
    },
    {
      NO: '293',
      CARNAMEMSTNAME2: '에쿠스 TRUE PRESTIGE 3800 GDI VS 380 프레스티지 AT 휘발유',
      RETURNDATE: '20120104',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1937120160741',
      RENTFEE: '488000',
      OBJCARNO: '06허4569',
      CARNO: '04허2290',
      ACCPERSONNAME: '',
      DATA_KEY: '293',
      CARNAMEMSTNAME: '에쿠스 TRUE PRESTIGE 3800 V6 람다 VS 380 럭셔리 AT 휘발유',
      RENTDATE: '20120103',
      UNIT24: '488000',
      TERMTYPE: 'S',
      NETSALEAMT: '243218',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '성수한국타이어예약소',
      SALEVATAMT: '24322',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '영업3팀',
      ACCDATE: '',
      SALEAMT: '267540',
      STARTDATE: ''
    },
    {
      NO: '294',
      CARNAMEMSTNAME2: 'K7 The Prestige 렌터카 3000 V6 람다 3.0LPI 럭셔리 AT LPG',
      RETURNDATE: '20120103',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1260120160827',
      RENTFEE: '307000',
      OBJCARNO: '42허5300',
      CARNO: '56허8334',
      ACCPERSONNAME: '',
      DATA_KEY: '294',
      CARNAMEMSTNAME: '오피러스 PREMIUM 2700 V6 뮤 GH270 스페셜-럭셔리 AT 휘발유',
      RENTDATE: '20120103',
      UNIT24: '292000',
      TERMTYPE: 'S',
      NETSALEAMT: '96364',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '광주지점',
      SALEVATAMT: '9636',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '광주지점',
      ACCDATE: '',
      SALEAMT: '106000',
      STARTDATE: ''
    },
    {
      NO: '295',
      CARNAMEMSTNAME2: '뉴 카니발R 9P 2200 E-VGT GX AT 디젤',
      RETURNDATE: '20120102',
      ACCNO: '201112283414',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1450100557872',
      CONTRACTNO: 'SS1944111253832',
      RENTFEE: '190000',
      OBJCARNO: '56허9792',
      CARNO: '59허3520',
      ACCPERSONNAME: '어성환',
      DATA_KEY: '295',
      CARNAMEMSTNAME: '투싼 ix 4WD 2000 E-VGT X20 Luxury AT 디젤',
      RENTDATE: '20111228',
      UNIT24: '270000',
      TERMTYPE: 'S',
      NETSALEAMT: '285727',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '대전태화예약소',
      SALEVATAMT: '28573',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업2팀',
      ACCDATE: '20111228',
      SALEAMT: '314300',
      STARTDATE: ''
    },
    {
      NO: '296',
      CARNAMEMSTNAME2: '뉴프라이드 1400 DOHC L AT 휘발유/LPG',
      RETURNDATE: '20120110',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1476111255365',
      RENTFEE: '0',
      OBJCARNO: '62허5647',
      CARNO: '38허3953',
      ACCPERSONNAME: '',
      DATA_KEY: '296',
      CARNAMEMSTNAME: '토스카 2000 DOHC L6 2.0 AT LPG',
      RENTDATE: '20111229',
      UNIT24: '99000',
      TERMTYPE: 'S',
      NETSALEAMT: '317673',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: 'MT기획팀',
      SALEVATAMT: '31767',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '부천지점',
      ACCDATE: '',
      SALEAMT: '349440',
      STARTDATE: ''
    },
    {
      NO: '297',
      CARNAMEMSTNAME2: '베르나 트랜스폼 1500 VGT TRENDY AT 디젤',
      RETURNDATE: '20120105',
      ACCNO: '201201040435',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1474100658860',
      CONTRACTNO: 'SS1894120161818',
      RENTFEE: '0',
      OBJCARNO: '05허5529',
      CARNO: '32허5749',
      ACCPERSONNAME: '김선연',
      DATA_KEY: '297',
      CARNAMEMSTNAME: 'SM3 1600 CVTC SE AT 휘발유',
      RENTDATE: '20120103',
      UNIT24: '95000',
      TERMTYPE: 'S',
      NETSALEAMT: '60000',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '(폐쇄)수지동화예약소',
      SALEVATAMT: '6000',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '잠실지점',
      ACCDATE: '20120103',
      SALEAMT: '66000',
      STARTDATE: ''
    },
    {
      NO: '298',
      CARNAMEMSTNAME2: '소나타 Y20 렌터카 2000 LPI Luxury AT LPG',
      RETURNDATE: '20120105',
      ACCNO: '201201020093',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1130110598991',
      CONTRACTNO: 'SS1848120161909',
      RENTFEE: '165000',
      OBJCARNO: '04허7533',
      CARNO: '56허9421',
      ACCPERSONNAME: '김병준',
      DATA_KEY: '298',
      CARNAMEMSTNAME: '소나타 Y20 렌터카 2000 LPI Luxury AT LPG',
      RENTDATE: '20120102',
      UNIT24: '165000',
      TERMTYPE: 'S',
      NETSALEAMT: '147251',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '수원삼정예약소',
      SALEVATAMT: '14725',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '수원지점',
      ACCDATE: '20120102',
      SALEAMT: '161976',
      STARTDATE: ''
    },
    {
      NO: '299',
      CARNAMEMSTNAME2: '소나타 Y20 렌터카 2000 LPI Deluxe AT LPG',
      RETURNDATE: '20120102',
      ACCNO: '201112293545',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1280111209665',
      CONTRACTNO: 'SS1913111255824',
      RENTFEE: '165000',
      OBJCARNO: '52허6639',
      CARNO: '59허3405',
      ACCPERSONNAME: '김대윤',
      DATA_KEY: '299',
      CARNAMEMSTNAME: 'K5렌터카 2000 LPI 디럭스 AT LPG',
      RENTDATE: '20111230',
      UNIT24: '165000',
      TERMTYPE: 'S',
      NETSALEAMT: '182105',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '성동성수예약소',
      SALEVATAMT: '18211',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '순천여수지점',
      ACCDATE: '20111229',
      SALEAMT: '200316',
      STARTDATE: ''
    },
    {
      NO: '300',
      CARNAMEMSTNAME2: '에쿠스 TRUE PRESTIGE 3800 GDI VS 380 럭셔리 AT 휘발유',
      RETURNDATE: '20120110',
      ACCNO: '201201030387',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1457110604039',
      CONTRACTNO: 'SS1878120161238',
      RENTFEE: '488000',
      OBJCARNO: '52허7247',
      CARNO: '62허5122',
      ACCPERSONNAME: '김현철',
      DATA_KEY: '300',
      CARNAMEMSTNAME: '에쿠스 TRUE PRESTIGE 3800 GDI VS 380 럭셔리 AT 휘발유',
      RENTDATE: '20120104',
      UNIT24: '488000',
      TERMTYPE: 'S',
      NETSALEAMT: '826764',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '성수트루예약소',
      SALEVATAMT: '82676',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업3팀',
      ACCDATE: '20120103',
      SALEAMT: '909440',
      STARTDATE: ''
    },
    {
      NO: '301',
      CARNAMEMSTNAME2: '투싼 ix 4WD 2000 E-VGT X20 Luxury AT 디젤',
      RETURNDATE: '20120110',
      ACCNO: '201112273261',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1220111108319',
      CONTRACTNO: 'SS1937111253512',
      RENTFEE: '199000',
      OBJCARNO: '52허4088',
      CARNO: '52허6590',
      ACCPERSONNAME: '정해성',
      DATA_KEY: '301',
      CARNAMEMSTNAME: '쏘렌토 R 4WD 2200 E-VGT TLX 고급형 AT 디젤',
      RENTDATE: '20111228',
      UNIT24: '190000',
      TERMTYPE: 'S',
      NETSALEAMT: '696436',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '성수한국타이어예약소',
      SALEVATAMT: '69644',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '속초영업소',
      ACCDATE: '20111227',
      SALEAMT: '766080',
      STARTDATE: ''
    },
    {
      NO: '302',
      CARNAMEMSTNAME2: '',
      RETURNDATE: '20120106',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1937120161730',
      RENTFEE: '150000',
      OBJCARNO: '59허3359',
      CARNO: '68허3076',
      ACCPERSONNAME: '',
      DATA_KEY: '302',
      CARNAMEMSTNAME: '로체 이노베이션 렌트카 2000 LPI LX20 기본형 스페셜 AT LPG',
      RENTDATE: '20120104',
      UNIT24: '0',
      TERMTYPE: 'S',
      NETSALEAMT: '103607',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '성수한국타이어예약소',
      SALEVATAMT: '10361',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '서대문지점',
      ACCDATE: '',
      SALEAMT: '113968',
      STARTDATE: ''
    },
    {
      NO: '303',
      CARNAMEMSTNAME2: '5G 그랜져 3000 GDI HG300 PRIME AT 휘발유',
      RETURNDATE: '20120105',
      ACCNO: '201201030236',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1457110503117',
      CONTRACTNO: 'SS1476120162119',
      RENTFEE: '292000',
      OBJCARNO: '04허7641',
      CARNO: '63허1655',
      ACCPERSONNAME: '김병준',
      DATA_KEY: '303',
      CARNAMEMSTNAME: 'K7 2700 V6 뮤 VG270 프레스티지 AT 휘발유',
      RENTDATE: '20120103',
      UNIT24: '292000',
      TERMTYPE: 'S',
      NETSALEAMT: '209440',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: 'MT기획팀',
      SALEVATAMT: '20944',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업3팀',
      ACCDATE: '20120102',
      SALEAMT: '230384',
      STARTDATE: ''
    },
    {
      NO: '304',
      CARNAMEMSTNAME2: 'All New 모닝 바이퓨얼 1000 MPI 스마트 AT 휘발유/LPG',
      RETURNDATE: '20120109',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1891120161996',
      RENTFEE: '109000',
      OBJCARNO: '45허4557',
      CARNO: '52허5665',
      ACCPERSONNAME: '',
      DATA_KEY: '304',
      CARNAMEMSTNAME: '아반떼 M16 1600 LPI 렌터카 LUXURY AT LPG',
      RENTDATE: '20120104',
      UNIT24: '95000',
      TERMTYPE: 'S',
      NETSALEAMT: '145647',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '시흥정왕예약소',
      SALEVATAMT: '14565',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '서울대지점',
      ACCDATE: '',
      SALEAMT: '160212',
      STARTDATE: ''
    },
    {
      NO: '305',
      CARNAMEMSTNAME2: '소나타 Y20 렌터카 2000 LPI Premier AT LPG',
      RETURNDATE: '20120104',
      ACCNO: '201201010001',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1440101264872',
      CONTRACTNO: 'SS1913120159018',
      RENTFEE: '292000',
      OBJCARNO: '63허9136',
      CARNO: '44허2267',
      ACCPERSONNAME: '윤원재',
      DATA_KEY: '305',
      CARNAMEMSTNAME: 'K7 렌터카 2700 V6 뮤 VG270 럭셔리 AT LPG',
      RENTDATE: '20120102',
      UNIT24: '165000',
      TERMTYPE: 'S',
      NETSALEAMT: '129818',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '성동성수예약소',
      SALEVATAMT: '12982',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '동대문지점',
      ACCDATE: '20120101',
      SALEAMT: '142800',
      STARTDATE: ''
    },
    {
      NO: '306',
      CARNAMEMSTNAME2: '투싼 ix 4WD 2000 E-VGT X20 Luxury AT 디젤',
      RETURNDATE: '20120103',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1330111255710',
      RENTFEE: '190000',
      OBJCARNO: '68허3158',
      CARNO: '20허3024',
      ACCPERSONNAME: '',
      DATA_KEY: '306',
      CARNAMEMSTNAME: '투싼 2WD 2000 VGT JX 기본형 AT 디젤',
      RENTDATE: '20111229',
      UNIT24: '190000',
      TERMTYPE: 'S',
      NETSALEAMT: '273175',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '창원지점',
      SALEVATAMT: '27317',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '부산지점',
      ACCDATE: '',
      SALEAMT: '300492',
      STARTDATE: ''
    },
    {
      NO: '307',
      CARNAMEMSTNAME2: '소나타 Y20 렌터카 2000 LPI Luxury AT LPG',
      RETURNDATE: '20120106',
      ACCNO: '201201040420',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1330100760541',
      CONTRACTNO: 'SS1947120167946',
      RENTFEE: '165000',
      OBJCARNO: '63허1590',
      CARNO: '63허5286',
      ACCPERSONNAME: '정해성',
      DATA_KEY: '307',
      CARNAMEMSTNAME: 'NEW SM5 렌터카 2000 CVTC Ⅱ LPLi 고급형 AT LPG',
      RENTDATE: '20120104',
      UNIT24: '165000',
      TERMTYPE: 'S',
      NETSALEAMT: '114273',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '청원서울예약소',
      SALEVATAMT: '11427',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '창원지점',
      ACCDATE: '20120104',
      SALEAMT: '125700',
      STARTDATE: ''
    },
    {
      NO: '308',
      CARNAMEMSTNAME2: '그랜져 THE LUXURY 2700 LPI 렌터카 Q270 모범형 PACKⅡ AT LPG',
      RETURNDATE: '20120106',
      ACCNO: '201112242866',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1130101163651',
      CONTRACTNO: 'SS1476120162120',
      RENTFEE: '266000',
      OBJCARNO: '63허7458',
      CARNO: '32허5896',
      ACCPERSONNAME: '김대윤',
      DATA_KEY: '308',
      CARNAMEMSTNAME: '그랜져TG 2700 LPI Q270 모범형 PACK 2 AT LPG',
      RENTDATE: '20120103',
      UNIT24: '266000',
      TERMTYPE: 'S',
      NETSALEAMT: '237600',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: 'MT기획팀',
      SALEVATAMT: '23760',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '수원지점',
      ACCDATE: '20111224',
      SALEAMT: '261360',
      STARTDATE: ''
    },
    {
      NO: '309',
      CARNAMEMSTNAME2: '제네시스 3300 람다 BH330 GRAND PRIME PACK AT 휘발유/LPG',
      RETURNDATE: '20120105',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1476120162125',
      RENTFEE: '399000',
      OBJCARNO: '60허5360',
      CARNO: '32허4474',
      ACCPERSONNAME: '',
      DATA_KEY: '309',
      CARNAMEMSTNAME: '제네시스 3300 람다 BH330 GRAND PRIME PACK AT 휘발유',
      RENTDATE: '20120103',
      UNIT24: '399000',
      TERMTYPE: 'S',
      NETSALEAMT: '264909',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: 'MT기획팀',
      SALEVATAMT: '26491',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '동대문지점',
      ACCDATE: '',
      SALEAMT: '291400',
      STARTDATE: ''
    },
    {
      NO: '310',
      CARNAMEMSTNAME2: 'K7 The Prestige 3000 V6 람다 3.0GDI 럭셔리 AT 휘발유',
      RETURNDATE: '20120106',
      ACCNO: '201201030235',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'SS1290110933137',
      CONTRACTNO: 'SS1280120161405',
      RENTFEE: '160000',
      OBJCARNO: '62허4837',
      CARNO: '17허8653',
      ACCPERSONNAME: '이준엽',
      DATA_KEY: '310',
      CARNAMEMSTNAME: 'K5 2000 I4 세타 Ⅱ 스마트 스페셜 AT 휘발유',
      RENTDATE: '20120104',
      UNIT24: '292000',
      TERMTYPE: 'S',
      NETSALEAMT: '125491',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '순천여수지점',
      SALEVATAMT: '12549',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'M',
      DEPTNAME: '여수공항영업소',
      ACCDATE: '20120103',
      SALEAMT: '138040',
      STARTDATE: ''
    },
    {
      NO: '311',
      CARNAMEMSTNAME2: '베라크루즈 4WD 3000 E-VGT 300VXL Premium AT 디젤',
      RETURNDATE: '20120106',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1945120162129',
      RENTFEE: '349000',
      OBJCARNO: '44허1299',
      CARNO: '52허5611',
      ACCPERSONNAME: '',
      DATA_KEY: '311',
      CARNAMEMSTNAME: '모하비 4WD 3000 V6 E-VGT JV300 AT 디젤',
      RENTDATE: '20120105',
      UNIT24: '349000',
      TERMTYPE: 'S',
      NETSALEAMT: '111600',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '일산탄현예약소',
      SALEVATAMT: '11160',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '영업3팀',
      ACCDATE: '',
      SALEAMT: '122760',
      STARTDATE: ''
    },
    {
      NO: '312',
      CARNAMEMSTNAME2: 'SM5 New Impression 렌터카 2000 LPLi 고급형 AT LPG',
      RETURNDATE: '20120109',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1476120162124',
      RENTFEE: '165000',
      OBJCARNO: '41허5599',
      CARNO: '44허1005',
      ACCPERSONNAME: '',
      DATA_KEY: '312',
      CARNAMEMSTNAME: '소나타 Y20 렌터카 2000 LPI Luxury AT LPG',
      RENTDATE: '20120103',
      UNIT24: '150000',
      TERMTYPE: 'S',
      NETSALEAMT: '276945',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: 'MT기획팀',
      SALEVATAMT: '27695',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '영업3팀',
      ACCDATE: '',
      SALEAMT: '304640',
      STARTDATE: ''
    },
    {
      NO: '313',
      CARNAMEMSTNAME2: '5G 그랜져 3000 LPI HG300 렌터카 Executive AT LPG',
      RETURNDATE: '20120105',
      ACCNO: '201112303727',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1180111209723',
      CONTRACTNO: 'SS1974120160028',
      RENTFEE: '292000',
      OBJCARNO: '08허1560',
      CARNO: '52허5906',
      ACCPERSONNAME: '김현철',
      DATA_KEY: '313',
      CARNAMEMSTNAME: '5G 그랜져 3000 LPI HG300 렌터카 Prime AT LPG',
      RENTDATE: '20120102',
      UNIT24: '292000',
      TERMTYPE: 'S',
      NETSALEAMT: '269338',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '성남단대역예약소',
      SALEVATAMT: '26934',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '천안아산지점',
      ACCDATE: '20111230',
      SALEAMT: '296272',
      STARTDATE: ''
    },
    {
      NO: '314',
      CARNAMEMSTNAME2: '5G 그랜져 3000 LPI HG300 렌터카 Executive AT LPG',
      RETURNDATE: '20120106',
      ACCNO: '201201050566',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1170111007719',
      CONTRACTNO: 'SS1921120162268',
      RENTFEE: '292000',
      OBJCARNO: '12허4681',
      CARNO: '12허4479',
      ACCPERSONNAME: '김현철',
      DATA_KEY: '314',
      CARNAMEMSTNAME: 'K7 렌터카 2700 V6 뮤 VG270 럭셔리 AT LPG',
      RENTDATE: '20120105',
      UNIT24: '292000',
      TERMTYPE: 'S',
      NETSALEAMT: '123200',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '안산사동예약소',
      SALEVATAMT: '12320',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '청주지점',
      ACCDATE: '20120105',
      SALEAMT: '135520',
      STARTDATE: ''
    },
    {
      NO: '315',
      CARNAMEMSTNAME2: '뉴프라이드(5DR) 1500 VGT LX AT 디젤',
      RETURNDATE: '20120106',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1862120162808',
      RENTFEE: '150000',
      OBJCARNO: '32허2324',
      CARNO: '59허1917',
      ACCPERSONNAME: '',
      DATA_KEY: '315',
      CARNAMEMSTNAME: '소나타 N20 2000 LPI LUX 기본형 AT LPG',
      RENTDATE: '20120105',
      UNIT24: '99000',
      TERMTYPE: 'S',
      NETSALEAMT: '39709',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '대구동구',
      SALEVATAMT: '3971',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '영업2팀',
      ACCDATE: '',
      SALEAMT: '43680',
      STARTDATE: ''
    },
    {
      NO: '316',
      CARNAMEMSTNAME2: '소나타 트랜스폼 N20 2000 LPI Deluxe AT LPG',
      RETURNDATE: '20120106',
      ACCNO: '201201040416',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1460080829992',
      CONTRACTNO: 'SS1848120162903',
      RENTFEE: '150000',
      OBJCARNO: '41허3635',
      CARNO: '59허2197',
      ACCPERSONNAME: '김현철',
      DATA_KEY: '316',
      CARNAMEMSTNAME: '소나타 N20 2000 LPI LUX 기본형 AT LPG',
      RENTDATE: '20120104',
      UNIT24: '150000',
      TERMTYPE: 'S',
      NETSALEAMT: '122400',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '수원삼정예약소',
      SALEVATAMT: '12240',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업1팀',
      ACCDATE: '20120103',
      SALEAMT: '134640',
      STARTDATE: ''
    },
    {
      NO: '317',
      CARNAMEMSTNAME2: '뉴프라이드(5DR) 1500 VGT LX AT 디젤',
      RETURNDATE: '20120104',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1956120160759',
      RENTFEE: '99000',
      OBJCARNO: '28허2346',
      CARNO: '41허1716',
      ACCPERSONNAME: '',
      DATA_KEY: '317',
      CARNAMEMSTNAME: '뉴프라이드(5DR) 1500 VGT LX AT 디젤',
      RENTDATE: '20120103',
      UNIT24: '99000',
      TERMTYPE: 'S',
      NETSALEAMT: '33091',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '상봉예약소',
      SALEVATAMT: '3309',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '영업2팀',
      ACCDATE: '',
      SALEAMT: '36400',
      STARTDATE: ''
    },
    {
      NO: '318',
      CARNAMEMSTNAME2: '그랜드 스타렉스 12P WAGON 2500 VGT CVX Deluxe AT 디젤',
      RETURNDATE: '20120109',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1891120162580',
      RENTFEE: '219000',
      OBJCARNO: '72허6153',
      CARNO: '72허6248',
      ACCPERSONNAME: '',
      DATA_KEY: '318',
      CARNAMEMSTNAME: '그랜드 스타렉스 12P WAGON 2500 VGT CVX Deluxe AT 디젤',
      RENTDATE: '20120105',
      UNIT24: '219000',
      TERMTYPE: 'S',
      NETSALEAMT: '267385',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '시흥정왕예약소',
      SALEVATAMT: '26739',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '부천지점',
      ACCDATE: '',
      SALEAMT: '294124',
      STARTDATE: ''
    },
    {
      NO: '319',
      CARNAMEMSTNAME2: '엑센트 1600 VGT PREMIER AT 디젤',
      RETURNDATE: '20120106',
      ACCNO: '201201040451',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1230110905915',
      CONTRACTNO: 'SS1130120162685',
      RENTFEE: '116000',
      OBJCARNO: '45허4433',
      CARNO: '41허5534',
      ACCPERSONNAME: '윤원재',
      DATA_KEY: '319',
      CARNAMEMSTNAME: 'i30 1600 VGT Luxury AT 디젤',
      RENTDATE: '20120104',
      UNIT24: '99000',
      TERMTYPE: 'S',
      NETSALEAMT: '69327',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '수원지점',
      SALEVATAMT: '6933',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '평택지점',
      ACCDATE: '20120103',
      SALEAMT: '76260',
      STARTDATE: ''
    },
    {
      NO: '320',
      CARNAMEMSTNAME2: 'All New 모닝 1000 MPI VAN 고급형 AT 휘발유',
      RETURNDATE: '20120106',
      ACCNO: '201112151534',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1320110805356',
      CONTRACTNO: 'SS1837120161491',
      RENTFEE: '99000',
      OBJCARNO: '39허4266',
      CARNO: '41허5412',
      ACCPERSONNAME: '이준엽',
      DATA_KEY: '320',
      CARNAMEMSTNAME: '뉴아반떼 1600 VVT S16 LUXURY  AT 휘발유',
      RENTDATE: '20120104',
      UNIT24: '95000',
      TERMTYPE: 'S',
      NETSALEAMT: '62913',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '부산태원',
      SALEVATAMT: '6291',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '포항지점',
      ACCDATE: '20111215',
      SALEAMT: '69204',
      STARTDATE: ''
    },
    {
      NO: '321',
      CARNAMEMSTNAME2: '소나타 트랜스폼 N20 2000 LPI 일반형 AT LPG',
      RETURNDATE: '20120110',
      ACCNO: '201201040403',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1260100861090',
      CONTRACTNO: 'SS1260120162789',
      RENTFEE: '150000',
      OBJCARNO: '42허5511',
      CARNO: '42허5404',
      ACCPERSONNAME: '박수호',
      DATA_KEY: '321',
      CARNAMEMSTNAME: '소나타 트랜스폼 N20 2000 LPI Luxury AT LPG',
      RENTDATE: '20120104',
      UNIT24: '150000',
      TERMTYPE: 'S',
      NETSALEAMT: '257145',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '광주지점',
      SALEVATAMT: '25715',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '광주지점',
      ACCDATE: '20120104',
      SALEAMT: '282860',
      STARTDATE: ''
    },
    {
      NO: '322',
      CARNAMEMSTNAME2: '그랜드 스타렉스 12P WAGON 2500 VGT CVX Luxury AT 디젤',
      RETURNDATE: '20120109',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1952120163160',
      RENTFEE: '219000',
      OBJCARNO: '72허6323',
      CARNO: '73허5991',
      ACCPERSONNAME: '',
      DATA_KEY: '322',
      CARNAMEMSTNAME: '그랜드 스타렉스 12P WAGON 2500 VGT CVX Premium AT 디젤',
      RENTDATE: '20120104',
      UNIT24: '219000',
      TERMTYPE: 'S',
      NETSALEAMT: '325636',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '전주금암예약소',
      SALEVATAMT: '32564',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '영업1팀',
      ACCDATE: '',
      SALEAMT: '358200',
      STARTDATE: ''
    },
    {
      NO: '323',
      CARNAMEMSTNAME2: 'K5렌터카 2000 LPI 스마트 AT LPG',
      RETURNDATE: '20120109',
      ACCNO: '201201070827',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1300100659163',
      CONTRACTNO: 'SS1300120166180',
      RENTFEE: '165000',
      OBJCARNO: '20허3846',
      CARNO: '47허5572',
      ACCPERSONNAME: '박수호',
      DATA_KEY: '323',
      CARNAMEMSTNAME: 'K5렌터카 2000 LPI 디럭스 AT LPG',
      RENTDATE: '20120109',
      UNIT24: '165000',
      TERMTYPE: 'S',
      NETSALEAMT: '54545',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '울산지점',
      SALEVATAMT: '5455',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '울산지점',
      ACCDATE: '20120107',
      SALEAMT: '60000',
      STARTDATE: ''
    },
    {
      NO: '324',
      CARNAMEMSTNAME2: '5G 그랜져 3000 LPI HG300 렌터카 Executive AT LPG',
      RETURNDATE: '20120109',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1360120166462',
      RENTFEE: '292000',
      OBJCARNO: '27허5375',
      CARNO: '28허2954',
      ACCPERSONNAME: '',
      DATA_KEY: '324',
      CARNAMEMSTNAME: 'K7 렌터카 2700 V6 뮤 VG270 럭셔리 AT LPG',
      RENTDATE: '20120109',
      UNIT24: '292000',
      TERMTYPE: 'S',
      NETSALEAMT: '88000',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '진주사천지점',
      SALEVATAMT: '8800',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '진주사천지점',
      ACCDATE: '',
      SALEAMT: '96800',
      STARTDATE: ''
    },
    {
      NO: '325',
      CARNAMEMSTNAME2: '봉고Ⅲ 1톤 4X4 더블캡 2900 CRDI 장축 GX 고급형 MT 디젤',
      RETURNDATE: '20120106',
      ACCNO: '201112232641',
      REPAIRNO: '',
      DISCOUNTRATE: '50',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1476120163227',
      RENTFEE: '190000',
      OBJCARNO: '86우8937',
      CARNO: '15허2931',
      ACCPERSONNAME: '김선연',
      DATA_KEY: '325',
      CARNAMEMSTNAME: '액티언 2000 XVT CLUB (2WD) AT 디젤',
      RENTDATE: '20120105',
      UNIT24: '0',
      TERMTYPE: 'S',
      NETSALEAMT: '88636',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: 'MT기획팀',
      SALEVATAMT: '8864',
      REPAIRPERSONNAME: '',
      PROMOCODE: '리스대차',
      TERMTYPE2: '',
      DEPTNAME: 'AJ캐피탈',
      ACCDATE: '20111222',
      SALEAMT: '97500',
      STARTDATE: ''
    },
    {
      NO: '326',
      CARNAMEMSTNAME2: '뉴 카니발R 9P 2200 E-VGT GX AT 디젤',
      RETURNDATE: '20120103',
      ACCNO: '201112273280',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1410100962002',
      CONTRACTNO: 'SS1410111253508',
      RENTFEE: '317000',
      OBJCARNO: '63허3516',
      CARNO: '72허6331',
      ACCPERSONNAME: '김대윤',
      DATA_KEY: '326',
      CARNAMEMSTNAME: '그랜드 카니발 11P 2900 VGT President AT 디젤',
      RENTDATE: '20111228',
      UNIT24: '270000',
      TERMTYPE: 'S',
      NETSALEAMT: '481091',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '부천지점',
      SALEVATAMT: '48109',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '부천지점',
      ACCDATE: '20111227',
      SALEAMT: '529200',
      STARTDATE: ''
    },
    {
      NO: '327',
      CARNAMEMSTNAME2: '싼타페 4WD 2200 VGT MLX 고급형 AT 디젤',
      RETURNDATE: '20120102',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1260111253654',
      RENTFEE: '307000',
      OBJCARNO: '32허4406',
      CARNO: '56허8334',
      ACCPERSONNAME: '',
      DATA_KEY: '327',
      CARNAMEMSTNAME: '오피러스 PREMIUM 2700 V6 뮤 GH270 스페셜-럭셔리 AT 휘발유',
      RENTDATE: '20111226',
      UNIT24: '199000',
      TERMTYPE: 'S',
      NETSALEAMT: '348218',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '광주지점',
      SALEVATAMT: '34822',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '영업4팀',
      ACCDATE: '',
      SALEAMT: '383040',
      STARTDATE: ''
    },
    {
      NO: '328',
      CARNAMEMSTNAME2: '뉴카렌스 2000 LPI GX 고급형 AT LPG',
      RETURNDATE: '20120102',
      ACCNO: '201112192019',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1140110266745',
      CONTRACTNO: 'SS1934111255698',
      RENTFEE: '165000',
      OBJCARNO: '04허6721',
      CARNO: '06허2615',
      ACCPERSONNAME: '김현철',
      DATA_KEY: '328',
      CARNAMEMSTNAME: 'K5렌터카 2000 LPI 디럭스 AT LPG',
      RENTDATE: '20111224',
      UNIT24: '165000',
      TERMTYPE: 'S',
      NETSALEAMT: '392727',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '의왕고천예약소',
      SALEVATAMT: '39273',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '안산지점',
      ACCDATE: '20111219',
      SALEAMT: '432000',
      STARTDATE: ''
    },
    {
      NO: '329',
      CARNAMEMSTNAME2: '소나타 Y20 렌터카 2000 LPI Premier AT LPG',
      RETURNDATE: '20120109',
      ACCNO: '201201040432',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1433110602679',
      CONTRACTNO: 'SS1869120164142',
      RENTFEE: '165000',
      OBJCARNO: '59허9002',
      CARNO: '60허6544',
      ACCPERSONNAME: '윤원재',
      DATA_KEY: '329',
      CARNAMEMSTNAME: '소나타 Y20 렌터카 2000 LPI Luxury AT LPG',
      RENTDATE: '20120105',
      UNIT24: '165000',
      TERMTYPE: 'S',
      NETSALEAMT: '185440',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '안산상록예약소',
      SALEVATAMT: '18544',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '안양지점',
      ACCDATE: '20120103',
      SALEAMT: '203984',
      STARTDATE: ''
    },
    {
      NO: '330',
      CARNAMEMSTNAME2: '소나타 Y20 2000 VVT Grand AT 휘발유',
      RETURNDATE: '20120109',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1476120165701',
      RENTFEE: '160000',
      OBJCARNO: '05허4972',
      CARNO: '05허4971',
      ACCPERSONNAME: '',
      DATA_KEY: '330',
      CARNAMEMSTNAME: '소나타 Y20 2000 VVT Prime 고급형 AT 휘발유',
      RENTDATE: '20120106',
      UNIT24: '160000',
      TERMTYPE: 'S',
      NETSALEAMT: '152382',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: 'MT기획팀',
      SALEVATAMT: '15238',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '영업3팀',
      ACCDATE: '',
      SALEAMT: '167620',
      STARTDATE: ''
    },
    {
      NO: '331',
      CARNAMEMSTNAME2: '모닝 1000 SOHC LX 기본 블랙프리미엄 AT 휘발유',
      RETURNDATE: '20120110',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1476120165703',
      RENTFEE: '95000',
      OBJCARNO: '21허5657',
      CARNO: '41허2404',
      ACCPERSONNAME: '',
      DATA_KEY: '331',
      CARNAMEMSTNAME: '클릭 1400 DOHC w 고급형 AT 휘발유',
      RENTDATE: '20120106',
      UNIT24: '95000',
      TERMTYPE: 'S',
      NETSALEAMT: '97662',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: 'MT기획팀',
      SALEVATAMT: '9766',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '수원지점',
      ACCDATE: '',
      SALEAMT: '107428',
      STARTDATE: ''
    },
    {
      NO: '332',
      CARNAMEMSTNAME2: 'K7 렌터카 2700 V6 뮤 VG270 프레스티지 AT LPG',
      RETURNDATE: '20120105',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1974120161001',
      RENTFEE: '292000',
      OBJCARNO: '22허1343',
      CARNO: '68허3216',
      ACCPERSONNAME: '',
      DATA_KEY: '332',
      CARNAMEMSTNAME: 'K7 렌터카 2700 V6 뮤 VG270 럭셔리 AT LPG',
      RENTDATE: '20120103',
      UNIT24: '292000',
      TERMTYPE: 'S',
      NETSALEAMT: '175091',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '성남단대역예약소',
      SALEVATAMT: '17509',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '대전지점',
      ACCDATE: '',
      SALEAMT: '192600',
      STARTDATE: ''
    },
    {
      NO: '333',
      CARNAMEMSTNAME2: '',
      RETURNDATE: '20120105',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '50',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1300111261325',
      RENTFEE: '190000',
      OBJCARNO: '',
      CARNO: '20허3091',
      ACCPERSONNAME: '',
      DATA_KEY: '333',
      CARNAMEMSTNAME: '투싼 2WD 2000 VGT MX 고급형 AT 디젤',
      RENTDATE: '20111226',
      UNIT24: '0',
      TERMTYPE: 'S',
      NETSALEAMT: '549091',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '울산지점',
      SALEVATAMT: '54909',
      REPAIRPERSONNAME: '',
      PROMOCODE: '리스대차',
      TERMTYPE2: '',
      DEPTNAME: '',
      ACCDATE: '',
      SALEAMT: '604000',
      STARTDATE: ''
    },
    {
      NO: '334',
      CARNAMEMSTNAME2: '모닝 1000 SOHC VAN AT 휘발유',
      RETURNDATE: '20120105',
      ACCNO: '201201020113',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LD1450090337282',
      CONTRACTNO: 'SS1904120159440',
      RENTFEE: '150000',
      OBJCARNO: '41허4953',
      CARNO: '30허2688',
      ACCPERSONNAME: '이준엽',
      DATA_KEY: '334',
      CARNAMEMSTNAME: '소나타 트랜스폼 N20 2000 LPI Deluxe AT LPG',
      RENTDATE: '20120102',
      UNIT24: '95000',
      TERMTYPE: 'S',
      NETSALEAMT: '80295',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '원주순호예약소',
      SALEVATAMT: '8029',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업1팀',
      ACCDATE: '20111201',
      SALEAMT: '88324',
      STARTDATE: ''
    },
    {
      NO: '335',
      CARNAMEMSTNAME2: '소나타 Y20 렌터카 2000 LPI Deluxe AT LPG',
      RETURNDATE: '20120103',
      ACCNO: '201112303710',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1434110603351',
      CONTRACTNO: 'SS1945111258877',
      RENTFEE: '165000',
      OBJCARNO: '52허7276',
      CARNO: '52허6290',
      ACCPERSONNAME: '김현철',
      DATA_KEY: '335',
      CARNAMEMSTNAME: '소나타 Y20 렌터카 2000 LPI Luxury AT LPG',
      RENTDATE: '20111230',
      UNIT24: '165000',
      TERMTYPE: 'S',
      NETSALEAMT: '185422',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '일산탄현예약소',
      SALEVATAMT: '18542',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '일산지점',
      ACCDATE: '20111230',
      SALEAMT: '203964',
      STARTDATE: ''
    },
    {
      NO: '336',
      CARNAMEMSTNAME2: '엑센트 1400 CVVT LUXURY AT 휘발유',
      RETURNDATE: '20120109',
      ACCNO: '201201050584',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1457111209141',
      CONTRACTNO: 'SS1913120162270',
      RENTFEE: '109000',
      OBJCARNO: '52허5340',
      CARNO: '52허5670',
      ACCPERSONNAME: '김대윤',
      DATA_KEY: '336',
      CARNAMEMSTNAME: '아반떼 M16 1600 LPI 렌터카 LUXURY AT LPG',
      RENTDATE: '20120105',
      UNIT24: '99000',
      TERMTYPE: 'S',
      NETSALEAMT: '106320',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '성동성수예약소',
      SALEVATAMT: '10632',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '부천지점',
      ACCDATE: '20120105',
      SALEAMT: '116952',
      STARTDATE: ''
    },
    {
      NO: '337',
      CARNAMEMSTNAME2: '투싼 ix 4WD 2000 E-VGT X20 Luxury AT 디젤',
      RETURNDATE: '20120109',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1935120183042',
      RENTFEE: '190000',
      OBJCARNO: '56허8958',
      CARNO: '60허6754',
      ACCPERSONNAME: '',
      DATA_KEY: '337',
      CARNAMEMSTNAME: '스포티지R 4WD 2000 E-VGT LX AT 디젤',
      RENTDATE: '20120103',
      UNIT24: '190000',
      TERMTYPE: 'S',
      NETSALEAMT: '348218',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '평택송화예약소',
      SALEVATAMT: '34822',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '평택지점',
      ACCDATE: '',
      SALEAMT: '383040',
      STARTDATE: ''
    },
    {
      NO: '338',
      CARNAMEMSTNAME2: 'SM5 New Impression 2000 CVTC SE AT 휘발유',
      RETURNDATE: '20120110',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1476120162112',
      RENTFEE: '142000',
      OBJCARNO: '68허3045',
      CARNO: '41허4596',
      ACCPERSONNAME: '',
      DATA_KEY: '338',
      CARNAMEMSTNAME: 'SM5 New Impression 2000 CVTC LE AT 휘발유',
      RENTDATE: '20120103',
      UNIT24: '142000',
      TERMTYPE: 'S',
      NETSALEAMT: '271604',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: 'MT기획팀',
      SALEVATAMT: '27160',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '영업3팀',
      ACCDATE: '',
      SALEAMT: '298764',
      STARTDATE: ''
    },
    {
      NO: '339',
      CARNAMEMSTNAME2: '그랜드 카니발R 11P 2200 E-VGT GLX AT 디젤',
      RETURNDATE: '20120106',
      ACCNO: '201112283388',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1400100962217',
      CONTRACTNO: 'SS1511120159737',
      RENTFEE: '270000',
      OBJCARNO: '72허9430',
      CARNO: '60허5289',
      ACCPERSONNAME: '김대윤',
      DATA_KEY: '339',
      CARNAMEMSTNAME: '뉴 카니발R 9P 2200 E-VGT GX AT 디젤',
      RENTDATE: '20120102',
      UNIT24: '317000',
      TERMTYPE: 'S',
      NETSALEAMT: '329193',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '서울대지점',
      SALEVATAMT: '32919',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영등포지점',
      ACCDATE: '20111228',
      SALEAMT: '362112',
      STARTDATE: ''
    },
    {
      NO: '340',
      CARNAMEMSTNAME2: '에쿠스 TRUE PRESTIGE 3800 V6 람다 VS 380 프라임 VIP PACK AT 휘발유',
      RETURNDATE: '20120104',
      ACCNO: '201112303696',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1420100354425',
      CONTRACTNO: 'SS1878111259250',
      RENTFEE: '488000',
      OBJCARNO: '56허9003',
      CARNO: '39허3254',
      ACCPERSONNAME: '김선연',
      DATA_KEY: '340',
      CARNAMEMSTNAME: '에쿠스 TRUE PRESTIGE 3800 GDI VS 380 프라임 AT 휘발유',
      RENTDATE: '20111230',
      UNIT24: '488000',
      TERMTYPE: 'S',
      NETSALEAMT: '634382',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '성수트루예약소',
      SALEVATAMT: '63438',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업2팀',
      ACCDATE: '20111230',
      SALEAMT: '697820',
      STARTDATE: ''
    },
    {
      NO: '341',
      CARNAMEMSTNAME2: '아반떼 M16 GDi 1600 GDI DELUXE AT 휘발유',
      RETURNDATE: '20120104',
      ACCNO: '201112263028',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1180101163610',
      CONTRACTNO: 'SS1180111250510',
      RENTFEE: '99000',
      OBJCARNO: '60허6285',
      CARNO: '60허6155',
      ACCPERSONNAME: '정해성',
      DATA_KEY: '341',
      CARNAMEMSTNAME: '라세티 프리미어 1600 DOHC CDX 고급형 AT 휘발유',
      RENTDATE: '20111226',
      UNIT24: '109000',
      TERMTYPE: 'S',
      NETSALEAMT: '241400',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '천안아산지점',
      SALEVATAMT: '24140',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '천안아산지점',
      ACCDATE: '20111226',
      SALEAMT: '265540',
      STARTDATE: ''
    },
    {
      NO: '342',
      CARNAMEMSTNAME2: '5G 그랜져 3000 LPI HG300 렌터카 Executive AT LPG',
      RETURNDATE: '20120103',
      ACCNO: '201112283393',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1140110592352',
      CONTRACTNO: 'SS1913111253166',
      RENTFEE: '488000',
      OBJCARNO: '05허7728',
      CARNO: '05허4079',
      ACCPERSONNAME: '김대윤',
      DATA_KEY: '342',
      CARNAMEMSTNAME: '에쿠스 TRUE PRESTIGE 3800 V6 람다 VS 380 럭셔리 AT 휘발유',
      RENTDATE: '20111228',
      UNIT24: '292000',
      TERMTYPE: 'S',
      NETSALEAMT: '501065',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '성동성수예약소',
      SALEVATAMT: '50107',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '안산지점',
      ACCDATE: '20111228',
      SALEAMT: '551172',
      STARTDATE: ''
    },
    {
      NO: '343',
      CARNAMEMSTNAME2: '소나타 Y20 렌터카 2000 LPI Top AT LPG',
      RETURNDATE: '20120102',
      ACCNO: '201112232721',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1460100962351',
      CONTRACTNO: 'SS1433111251017',
      RENTFEE: '292000',
      OBJCARNO: '60허5892',
      CARNO: '56허9492',
      ACCPERSONNAME: '정해성',
      DATA_KEY: '343',
      CARNAMEMSTNAME: 'K7 2700 V6 뮤 VG270 럭셔리 AT 휘발유',
      RENTDATE: '20111226',
      UNIT24: '165000',
      TERMTYPE: 'S',
      NETSALEAMT: '305455',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '안양지점',
      SALEVATAMT: '30545',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: 'SU6팀',
      ACCDATE: '20111223',
      SALEAMT: '336000',
      STARTDATE: ''
    },
    {
      NO: '344',
      CARNAMEMSTNAME2: '그랜져TG 2700 DOHC Q270 LUXURY AT 휘발유',
      RETURNDATE: '20120105',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1952120160491',
      RENTFEE: '160000',
      OBJCARNO: '32허7941',
      CARNO: '62허5265',
      ACCPERSONNAME: '',
      DATA_KEY: '344',
      CARNAMEMSTNAME: 'K5 2000 I4 세타 Ⅱ 스마트 스페셜 AT 휘발유',
      RENTDATE: '20120103',
      UNIT24: '266000',
      TERMTYPE: 'S',
      NETSALEAMT: '104364',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '전주금암예약소',
      SALEVATAMT: '10436',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '영업4팀',
      ACCDATE: '',
      SALEAMT: '114800',
      STARTDATE: ''
    },
    {
      NO: '345',
      CARNAMEMSTNAME2: 'SM5 New Impression 2000 CVTC LE AT 휘발유',
      RETURNDATE: '20120106',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1853120161005',
      RENTFEE: '165000',
      OBJCARNO: '13허2297',
      CARNO: '13허3558',
      ACCPERSONNAME: '',
      DATA_KEY: '345',
      CARNAMEMSTNAME: '소나타 Y20 렌터카 2000 LPI Luxury AT LPG',
      RENTDATE: '20120103',
      UNIT24: '142000',
      TERMTYPE: 'S',
      NETSALEAMT: '126625',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '포항마스터예약소',
      SALEVATAMT: '12663',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '포항지점',
      ACCDATE: '',
      SALEAMT: '139288',
      STARTDATE: ''
    },
    {
      NO: '346',
      CARNAMEMSTNAME2: '모닝 1000 LPI LX 기본 블랙프리미엄 AT LPG',
      RETURNDATE: '20120102',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1855111255053',
      RENTFEE: '150000',
      OBJCARNO: '32허8108',
      CARNO: '41허3814',
      ACCPERSONNAME: '',
      DATA_KEY: '346',
      CARNAMEMSTNAME: '소나타 트랜스폼 N20 2000 LPI Deluxe AT LPG',
      RENTDATE: '20111223',
      UNIT24: '95000',
      TERMTYPE: 'S',
      NETSALEAMT: '235276',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '부산연산역',
      SALEVATAMT: '23528',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '창원지점',
      ACCDATE: '',
      SALEAMT: '258804',
      STARTDATE: ''
    },
    {
      NO: '347',
      CARNAMEMSTNAME2: 'K7 2700 V6 뮤 VG270 프레스티지 AT 휘발유',
      RETURNDATE: '20120110',
      ACCNO: '201201030294',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1450101163438',
      CONTRACTNO: 'SS1819120161068',
      RENTFEE: '292000',
      OBJCARNO: '26허5351',
      CARNO: '52허5044',
      ACCPERSONNAME: '이준엽',
      DATA_KEY: '347',
      CARNAMEMSTNAME: 'K7 The Prestige 렌터카 3000 V6 람다 3.0LPI 럭셔리 AT LPG',
      RENTDATE: '20120103',
      UNIT24: '292000',
      TERMTYPE: 'S',
      NETSALEAMT: '501160',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '공주지점',
      SALEVATAMT: '50116',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업1팀',
      ACCDATE: '20120103',
      SALEAMT: '551276',
      STARTDATE: ''
    },
    {
      NO: '348',
      CARNAMEMSTNAME2: 'All New 모닝 1000 MPI 스마트 스페셜 AT 휘발유',
      RETURNDATE: '20120106',
      ACCNO: '201201020182',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1453110704051',
      CONTRACTNO: 'SS1903120161081',
      RENTFEE: '99000',
      OBJCARNO: '06허4810',
      CARNO: '41허4156',
      ACCPERSONNAME: '김선연',
      DATA_KEY: '348',
      CARNAMEMSTNAME: '뉴아반떼 1600 VVT E16 VALUE AT 휘발유/LPG',
      RENTDATE: '20120104',
      UNIT24: '95000',
      TERMTYPE: 'S',
      NETSALEAMT: '57455',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '구로현주예약소',
      SALEVATAMT: '5745',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업2팀',
      ACCDATE: '20111226',
      SALEAMT: '63200',
      STARTDATE: ''
    },
    {
      NO: '349',
      CARNAMEMSTNAME2: 'All New 프라이드 1400 MPI 디럭스 AT 휘발유',
      RETURNDATE: '20120107',
      ACCNO: '201201020179',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1351111108061',
      CONTRACTNO: 'SS1837120162380',
      RENTFEE: '99000',
      OBJCARNO: '47허6328',
      CARNO: '47허5609',
      ACCPERSONNAME: '어성환',
      DATA_KEY: '349',
      CARNAMEMSTNAME: '뉴프라이드 1500 VGT LX AT 디젤',
      RENTDATE: '20120105',
      UNIT24: '99000',
      TERMTYPE: 'S',
      NETSALEAMT: '75615',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '부산태원',
      SALEVATAMT: '7561',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '해운대지점',
      ACCDATE: '20120102',
      SALEAMT: '83176',
      STARTDATE: ''
    },
    {
      NO: '350',
      CARNAMEMSTNAME2: 'New SM5  2000 CVTC Ⅱ SE AT 휘발유',
      RETURNDATE: '20120110',
      ACCNO: '201201030298',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1450100860924',
      CONTRACTNO: 'SS1965120167492',
      RENTFEE: '160000',
      OBJCARNO: '60허5653',
      CARNO: '13허2875',
      ACCPERSONNAME: '김대윤',
      DATA_KEY: '350',
      CARNAMEMSTNAME: 'K5 2000 I4 세타 Ⅱ 스마트 스페셜 AT 휘발유',
      RENTDATE: '20120104',
      UNIT24: '160000',
      TERMTYPE: 'S',
      NETSALEAMT: '295273',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '김포장기예약소',
      SALEVATAMT: '29527',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업5팀',
      ACCDATE: '20111227',
      SALEAMT: '324800',
      STARTDATE: ''
    },
    {
      NO: '351',
      CARNAMEMSTNAME2: '봉고1톤 더블캡 2900 CRDI 장축 GX 고급형 MT 디젤',
      RETURNDATE: '20120106',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '50',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1955111253829',
      RENTFEE: '199000',
      OBJCARNO: '82고9532',
      CARNO: '26허7723',
      ACCPERSONNAME: '',
      DATA_KEY: '351',
      CARNAMEMSTNAME: '뉴싼타페 2000 VGT CLX 고급형 AT 디젤',
      RENTDATE: '20111228',
      UNIT24: '0',
      TERMTYPE: 'S',
      NETSALEAMT: '638273',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '대구태정예약소',
      SALEVATAMT: '63827',
      REPAIRPERSONNAME: '',
      PROMOCODE: '리스대차',
      TERMTYPE2: '',
      DEPTNAME: 'AJ캐피탈',
      ACCDATE: '',
      SALEAMT: '702100',
      STARTDATE: ''
    },
    {
      NO: '352',
      CARNAMEMSTNAME2: '토스카 PREMIUM 6 2000 DOHC L6 2.0 SX AT 휘발유',
      RETURNDATE: '20120105',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1330111252932',
      RENTFEE: '160000',
      OBJCARNO: '28허2243',
      CARNO: '62허4990',
      ACCPERSONNAME: '',
      DATA_KEY: '352',
      CARNAMEMSTNAME: '소나타 Y20 2000 I4 세타 Ⅱ Prime AT 휘발유',
      RENTDATE: '20111228',
      UNIT24: '142000',
      TERMTYPE: 'S',
      NETSALEAMT: '309131',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '창원지점',
      SALEVATAMT: '30913',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '창원지점',
      ACCDATE: '',
      SALEAMT: '340044',
      STARTDATE: ''
    },
    {
      NO: '353',
      CARNAMEMSTNAME2: '아반떼 M16 1600 LPI 렌터카 DELUXE AT LPG',
      RETURNDATE: '20120104',
      ACCNO: '201112303608',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1250110805526',
      CONTRACTNO: 'SS1822111258675',
      RENTFEE: '165000',
      OBJCARNO: '52허4275',
      CARNO: '56허9665',
      ACCPERSONNAME: '이준엽',
      DATA_KEY: '353',
      CARNAMEMSTNAME: '소나타 Y20 렌터카 2000 LPI Luxury AT LPG',
      RENTDATE: '20111230',
      UNIT24: '109000',
      TERMTYPE: 'S',
      NETSALEAMT: '158342',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '대구하나',
      SALEVATAMT: '15834',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '대전지점',
      ACCDATE: '20111229',
      SALEAMT: '174176',
      STARTDATE: ''
    },
    {
      NO: '354',
      CARNAMEMSTNAME2: '소나타 트랜스폼 N20 2000 LPI 일반형 AT LPG',
      RETURNDATE: '20120110',
      ACCNO: '201201060708',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1080100659305',
      CONTRACTNO: 'SS1907120163593',
      RENTFEE: '165000',
      OBJCARNO: '05허5674',
      CARNO: '42허5460',
      ACCPERSONNAME: '이준엽',
      DATA_KEY: '354',
      CARNAMEMSTNAME: '소나타 Y20 렌터카 2000 LPI Premier AT LPG',
      RENTDATE: '20120106',
      UNIT24: '150000',
      TERMTYPE: 'S',
      NETSALEAMT: '182735',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '당진원당예약소',
      SALEVATAMT: '18273',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '강남지점',
      ACCDATE: '20120106',
      SALEAMT: '201008',
      STARTDATE: ''
    },
    {
      NO: '355',
      CARNAMEMSTNAME2: '소나타 Y20 렌터카 2000 LPI Deluxe AT LPG',
      RETURNDATE: '20120110',
      ACCNO: '201201060686',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1280100658688',
      CONTRACTNO: 'SS1180120163198',
      RENTFEE: '165000',
      OBJCARNO: '17허8594',
      CARNO: '56허8269',
      ACCPERSONNAME: '박수호',
      DATA_KEY: '355',
      CARNAMEMSTNAME: '소나타 Y20 렌터카 2000 LPI Deluxe AT LPG',
      RENTDATE: '20120106',
      UNIT24: '165000',
      TERMTYPE: 'S',
      NETSALEAMT: '206727',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '천안아산지점',
      SALEVATAMT: '20673',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '순천여수지점',
      ACCDATE: '20120106',
      SALEAMT: '227400',
      STARTDATE: ''
    },
    {
      NO: '356',
      CARNAMEMSTNAME2: '투싼 ix 2WD 2000 E-VGT X20 Luxury AT 디젤',
      RETURNDATE: '20120110',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1972120174014',
      RENTFEE: '190000',
      OBJCARNO: '20허3499',
      CARNO: '68허3364',
      ACCPERSONNAME: '',
      DATA_KEY: '356',
      CARNAMEMSTNAME: '스포티지R 4WD 2000 E-VGT LX AT 디젤',
      RENTDATE: '20120107',
      UNIT24: '190000',
      TERMTYPE: 'S',
      NETSALEAMT: '191520',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '(폐쇄)순천봉화예약소',
      SALEVATAMT: '19152',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '순천여수지점',
      ACCDATE: '',
      SALEAMT: '210672',
      STARTDATE: ''
    },
    {
      NO: '357',
      CARNAMEMSTNAME2: '그랜져TG 2400 DOHC Q240 DELUXE AT 휘발유',
      RETURNDATE: '20120106',
      ACCNO: '201201030308',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1470090439224',
      CONTRACTNO: 'SS1913120161191',
      RENTFEE: '266000',
      OBJCARNO: '41허5027',
      CARNO: '38허3359',
      ACCPERSONNAME: '김현철',
      DATA_KEY: '357',
      CARNAMEMSTNAME: '그랜져TG 2700 DOHC Q270 LUXURY AT 휘발유',
      RENTDATE: '20120103',
      UNIT24: '213000',
      TERMTYPE: 'S',
      NETSALEAMT: '190473',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '성동성수예약소',
      SALEVATAMT: '19047',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업2팀',
      ACCDATE: '20111209',
      SALEAMT: '209520',
      STARTDATE: ''
    },
    {
      NO: '358',
      CARNAMEMSTNAME2: '올란도 2000 ECOTEC LS 고급형 AT LPG',
      RETURNDATE: '20120104',
      ACCNO: '201201030365',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1200111108860',
      CONTRACTNO: 'SS1260120161210',
      RENTFEE: '99000',
      OBJCARNO: '52허5534',
      CARNO: '42허5432',
      ACCPERSONNAME: '어성환',
      DATA_KEY: '358',
      CARNAMEMSTNAME: '뉴아반떼 1600 VVT S16 LUXURY  AT 휘발유',
      RENTDATE: '20120103',
      UNIT24: '190000',
      TERMTYPE: 'S',
      NETSALEAMT: '33091',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '광주지점',
      SALEVATAMT: '3309',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '원주지점',
      ACCDATE: '20120103',
      SALEAMT: '36400',
      STARTDATE: ''
    },
    {
      NO: '359',
      CARNAMEMSTNAME2: '카운티 15P 3900 CRDI 롱바디 장축 TOUR MT 디젤',
      RETURNDATE: '20120106',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1937120161732',
      RENTFEE: '219000',
      OBJCARNO: '72허9219',
      CARNO: '79허3540',
      ACCPERSONNAME: '',
      DATA_KEY: '359',
      CARNAMEMSTNAME: '그랜드 스타렉스 12P WAGON 2500 VGT CVX Luxury AT 디젤',
      RENTDATE: '20120104',
      UNIT24: '0',
      TERMTYPE: 'S',
      NETSALEAMT: '158476',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '성수한국타이어예약소',
      SALEVATAMT: '15848',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '대전지점',
      ACCDATE: '',
      SALEAMT: '174324',
      STARTDATE: ''
    },
    {
      NO: '360',
      CARNAMEMSTNAME2: 'New SM5  2000 CVTC Ⅱ PE AT 휘발유',
      RETURNDATE: '20120103',
      ACCNO: '201112273263',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1420101264808',
      CONTRACTNO: 'SS1965111253576',
      RENTFEE: '160000',
      OBJCARNO: '60허6747',
      CARNO: '13허2875',
      ACCPERSONNAME: '윤원재',
      DATA_KEY: '360',
      CARNAMEMSTNAME: 'K5 2000 I4 세타 Ⅱ 스마트 스페셜 AT 휘발유',
      RENTDATE: '20111228',
      UNIT24: '160000',
      TERMTYPE: 'S',
      NETSALEAMT: '295273',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '김포장기예약소',
      SALEVATAMT: '29527',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: 'SU6팀',
      ACCDATE: '20111227',
      SALEAMT: '324800',
      STARTDATE: ''
    },
    {
      NO: '361',
      CARNAMEMSTNAME2: '엑센트 1600 VGT PREMIER AT 디젤',
      RETURNDATE: '20120105',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1433120161613',
      RENTFEE: '116000',
      OBJCARNO: '52허5746',
      CARNO: '04허5559',
      ACCPERSONNAME: '',
      DATA_KEY: '361',
      CARNAMEMSTNAME: 'i30 1600 VGT Luxury AT 디젤',
      RENTDATE: '20120104',
      UNIT24: '99000',
      TERMTYPE: 'S',
      NETSALEAMT: '33091',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '안양지점',
      SALEVATAMT: '3309',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '부천지점',
      ACCDATE: '',
      SALEAMT: '36400',
      STARTDATE: ''
    },
    {
      NO: '362',
      CARNAMEMSTNAME2: '뉴아반떼 1600 VGT E16 DELUXE AT 디젤',
      RETURNDATE: '20120105',
      ACCNO: '201112192078',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1240080627121',
      CONTRACTNO: 'SS1400120160363',
      RENTFEE: '116000',
      OBJCARNO: '16허7541',
      CARNO: '63허8865',
      ACCPERSONNAME: '김병준',
      DATA_KEY: '362',
      CARNAMEMSTNAME: 'i30 1600 VGT Luxury AT 디젤',
      RENTDATE: '20120102',
      UNIT24: '99000',
      TERMTYPE: 'S',
      NETSALEAMT: '89335',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '영등포지점',
      SALEVATAMT: '8933',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '대구지점(동대구역)',
      ACCDATE: '20111219',
      SALEAMT: '98268',
      STARTDATE: ''
    },
    {
      NO: '363',
      CARNAMEMSTNAME2: '아반떼 M16 1600 LPI 렌터카 LUXURY AT LPG',
      RETURNDATE: '20120103',
      ACCNO: '201112283462',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1020111209224',
      CONTRACTNO: 'SS1837111255807',
      RENTFEE: '109000',
      OBJCARNO: '52허5975',
      CARNO: '52허5627',
      ACCPERSONNAME: '박수호',
      DATA_KEY: '363',
      CARNAMEMSTNAME: '아반떼 M16 1600 LPI 렌터카 LUXURY AT LPG',
      RENTDATE: '20111229',
      UNIT24: '109000',
      TERMTYPE: 'S',
      NETSALEAMT: '168611',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '부산태원',
      SALEVATAMT: '16861',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '서대문지점',
      ACCDATE: '20111228',
      SALEAMT: '185472',
      STARTDATE: ''
    },
    {
      NO: '364',
      CARNAMEMSTNAME2: '오피러스 PREMIUM 3300 V6 람다 GH330 럭셔리 AT 휘발유/LPG',
      RETURNDATE: '20120105',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1848120161914',
      RENTFEE: '307000',
      OBJCARNO: '06허4533',
      CARNO: '63허6623',
      ACCPERSONNAME: '',
      DATA_KEY: '364',
      CARNAMEMSTNAME: '오피러스 PREMIUM 렌터카 2700 V6 뮤 GH270 럭셔리 AT LPG',
      RENTDATE: '20120103',
      UNIT24: '349000',
      TERMTYPE: 'S',
      NETSALEAMT: '202909',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '수원삼정예약소',
      SALEVATAMT: '20291',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '영업3팀',
      ACCDATE: '',
      SALEAMT: '223200',
      STARTDATE: ''
    },
    {
      NO: '365',
      CARNAMEMSTNAME2: '투싼 ix 4WD 2000 E-VGT X20 Luxury AT 디젤',
      RETURNDATE: '20120109',
      ACCNO: '201201040462',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1456110602819',
      CONTRACTNO: 'SS1853120161925',
      RENTFEE: '199000',
      OBJCARNO: '04허7612',
      CARNO: '04허1327',
      ACCPERSONNAME: '박수호',
      DATA_KEY: '365',
      CARNAMEMSTNAME: '싼타페 The Style 4WD 2200 E-VGT CLX DELUXE AT 디젤',
      RENTDATE: '20120104',
      UNIT24: '190000',
      TERMTYPE: 'S',
      NETSALEAMT: '267356',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '포항마스터예약소',
      SALEVATAMT: '26736',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업1팀',
      ACCDATE: '20120104',
      SALEAMT: '294092',
      STARTDATE: ''
    },
    {
      NO: '366',
      CARNAMEMSTNAME2: '알페온 3000 SIDI EL300 슈프림 AT 휘발유',
      RETURNDATE: '20120106',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1869120162026',
      RENTFEE: '266000',
      OBJCARNO: '68허3558',
      CARNO: '52허4214',
      ACCPERSONNAME: '',
      DATA_KEY: '366',
      CARNAMEMSTNAME: '5G 그랜져 2400 GDI HG240 LUXURY AT 휘발유',
      RENTDATE: '20120104',
      UNIT24: '292000',
      TERMTYPE: 'S',
      NETSALEAMT: '209440',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '안산상록예약소',
      SALEVATAMT: '20944',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '해운대지점',
      ACCDATE: '',
      SALEAMT: '230384',
      STARTDATE: ''
    },
    {
      NO: '367',
      CARNAMEMSTNAME2: '소나타 Y20 2000 VVT Prime 고급형 AT 휘발유',
      RETURNDATE: '20120104',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1891111256020',
      RENTFEE: '160000',
      OBJCARNO: '44허2044',
      CARNO: '44허2181',
      ACCPERSONNAME: '',
      DATA_KEY: '367',
      CARNAMEMSTNAME: '소나타 Y20 2000 VVT Premier 최고급형 AT 휘발유',
      RENTDATE: '20111230',
      UNIT24: '160000',
      TERMTYPE: 'S',
      NETSALEAMT: '237273',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '시흥정왕예약소',
      SALEVATAMT: '23727',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '영업5팀',
      ACCDATE: '',
      SALEAMT: '261000',
      STARTDATE: ''
    },
    {
      NO: '368',
      CARNAMEMSTNAME2: 'SM5 New Impression 렌터카 2000 LPLi 고급형 AT LPG',
      RETURNDATE: '20120109',
      ACCNO: '201201030292',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1410101062527',
      CONTRACTNO: 'SS1802120163523',
      RENTFEE: '150000',
      OBJCARNO: '60허5872',
      CARNO: '59허1938',
      ACCPERSONNAME: '정해성',
      DATA_KEY: '368',
      CARNAMEMSTNAME: '소나타 N20 2000 LPI LUX 기본형 AT LPG',
      RENTDATE: '20120106',
      UNIT24: '150000',
      TERMTYPE: 'S',
      NETSALEAMT: '165109',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '천안코리아',
      SALEVATAMT: '16511',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '부천지점',
      ACCDATE: '20120103',
      SALEAMT: '181620',
      STARTDATE: ''
    },
    {
      NO: '369',
      CARNAMEMSTNAME2: '소나타 N20 2000 LPI DLX 고급형 AT LPG',
      RETURNDATE: '20120105',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1476120160406',
      RENTFEE: '0',
      OBJCARNO: '24허5539',
      CARNO: '59허2266',
      ACCPERSONNAME: '',
      DATA_KEY: '369',
      CARNAMEMSTNAME: 'SM5 2000 LPI 렌터카 모범형 AT LPG',
      RENTDATE: '20120102',
      UNIT24: '150000',
      TERMTYPE: 'S',
      NETSALEAMT: '133498',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: 'MT기획팀',
      SALEVATAMT: '13350',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '구로지점',
      ACCDATE: '',
      SALEAMT: '146848',
      STARTDATE: ''
    },
    {
      NO: '370',
      CARNAMEMSTNAME2: '카니발R 리무진 9P 2200 E-VGT GLX AT 디젤',
      RETURNDATE: '20120106',
      ACCNO: '201201040405',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1410100962305',
      CONTRACTNO: 'SS1974120161391',
      RENTFEE: '317000',
      OBJCARNO: '28허4516',
      CARNO: '71허3811',
      ACCPERSONNAME: '김병준',
      DATA_KEY: '370',
      CARNAMEMSTNAME: '그랜드 카니발R 11P 2200 E-VGT GX 그랜드팩 AT 디젤',
      RENTDATE: '20120104',
      UNIT24: '317000',
      TERMTYPE: 'S',
      NETSALEAMT: '209455',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '성남단대역예약소',
      SALEVATAMT: '20945',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '부천지점',
      ACCDATE: '20120103',
      SALEAMT: '230400',
      STARTDATE: ''
    },
    {
      NO: '371',
      CARNAMEMSTNAME2: '소나타 Y20 렌터카 2000 LPI Luxury AT LPG',
      RETURNDATE: '20120107',
      ACCNO: '201201040399',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'SS1071110550083',
      CONTRACTNO: 'SS1837120162379',
      RENTFEE: '165000',
      OBJCARNO: '56허9689',
      CARNO: '47허5936',
      ACCPERSONNAME: '어성환',
      DATA_KEY: '371',
      CARNAMEMSTNAME: '소나타 Y20 렌터카 2000 LPI Luxury AT LPG',
      RENTDATE: '20120105',
      UNIT24: '165000',
      TERMTYPE: 'S',
      NETSALEAMT: '109091',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '부산태원',
      SALEVATAMT: '10909',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'M',
      DEPTNAME: '김포공항지점',
      ACCDATE: '20120104',
      SALEAMT: '120000',
      STARTDATE: ''
    },
    {
      NO: '372',
      CARNAMEMSTNAME2: '포르테 1600 CVVT S 기본형 AT 휘발유/LPG',
      RETURNDATE: '20120103',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1855111254327',
      RENTFEE: '150000',
      OBJCARNO: '56허9975',
      CARNO: '28허5009',
      ACCPERSONNAME: '',
      DATA_KEY: '372',
      CARNAMEMSTNAME: '소나타 N20 2000 LPI DLX 기본형 AT LPG',
      RENTDATE: '20111223',
      UNIT24: '99000',
      TERMTYPE: 'S',
      NETSALEAMT: '303775',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '부산연산역',
      SALEVATAMT: '30377',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '대구지점(동대구역)',
      ACCDATE: '',
      SALEAMT: '334152',
      STARTDATE: ''
    },
    {
      NO: '373',
      CARNAMEMSTNAME2: '베르나 트랜스폼 1500 VGT PREMIER AT 디젤',
      RETURNDATE: '20120103',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1937111254330',
      RENTFEE: '160000',
      OBJCARNO: '05허4415',
      CARNO: '62허5088',
      ACCPERSONNAME: '',
      DATA_KEY: '373',
      CARNAMEMSTNAME: '소나타 Y20 2000 I4 세타 Ⅱ Prime AT 휘발유',
      RENTDATE: '20111229',
      UNIT24: '95000',
      TERMTYPE: 'S',
      NETSALEAMT: '143698',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '성수한국타이어예약소',
      SALEVATAMT: '14370',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '영업3팀',
      ACCDATE: '',
      SALEAMT: '158068',
      STARTDATE: ''
    },
    {
      NO: '374',
      CARNAMEMSTNAME2: '엑센트 1600 VGT LUXURY AT 디젤',
      RETURNDATE: '20120103',
      ACCNO: '201201010027',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1100110804928',
      CONTRACTNO: 'SS1819120159190',
      RENTFEE: '150000',
      OBJCARNO: '49허6195',
      CARNO: '32허5911',
      ACCPERSONNAME: '이준엽',
      DATA_KEY: '374',
      CARNAMEMSTNAME: '소나타 트랜스폼 N20 2000 LPI Deluxe AT LPG',
      RENTDATE: '20120102',
      UNIT24: '99000',
      TERMTYPE: 'S',
      NETSALEAMT: '54509',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '공주지점',
      SALEVATAMT: '5451',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '인천지점',
      ACCDATE: '20120101',
      SALEAMT: '59960',
      STARTDATE: ''
    },
    {
      NO: '375',
      CARNAMEMSTNAME2: '오피러스 PREMIUM 3300 V6 람다 GH330 럭셔리 AT 휘발유/LPG',
      RETURNDATE: '20120106',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1873120163596',
      RENTFEE: '399000',
      OBJCARNO: '06허4533',
      CARNO: '56허8116',
      ACCPERSONNAME: '',
      DATA_KEY: '375',
      CARNAMEMSTNAME: '제네시스 3300 람다 BH330 GRAND PRIME PACK AT 휘발유',
      RENTDATE: '20120105',
      UNIT24: '349000',
      TERMTYPE: 'S',
      NETSALEAMT: '233127',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '성수성우예약소',
      SALEVATAMT: '23313',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '영업3팀',
      ACCDATE: '',
      SALEAMT: '256440',
      STARTDATE: ''
    },
    {
      NO: '376',
      CARNAMEMSTNAME2: '소나타 Y20 렌터카 2000 LPI Deluxe AT LPG',
      RETURNDATE: '20120105',
      ACCNO: '201201030281',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1410110265813',
      CONTRACTNO: 'SS1804120160692',
      RENTFEE: '150000',
      OBJCARNO: '26허6689',
      CARNO: '41허3826',
      ACCPERSONNAME: '김병준',
      DATA_KEY: '376',
      CARNAMEMSTNAME: '소나타 트랜스폼 N20 2000 LPI Deluxe AT LPG',
      RENTDATE: '20120103',
      UNIT24: '165000',
      TERMTYPE: 'S',
      NETSALEAMT: '97891',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '(폐쇄)영등포현주',
      SALEVATAMT: '9789',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '부천지점',
      ACCDATE: '20120103',
      SALEAMT: '107680',
      STARTDATE: ''
    },
    {
      NO: '377',
      CARNAMEMSTNAME2: '라세티 프리미어 1800 ECOTEC SX IDENTITY 고급형 AT 휘발유',
      RETURNDATE: '20120105',
      ACCNO: '201201030335',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1420100251753',
      CONTRACTNO: 'SS1818120160717',
      RENTFEE: '109000',
      OBJCARNO: '56허8749',
      CARNO: '63허8969',
      ACCPERSONNAME: '윤원재',
      DATA_KEY: '377',
      CARNAMEMSTNAME: '아반떼 M16 GDi 1600 GDI LUXURY AT 휘발유',
      RENTDATE: '20120103',
      UNIT24: '99000',
      TERMTYPE: 'S',
      NETSALEAMT: '69327',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '도곡예약소',
      SALEVATAMT: '6933',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업2팀',
      ACCDATE: '20120103',
      SALEAMT: '76260',
      STARTDATE: ''
    },
    {
      NO: '378',
      CARNAMEMSTNAME2: '뉴아반떼 1600 VVT E16 DELUXE AT 휘발유',
      RETURNDATE: '20120106',
      ACCNO: '201201040456',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1400091147307',
      CONTRACTNO: 'SS1819120161070',
      RENTFEE: '165000',
      OBJCARNO: '04허2140',
      CARNO: '28허4039',
      ACCPERSONNAME: '어성환',
      DATA_KEY: '378',
      CARNAMEMSTNAME: '소나타 Y20 렌터카 2000 LPI Luxury AT LPG',
      RENTDATE: '20120104',
      UNIT24: '99000',
      TERMTYPE: 'S',
      NETSALEAMT: '75615',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '공주지점',
      SALEVATAMT: '7561',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영등포지점',
      ACCDATE: '20111230',
      SALEAMT: '83176',
      STARTDATE: ''
    },
    {
      NO: '379',
      CARNAMEMSTNAME2: '5G 그랜져 3000 GDI HG300 NOBLE AT 휘발유',
      RETURNDATE: '20120104',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '50',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1848111259973',
      RENTFEE: '292000',
      OBJCARNO: '59도7506',
      CARNO: '39허4307',
      ACCPERSONNAME: '',
      DATA_KEY: '379',
      CARNAMEMSTNAME: '5G 그랜져 3000 LPI HG300 렌터카 Prime AT LPG',
      RENTDATE: '20111230',
      UNIT24: '292000',
      TERMTYPE: 'S',
      NETSALEAMT: '610705',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '수원삼정예약소',
      SALEVATAMT: '61070',
      REPAIRPERSONNAME: '',
      PROMOCODE: '리스대차',
      TERMTYPE2: '',
      DEPTNAME: 'AJ캐피탈',
      ACCDATE: '',
      SALEAMT: '671775',
      STARTDATE: ''
    },
    {
      NO: '380',
      CARNAMEMSTNAME2: '소나타 Y20 렌터카 2000 LPI Deluxe AT LPG',
      RETURNDATE: '20120102',
      ACCNO: '201112303641',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1351110165891',
      CONTRACTNO: 'SS1933111260040',
      RENTFEE: '266000',
      OBJCARNO: '68허3276',
      CARNO: '32허5722',
      ACCPERSONNAME: '김선연',
      DATA_KEY: '380',
      CARNAMEMSTNAME: '그랜져TG 2700 LPI Q270 모범형 AT LPG',
      RENTDATE: '20111230',
      UNIT24: '165000',
      TERMTYPE: 'S',
      NETSALEAMT: '173182',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '화성동탄예약소',
      SALEVATAMT: '17318',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '부산지점',
      ACCDATE: '20111230',
      SALEAMT: '190500',
      STARTDATE: ''
    },
    {
      NO: '381',
      CARNAMEMSTNAME2: '그랜드 스타렉스 12P WAGON 2500 VGT CVX Premium AT 디젤',
      RETURNDATE: '20120104',
      ACCNO: '201112263114',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'SS1050110745071',
      CONTRACTNO: 'SS1956111252313',
      RENTFEE: '219000',
      OBJCARNO: '72허9460',
      CARNO: '73허6588',
      ACCPERSONNAME: '윤원재',
      DATA_KEY: '381',
      CARNAMEMSTNAME: '그랜드 스타렉스 12P WAGON 2500 VGT CVX Premium AT 디젤',
      RENTDATE: '20111227',
      UNIT24: '219000',
      TERMTYPE: 'S',
      NETSALEAMT: '463127',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '상봉예약소',
      SALEVATAMT: '46313',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'M',
      DEPTNAME: '분당지점',
      ACCDATE: '20111226',
      SALEAMT: '509440',
      STARTDATE: ''
    },
    {
      NO: '382',
      CARNAMEMSTNAME2: '소나타 트랜스폼 N20 2000 LPI Premier AT LPG',
      RETURNDATE: '20120106',
      ACCNO: '201201030381',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1470081234315',
      CONTRACTNO: 'SS1816120161314',
      RENTFEE: '165000',
      OBJCARNO: '32허5760',
      CARNO: '63허1490',
      ACCPERSONNAME: '박수호',
      DATA_KEY: '382',
      CARNAMEMSTNAME: 'K5렌터카 2000 LPI 디럭스 AT LPG',
      RENTDATE: '20120104',
      UNIT24: '150000',
      TERMTYPE: 'S',
      NETSALEAMT: '131353',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '광주진왕',
      SALEVATAMT: '13135',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업1팀',
      ACCDATE: '20120103',
      SALEAMT: '144488',
      STARTDATE: ''
    },
    {
      NO: '383',
      CARNAMEMSTNAME2: 'K7 렌터카 2700 V6 뮤 VG270 프레스티지 AT LPG',
      RETURNDATE: '20120110',
      ACCNO: '201201090936',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1410100455757',
      CONTRACTNO: 'SS1901120168352',
      RENTFEE: '292000',
      OBJCARNO: '05허4260',
      CARNO: '63허9113',
      ACCPERSONNAME: '김현철',
      DATA_KEY: '383',
      CARNAMEMSTNAME: 'K7 렌터카 2700 V6 뮤 VG270 럭셔리 AT LPG',
      RENTDATE: '20120109',
      UNIT24: '292000',
      TERMTYPE: 'S',
      NETSALEAMT: '153309',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '경기광주예약소',
      SALEVATAMT: '15331',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '부천지점',
      ACCDATE: '20120109',
      SALEAMT: '168640',
      STARTDATE: ''
    },
    {
      NO: '384',
      CARNAMEMSTNAME2: '뉴프라이드 1400 DOHC LX AT 휘발유',
      RETURNDATE: '20120107',
      ACCNO: '201201040404',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1130110603395',
      CONTRACTNO: 'SS1822120166952',
      RENTFEE: '165000',
      OBJCARNO: '52허7280',
      CARNO: '56허9665',
      ACCPERSONNAME: '이준엽',
      DATA_KEY: '384',
      CARNAMEMSTNAME: '소나타 Y20 렌터카 2000 LPI Luxury AT LPG',
      RENTDATE: '20120104',
      UNIT24: '99000',
      TERMTYPE: 'S',
      NETSALEAMT: '89309',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '대구하나',
      SALEVATAMT: '8931',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '수원지점',
      ACCDATE: '20120104',
      SALEAMT: '98240',
      STARTDATE: ''
    },
    {
      NO: '385',
      CARNAMEMSTNAME2: '투싼 ix 4WD 2000 E-VGT X20 Luxury AT 디젤',
      RETURNDATE: '20120106',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1808120160570',
      RENTFEE: '190000',
      OBJCARNO: '20허4151',
      CARNO: '20허4729',
      ACCPERSONNAME: '',
      DATA_KEY: '385',
      CARNAMEMSTNAME: '투싼 ix 4WD 2000 E-VGT X20 Luxury AT 디젤',
      RENTDATE: '20120103',
      UNIT24: '190000',
      TERMTYPE: 'S',
      NETSALEAMT: '191520',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '동울산',
      SALEVATAMT: '19152',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '울산지점',
      ACCDATE: '',
      SALEAMT: '210672',
      STARTDATE: ''
    },
    {
      NO: '386',
      CARNAMEMSTNAME2: 'K5렌터카 2000 LPI 럭셔리 AT LPG',
      RETURNDATE: '20120110',
      ACCNO: '201201050658',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1350101062603',
      CONTRACTNO: 'SS1350120167663',
      RENTFEE: '165000',
      OBJCARNO: '47허5841',
      CARNO: '68허3263',
      ACCPERSONNAME: '박수호',
      DATA_KEY: '386',
      CARNAMEMSTNAME: 'K5렌터카 2000 LPI 디럭스 AT LPG',
      RENTDATE: '20120106',
      UNIT24: '165000',
      TERMTYPE: 'S',
      NETSALEAMT: '227455',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '김해공항지점',
      SALEVATAMT: '22745',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '김해공항지점',
      ACCDATE: '20120105',
      SALEAMT: '250200',
      STARTDATE: ''
    },
    {
      NO: '387',
      CARNAMEMSTNAME2: '그랜져TG 2700 DOHC Q270 DELUXE AT 휘발유',
      RETURNDATE: '20120109',
      ACCNO: '201201030274',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1460071018481',
      CONTRACTNO: 'SS1913120160584',
      RENTFEE: '266000',
      OBJCARNO: '26허6356',
      CARNO: '41허2614',
      ACCPERSONNAME: '윤원재',
      DATA_KEY: '387',
      CARNAMEMSTNAME: '그랜져TG 2700 DOHC Q270 PREMIER SMART PACK AT 휘발유',
      RENTDATE: '20120103',
      UNIT24: '266000',
      TERMTYPE: 'S',
      NETSALEAMT: '492800',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '성동성수예약소',
      SALEVATAMT: '49280',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업2팀',
      ACCDATE: '20111225',
      SALEAMT: '542080',
      STARTDATE: ''
    },
    {
      NO: '388',
      CARNAMEMSTNAME2: '투싼 ix 4WD 2000 E-VGT X20 Luxury AT 디젤',
      RETURNDATE: '20120109',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1230111258883',
      RENTFEE: '292000',
      OBJCARNO: '56허8958',
      CARNO: '05허6791',
      ACCPERSONNAME: '',
      DATA_KEY: '388',
      CARNAMEMSTNAME: 'K7 2700 V6 뮤 VG270 프레스티지 AT 휘발유',
      RENTDATE: '20111231',
      UNIT24: '190000',
      TERMTYPE: 'S',
      NETSALEAMT: '453618',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '평택지점',
      SALEVATAMT: '45362',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '평택지점',
      ACCDATE: '',
      SALEAMT: '498980',
      STARTDATE: ''
    },
    {
      NO: '389',
      CARNAMEMSTNAME2: '스파크 1000 DOHC LS AT 휘발유',
      RETURNDATE: '20120105',
      ACCNO: '201201030312',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1452111108890',
      CONTRACTNO: 'SS1955120161895',
      RENTFEE: '150000',
      OBJCARNO: '52허5272',
      CARNO: '16허7662',
      ACCPERSONNAME: '어성환',
      DATA_KEY: '389',
      CARNAMEMSTNAME: '소나타 트랜스폼 N20 2000 LPI 고급형 AT LPG',
      RENTDATE: '20120103',
      UNIT24: '95000',
      TERMTYPE: 'S',
      NETSALEAMT: '57455',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '대구태정예약소',
      SALEVATAMT: '5745',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업1팀',
      ACCDATE: '20120103',
      SALEAMT: '63200',
      STARTDATE: ''
    },
    {
      NO: '390',
      CARNAMEMSTNAME2: '소나타 트랜스폼 N20 2000 VVT Deluxe AT 휘발유',
      RETURNDATE: '20120106',
      ACCNO: '201201020068',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1460090135295',
      CONTRACTNO: 'SS1260120160797',
      RENTFEE: '160000',
      OBJCARNO: '28허2182',
      CARNO: '42허5477',
      ACCPERSONNAME: '이준엽',
      DATA_KEY: '390',
      CARNAMEMSTNAME: '소나타 Y20 2000 VVT Prime 고급형 AT 휘발유',
      RENTDATE: '20120102',
      UNIT24: '142000',
      TERMTYPE: 'S',
      NETSALEAMT: '197865',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '광주지점',
      SALEVATAMT: '19787',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업1팀',
      ACCDATE: '20120101',
      SALEAMT: '217652',
      STARTDATE: ''
    },
    {
      NO: '391',
      CARNAMEMSTNAME2: '아반떼 M16 1600 LPI 렌터카 DELUXE AT LPG',
      RETURNDATE: '20120104',
      ACCNO: '201112262958',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1454110265951',
      CONTRACTNO: 'SS1914111250501',
      RENTFEE: '165000',
      OBJCARNO: '62허4098',
      CARNO: '05허5637',
      ACCPERSONNAME: '윤원재',
      DATA_KEY: '391',
      CARNAMEMSTNAME: '소나타 Y20 렌터카 2000 LPI Luxury AT LPG',
      RENTDATE: '20111226',
      UNIT24: '109000',
      TERMTYPE: 'S',
      NETSALEAMT: '264727',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '경기오포예약소',
      SALEVATAMT: '26473',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업3팀',
      ACCDATE: '20111226',
      SALEAMT: '291200',
      STARTDATE: ''
    },
    {
      NO: '392',
      CARNAMEMSTNAME2: '그랜드 카니발R 11P 2200 E-VGT GX 그랜드팩 AT 디젤',
      RETURNDATE: '20120103',
      ACCNO: '201112141438',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1458110704346',
      CONTRACTNO: 'SS1945111250519',
      RENTFEE: '270000',
      OBJCARNO: '74허6386',
      CARNO: '59허1146',
      ACCPERSONNAME: '김선연',
      DATA_KEY: '392',
      CARNAMEMSTNAME: '뉴 카니발R 9P 2200 E-VGT GX AT 디젤',
      RENTDATE: '20111226',
      UNIT24: '317000',
      TERMTYPE: 'S',
      NETSALEAMT: '570182',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '일산탄현예약소',
      SALEVATAMT: '57018',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: 'SU7팀',
      ACCDATE: '20111214',
      SALEAMT: '627200',
      STARTDATE: ''
    },
    {
      NO: '393',
      CARNAMEMSTNAME2: '액티언스포츠 2000 XVT AX7(4WD) PASSION AT 디젤',
      RETURNDATE: '20120110',
      ACCNO: '201112303604',
      REPAIRNO: '',
      DISCOUNTRATE: '50',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1866111258891',
      RENTFEE: '190000',
      OBJCARNO: '85조4936',
      CARNO: '06허4756',
      ACCPERSONNAME: '정해성',
      DATA_KEY: '393',
      CARNAMEMSTNAME: '스포티지R 4WD 2000 E-VGT LX AT 디젤',
      RENTDATE: '20111230',
      UNIT24: '190000',
      TERMTYPE: 'S',
      NETSALEAMT: '698768',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '상주지점',
      SALEVATAMT: '69877',
      REPAIRPERSONNAME: '',
      PROMOCODE: '리스대차',
      TERMTYPE2: '',
      DEPTNAME: 'AJ캐피탈',
      ACCDATE: '20111223',
      SALEAMT: '768645',
      STARTDATE: ''
    },
    {
      NO: '394',
      CARNAMEMSTNAME2: '아반떼 M16 1600 LPI 렌터카 DELUXE AT LPG',
      RETURNDATE: '20120106',
      ACCNO: '201112232705',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1100111209103',
      CONTRACTNO: 'SS1837120161134',
      RENTFEE: '109000',
      OBJCARNO: '52허5850',
      CARNO: '52허5624',
      ACCPERSONNAME: '어성환',
      DATA_KEY: '394',
      CARNAMEMSTNAME: '아반떼 M16 1600 LPI 렌터카 LUXURY AT LPG',
      RENTDATE: '20120104',
      UNIT24: '109000',
      TERMTYPE: 'S',
      NETSALEAMT: '69327',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '부산태원',
      SALEVATAMT: '6933',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '인천지점',
      ACCDATE: '20111220',
      SALEAMT: '76260',
      STARTDATE: ''
    },
    {
      NO: '395',
      CARNAMEMSTNAME2: '소나타 Y20 렌터카 2000 LPI Deluxe AT LPG',
      RETURNDATE: '20120105',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1808111251958',
      RENTFEE: '165000',
      OBJCARNO: '26허7378',
      CARNO: '13허2312',
      ACCPERSONNAME: '',
      DATA_KEY: '395',
      CARNAMEMSTNAME: '소나타 Y20 렌터카 2000 LPI Luxury AT LPG',
      RENTDATE: '20111227',
      UNIT24: '165000',
      TERMTYPE: 'S',
      NETSALEAMT: '413455',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '동울산',
      SALEVATAMT: '41345',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '해운대지점',
      ACCDATE: '',
      SALEAMT: '454800',
      STARTDATE: ''
    },
    {
      NO: '396',
      CARNAMEMSTNAME2: '봉고1톤 더블캡 2900 CRDI 장축 GX 고급형 MT 디젤',
      RETURNDATE: '20120109',
      ACCNO: '201111222436',
      REPAIRNO: '',
      DISCOUNTRATE: '50',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1476111259244',
      RENTFEE: '190000',
      OBJCARNO: '97머8931',
      CARNO: '20허3060',
      ACCPERSONNAME: '김병준',
      DATA_KEY: '396',
      CARNAMEMSTNAME: '투싼 2WD 2000 VGT JX 기본형 AT 디젤',
      RENTDATE: '20111230',
      UNIT24: '0',
      TERMTYPE: 'S',
      NETSALEAMT: '588214',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: 'MT기획팀',
      SALEVATAMT: '58821',
      REPAIRPERSONNAME: '',
      PROMOCODE: '리스대차',
      TERMTYPE2: '',
      DEPTNAME: 'AJ캐피탈',
      ACCDATE: '20111121',
      SALEAMT: '647035',
      STARTDATE: ''
    },
    {
      NO: '397',
      CARNAMEMSTNAME2: '뉴아반떼 1600 VVT S16 PREMIER AT 휘발유',
      RETURNDATE: '20120102',
      ACCNO: '201112242747',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1460080323210',
      CONTRACTNO: 'SS1819111250181',
      RENTFEE: '150000',
      OBJCARNO: '26허8693',
      CARNO: '20허3811',
      ACCPERSONNAME: '정해성',
      DATA_KEY: '397',
      CARNAMEMSTNAME: '로체 이노베이션 렌트카 2000 LPI LX20 기본형 스페셜 AT LPG',
      RENTDATE: '20111224',
      UNIT24: '99000',
      TERMTYPE: 'S',
      NETSALEAMT: '253975',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '공주지점',
      SALEVATAMT: '25397',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업5팀',
      ACCDATE: '20111224',
      SALEAMT: '279372',
      STARTDATE: ''
    },
    {
      NO: '398',
      CARNAMEMSTNAME2: 'K7 The Prestige 렌터카 3000 V6 람다 3.0LPI 프레스티지 AT LPG',
      RETURNDATE: '20120107',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1956111245252',
      RENTFEE: '292000',
      OBJCARNO: '10허6147',
      CARNO: '52허5903',
      ACCPERSONNAME: '',
      DATA_KEY: '398',
      CARNAMEMSTNAME: '5G 그랜져 3000 LPI HG300 렌터카 Prime AT LPG',
      RENTDATE: '20111222',
      UNIT24: '292000',
      TERMTYPE: 'S',
      NETSALEAMT: '1310545',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '상봉예약소',
      SALEVATAMT: '131055',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '대전지점',
      ACCDATE: '',
      SALEAMT: '1441600',
      STARTDATE: ''
    },
    {
      NO: '399',
      CARNAMEMSTNAME2: '쏘렌토 R 4WD 2200 E-VGT LX 고급형 AT 디젤',
      RETURNDATE: '20120110',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1476111245612',
      RENTFEE: '349000',
      OBJCARNO: '62허5674',
      CARNO: '15허2949',
      ACCPERSONNAME: '',
      DATA_KEY: '399',
      CARNAMEMSTNAME: '모하비 4WD 3000 E-VGT KV300 최고급형 AT 디젤',
      RENTDATE: '20111222',
      UNIT24: '199000',
      TERMTYPE: 'S',
      NETSALEAMT: '866909',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: 'MT기획팀',
      SALEVATAMT: '86691',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '천안아산지점',
      ACCDATE: '',
      SALEAMT: '953600',
      STARTDATE: ''
    },
    {
      NO: '400',
      CARNAMEMSTNAME2: '투싼 4WD 2000 VGT JX MT 디젤',
      RETURNDATE: '20120105',
      ACCNO: '201112222428',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1470090843289',
      CONTRACTNO: 'SS1476111245613',
      RENTFEE: '349000',
      OBJCARNO: '41허5625',
      CARNO: '59허1877',
      ACCPERSONNAME: '박수호',
      DATA_KEY: '400',
      CARNAMEMSTNAME: '모하비 4WD 3000 E-VGT JV300 최고급형 AT 디젤',
      RENTDATE: '20111222',
      UNIT24: '190000',
      TERMTYPE: 'S',
      NETSALEAMT: '857455',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: 'MT기획팀',
      SALEVATAMT: '85745',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: 'SU7팀',
      ACCDATE: '20111222',
      SALEAMT: '943200',
      STARTDATE: ''
    },
    {
      NO: '401',
      CARNAMEMSTNAME2: '베르나 트랜스폼 1500 VGT PREMIER AT 디젤',
      RETURNDATE: '20120102',
      ACCNO: '201112313743',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1470100455979',
      CONTRACTNO: 'SS1260111260524',
      RENTFEE: '165000',
      OBJCARNO: '05허4130',
      CARNO: '42허5436',
      ACCPERSONNAME: '어성환',
      DATA_KEY: '401',
      CARNAMEMSTNAME: '뉴카렌스 2000 LPI GX 고급형 AT LPG',
      RENTDATE: '20111231',
      UNIT24: '95000',
      TERMTYPE: 'S',
      NETSALEAMT: '80371',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '광주지점',
      SALEVATAMT: '8037',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업5팀',
      ACCDATE: '20111231',
      SALEAMT: '88408',
      STARTDATE: ''
    },
    {
      NO: '402',
      CARNAMEMSTNAME2: '오피러스 PREMIUM 렌터카 2700 V6 뮤 GH270 고급형 AT LPG',
      RETURNDATE: '20120103',
      ACCNO: '201112303649',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1461100251288',
      CONTRACTNO: 'SS1818120159877',
      RENTFEE: '292000',
      OBJCARNO: '56허8731',
      CARNO: '05허7564',
      ACCPERSONNAME: '김선연',
      DATA_KEY: '402',
      CARNAMEMSTNAME: 'K7 The Prestige 렌터카 3000 V6 람다 3.0LPI 럭셔리 AT LPG',
      RENTDATE: '20120102',
      UNIT24: '307000',
      TERMTYPE: 'S',
      NETSALEAMT: '134909',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '도곡예약소',
      SALEVATAMT: '13491',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업1팀',
      ACCDATE: '20111230',
      SALEAMT: '148400',
      STARTDATE: ''
    },
    {
      NO: '403',
      CARNAMEMSTNAME2: '싼타페 The Style 4WD 2200 E-VGT CLX DELUXE AT 디젤',
      RETURNDATE: '20120110',
      ACCNO: '201201060689',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1450101062759',
      CONTRACTNO: 'SS1837120166597',
      RENTFEE: '150000',
      OBJCARNO: '63허4662',
      CARNO: '27허5995',
      ACCPERSONNAME: '이준엽',
      DATA_KEY: '403',
      CARNAMEMSTNAME: '소나타 N20 2000 LPI LUX 기본형 AT LPG',
      RENTDATE: '20120106',
      UNIT24: '199000',
      TERMTYPE: 'S',
      NETSALEAMT: '206225',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '부산태원',
      SALEVATAMT: '20623',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '부산지점',
      ACCDATE: '20120103',
      SALEAMT: '226848',
      STARTDATE: ''
    },
    {
      NO: '404',
      CARNAMEMSTNAME2: '5G 그랜져 2400 GDI HG240 LUXURY AT 휘발유',
      RETURNDATE: '20120106',
      ACCNO: '201112313792',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1456110478991',
      CONTRACTNO: 'SS1818120161598',
      RENTFEE: '399000',
      OBJCARNO: '05허7256',
      CARNO: '60허5193',
      ACCPERSONNAME: '윤원재',
      DATA_KEY: '404',
      CARNAMEMSTNAME: '제네시스 3300 람다 BH330 LUXURY AT 휘발유',
      RENTDATE: '20120104',
      UNIT24: '266000',
      TERMTYPE: 'S',
      NETSALEAMT: '172400',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '도곡예약소',
      SALEVATAMT: '17240',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업5팀',
      ACCDATE: '20111231',
      SALEAMT: '189640',
      STARTDATE: ''
    },
    {
      NO: '405',
      CARNAMEMSTNAME2: 'K7 The Prestige 렌터카 3000 V6 람다 3.0LPI 럭셔리 AT LPG',
      RETURNDATE: '20120104',
      ACCNO: '201201020180',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1330110473731',
      CONTRACTNO: 'SS1300120160387',
      RENTFEE: '292000',
      OBJCARNO: '44허5466',
      CARNO: '20허2041',
      ACCPERSONNAME: '정해성',
      DATA_KEY: '405',
      CARNAMEMSTNAME: 'K7 The Prestige 렌터카 3000 V6 람다 3.0LPI 럭셔리 AT LPG',
      RENTDATE: '20120103',
      UNIT24: '292000',
      TERMTYPE: 'S',
      NETSALEAMT: '158764',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '울산지점',
      SALEVATAMT: '15876',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '창원지점',
      ACCDATE: '20120102',
      SALEAMT: '174640',
      STARTDATE: ''
    },
    {
      NO: '406',
      CARNAMEMSTNAME2: '뉴마티즈 800 SOHC Super 일반형 AT 휘발유',
      RETURNDATE: '20120105',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1280120161407',
      RENTFEE: '99000',
      OBJCARNO: '18허2992',
      CARNO: '31허2197',
      ACCPERSONNAME: '',
      DATA_KEY: '406',
      CARNAMEMSTNAME: '뉴아반떼 1600 VGT E16 DELUXE AT 디젤',
      RENTDATE: '20120104',
      UNIT24: '95000',
      TERMTYPE: 'S',
      NETSALEAMT: '43091',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '순천여수지점',
      SALEVATAMT: '4309',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '순천여수지점',
      ACCDATE: '',
      SALEAMT: '47400',
      STARTDATE: ''
    },
    {
      NO: '407',
      CARNAMEMSTNAME2: 'New SM5 장애우용 2000 CVTC Ⅱ LPLi LE AT LPG',
      RETURNDATE: '20120107',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1816111245659',
      RENTFEE: '165000',
      OBJCARNO: '04허3224',
      CARNO: '52허7287',
      ACCPERSONNAME: '',
      DATA_KEY: '407',
      CARNAMEMSTNAME: '소나타 Y20 렌터카 2000 LPI Luxury AT LPG',
      RENTDATE: '20111222',
      UNIT24: '165000',
      TERMTYPE: 'S',
      NETSALEAMT: '698182',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '광주진왕',
      SALEVATAMT: '69818',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '영업2팀',
      ACCDATE: '',
      SALEAMT: '768000',
      STARTDATE: ''
    },
    {
      NO: '408',
      CARNAMEMSTNAME2: 'SM5 2000 LPI 렌터카 고급형 AT LPG',
      RETURNDATE: '20120104',
      ACCNO: '201201020143',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1460080525905',
      CONTRACTNO: 'SS1878120160428',
      RENTFEE: '165000',
      OBJCARNO: '41허2147',
      CARNO: '63허8751',
      ACCPERSONNAME: '김대윤',
      DATA_KEY: '408',
      CARNAMEMSTNAME: 'NEW SM5 렌터카 2000 CVTC Ⅱ LPLi 고급형 AT LPG',
      RENTDATE: '20120102',
      UNIT24: '0',
      TERMTYPE: 'S',
      NETSALEAMT: '103607',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '성수트루예약소',
      SALEVATAMT: '10361',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업1팀',
      ACCDATE: '20120102',
      SALEAMT: '113968',
      STARTDATE: ''
    },
    {
      NO: '409',
      CARNAMEMSTNAME2: '그랜져TG 2700 LPI Q270 모범형 PACK 1 AT LPG',
      RETURNDATE: '20120107',
      ACCNO: '201201020120',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1460070614464',
      CONTRACTNO: 'SS1330120159847',
      RENTFEE: '266000',
      OBJCARNO: '47허5912',
      CARNO: '60허5392',
      ACCPERSONNAME: '박수호',
      DATA_KEY: '409',
      CARNAMEMSTNAME: '그랜져 THE LUXURY 2700 LPI 렌터카 Q270 모범형 PACKⅠ AT LPG',
      RENTDATE: '20120102',
      UNIT24: '266000',
      TERMTYPE: 'S',
      NETSALEAMT: '396000',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '창원지점',
      SALEVATAMT: '39600',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업2팀',
      ACCDATE: '20120101',
      SALEAMT: '435600',
      STARTDATE: ''
    },
    {
      NO: '410',
      CARNAMEMSTNAME2: '소나타 Y20 렌터카 2000 LPI Luxury AT LPG',
      RETURNDATE: '20120106',
      ACCNO: '201112313782',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1450100151190',
      CONTRACTNO: 'SS1822120160746',
      RENTFEE: '165000',
      OBJCARNO: '44허1377',
      CARNO: '44허7096',
      ACCPERSONNAME: '윤원재',
      DATA_KEY: '410',
      CARNAMEMSTNAME: '소나타 Y20 렌터카 2000 LPI Luxury AT LPG',
      RENTDATE: '20120103',
      UNIT24: '165000',
      TERMTYPE: 'S',
      NETSALEAMT: '173182',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '대구하나',
      SALEVATAMT: '17318',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업5팀',
      ACCDATE: '20111231',
      SALEAMT: '190500',
      STARTDATE: ''
    },
    {
      NO: '411',
      CARNAMEMSTNAME2: '그랜져TG 2400 DOHC Q240 DELUXE AT 휘발유',
      RETURNDATE: '20120103',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1853120159383',
      RENTFEE: '199000',
      OBJCARNO: '13허2223',
      CARNO: '04허1327',
      ACCPERSONNAME: '',
      DATA_KEY: '411',
      CARNAMEMSTNAME: '싼타페 The Style 4WD 2200 E-VGT CLX DELUXE AT 디젤',
      RENTDATE: '20120102',
      UNIT24: '213000',
      TERMTYPE: 'S',
      NETSALEAMT: '87055',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '포항마스터예약소',
      SALEVATAMT: '8705',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '포항지점',
      ACCDATE: '',
      SALEAMT: '95760',
      STARTDATE: ''
    },
    {
      NO: '412',
      CARNAMEMSTNAME2: 'SM5 2000 DOHC SE AT 휘발유',
      RETURNDATE: '20120103',
      ACCNO: '201111070763',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1460070918435',
      CONTRACTNO: 'SS1806111261311',
      RENTFEE: '165000',
      OBJCARNO: '31허1882',
      CARNO: '62허5102',
      ACCPERSONNAME: '어성환',
      DATA_KEY: '412',
      CARNAMEMSTNAME: '소나타 Y20 렌터카 2000 LPI Luxury AT LPG',
      RENTDATE: '20111228',
      UNIT24: '0',
      TERMTYPE: 'S',
      NETSALEAMT: '262691',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '창원대한',
      SALEVATAMT: '26269',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업2팀',
      ACCDATE: '20111102',
      SALEAMT: '288960',
      STARTDATE: ''
    },
    {
      NO: '413',
      CARNAMEMSTNAME2: '소나타 Y20 렌터카 2000 LPI Deluxe AT LPG',
      RETURNDATE: '20120110',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1806120165831',
      RENTFEE: '165000',
      OBJCARNO: '26허5842',
      CARNO: '62허5102',
      ACCPERSONNAME: '',
      DATA_KEY: '413',
      CARNAMEMSTNAME: '소나타 Y20 렌터카 2000 LPI Luxury AT LPG',
      RENTDATE: '20120105',
      UNIT24: '165000',
      TERMTYPE: 'S',
      NETSALEAMT: '245455',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '창원대한',
      SALEVATAMT: '24545',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '해운대지점',
      ACCDATE: '',
      SALEAMT: '270000',
      STARTDATE: ''
    },
    {
      NO: '414',
      CARNAMEMSTNAME2: '5G 그랜져 2400 GDI HG240 LUXURY AT 휘발유',
      RETURNDATE: '20120107',
      ACCNO: '201201040410',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1410111108010',
      CONTRACTNO: 'SS1974120162095',
      RENTFEE: '292000',
      OBJCARNO: '45허4653',
      CARNO: '52허5904',
      ACCPERSONNAME: '김병준',
      DATA_KEY: '414',
      CARNAMEMSTNAME: '5G 그랜져 3000 LPI HG300 렌터카 Prime AT LPG',
      RENTDATE: '20120105',
      UNIT24: '266000',
      TERMTYPE: 'S',
      NETSALEAMT: '192720',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '성남단대역예약소',
      SALEVATAMT: '19272',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '부천지점',
      ACCDATE: '20120103',
      SALEAMT: '211992',
      STARTDATE: ''
    },
    {
      NO: '415',
      CARNAMEMSTNAME2: '오피러스 PREMIUM 3300 V6 람다 GH330 노블레스 AT 휘발유',
      RETURNDATE: '20120104',
      ACCNO: '201201020095',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1457110266283',
      CONTRACTNO: 'SS1476120162099',
      RENTFEE: '447000',
      OBJCARNO: '04허6151',
      CARNO: '41허1076',
      ACCPERSONNAME: '김대윤',
      DATA_KEY: '415',
      CARNAMEMSTNAME: '제네시스 3800 람다 BH380 VIP PACK AT 휘발유',
      RENTDATE: '20120102',
      UNIT24: '349000',
      TERMTYPE: 'S',
      NETSALEAMT: '245636',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: 'MT기획팀',
      SALEVATAMT: '24564',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업4팀',
      ACCDATE: '20120101',
      SALEAMT: '270200',
      STARTDATE: ''
    },
    {
      NO: '416',
      CARNAMEMSTNAME2: '쏘렌토 R 4WD 2200 E-VGT LX 고급형 AT 디젤',
      RETURNDATE: '20120109',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1476120162108',
      RENTFEE: '199000',
      OBJCARNO: '12허4163',
      CARNO: '46허5703',
      ACCPERSONNAME: '',
      DATA_KEY: '416',
      CARNAMEMSTNAME: '쏘렌토 7P 2500 VGT LX 고급형 AT 디젤',
      RENTDATE: '20120104',
      UNIT24: '199000',
      TERMTYPE: 'S',
      NETSALEAMT: '303447',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: 'MT기획팀',
      SALEVATAMT: '30345',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '청주지점',
      ACCDATE: '',
      SALEAMT: '333792',
      STARTDATE: ''
    },
    {
      NO: '417',
      CARNAMEMSTNAME2: 'New SM5 장애우용 2000 CVTC Ⅱ LPLi SE AT LPG',
      RETURNDATE: '20120109',
      ACCNO: '201201050548',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1060110805639',
      CONTRACTNO: 'SS1818120162755',
      RENTFEE: '165000',
      OBJCARNO: '52허4239',
      CARNO: '62허4067',
      ACCPERSONNAME: '김병준',
      DATA_KEY: '417',
      CARNAMEMSTNAME: 'K5렌터카 2000 LPI 디럭스 AT LPG',
      RENTDATE: '20120105',
      UNIT24: '165000',
      TERMTYPE: 'S',
      NETSALEAMT: '185440',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '도곡예약소',
      SALEVATAMT: '18544',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '건대지점',
      ACCDATE: '20120105',
      SALEAMT: '203984',
      STARTDATE: ''
    },
    {
      NO: '418',
      CARNAMEMSTNAME2: '에쿠스 TRUE PRESTIGE 3800 V6 람다 VS 380 프레스티지 VIP PACKⅠ AT 휘발유',
      RETURNDATE: '20120110',
      ACCNO: '201201040455',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1170100557874',
      CONTRACTNO: 'SS1901120168035',
      RENTFEE: '488000',
      OBJCARNO: '12허4140',
      CARNO: '05허7540',
      ACCPERSONNAME: '김현철',
      DATA_KEY: '418',
      CARNAMEMSTNAME: '에쿠스 TRUE PRESTIGE 3800 V6 람다 VS 380 프라임 AT 휘발유',
      RENTDATE: '20120109',
      UNIT24: '488000',
      TERMTYPE: 'S',
      NETSALEAMT: '162400',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '경기광주예약소',
      SALEVATAMT: '16240',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '청주지점',
      ACCDATE: '20120104',
      SALEAMT: '178640',
      STARTDATE: ''
    },
    {
      NO: '419',
      CARNAMEMSTNAME2: '스파크 1000 DOHC LS AT 휘발유',
      RETURNDATE: '20120108',
      ACCNO: '201112303629',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'SS1453111118341',
      CONTRACTNO: 'SS1898120168550',
      RENTFEE: '165000',
      OBJCARNO: '06허4861',
      CARNO: '56허8875',
      ACCPERSONNAME: '정해성',
      DATA_KEY: '419',
      CARNAMEMSTNAME: '소나타 Y20 렌터카 2000 LPI Luxury AT LPG',
      RENTDATE: '20120102',
      UNIT24: '95000',
      TERMTYPE: 'S',
      NETSALEAMT: '160873',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '서울석촌예약소',
      SALEVATAMT: '16087',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'M',
      DEPTNAME: '영업2팀',
      ACCDATE: '20111230',
      SALEAMT: '176960',
      STARTDATE: ''
    },
    {
      NO: '420',
      CARNAMEMSTNAME2: 'K5렌터카 2000 LPI 디럭스 AT LPG',
      RETURNDATE: '20120106',
      ACCNO: '201112303690',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'SS1351110503701',
      CONTRACTNO: 'SS1837120161472',
      RENTFEE: '165000',
      OBJCARNO: '62허5408',
      CARNO: '47허6049',
      ACCPERSONNAME: '정해성',
      DATA_KEY: '420',
      CARNAMEMSTNAME: 'NEW SM5 렌터카 2000 CVTC Ⅱ LPLi 고급형 AT LPG',
      RENTDATE: '20120102',
      UNIT24: '165000',
      TERMTYPE: 'S',
      NETSALEAMT: '185440',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '부산태원',
      SALEVATAMT: '18544',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'M',
      DEPTNAME: '해운대지점',
      ACCDATE: '20111230',
      SALEAMT: '203984',
      STARTDATE: ''
    },
    {
      NO: '421',
      CARNAMEMSTNAME2: '쏘렌토 R 4WD 2200 E-VGT LX 고급형 AT 디젤',
      RETURNDATE: '20120109',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1476120162110',
      RENTFEE: '199000',
      OBJCARNO: '04허3275',
      CARNO: '10허6223',
      ACCPERSONNAME: '',
      DATA_KEY: '421',
      CARNAMEMSTNAME: '싼타페 4WD 2200 VGT CLX 기본형 AT 디젤',
      RENTDATE: '20120103',
      UNIT24: '199000',
      TERMTYPE: 'S',
      NETSALEAMT: '323331',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: 'MT기획팀',
      SALEVATAMT: '32333',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '천안아산지점',
      ACCDATE: '',
      SALEAMT: '355664',
      STARTDATE: ''
    },
    {
      NO: '422',
      CARNAMEMSTNAME2: '소나타 N20 2000 LPI LUX 기본형 AT LPG',
      RETURNDATE: '20120104',
      ACCNO: '201112242776',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1130080323163',
      CONTRACTNO: 'SS1476111253960',
      RENTFEE: '150000',
      OBJCARNO: '26허8736',
      CARNO: '62허5523',
      ACCPERSONNAME: '김병준',
      DATA_KEY: '422',
      CARNAMEMSTNAME: '소나타 N20 2000 LPI 일반 고급형 AT LPG',
      RENTDATE: '20111228',
      UNIT24: '150000',
      TERMTYPE: 'S',
      NETSALEAMT: '316509',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: 'MT기획팀',
      SALEVATAMT: '31651',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '수원지점',
      ACCDATE: '20111224',
      SALEAMT: '348160',
      STARTDATE: ''
    },
    {
      NO: '423',
      CARNAMEMSTNAME2: '그랜드 스타렉스 12P WAGON 2500 VGT CVX Deluxe AT 디젤',
      RETURNDATE: '20120106',
      ACCNO: '201201020187',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1140111007895',
      CONTRACTNO: 'SS1476120162121',
      RENTFEE: '219000',
      OBJCARNO: '74허3245',
      CARNO: '72허3730',
      ACCPERSONNAME: '윤원재',
      DATA_KEY: '423',
      CARNAMEMSTNAME: '그랜드 스타렉스 12P WAGON 2500 VGT CVX Deluxe AT 디젤',
      RENTDATE: '20120103',
      UNIT24: '219000',
      TERMTYPE: 'S',
      NETSALEAMT: '229756',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: 'MT기획팀',
      SALEVATAMT: '22976',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '안산지점',
      ACCDATE: '20111230',
      SALEAMT: '252732',
      STARTDATE: ''
    },
    {
      NO: '424',
      CARNAMEMSTNAME2: '포르테 1600 CVVT S 고급형 AT 휘발유',
      RETURNDATE: '20120104',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '50',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1476120162123',
      RENTFEE: '116000',
      OBJCARNO: '46도3421',
      CARNO: '41허5482',
      ACCPERSONNAME: '',
      DATA_KEY: '424',
      CARNAMEMSTNAME: 'i30 1600 VVT Luxury AT 휘발유',
      RENTDATE: '20120103',
      UNIT24: '99000',
      TERMTYPE: 'S',
      NETSALEAMT: '73864',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: 'MT기획팀',
      SALEVATAMT: '7386',
      REPAIRPERSONNAME: '',
      PROMOCODE: '리스대차',
      TERMTYPE2: '',
      DEPTNAME: 'AJ캐피탈',
      ACCDATE: '',
      SALEAMT: '81250',
      STARTDATE: ''
    },
    {
      NO: '425',
      CARNAMEMSTNAME2: '모닝 1000 LPI LX 기본형 AT LPG',
      RETURNDATE: '20120103',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1476111255266',
      RENTFEE: '0',
      OBJCARNO: '60허5021',
      CARNO: '59허2038',
      ACCPERSONNAME: '',
      DATA_KEY: '425',
      CARNAMEMSTNAME: 'SM5 2000 LPI 렌터카 모범형 AT LPG',
      RENTDATE: '20111229',
      UNIT24: '95000',
      TERMTYPE: 'S',
      NETSALEAMT: '123513',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: 'MT기획팀',
      SALEVATAMT: '12351',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '강남지점',
      ACCDATE: '',
      SALEAMT: '135864',
      STARTDATE: ''
    },
    {
      NO: '426',
      CARNAMEMSTNAME2: 'SM5 New Impression 2000 γ - 1.6 LPi 엔진 SE Black AT LPG',
      RETURNDATE: '20120103',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1848111253180',
      RENTFEE: '165000',
      OBJCARNO: '04허1312',
      CARNO: '49허6127',
      ACCPERSONNAME: '',
      DATA_KEY: '426',
      CARNAMEMSTNAME: '소나타 Y20 렌터카 2000 LPI Premier AT LPG',
      RENTDATE: '20111227',
      UNIT24: '150000',
      TERMTYPE: 'S',
      NETSALEAMT: '316509',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '수원삼정예약소',
      SALEVATAMT: '31651',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '거제지점',
      ACCDATE: '',
      SALEAMT: '348160',
      STARTDATE: ''
    },
    {
      NO: '427',
      CARNAMEMSTNAME2: '로체 이노베이션 2000 CVVT LX20 기본형 AT 휘발유',
      RETURNDATE: '20120103',
      ACCNO: '201112263122',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1130090438147',
      CONTRACTNO: 'SS1360111253089',
      RENTFEE: '142000',
      OBJCARNO: '32허5289',
      CARNO: '32허3492',
      ACCPERSONNAME: '박수호',
      DATA_KEY: '427',
      CARNAMEMSTNAME: '소나타 트랜스폼 N20 2000 VVT Premier Black 최고급형 AT 휘발유',
      RENTDATE: '20111227',
      UNIT24: '142000',
      TERMTYPE: 'S',
      NETSALEAMT: '284975',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '진주사천지점',
      SALEVATAMT: '28497',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '수원지점',
      ACCDATE: '20111226',
      SALEAMT: '313472',
      STARTDATE: ''
    },
    {
      NO: '428',
      CARNAMEMSTNAME2: '토스카 PREMIUM 6 2000 LPGi L6 2.0 AT LPG',
      RETURNDATE: '20120102',
      ACCNO: '201112293512',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1470100455764',
      CONTRACTNO: 'SS1848111259055',
      RENTFEE: '150000',
      OBJCARNO: '56허9283',
      CARNO: '41허3703',
      ACCPERSONNAME: '김대윤',
      DATA_KEY: '428',
      CARNAMEMSTNAME: '소나타 트랜스폼 N20 2000 LPI Deluxe AT LPG',
      RENTDATE: '20111229',
      UNIT24: '150000',
      TERMTYPE: 'S',
      NETSALEAMT: '201527',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '수원삼정예약소',
      SALEVATAMT: '20153',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업2팀',
      ACCDATE: '20111229',
      SALEAMT: '221680',
      STARTDATE: ''
    },
    {
      NO: '429',
      CARNAMEMSTNAME2: '뉴싼타페 2200 VGT MLX 최고급형 AT 디젤',
      RETURNDATE: '20120105',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1140120162290',
      RENTFEE: '190000',
      OBJCARNO: '08허8700',
      CARNO: '06허4757',
      ACCPERSONNAME: '',
      DATA_KEY: '429',
      CARNAMEMSTNAME: '스포티지R 4WD 2000 E-VGT LX AT 디젤',
      RENTDATE: '20120104',
      UNIT24: '199000',
      TERMTYPE: 'S',
      NETSALEAMT: '62182',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '안산지점',
      SALEVATAMT: '6218',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '평택지점',
      ACCDATE: '',
      SALEAMT: '68400',
      STARTDATE: ''
    },
    {
      NO: '430',
      CARNAMEMSTNAME2: 'K7 The Prestige 2400 I4 세타 Ⅱ 2.4GDI 럭셔리 AT 휘발유',
      RETURNDATE: '20120109',
      ACCNO: '201201040498',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1454111007613',
      CONTRACTNO: 'SS1878120162448',
      RENTFEE: '266000',
      OBJCARNO: '39허6696',
      CARNO: '39허5889',
      ACCPERSONNAME: '김선연',
      DATA_KEY: '430',
      CARNAMEMSTNAME: 'K7 The Prestige 2400 I4 세타 Ⅱ 2.4GDI 럭셔리 AT 휘발유',
      RENTDATE: '20120105',
      UNIT24: '266000',
      TERMTYPE: 'S',
      NETSALEAMT: '253964',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '성수트루예약소',
      SALEVATAMT: '25396',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업3팀',
      ACCDATE: '20111228',
      SALEAMT: '279360',
      STARTDATE: ''
    },
    {
      NO: '431',
      CARNAMEMSTNAME2: '아반떼 M16 1600 LPI 렌터카 DELUXE AT LPG',
      RETURNDATE: '20120107',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1921120162461',
      RENTFEE: '109000',
      OBJCARNO: '62허4850',
      CARNO: '44허5962',
      ACCPERSONNAME: '',
      DATA_KEY: '431',
      CARNAMEMSTNAME: '아반떼 M16 1600 LPI 렌터카 LUXURY AT LPG',
      RENTDATE: '20120105',
      UNIT24: '109000',
      TERMTYPE: 'S',
      NETSALEAMT: '78756',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '안산사동예약소',
      SALEVATAMT: '7876',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '평택지점',
      ACCDATE: '',
      SALEAMT: '86632',
      STARTDATE: ''
    },
    {
      NO: '432',
      CARNAMEMSTNAME2: '소나타 Y20 2000 I4 세타 Ⅱ Prime AT 휘발유',
      RETURNDATE: '20120109',
      ACCNO: '201201050598',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1100110164982',
      CONTRACTNO: 'SS1801120166611',
      RENTFEE: '150000',
      OBJCARNO: '60허6826',
      CARNO: '26허8297',
      ACCPERSONNAME: '김대윤',
      DATA_KEY: '432',
      CARNAMEMSTNAME: '소나타 N20 2000 LPI DLX 기본형 AT LPG',
      RENTDATE: '20120106',
      UNIT24: '160000',
      TERMTYPE: 'S',
      NETSALEAMT: '138225',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '인천21세기',
      SALEVATAMT: '13823',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '인천지점',
      ACCDATE: '20120105',
      SALEAMT: '152048',
      STARTDATE: ''
    },
    {
      NO: '433',
      CARNAMEMSTNAME2: '오피러스 PREMIUM 2700 V6 뮤 GH270 스페셜-럭셔리 AT 휘발유',
      RETURNDATE: '20120109',
      ACCNO: '201201050581',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LE1460100557128',
      CONTRACTNO: 'SS1913120162346',
      RENTFEE: '399000',
      OBJCARNO: '44허2254',
      CARNO: '56허8251',
      ACCPERSONNAME: '김병준',
      DATA_KEY: '433',
      CARNAMEMSTNAME: '제네시스 3300 람다 BH330 GRAND PRIME PACK AT 휘발유',
      RENTDATE: '20120105',
      UNIT24: '307000',
      TERMTYPE: 'S',
      NETSALEAMT: '365236',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '성동성수예약소',
      SALEVATAMT: '36524',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업4팀',
      ACCDATE: '20120105',
      SALEAMT: '401760',
      STARTDATE: ''
    },
    {
      NO: '434',
      CARNAMEMSTNAME2: '소나타 Y20 렌터카 2000 LPI Premier AT LPG',
      RETURNDATE: '20120110',
      ACCNO: '201201060751',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1355110805778',
      CONTRACTNO: 'SS1837120166044',
      RENTFEE: '165000',
      OBJCARNO: '68허3556',
      CARNO: '47허5994',
      ACCPERSONNAME: '박수호',
      DATA_KEY: '434',
      CARNAMEMSTNAME: '소나타 Y20 렌터카 2000 LPI Luxury AT LPG',
      RENTDATE: '20120109',
      UNIT24: '165000',
      TERMTYPE: 'S',
      NETSALEAMT: '87273',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '부산태원',
      SALEVATAMT: '8727',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '부산지점',
      ACCDATE: '20120106',
      SALEAMT: '96000',
      STARTDATE: ''
    },
    {
      NO: '435',
      CARNAMEMSTNAME2: '라세티 프리미어 1800 ECOTEC SX IDENTITY 일반형 AT 휘발유',
      RETURNDATE: '20120102',
      ACCNO: '201112263097',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1420110164868',
      CONTRACTNO: 'SS1903111250823',
      RENTFEE: '99000',
      OBJCARNO: '60허6750',
      CARNO: '41허4089',
      ACCPERSONNAME: '김병준',
      DATA_KEY: '435',
      CARNAMEMSTNAME: '뉴아반떼 1600 VVT E16 VALUE AT 휘발유/LPG',
      RENTDATE: '20111226',
      UNIT24: '99000',
      TERMTYPE: 'S',
      NETSALEAMT: '185309',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '구로현주예약소',
      SALEVATAMT: '18531',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: 'SU6팀',
      ACCDATE: '20111226',
      SALEAMT: '203840',
      STARTDATE: ''
    },
    {
      NO: '436',
      CARNAMEMSTNAME2: '소나타 트랜스폼 N20 2000 LPI 일반형 AT LPG',
      RETURNDATE: '20120110',
      ACCNO: '201201080884',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1080101264463',
      CONTRACTNO: 'SS1818120166795',
      RENTFEE: '165000',
      OBJCARNO: '63허8772',
      CARNO: '27허7435',
      ACCPERSONNAME: '김현철',
      DATA_KEY: '436',
      CARNAMEMSTNAME: '소나타 Y20 렌터카 2000 LPI Premier AT LPG',
      RENTDATE: '20120109',
      UNIT24: '150000',
      TERMTYPE: 'S',
      NETSALEAMT: '59345',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '도곡예약소',
      SALEVATAMT: '5935',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '강남지점',
      ACCDATE: '20120108',
      SALEAMT: '65280',
      STARTDATE: ''
    },
    {
      NO: '437',
      CARNAMEMSTNAME2: '소나타 Y20 렌터카 2000 LPI Luxury AT LPG',
      RETURNDATE: '20120109',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1937120166926',
      RENTFEE: '165000',
      OBJCARNO: '12허4128',
      CARNO: '52허5494',
      ACCPERSONNAME: '',
      DATA_KEY: '437',
      CARNAMEMSTNAME: 'K5렌터카 2000 LPI 디럭스 AT LPG',
      RENTDATE: '20120109',
      UNIT24: '165000',
      TERMTYPE: 'S',
      NETSALEAMT: '54545',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '성수한국타이어예약소',
      SALEVATAMT: '5455',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '천안아산지점',
      ACCDATE: '',
      SALEAMT: '60000',
      STARTDATE: ''
    },
    {
      NO: '438',
      CARNAMEMSTNAME2: 'K5렌터카 2000 LPI 디럭스 AT LPG',
      RETURNDATE: '20120106',
      ACCNO: '201201040395',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1457110906761',
      CONTRACTNO: 'SS1260120167094',
      RENTFEE: '165000',
      OBJCARNO: '52허3527',
      CARNO: '63허3342',
      ACCPERSONNAME: '박수호',
      DATA_KEY: '438',
      CARNAMEMSTNAME: '소나타 Y20 렌터카 2000 LPI Deluxe AT LPG',
      RENTDATE: '20120105',
      UNIT24: '165000',
      TERMTYPE: 'S',
      NETSALEAMT: '89855',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '광주지점',
      SALEVATAMT: '8985',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업1팀',
      ACCDATE: '20120104',
      SALEAMT: '98840',
      STARTDATE: ''
    },
    {
      NO: '439',
      CARNAMEMSTNAME2: '엑센트 1600 VGT PREMIER AT 디젤',
      RETURNDATE: '20120109',
      ACCNO: '201112242797',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1150110589751',
      CONTRACTNO: 'SS1848111251401',
      RENTFEE: '150000',
      OBJCARNO: '05허7713',
      CARNO: '41허5530',
      ACCPERSONNAME: '김병준',
      DATA_KEY: '439',
      CARNAMEMSTNAME: 'SM5 New Impression 렌터카 2000 LPLi 고급형 AT LPG',
      RENTDATE: '20111224',
      UNIT24: '99000',
      TERMTYPE: 'S',
      NETSALEAMT: '423564',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '수원삼정예약소',
      SALEVATAMT: '42356',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '도봉지점',
      ACCDATE: '20111224',
      SALEAMT: '465920',
      STARTDATE: ''
    },
    {
      NO: '440',
      CARNAMEMSTNAME2: '소나타 트랜스폼 N20 2000 LPI 고급형 AT LPG',
      RETURNDATE: '20120103',
      ACCNO: '201112242778',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1460090539999',
      CONTRACTNO: 'SS1848111251404',
      RENTFEE: '150000',
      OBJCARNO: '32허5882',
      CARNO: '41허1403',
      ACCPERSONNAME: '윤원재',
      DATA_KEY: '440',
      CARNAMEMSTNAME: '소나타 N20 2000 LPI DLX 기본형 AT LPG',
      RENTDATE: '20111224',
      UNIT24: '150000',
      TERMTYPE: 'S',
      NETSALEAMT: '409731',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '수원삼정예약소',
      SALEVATAMT: '40973',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업4팀',
      ACCDATE: '20111224',
      SALEAMT: '450704',
      STARTDATE: ''
    },
    {
      NO: '441',
      CARNAMEMSTNAME2: 'New SM5  2000 CVTC Ⅱ RE AT 휘발유',
      RETURNDATE: '20120106',
      ACCNO: '201112242779',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1460100455334',
      CONTRACTNO: 'SS1974111251623',
      RENTFEE: '116000',
      OBJCARNO: '56허9238',
      CARNO: '52허5984',
      ACCPERSONNAME: '김대윤',
      DATA_KEY: '441',
      CARNAMEMSTNAME: '아반떼 LPI 하이브리드 1600 γ - 1.6 LPi 엔진 HDe 2 AT 하이브리드/LPG',
      RENTDATE: '20111224',
      UNIT24: '160000',
      TERMTYPE: 'S',
      NETSALEAMT: '415229',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '성남단대역예약소',
      SALEVATAMT: '41523',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업3팀',
      ACCDATE: '20111224',
      SALEAMT: '456752',
      STARTDATE: ''
    },
    {
      NO: '442',
      CARNAMEMSTNAME2: 'i30 1600 VGT Luxury AT 디젤',
      RETURNDATE: '20120107',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1320120165713',
      RENTFEE: '109000',
      OBJCARNO: '04허5658',
      CARNO: '44허5909',
      ACCPERSONNAME: '',
      DATA_KEY: '442',
      CARNAMEMSTNAME: '아반떼 M16 GDi 1600 GDI LUXURY AT 휘발유',
      RENTDATE: '20120105',
      UNIT24: '116000',
      TERMTYPE: 'S',
      NETSALEAMT: '66182',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '포항지점',
      SALEVATAMT: '6618',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '포항지점',
      ACCDATE: '',
      SALEAMT: '72800',
      STARTDATE: ''
    },
    {
      NO: '443',
      CARNAMEMSTNAME2: 'K5렌터카 2000 LPI 럭셔리 AT LPG',
      RETURNDATE: '20120109',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1320120165721',
      RENTFEE: '165000',
      OBJCARNO: '52허7039',
      CARNO: '55허1099',
      ACCPERSONNAME: '',
      DATA_KEY: '443',
      CARNAMEMSTNAME: '소나타 Y20 렌터카 2000 LPI Luxury AT LPG',
      RENTDATE: '20120102',
      UNIT24: '165000',
      TERMTYPE: 'S',
      NETSALEAMT: '321000',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '포항지점',
      SALEVATAMT: '32100',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '포항지점',
      ACCDATE: '',
      SALEAMT: '353100',
      STARTDATE: ''
    },
    {
      NO: '444',
      CARNAMEMSTNAME2: 'K7 렌터카 2700 V6 뮤 VG270 럭셔리 프리미엄 AT LPG',
      RETURNDATE: '20120109',
      ACCNO: '201112313747',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1351110165193',
      CONTRACTNO: 'SS1837111258719',
      RENTFEE: '165000',
      OBJCARNO: '47허5980',
      CARNO: '47허5902',
      ACCPERSONNAME: '박수호',
      DATA_KEY: '444',
      CARNAMEMSTNAME: '소나타 Y20 렌터카 2000 LPI Luxury AT LPG',
      RENTDATE: '20111231',
      UNIT24: '292000',
      TERMTYPE: 'S',
      NETSALEAMT: '408273',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '부산태원',
      SALEVATAMT: '40827',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '해운대지점',
      ACCDATE: '20111231',
      SALEAMT: '449100',
      STARTDATE: ''
    },
    {
      NO: '445',
      CARNAMEMSTNAME2: 'K5렌터카 2000 LPI 스마트 AT LPG',
      RETURNDATE: '20120107',
      ACCNO: '201112303681',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1454110473291',
      CONTRACTNO: 'SS1903111258723',
      RENTFEE: '165000',
      OBJCARNO: '44허5266',
      CARNO: '52허7368',
      ACCPERSONNAME: '김병준',
      DATA_KEY: '445',
      CARNAMEMSTNAME: '소나타 Y20 렌터카 2000 LPI Luxury AT LPG',
      RENTDATE: '20111230',
      UNIT24: '165000',
      TERMTYPE: 'S',
      NETSALEAMT: '349091',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '구로현주예약소',
      SALEVATAMT: '34909',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업3팀',
      ACCDATE: '20111230',
      SALEAMT: '384000',
      STARTDATE: ''
    },
    {
      NO: '446',
      CARNAMEMSTNAME2: '싼타페 The Style 4WD 2200 E-VGT CLX DELUXE AT 디젤',
      RETURNDATE: '20120104',
      ACCNO: '201201010016',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'SS1040111110177',
      CONTRACTNO: 'SS1878120159255',
      RENTFEE: '190000',
      OBJCARNO: '05허7422',
      CARNO: '06허4754',
      ACCPERSONNAME: '김현철',
      DATA_KEY: '446',
      CARNAMEMSTNAME: '스포티지R 4WD 2000 E-VGT LX AT 디젤',
      RENTDATE: '20120102',
      UNIT24: '199000',
      TERMTYPE: 'S',
      NETSALEAMT: '142087',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '성수트루예약소',
      SALEVATAMT: '14209',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'M',
      DEPTNAME: '강동지점',
      ACCDATE: '20120101',
      SALEAMT: '156296',
      STARTDATE: ''
    },
    {
      NO: '447',
      CARNAMEMSTNAME2: '소나타 Y20 렌터카 2000 LPI Luxury AT LPG',
      RETURNDATE: '20120103',
      ACCNO: '201112283441',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1453111007907',
      CONTRACTNO: 'SS1878111254423',
      RENTFEE: '165000',
      OBJCARNO: '45허4672',
      CARNO: '59허9109',
      ACCPERSONNAME: '김대윤',
      DATA_KEY: '447',
      CARNAMEMSTNAME: 'NEW SM5 렌터카 2000 CVTC Ⅱ LPLi 고급형 AT LPG',
      RENTDATE: '20111229',
      UNIT24: '165000',
      TERMTYPE: 'S',
      NETSALEAMT: '234484',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '성수트루예약소',
      SALEVATAMT: '23448',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업2팀',
      ACCDATE: '20111228',
      SALEAMT: '257932',
      STARTDATE: ''
    },
    {
      NO: '448',
      CARNAMEMSTNAME2: 'NEW 다마스코치 800 LPG 5P DLX MT LPG',
      RETURNDATE: '20120110',
      ACCNO: '201201020175',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1470081031985',
      CONTRACTNO: 'SS1476120168433',
      RENTFEE: '142000',
      OBJCARNO: '70허2155',
      CARNO: '56허8369',
      ACCPERSONNAME: '윤원재',
      DATA_KEY: '448',
      CARNAMEMSTNAME: 'SM5 New Impression 2000 γ - 1.6 LPi 엔진 SE Black AT 휘발유',
      RENTDATE: '20120102',
      UNIT24: '0',
      TERMTYPE: 'S',
      NETSALEAMT: '183855',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: 'MT기획팀',
      SALEVATAMT: '18385',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업5팀',
      ACCDATE: '20120102',
      SALEAMT: '202240',
      STARTDATE: ''
    },
    {
      NO: '449',
      CARNAMEMSTNAME2: '로체 이노베이션 렌트카 2000 LPI LX20 기본형 스페셜 AT LPG',
      RETURNDATE: '20120106',
      ACCNO: '201112303643',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1470090337844',
      CONTRACTNO: 'SS1848111259264',
      RENTFEE: '165000',
      OBJCARNO: '32허5204',
      CARNO: '60허5587',
      ACCPERSONNAME: '김병준',
      DATA_KEY: '449',
      CARNAMEMSTNAME: 'K5렌터카 2000 LPI 디럭스 AT LPG',
      RENTDATE: '20111230',
      UNIT24: '150000',
      TERMTYPE: 'S',
      NETSALEAMT: '281644',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '수원삼정예약소',
      SALEVATAMT: '28164',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: 'SU7팀',
      ACCDATE: '20111230',
      SALEAMT: '309808',
      STARTDATE: ''
    },
    {
      NO: '450',
      CARNAMEMSTNAME2: '소나타 Y20 2000 I4 세타 Ⅱ 월드컵 Special Edition AT 휘발유',
      RETURNDATE: '20120102',
      ACCNO: '201112293538',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1170100658674',
      CONTRACTNO: 'SS1901120159335',
      RENTFEE: '165000',
      OBJCARNO: '05허4752',
      CARNO: '59허2747',
      ACCPERSONNAME: '김현철',
      DATA_KEY: '450',
      CARNAMEMSTNAME: '소나타 Y20 렌터카 2000 LPI Luxury AT LPG',
      RENTDATE: '20120102',
      UNIT24: '160000',
      TERMTYPE: 'S',
      NETSALEAMT: '54545',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '경기광주예약소',
      SALEVATAMT: '5455',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '청주지점',
      ACCDATE: '20111228',
      SALEAMT: '60000',
      STARTDATE: ''
    },
    {
      NO: '451',
      CARNAMEMSTNAME2: '소나타 Y20 렌터카 2000 LPI Deluxe AT LPG',
      RETURNDATE: '20120102',
      ACCNO: '201112303601',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LD1457110603620',
      CONTRACTNO: 'SS1818111255366',
      RENTFEE: '165000',
      OBJCARNO: '62허5717',
      CARNO: '62허4067',
      ACCPERSONNAME: '김병준',
      DATA_KEY: '451',
      CARNAMEMSTNAME: 'K5렌터카 2000 LPI 디럭스 AT LPG',
      RENTDATE: '20111230',
      UNIT24: '165000',
      TERMTYPE: 'S',
      NETSALEAMT: '147258',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '도곡예약소',
      SALEVATAMT: '14726',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: 'SU6팀',
      ACCDATE: '20111220',
      SALEAMT: '161984',
      STARTDATE: ''
    },
    {
      NO: '452',
      CARNAMEMSTNAME2: '아반떼 M16 1600 LPI 렌터카 DELUXE AT LPG',
      RETURNDATE: '20120110',
      ACCNO: '201201060780',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1060110805055',
      CONTRACTNO: 'SS1818120166336',
      RENTFEE: '165000',
      OBJCARNO: '45허4306',
      CARNO: '62허4067',
      ACCPERSONNAME: '김대윤',
      DATA_KEY: '452',
      CARNAMEMSTNAME: 'K5렌터카 2000 LPI 디럭스 AT LPG',
      RENTDATE: '20120109',
      UNIT24: '109000',
      TERMTYPE: 'S',
      NETSALEAMT: '52945',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '도곡예약소',
      SALEVATAMT: '5295',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '건대지점',
      ACCDATE: '20120106',
      SALEAMT: '58240',
      STARTDATE: ''
    },
    {
      NO: '453',
      CARNAMEMSTNAME2: 'K7 2700 V6 뮤 VG270 럭셔리 AT 휘발유',
      RETURNDATE: '20120110',
      ACCNO: '201201080899',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'SS1050111250146',
      CONTRACTNO: 'SS1818120166341',
      RENTFEE: '266000',
      OBJCARNO: '63허4531',
      CARNO: '41허2387',
      ACCPERSONNAME: '김선연',
      DATA_KEY: '453',
      CARNAMEMSTNAME: '그랜져TG 2700 DOHC Q270 LUXURY AT 휘발유',
      RENTDATE: '20120108',
      UNIT24: '292000',
      TERMTYPE: 'S',
      NETSALEAMT: '172400',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '도곡예약소',
      SALEVATAMT: '17240',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'M',
      DEPTNAME: '분당지점',
      ACCDATE: '20120108',
      SALEAMT: '189640',
      STARTDATE: ''
    },
    {
      NO: '454',
      CARNAMEMSTNAME2: '소나타 N20 2000 LPI 일반 고급형 AT LPG',
      RETURNDATE: '20120109',
      ACCNO: '201201030373',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1460080526484',
      CONTRACTNO: 'SS1907120167144',
      RENTFEE: '165000',
      OBJCARNO: '18허4048',
      CARNO: '04허3219',
      ACCPERSONNAME: '이준엽',
      DATA_KEY: '454',
      CARNAMEMSTNAME: '소나타 Y20 렌터카 2000 LPI Luxury AT LPG',
      RENTDATE: '20120103',
      UNIT24: '150000',
      TERMTYPE: 'S',
      NETSALEAMT: '257153',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '당진원당예약소',
      SALEVATAMT: '25715',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업3팀',
      ACCDATE: '20120103',
      SALEAMT: '282868',
      STARTDATE: ''
    },
    {
      NO: '455',
      CARNAMEMSTNAME2: '아반떼 M16 GDi 1600 GDI LUXURY AT 휘발유',
      RETURNDATE: '20120102',
      ACCNO: '201112273305',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1450101264470',
      CONTRACTNO: 'SS1818111254763',
      RENTFEE: '109000',
      OBJCARNO: '63허8160',
      CARNO: '63허8969',
      ACCPERSONNAME: '김선연',
      DATA_KEY: '455',
      CARNAMEMSTNAME: '아반떼 M16 GDi 1600 GDI LUXURY AT 휘발유',
      RENTDATE: '20111229',
      UNIT24: '109000',
      TERMTYPE: 'S',
      NETSALEAMT: '137989',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '도곡예약소',
      SALEVATAMT: '13799',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: 'SU7팀',
      ACCDATE: '20111227',
      SALEAMT: '151788',
      STARTDATE: ''
    },
    {
      NO: '456',
      CARNAMEMSTNAME2: '오피러스 PREMIUM 3300 V6 람다 GH330 럭셔리 AT 휘발유',
      RETURNDATE: '20120102',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1937111254823',
      RENTFEE: '488000',
      OBJCARNO: '69허2881',
      CARNO: '04허2290',
      ACCPERSONNAME: '',
      DATA_KEY: '456',
      CARNAMEMSTNAME: '에쿠스 TRUE PRESTIGE 3800 V6 람다 VS 380 럭셔리 AT 휘발유',
      RENTDATE: '20111229',
      UNIT24: '349000',
      TERMTYPE: 'S',
      NETSALEAMT: '484567',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '성수한국타이어예약소',
      SALEVATAMT: '48457',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '원주지점',
      ACCDATE: '',
      SALEAMT: '533024',
      STARTDATE: ''
    },
    {
      NO: '457',
      CARNAMEMSTNAME2: '에쿠스 TRUE PRESTIGE 4600 V8타우 VS 460 프레스티지 AT 휘발유',
      RETURNDATE: '20120105',
      ACCNO: '201201020076',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1470100456613',
      CONTRACTNO: 'SS1476120160403',
      RENTFEE: '557000',
      OBJCARNO: '60허5500',
      CARNO: '32허8078',
      ACCPERSONNAME: '김현철',
      DATA_KEY: '457',
      CARNAMEMSTNAME: '에쿠스 TRUE PRESTIGE 4600 V8타우 VS 460 프레스티지 AT 휘발유',
      RENTDATE: '20120102',
      UNIT24: '557000',
      TERMTYPE: 'S',
      NETSALEAMT: '481942',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: 'MT기획팀',
      SALEVATAMT: '48194',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업3팀',
      ACCDATE: '20120102',
      SALEAMT: '530136',
      STARTDATE: ''
    },
    {
      NO: '458',
      CARNAMEMSTNAME2: '소나타 트랜스폼 N20 2000 VVT Elegance Special 고급형 AT 휘발유',
      RETURNDATE: '20120105',
      ACCNO: '201201020142',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1440090743554',
      CONTRACTNO: 'SS1476120160405',
      RENTFEE: '142000',
      OBJCARNO: '32허8077',
      CARNO: '04허1273',
      ACCPERSONNAME: '윤원재',
      DATA_KEY: '458',
      CARNAMEMSTNAME: 'SM5 New Impression 2000 γ - 1.6 LPi 엔진 SE Plus AT 휘발유',
      RENTDATE: '20120102',
      UNIT24: '142000',
      TERMTYPE: 'S',
      NETSALEAMT: '126604',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: 'MT기획팀',
      SALEVATAMT: '12660',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '동대문지점',
      ACCDATE: '20111222',
      SALEAMT: '139264',
      STARTDATE: ''
    },
    {
      NO: '459',
      CARNAMEMSTNAME2: '체어맨 H 2800 DOHC 500S VIP AT 휘발유',
      RETURNDATE: '20120104',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1476120160408',
      RENTFEE: '447000',
      OBJCARNO: '21허5818',
      CARNO: '59허1629',
      ACCPERSONNAME: '',
      DATA_KEY: '459',
      CARNAMEMSTNAME: '체어맨 W 3600 IL6 CW 700 VVIP AT 휘발유',
      RENTDATE: '20120102',
      UNIT24: '349000',
      TERMTYPE: 'S',
      NETSALEAMT: '245636',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: 'MT기획팀',
      SALEVATAMT: '24564',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '영업4팀',
      ACCDATE: '',
      SALEAMT: '270200',
      STARTDATE: ''
    },
    {
      NO: '460',
      CARNAMEMSTNAME2: 'K7 The Prestige 2400 I4 세타 Ⅱ 2.4GDI 럭셔리 AT 휘발유',
      RETURNDATE: '20120105',
      ACCNO: '201201030232',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1458110599332',
      CONTRACTNO: 'SS1878120160430',
      RENTFEE: '266000',
      OBJCARNO: '04허7536',
      CARNO: '39허5889',
      ACCPERSONNAME: '김대윤',
      DATA_KEY: '460',
      CARNAMEMSTNAME: 'K7 The Prestige 2400 I4 세타 Ⅱ 2.4GDI 럭셔리 AT 휘발유',
      RENTDATE: '20120103',
      UNIT24: '266000',
      TERMTYPE: 'S',
      NETSALEAMT: '138945',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '성수트루예약소',
      SALEVATAMT: '13895',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업5팀',
      ACCDATE: '20120103',
      SALEAMT: '152840',
      STARTDATE: ''
    },
    {
      NO: '461',
      CARNAMEMSTNAME2: '에쿠스 TRUE PRESTIGE 3800 V6 람다 VS 380 럭셔리 AT 휘발유',
      RETURNDATE: '20120104',
      ACCNO: '201112313749',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1433110266023',
      CONTRACTNO: 'SS1945120160433',
      RENTFEE: '488000',
      OBJCARNO: '05허6969',
      CARNO: '60허6224',
      ACCPERSONNAME: '김현철',
      DATA_KEY: '461',
      CARNAMEMSTNAME: '에쿠스 TRUE PRESTIGE 3800 V6 람다 VS 380 럭셔리 AT 휘발유',
      RENTDATE: '20120102',
      UNIT24: '488000',
      TERMTYPE: 'S',
      NETSALEAMT: '337349',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '일산탄현예약소',
      SALEVATAMT: '33735',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '안양지점',
      ACCDATE: '20111230',
      SALEAMT: '371084',
      STARTDATE: ''
    },
    {
      NO: '462',
      CARNAMEMSTNAME2: '뉴프라이드 1400 DOHC L AT 휘발유/LPG',
      RETURNDATE: '20120109',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1476111251825',
      RENTFEE: '150000',
      OBJCARNO: '62허4636',
      CARNO: '16허7525',
      ACCPERSONNAME: '',
      DATA_KEY: '462',
      CARNAMEMSTNAME: '소나타 N20 2000 LPI DLX 기본형 AT LPG',
      RENTDATE: '20111226',
      UNIT24: '99000',
      TERMTYPE: 'S',
      NETSALEAMT: '376905',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: 'MT기획팀',
      SALEVATAMT: '37691',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '부천지점',
      ACCDATE: '',
      SALEAMT: '414596',
      STARTDATE: ''
    },
    {
      NO: '463',
      CARNAMEMSTNAME2: '소나타 트랜스폼 N20 2000 LPI Premier AT LPG',
      RETURNDATE: '20120105',
      ACCNO: '201112303671',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1420090945112',
      CONTRACTNO: 'SS1903111258713',
      RENTFEE: '165000',
      OBJCARNO: '32허9001',
      CARNO: '56허9179',
      ACCPERSONNAME: '김대윤',
      DATA_KEY: '463',
      CARNAMEMSTNAME: '소나타 Y20 렌터카 2000 LPI Premier AT LPG',
      RENTDATE: '20111230',
      UNIT24: '150000',
      TERMTYPE: 'S',
      NETSALEAMT: '267055',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '구로현주예약소',
      SALEVATAMT: '26705',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: 'SU6팀',
      ACCDATE: '20111230',
      SALEAMT: '293760',
      STARTDATE: ''
    },
    {
      NO: '464',
      CARNAMEMSTNAME2: '5G 그랜져 2400 GDI HG240 LUXURY AT 휘발유',
      RETURNDATE: '20120103',
      ACCNO: '201112293530',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1458111209490',
      CONTRACTNO: 'SS1937111258650',
      RENTFEE: '266000',
      OBJCARNO: '52허6604',
      CARNO: '06허4518',
      ACCPERSONNAME: '김병준',
      DATA_KEY: '464',
      CARNAMEMSTNAME: '5G 그랜져 2400 GDI HG240 LUXURY AT 휘발유',
      RENTDATE: '20111230',
      UNIT24: '266000',
      TERMTYPE: 'S',
      NETSALEAMT: '325160',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '성수한국타이어예약소',
      SALEVATAMT: '32516',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: 'SU7팀',
      ACCDATE: '20111229',
      SALEAMT: '357676',
      STARTDATE: ''
    },
    {
      NO: '465',
      CARNAMEMSTNAME2: '5G 그랜져 3000 GDI HG300 ROYAL AT 휘발유',
      RETURNDATE: '20120104',
      ACCNO: '201112313762',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1300111209758',
      CONTRACTNO: 'SS1351111258799',
      RENTFEE: '160000',
      OBJCARNO: '57허4330',
      CARNO: '62허5087',
      ACCPERSONNAME: '이준엽',
      DATA_KEY: '465',
      CARNAMEMSTNAME: '소나타 Y20 2000 I4 세타 Ⅱ Prime AT 휘발유',
      RENTDATE: '20111231',
      UNIT24: '292000',
      TERMTYPE: 'S',
      NETSALEAMT: '199836',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '해운대지점',
      SALEVATAMT: '19984',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '울산지점',
      ACCDATE: '20111231',
      SALEAMT: '219820',
      STARTDATE: ''
    },
    {
      NO: '466',
      CARNAMEMSTNAME2: '아반떼 M16 GDi 1600 GDI LUXURY AT 휘발유',
      RETURNDATE: '20120103',
      ACCNO: '201112263145',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1355111209412',
      CONTRACTNO: 'SS1837120158950',
      RENTFEE: '109000',
      OBJCARNO: '47허6386',
      CARNO: '52허5624',
      ACCPERSONNAME: '어성환',
      DATA_KEY: '466',
      CARNAMEMSTNAME: '아반떼 M16 1600 LPI 렌터카 LUXURY AT LPG',
      RENTDATE: '20120102',
      UNIT24: '109000',
      TERMTYPE: 'S',
      NETSALEAMT: '56073',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '부산태원',
      SALEVATAMT: '5607',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '부산지점',
      ACCDATE: '20111226',
      SALEAMT: '61680',
      STARTDATE: ''
    },
    {
      NO: '467',
      CARNAMEMSTNAME2: 'New SM5  2000 CVTC Ⅱ SE Plus AT 휘발유',
      RETURNDATE: '20120109',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1904120165750',
      RENTFEE: '150000',
      OBJCARNO: '62허4592',
      CARNO: '30허2688',
      ACCPERSONNAME: '',
      DATA_KEY: '467',
      CARNAMEMSTNAME: '소나타 트랜스폼 N20 2000 LPI Deluxe AT LPG',
      RENTDATE: '20120107',
      UNIT24: '160000',
      TERMTYPE: 'S',
      NETSALEAMT: '133171',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '원주순호예약소',
      SALEVATAMT: '13317',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '영업2팀',
      ACCDATE: '',
      SALEAMT: '146488',
      STARTDATE: ''
    },
    {
      NO: '468',
      CARNAMEMSTNAME2: '그랜드 스타렉스 12P WAGON 2500 VGT CVX Value AT 디젤',
      RETURNDATE: '20120110',
      ACCNO: '201112242730',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1457110369358',
      CONTRACTNO: 'SS1476111251809',
      RENTFEE: '270000',
      OBJCARNO: '76허1405',
      CARNO: '20허2436',
      ACCPERSONNAME: '윤원재',
      DATA_KEY: '468',
      CARNAMEMSTNAME: '뉴 카니발 9P 2900 CRDI GX 고급형 AT 디젤',
      RENTDATE: '20111226',
      UNIT24: '219000',
      TERMTYPE: 'S',
      NETSALEAMT: '868364',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: 'MT기획팀',
      SALEVATAMT: '86836',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: 'SU6팀',
      ACCDATE: '20111224',
      SALEAMT: '955200',
      STARTDATE: ''
    },
    {
      NO: '469',
      CARNAMEMSTNAME2: 'SM5 New Impression 렌터카 2000 LPI 렌터카 최고급형 AT LPG',
      RETURNDATE: '20120106',
      ACCNO: '201112303717',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1410100354570',
      CONTRACTNO: 'SS1937120159781',
      RENTFEE: '165000',
      OBJCARNO: '28허2375',
      CARNO: '52허5494',
      ACCPERSONNAME: '김병준',
      DATA_KEY: '469',
      CARNAMEMSTNAME: 'K5렌터카 2000 LPI 디럭스 AT LPG',
      RENTDATE: '20120102',
      UNIT24: '150000',
      TERMTYPE: 'S',
      NETSALEAMT: '168127',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '성수한국타이어예약소',
      SALEVATAMT: '16813',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '부천지점',
      ACCDATE: '20111230',
      SALEAMT: '184940',
      STARTDATE: ''
    },
    {
      NO: '470',
      CARNAMEMSTNAME2: '소나타 Y20 렌터카 2000 LPI Luxury AT LPG',
      RETURNDATE: '20120104',
      ACCNO: '201201010011',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1170100658679',
      CONTRACTNO: 'SS1947120159315',
      RENTFEE: '165000',
      OBJCARNO: '12허4409',
      CARNO: '63허5286',
      ACCPERSONNAME: '박수호',
      DATA_KEY: '470',
      CARNAMEMSTNAME: 'NEW SM5 렌터카 2000 CVTC Ⅱ LPLi 고급형 AT LPG',
      RENTDATE: '20120102',
      UNIT24: '165000',
      TERMTYPE: 'S',
      NETSALEAMT: '129818',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '청원서울예약소',
      SALEVATAMT: '12982',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '청주지점',
      ACCDATE: '20120101',
      SALEAMT: '142800',
      STARTDATE: ''
    },
    {
      NO: '471',
      CARNAMEMSTNAME2: '액티언스포츠 2000 XVT AX7(4WD) CLUB AT 디젤',
      RETURNDATE: '20120109',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '50',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1937120159812',
      RENTFEE: '190000',
      OBJCARNO: '85조4878',
      CARNO: '04허5478',
      ACCPERSONNAME: '',
      DATA_KEY: '471',
      CARNAMEMSTNAME: '투싼 ix 2WD 2000 E-VGT X20 Deluxe AT 디젤',
      RENTDATE: '20120102',
      UNIT24: '190000',
      TERMTYPE: 'S',
      NETSALEAMT: '435273',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '성수한국타이어예약소',
      SALEVATAMT: '43527',
      REPAIRPERSONNAME: '',
      PROMOCODE: '리스대차',
      TERMTYPE2: '',
      DEPTNAME: 'AJ캐피탈',
      ACCDATE: '',
      SALEAMT: '478800',
      STARTDATE: ''
    },
    {
      NO: '472',
      CARNAMEMSTNAME2: 'New SM5 장애우용 2000 CVTC Ⅱ LPLi SE AT LPG',
      RETURNDATE: '20120109',
      ACCNO: '201112313780',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1260111209993',
      CONTRACTNO: 'SS1898111269865',
      RENTFEE: '165000',
      OBJCARNO: '41허9144',
      CARNO: '44허1065',
      ACCPERSONNAME: '김선연',
      DATA_KEY: '472',
      CARNAMEMSTNAME: '소나타 Y20 렌터카 2000 LPI Deluxe AT LPG',
      RENTDATE: '20111231',
      UNIT24: '165000',
      TERMTYPE: 'S',
      NETSALEAMT: '392727',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '서울석촌예약소',
      SALEVATAMT: '39273',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '광주지점',
      ACCDATE: '20111231',
      SALEAMT: '432000',
      STARTDATE: ''
    },
    {
      NO: '473',
      CARNAMEMSTNAME2: '쏘렌토 R 2WD 2000 E-VGT LX 고급형 AT 디젤',
      RETURNDATE: '20120110',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1972120167668',
      RENTFEE: '190000',
      OBJCARNO: '17허9283',
      CARNO: '68허3364',
      ACCPERSONNAME: '',
      DATA_KEY: '473',
      CARNAMEMSTNAME: '스포티지R 4WD 2000 E-VGT LX AT 디젤',
      RENTDATE: '20120103',
      UNIT24: '199000',
      TERMTYPE: 'S',
      NETSALEAMT: '383662',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '(폐쇄)순천봉화예약소',
      SALEVATAMT: '38366',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '순천여수지점',
      ACCDATE: '',
      SALEAMT: '422028',
      STARTDATE: ''
    },
    {
      NO: '474',
      CARNAMEMSTNAME2: '모닝 1000 LPI LX 기본형 AT LPG',
      RETURNDATE: '20120110',
      ACCNO: '201112313731',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1200100962208',
      CONTRACTNO: 'SS1913120159487',
      RENTFEE: '95000',
      OBJCARNO: '69허1178',
      CARNO: '41허2321',
      ACCPERSONNAME: '김현철',
      DATA_KEY: '474',
      CARNAMEMSTNAME: '모닝 1000 SOHC LX 기본형 AT 휘발유',
      RENTDATE: '20120102',
      UNIT24: '95000',
      TERMTYPE: 'S',
      NETSALEAMT: '186585',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '성동성수예약소',
      SALEVATAMT: '18659',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '원주지점',
      ACCDATE: '20111231',
      SALEAMT: '205244',
      STARTDATE: ''
    },
    {
      NO: '475',
      CARNAMEMSTNAME2: '싼타페 The Style 4WD 2200 E-VGT CLX DELUXE AT 디젤',
      RETURNDATE: '20120105',
      ACCNO: '201112293523',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1420100251887',
      CONTRACTNO: 'SS1937120159786',
      RENTFEE: '199000',
      OBJCARNO: '56허8759',
      CARNO: '52허5592',
      ACCPERSONNAME: '김병준',
      DATA_KEY: '475',
      CARNAMEMSTNAME: '싼타페 The Style 4WD 2200 E-VGT CLX DELUXE AT 디젤',
      RENTDATE: '20120102',
      UNIT24: '199000',
      TERMTYPE: 'S',
      NETSALEAMT: '167822',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '성수한국타이어예약소',
      SALEVATAMT: '16782',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업3팀',
      ACCDATE: '20111229',
      SALEAMT: '184604',
      STARTDATE: ''
    },
    {
      NO: '476',
      CARNAMEMSTNAME2: '알페온 2400 SIDI EL240 디럭스 AT 휘발유',
      RETURNDATE: '20120110',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1937120159778',
      RENTFEE: '292000',
      OBJCARNO: '52허6212',
      CARNO: '44허1151',
      ACCPERSONNAME: '',
      DATA_KEY: '476',
      CARNAMEMSTNAME: 'K7 2700 V6 뮤 VG270 럭셔리 AT 휘발유',
      RENTDATE: '20120102',
      UNIT24: '266000',
      TERMTYPE: 'S',
      NETSALEAMT: '579920',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '성수한국타이어예약소',
      SALEVATAMT: '57992',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '영업1팀',
      ACCDATE: '',
      SALEAMT: '637912',
      STARTDATE: ''
    },
    {
      NO: '477',
      CARNAMEMSTNAME2: '아반떼 M16 1600 LPI 렌터카 DELUXE AT LPG',
      RETURNDATE: '20120109',
      ACCNO: '201201030330',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1453110165303',
      CONTRACTNO: 'SS1903120160530',
      RENTFEE: '150000',
      OBJCARNO: '05허6050',
      CARNO: '41허3744',
      ACCPERSONNAME: '김대윤',
      DATA_KEY: '477',
      CARNAMEMSTNAME: '소나타 N20 2000 LPI 일반 고급형 AT LPG',
      RENTDATE: '20120103',
      UNIT24: '109000',
      TERMTYPE: 'S',
      NETSALEAMT: '185309',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '구로현주예약소',
      SALEVATAMT: '18531',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업2팀',
      ACCDATE: '20120103',
      SALEAMT: '203840',
      STARTDATE: ''
    },
    {
      NO: '478',
      CARNAMEMSTNAME2: '뉴아반떼 1600 VVT E16 DELUXE AT 휘발유',
      RETURNDATE: '20120102',
      ACCNO: '201112273217',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1050100251387',
      CONTRACTNO: 'SS1873111253171',
      RENTFEE: '99000',
      OBJCARNO: '28허2407',
      CARNO: '38허3462',
      ACCPERSONNAME: '김대윤',
      DATA_KEY: '478',
      CARNAMEMSTNAME: '뉴아반떼 1600 VVT E16 DELUXE AT 휘발유',
      RENTDATE: '20111227',
      UNIT24: '99000',
      TERMTYPE: 'S',
      NETSALEAMT: '172022',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '성수성우예약소',
      SALEVATAMT: '17202',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '분당지점',
      ACCDATE: '20111227',
      SALEAMT: '189224',
      STARTDATE: ''
    },
    {
      NO: '479',
      CARNAMEMSTNAME2: '그랜드 스타렉스 12P WAGON 2500 VGT CVX Luxury AT 디젤',
      RETURNDATE: '20120105',
      ACCNO: '201201030361',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1458111007491',
      CONTRACTNO: 'SS1913120161331',
      RENTFEE: '160000',
      OBJCARNO: '72허6206',
      CARNO: '17허9315',
      ACCPERSONNAME: '김현철',
      DATA_KEY: '479',
      CARNAMEMSTNAME: 'K5 2000 I4 세타 Ⅱ 스마트 스페셜 AT 휘발유',
      RENTDATE: '20120104',
      UNIT24: '219000',
      TERMTYPE: 'S',
      NETSALEAMT: '52727',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '성동성수예약소',
      SALEVATAMT: '5273',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업5팀',
      ACCDATE: '20120103',
      SALEAMT: '58000',
      STARTDATE: ''
    },
    {
      NO: '480',
      CARNAMEMSTNAME2: '그랜드 스타렉스 12P WAGON 2500 VGT CVX Deluxe AT 디젤',
      RETURNDATE: '20120109',
      ACCNO: '201201020141',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LD1170100455188',
      CONTRACTNO: 'SS1476120167438',
      RENTFEE: '219000',
      OBJCARNO: '72허5402',
      CARNO: '71허3758',
      ACCPERSONNAME: '정해성',
      DATA_KEY: '480',
      CARNAMEMSTNAME: '그랜드 스타렉스 12P WAGON 2500 VGT CVX Premium AT 디젤',
      RENTDATE: '20120103',
      UNIT24: '219000',
      TERMTYPE: 'S',
      NETSALEAMT: '405236',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: 'MT기획팀',
      SALEVATAMT: '40524',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '청주지점',
      ACCDATE: '20120102',
      SALEAMT: '445760',
      STARTDATE: ''
    },
    {
      NO: '481',
      CARNAMEMSTNAME2: '뉴 오피러스 2700 V6 뮤 GH270 스페셜 럭셔리 AT 휘발유',
      RETURNDATE: '20120104',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1935120176933',
      RENTFEE: '292000',
      OBJCARNO: '28허2169',
      CARNO: '52허5704',
      ACCPERSONNAME: '',
      DATA_KEY: '481',
      CARNAMEMSTNAME: '5G 그랜져 3000 LPI HG300 렌터카 Prime AT LPG',
      RENTDATE: '20120101',
      UNIT24: '307000',
      TERMTYPE: 'S',
      NETSALEAMT: '319742',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '평택송화예약소',
      SALEVATAMT: '31974',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '평택지점',
      ACCDATE: '',
      SALEAMT: '351716',
      STARTDATE: ''
    },
    {
      NO: '482',
      CARNAMEMSTNAME2: '아반떼 M16 1600 LPI 렌터카 DELUXE AT LPG',
      RETURNDATE: '20120104',
      ACCNO: '201112212316',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1457110906241',
      CONTRACTNO: 'SS1962111250109',
      RENTFEE: '165000',
      OBJCARNO: '52허3422',
      CARNO: '08허1509',
      ACCPERSONNAME: '정해성',
      DATA_KEY: '482',
      CARNAMEMSTNAME: 'K5렌터카 2000 LPI 스마트 AT LPG',
      RENTDATE: '20111221',
      UNIT24: '109000',
      TERMTYPE: 'S',
      NETSALEAMT: '370618',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '완주삼례예약소',
      SALEVATAMT: '37062',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: 'SU6팀',
      ACCDATE: '20111221',
      SALEAMT: '407680',
      STARTDATE: ''
    },
    {
      NO: '483',
      CARNAMEMSTNAME2: 'K7 렌터카 2700 V6 뮤 VG270 프레스티지 프리미엄 AT LPG',
      RETURNDATE: '20120105',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1956120161772',
      RENTFEE: '292000',
      OBJCARNO: '63허6612',
      CARNO: '44허7982',
      ACCPERSONNAME: '',
      DATA_KEY: '483',
      CARNAMEMSTNAME: 'K7 The Prestige 렌터카 3000 V6 람다 3.0LPI 럭셔리 AT LPG',
      RENTDATE: '20120104',
      UNIT24: '292000',
      TERMTYPE: 'S',
      NETSALEAMT: '88000',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '상봉예약소',
      SALEVATAMT: '8800',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '강동지점',
      ACCDATE: '',
      SALEAMT: '96800',
      STARTDATE: ''
    },
    {
      NO: '484',
      CARNAMEMSTNAME2: '제네시스 3300 람다 BH330 LUXURY AT 휘발유',
      RETURNDATE: '20120110',
      ACCNO: '201201030333',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1461091248688',
      CONTRACTNO: 'SS1913120166045',
      RENTFEE: '488000',
      OBJCARNO: '05허1984',
      CARNO: '05허4079',
      ACCPERSONNAME: '김병준',
      DATA_KEY: '484',
      CARNAMEMSTNAME: '에쿠스 TRUE PRESTIGE 3800 V6 람다 VS 380 럭셔리 AT 휘발유',
      RENTDATE: '20120109',
      UNIT24: '399000',
      TERMTYPE: 'S',
      NETSALEAMT: '160582',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '성동성수예약소',
      SALEVATAMT: '16058',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '건대지점',
      ACCDATE: '20111203',
      SALEAMT: '176640',
      STARTDATE: ''
    },
    {
      NO: '485',
      CARNAMEMSTNAME2: '소나타 트랜스폼 N20 2000 LPI Luxury AT LPG',
      RETURNDATE: '20120106',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1898120170310',
      RENTFEE: '266000',
      OBJCARNO: '32허7227',
      CARNO: '32허4423',
      ACCPERSONNAME: '',
      DATA_KEY: '485',
      CARNAMEMSTNAME: '그랜져TG 2700 LPI Q270 모범형 PACK 2 AT LPG',
      RENTDATE: '20120104',
      UNIT24: '150000',
      TERMTYPE: 'S',
      NETSALEAMT: '96400',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '서울석촌예약소',
      SALEVATAMT: '9640',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '잠실지점',
      ACCDATE: '',
      SALEAMT: '106040',
      STARTDATE: ''
    },
    {
      NO: '486',
      CARNAMEMSTNAME2: '싼타페 The Style 4WD 2200 E-VGT CLX DELUXE AT 디젤',
      RETURNDATE: '20120109',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1862111258778',
      RENTFEE: '199000',
      OBJCARNO: '16허7684',
      CARNO: '69허1133',
      ACCPERSONNAME: '',
      DATA_KEY: '486',
      CARNAMEMSTNAME: '쏘렌토 5P 2500 VGT LX 고급형 AT 디젤',
      RENTDATE: '20111230',
      UNIT24: '199000',
      TERMTYPE: 'S',
      NETSALEAMT: '497455',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '대구동구',
      SALEVATAMT: '49745',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '영업5팀',
      ACCDATE: '',
      SALEAMT: '547200',
      STARTDATE: ''
    },
    {
      NO: '487',
      CARNAMEMSTNAME2: '소나타 트랜스폼 N20 2000 LPI 일반형 AT LPG',
      RETURNDATE: '20120107',
      ACCNO: '201201020213',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1470101163549',
      CONTRACTNO: 'SS1837120162295',
      RENTFEE: '109000',
      OBJCARNO: '26허5155',
      CARNO: '52허5639',
      ACCPERSONNAME: '정해성',
      DATA_KEY: '487',
      CARNAMEMSTNAME: '아반떼 M16 1600 LPI 렌터카 LUXURY AT LPG',
      RENTDATE: '20120105',
      UNIT24: '150000',
      TERMTYPE: 'S',
      NETSALEAMT: '69327',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '부산태원',
      SALEVATAMT: '6933',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업1팀',
      ACCDATE: '20120102',
      SALEAMT: '76260',
      STARTDATE: ''
    },
    {
      NO: '488',
      CARNAMEMSTNAME2: '엑센트 1600 VGT LUXURY AT 디젤',
      RETURNDATE: '20120102',
      ACCNO: '201112293532',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1200110602689',
      CONTRACTNO: 'SS1832111254971',
      RENTFEE: '165000',
      OBJCARNO: '69허1180',
      CARNO: '52허7365',
      ACCPERSONNAME: '윤원재',
      DATA_KEY: '488',
      CARNAMEMSTNAME: '소나타 Y20 렌터카 2000 LPI Luxury AT LPG',
      RENTDATE: '20111230',
      UNIT24: '99000',
      TERMTYPE: 'S',
      NETSALEAMT: '109047',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '춘천효성예약소',
      SALEVATAMT: '10905',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '원주지점',
      ACCDATE: '20111229',
      SALEAMT: '119952',
      STARTDATE: ''
    },
    {
      NO: '489',
      CARNAMEMSTNAME2: '5G 그랜져 3000 GDI HG300 PRIME AT 휘발유',
      RETURNDATE: '20120110',
      ACCNO: '201201090941',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1454110602719',
      CONTRACTNO: 'SS1818120166796',
      RENTFEE: '399000',
      OBJCARNO: '59허9204',
      CARNO: '60허5193',
      ACCPERSONNAME: '윤원재',
      DATA_KEY: '489',
      CARNAMEMSTNAME: '제네시스 3300 람다 BH330 LUXURY AT 휘발유',
      RENTDATE: '20120109',
      UNIT24: '292000',
      TERMTYPE: 'S',
      NETSALEAMT: '96364',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '도곡예약소',
      SALEVATAMT: '9636',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업3팀',
      ACCDATE: '20120108',
      SALEAMT: '106000',
      STARTDATE: ''
    },
    {
      NO: '490',
      CARNAMEMSTNAME2: 'K7 렌터카 2700 V6 뮤 VG270 프레스티지 프리미엄 AT LPG',
      RETURNDATE: '20120109',
      ACCNO: '201201090910',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1250101063051',
      CONTRACTNO: 'SS1260120168672',
      RENTFEE: '307000',
      OBJCARNO: '10허6074',
      CARNO: '16허7381',
      ACCPERSONNAME: '정해성',
      DATA_KEY: '490',
      CARNAMEMSTNAME: '오피러스 PREMIUM 렌터카 2700 V6 뮤 GH270 고급형 AT LPG',
      RENTDATE: '20120109',
      UNIT24: '292000',
      TERMTYPE: 'S',
      NETSALEAMT: '88000',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '광주지점',
      SALEVATAMT: '8800',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '대전지점',
      ACCDATE: '20120109',
      SALEAMT: '96800',
      STARTDATE: ''
    },
    {
      NO: '491',
      CARNAMEMSTNAME2: '로체 이노베이션 렌트카 2000 LPI LX20 고급형 스페셜 AT LPG',
      RETURNDATE: '20120103',
      ACCNO: '201112303613',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'SS1230081205094',
      CONTRACTNO: 'SS1907111260237',
      RENTFEE: '165000',
      OBJCARNO: '32허2379',
      CARNO: '04허3219',
      ACCPERSONNAME: '김대윤',
      DATA_KEY: '491',
      CARNAMEMSTNAME: '소나타 Y20 렌터카 2000 LPI Luxury AT LPG',
      RENTDATE: '20111230',
      UNIT24: '150000',
      TERMTYPE: 'S',
      NETSALEAMT: '201527',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '당진원당예약소',
      SALEVATAMT: '20153',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'M',
      DEPTNAME: '평택지점',
      ACCDATE: '20111229',
      SALEAMT: '221680',
      STARTDATE: ''
    },
    {
      NO: '492',
      CARNAMEMSTNAME2: 'SM3 1600 γ - 1.6 LPi 엔진 CE PLUS AT 휘발유',
      RETURNDATE: '20120103',
      ACCNO: '201112242760',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1420100150468',
      CONTRACTNO: 'SS1816111252827',
      RENTFEE: '165000',
      OBJCARNO: '44허1249',
      CARNO: '63허1490',
      ACCPERSONNAME: '정해성',
      DATA_KEY: '492',
      CARNAMEMSTNAME: 'K5렌터카 2000 LPI 디럭스 AT LPG',
      RENTDATE: '20111227',
      UNIT24: '0',
      TERMTYPE: 'S',
      NETSALEAMT: '185309',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '광주진왕',
      SALEVATAMT: '18531',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업2팀',
      ACCDATE: '20111224',
      SALEAMT: '203840',
      STARTDATE: ''
    },
    {
      NO: '493',
      CARNAMEMSTNAME2: '투싼 ix 4WD 2000 E-VGT X20 Luxury AT 디젤',
      RETURNDATE: '20120106',
      ACCNO: '201112313753',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1410101163844',
      CONTRACTNO: 'SS1937120162703',
      RENTFEE: '199000',
      OBJCARNO: '63허7505',
      CARNO: '41허2873',
      ACCPERSONNAME: '김선연',
      DATA_KEY: '493',
      CARNAMEMSTNAME: '뉴싼타페 2000 VGT CLX 고급형 AT 디젤',
      RENTDATE: '20120105',
      UNIT24: '190000',
      TERMTYPE: 'S',
      NETSALEAMT: '102436',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '성수한국타이어예약소',
      SALEVATAMT: '10244',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '부천지점',
      ACCDATE: '20111223',
      SALEAMT: '112680',
      STARTDATE: ''
    },
    {
      NO: '494',
      CARNAMEMSTNAME2: '아반떼 M16 GDi 1600 GDI TOP AT 휘발유',
      RETURNDATE: '20120109',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1330120163049',
      RENTFEE: '160000',
      OBJCARNO: '63허6547',
      CARNO: '62허5400',
      ACCPERSONNAME: '',
      DATA_KEY: '494',
      CARNAMEMSTNAME: 'K5 2000 I4 세타 Ⅱ 스마트 스페셜 AT 휘발유',
      RENTDATE: '20120105',
      UNIT24: '109000',
      TERMTYPE: 'S',
      NETSALEAMT: '125415',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '창원지점',
      SALEVATAMT: '12541',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '창원지점',
      ACCDATE: '',
      SALEAMT: '137956',
      STARTDATE: ''
    },
    {
      NO: '495',
      CARNAMEMSTNAME2: '소나타 Y20 2000 VVT Prime 최고급형 AT 휘발유',
      RETURNDATE: '20120110',
      ACCNO: '201201090932',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1470100354637',
      CONTRACTNO: 'SS1818120166860',
      RENTFEE: '160000',
      OBJCARNO: '05허4009',
      CARNO: '40허6454',
      ACCPERSONNAME: '김선연',
      DATA_KEY: '495',
      CARNAMEMSTNAME: '소나타 Y20 2000 I4 세타 Ⅱ Prime AT 휘발유',
      RENTDATE: '20120109',
      UNIT24: '160000',
      TERMTYPE: 'S',
      NETSALEAMT: '79091',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '도곡예약소',
      SALEVATAMT: '7909',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업1팀',
      ACCDATE: '20120105',
      SALEAMT: '87000',
      STARTDATE: ''
    },
    {
      NO: '496',
      CARNAMEMSTNAME2: 'K7 The Prestige 렌터카 3000 V6 람다 3.0LPI 프레스티지 AT LPG',
      RETURNDATE: '20120110',
      ACCNO: '201201040515',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1140110500581',
      CONTRACTNO: 'SS1848120162906',
      RENTFEE: '292000',
      OBJCARNO: '04허7594',
      CARNO: '39허4307',
      ACCPERSONNAME: '김대윤',
      DATA_KEY: '496',
      CARNAMEMSTNAME: '5G 그랜져 3000 LPI HG300 렌터카 Prime AT LPG',
      RENTDATE: '20120104',
      UNIT24: '292000',
      TERMTYPE: 'S',
      NETSALEAMT: '500887',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '수원삼정예약소',
      SALEVATAMT: '50089',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '안산지점',
      ACCDATE: '20120104',
      SALEAMT: '550976',
      STARTDATE: ''
    },
    {
      NO: '497',
      CARNAMEMSTNAME2: 'All-New SM7 2500 VQ25 RE AT 휘발유',
      RETURNDATE: '20120106',
      ACCNO: '201201040448',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1454111209532',
      CONTRACTNO: 'SS1878120162451',
      RENTFEE: '399000',
      OBJCARNO: '52허5941',
      CARNO: '44허5419',
      ACCPERSONNAME: '김선연',
      DATA_KEY: '497',
      CARNAMEMSTNAME: '제네시스 3300 람다 BH330 LUXURY AT 휘발유',
      RENTDATE: '20120104',
      UNIT24: '266000',
      TERMTYPE: 'S',
      NETSALEAMT: '191745',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '성수트루예약소',
      SALEVATAMT: '19175',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업3팀',
      ACCDATE: '20120104',
      SALEAMT: '210920',
      STARTDATE: ''
    },
    {
      NO: '498',
      CARNAMEMSTNAME2: '아반떼 M16 GDi 1600 GDI LUXURY AT 휘발유',
      RETURNDATE: '20120106',
      ACCNO: '201201040441',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1355111209412',
      CONTRACTNO: 'SS1837120163368',
      RENTFEE: '109000',
      OBJCARNO: '47허6386',
      CARNO: '52허5627',
      ACCPERSONNAME: '정해성',
      DATA_KEY: '498',
      CARNAMEMSTNAME: '아반떼 M16 1600 LPI 렌터카 LUXURY AT LPG',
      RENTDATE: '20120104',
      UNIT24: '109000',
      TERMTYPE: 'S',
      NETSALEAMT: '66182',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '부산태원',
      SALEVATAMT: '6618',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '부산지점',
      ACCDATE: '20120104',
      SALEAMT: '72800',
      STARTDATE: ''
    },
    {
      NO: '499',
      CARNAMEMSTNAME2: 'SM7 New art 2300 VQ23 LE AT 휘발유',
      RETURNDATE: '20120104',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1080111258561',
      RENTFEE: '266000',
      OBJCARNO: '62허4727',
      CARNO: '44허7958',
      ACCPERSONNAME: '',
      DATA_KEY: '499',
      CARNAMEMSTNAME: 'K7 The Prestige 2400 I4 세타 Ⅱ 2.4GDI 럭셔리 AT 휘발유',
      RENTDATE: '20111230',
      UNIT24: '266000',
      TERMTYPE: 'S',
      NETSALEAMT: '324156',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '강남지점',
      SALEVATAMT: '32416',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '강남지점',
      ACCDATE: '',
      SALEAMT: '356572',
      STARTDATE: ''
    },
    {
      NO: '500',
      CARNAMEMSTNAME2: 'NEW SM5 렌터카 2000 CVTC Ⅱ LPLi 고급형 AT LPG',
      RETURNDATE: '20120105',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1260120168669',
      RENTFEE: '307000',
      OBJCARNO: '63허7412',
      CARNO: '56허8334',
      ACCPERSONNAME: '',
      DATA_KEY: '500',
      CARNAMEMSTNAME: '오피러스 PREMIUM 2700 V6 뮤 GH270 스페셜-럭셔리 AT 휘발유',
      RENTDATE: '20120104',
      UNIT24: '165000',
      TERMTYPE: 'S',
      NETSALEAMT: '65455',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '광주지점',
      SALEVATAMT: '6545',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '부천지점',
      ACCDATE: '',
      SALEAMT: '72000',
      STARTDATE: ''
    },
    {
      NO: '501',
      CARNAMEMSTNAME2: 'K5렌터카 2000 LPI 디럭스 AT LPG',
      RETURNDATE: '20120106',
      ACCNO: '201201050567',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'SS1474111109921',
      CONTRACTNO: 'SS1818120167100',
      RENTFEE: '307000',
      OBJCARNO: '59허9792',
      CARNO: '63허6622',
      ACCPERSONNAME: '김선연',
      DATA_KEY: '501',
      CARNAMEMSTNAME: '오피러스 PREMIUM 렌터카 2700 V6 뮤 GH270 럭셔리 AT LPG',
      RENTDATE: '20120105',
      UNIT24: '165000',
      TERMTYPE: 'S',
      NETSALEAMT: '54545',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '도곡예약소',
      SALEVATAMT: '5455',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'M',
      DEPTNAME: '잠실지점',
      ACCDATE: '20120104',
      SALEAMT: '60000',
      STARTDATE: ''
    },
    {
      NO: '502',
      CARNAMEMSTNAME2: '뉴아반떼 1600 VVT E16 VALUE AT 휘발유',
      RETURNDATE: '20120109',
      ACCNO: '201201050602',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LD1450090640478',
      CONTRACTNO: 'SS1913120162811',
      RENTFEE: '142000',
      OBJCARNO: '41허5134',
      CARNO: '30허2648',
      ACCPERSONNAME: '김대윤',
      DATA_KEY: '502',
      CARNAMEMSTNAME: '소나타 N20 2000 VVT Luxury AT 휘발유',
      RENTDATE: '20120105',
      UNIT24: '99000',
      TERMTYPE: 'S',
      NETSALEAMT: '119127',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '성동성수예약소',
      SALEVATAMT: '11913',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업2팀',
      ACCDATE: '20120105',
      SALEAMT: '131040',
      STARTDATE: ''
    },
    {
      NO: '503',
      CARNAMEMSTNAME2: '모닝 1000 SOHC VAN 고급형 AT 휘발유',
      RETURNDATE: '20120105',
      ACCNO: '',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: '',
      CONTRACTNO: 'SS1937111258638',
      RENTFEE: '116000',
      OBJCARNO: '60허6043',
      CARNO: '52허5981',
      ACCPERSONNAME: '',
      DATA_KEY: '503',
      CARNAMEMSTNAME: '아반떼 LPI 하이브리드 1600 γ - 1.6 LPi 엔진 HDe 2 AT 하이브리드/LPG',
      RENTDATE: '20111230',
      UNIT24: '95000',
      TERMTYPE: 'S',
      NETSALEAMT: '160873',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '성수한국타이어예약소',
      SALEVATAMT: '16087',
      REPAIRPERSONNAME: '',
      PROMOCODE: '수리대차',
      TERMTYPE2: '',
      DEPTNAME: '동대문지점',
      ACCDATE: '',
      SALEAMT: '176960',
      STARTDATE: ''
    },
    {
      NO: '504',
      CARNAMEMSTNAME2: '베라크루즈 4WD 3000 E-VGT 300X Deluxe AT 디젤',
      RETURNDATE: '20120109',
      ACCNO: '201201040489',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1260100149947',
      CONTRACTNO: 'SS1867120161866',
      RENTFEE: '292000',
      OBJCARNO: '42허5225',
      CARNO: '52허5915',
      ACCPERSONNAME: '어성환',
      DATA_KEY: '504',
      CARNAMEMSTNAME: '5G 그랜져 3000 LPI HG300 렌터카 Prime AT LPG',
      RENTDATE: '20120104',
      UNIT24: '349000',
      TERMTYPE: 'S',
      NETSALEAMT: '470255',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '(폐쇄)목포상동예약소',
      SALEVATAMT: '47025',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '광주지점',
      ACCDATE: '20120104',
      SALEAMT: '517280',
      STARTDATE: ''
    },
    {
      NO: '505',
      CARNAMEMSTNAME2: '쏘렌토 7P 2500 VGT LX 고급형 AT 디젤',
      RETURNDATE: '20120105',
      ACCNO: '201112283467',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1450080829632',
      CONTRACTNO: 'SS1836111254855',
      RENTFEE: '190000',
      OBJCARNO: '41허3542',
      CARNO: '04허5481',
      ACCPERSONNAME: '정해성',
      DATA_KEY: '505',
      CARNAMEMSTNAME: '투싼 ix 2WD 2000 E-VGT X20 Deluxe AT 디젤',
      RENTDATE: '20111229',
      UNIT24: '199000',
      TERMTYPE: 'S',
      NETSALEAMT: '348218',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: '김천지점',
      SALEVATAMT: '34822',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '영업3팀',
      ACCDATE: '20111228',
      SALEAMT: '383040',
      STARTDATE: ''
    },
    {
      NO: '506',
      CARNAMEMSTNAME2: '제네시스 3800 람다 BH380 LUXURY AT 휘발유',
      RETURNDATE: '20120102',
      ACCNO: '201112283401',
      REPAIRNO: '',
      DISCOUNTRATE: '60',
      OBJCONTRACTNO: 'LS1100100252065',
      CONTRACTNO: 'SS1476111255275',
      RENTFEE: '447000',
      OBJCARNO: '09허6504',
      CARNO: '41허1076',
      ACCPERSONNAME: '김대윤',
      DATA_KEY: '506',
      CARNAMEMSTNAME: '제네시스 3800 람다 BH380 VIP PACK AT 휘발유',
      RENTDATE: '20111229',
      UNIT24: '447000',
      TERMTYPE: 'S',
      NETSALEAMT: '559542',
      ENDDATE: '',
      ISTATUS: '1',
      DELIVERYDEPTNAME: 'MT기획팀',
      SALEVATAMT: '55954',
      REPAIRPERSONNAME: '',
      PROMOCODE: '사고대차',
      TERMTYPE2: 'L',
      DEPTNAME: '인천지점',
      ACCDATE: '20111228',
      SALEAMT: '615496',
      STARTDATE: ''
    }
  ]

};

var sampleBtn = function () {
  var args = Array.prototype.slice.call(arguments, 0);

  samplePageObj.action.apply(null, args);
};
